function ObatAlkesAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
ObatAlkesAction.prototype.constructor = ObatAlkesAction;
ObatAlkesAction.prototype = new TableAction();
ObatAlkesAction.prototype.addRegulerData = function(data) {
	data['filter_bpjs'] = $("#filter_bpjs").val();
	return data;
};
ObatAlkesAction.prototype.show_add_form = function() {
	TableAction.prototype.show_add_form.call(this);
	$("#obat_alkes_margin_jual").val(100);
	this.get_last_code();
};
ObatAlkesAction.prototype.validate = function() {
	var valid = true;
	var invalid_msg = "";
	var nama_obat = $("#obat_alkes_nama").val();
	var nama_jenis_obat = $("#obat_alkes_nama_jenis_barang").val();
	var satuan = $("#obat_alkes_satuan").val();
	var konversi = $("#obat_alkes_konversi").val();
	var satuan_konversi = $("#obat_alkes_satuan_konversi").val();
	$(".error_field").removeClass("error_field");
	if (nama_obat == "") {
		valid = false;
		invalid_msg += "</br><strong>Nama</strong> tidak boleh kosong";
		$("#obat_alkes_nama").addClass("error_field");
	}
	if (nama_jenis_obat == "") {
		valid = false;
		invalid_msg += "</br><strong>Jenis Obat</strong> tidak boleh kosong";
		$("#obat_alkes_nama_jenis_barang").addClass("error_field");
	}
	if (satuan == "") {
		valid = false;
		invalid_msg += "</br><strong>Satuan</strong> tidak boleh kosong";
		$("#obat_alkes_satuan").addClass("error_field");
	}
	if (konversi == "") {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> tidak boleh kosong";
		$("#obat_alkes_konversi").addClass("error_field");
	} else if (konversi <= 0) {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> > 0";
		$("#obat_alkes_konversi").addClass("error_field");
	}
	if (satuan_konversi == "") {
		valid = false;
		invalid_msg += "</br><strong>Satuan Konversi</strong> tidak boleh kosong";
		$("#obat_alkes_satuan").addClass("error_field");
	}
	if (!valid) {
		$("#modal_alert_obat_alkes_add_form").html(
			"<div class='alert alert-block alert-danger'>" +
				"<h4>Peringatan</h4>" +
				invalid_msg +
			"</div>"
		);
	}
	return valid;
};
ObatAlkesAction.prototype.save = function() {
	if (!this.validate())
		return;
	TableAction.prototype.save.call(this);
};
ObatAlkesAction.prototype.edit = function(id) {
	var self = this;
	var data = this.getEditData(id);
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) return;
			$("#obat_alkes_id").val(json.id);
			$("#obat_alkes_kode").val(json.kode);
			$("#obat_alkes_nama").val(json.nama);
			$("#obat_alkes_id_jenis_barang").val(json.id_jenis_barang);
			$("#obat_alkes_kode_jenis_barang").val(json.kode_jenis_barang);
			$("#obat_alkes_nama_jenis_barang").val(json.nama_jenis_barang);
			if (json.bpjs == 1)
				$("#obat_alkes_bpjs").prop("checked", true);
			else
				$("#obat_alkes_bpjs").prop("checked", false);
			if (json.formularium == 1)
				$("#obat_alkes_formularium").prop("checked", true);
			else
				$("#obat_alkes_formularium").prop("checked", false);
			if (json.generik == 1)
				$("#obat_alkes_generik").prop("checked", true);
			else
				$("#obat_alkes_generik").prop("checked", false);
			if (json.berlogo == 1)
				$("#obat_alkes_berlogo").prop("checked", true);
			else
				$("#obat_alkes_berlogo").prop("checked", false);
			if (json.alkes == 1)
				$("#obat_alkes_alkes").prop("checked", true);
			else
				$("#obat_alkes_alkes").prop("checked", false);
			if (json.narkotika == 1)
				$("#obat_alkes_narkotika").prop("checked", true);
			else
				$("#obat_alkes_narkotika").prop("checked", false);
			if (json.okt == 1)
				$("#obat_alkes_okt").prop("checked", true);
			else
				$("#obat_alkes_okt").prop("checked", false);
			if (json.prekursor == 1)
				$("#obat_alkes_prekursor").prop("checked", true);
			else
				$("#obat_alkes_prekursor").prop("checked", false);
			$("#obat_alkes_satuan").val(json.satuan);
			$("#obat_alkes_konversi").val(json.konversi);
			$("#obat_alkes_satuan_konversi").val(json.satuan_konversi);
			$("#obat_alkes_kode_dpho").val(json.kode_dpho);
			$("#obat_alkes_nama_dpho").val(json.nama_dpho);
			
			var data_margin_jual = self.getRegulerData();
			data_margin_jual['command'] = "get_margin_jual";
			data_margin_jual['id_obat'] = id;
			$.post(
				"",
				data_margin_jual,
				function(response_margin_jual) {
					var json_margin_jual = JSON.parse(response_margin_jual);
					if (json_margin_jual == null) return;
					$("#obat_alkes_margin_jual").val(json_margin_jual.margin_jual);
					$("#obat_alkes_add_form").smodal("show");
				}
			);
		}
	);
};
ObatAlkesAction.prototype.get_last_code = function() {
	var data = this.getRegulerData();
	data['command'] = "get_last_code";
	data['super_command'] = "";
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) {
				$("#obat_alkes_kode").val("OB-000001");
				return;
			}
			var kode = parseFloat(json.kode_obat.replace("OB-", "")) + 1;
			kode = "OB-" + ('00000' + kode).slice(-6);
			$("#obat_alkes_kode").val(kode);
		}
	);
};