var obat_alkes;
var jenis_obat_alkes;
var dpho;

$(document).ready(function() {
	$('[data-toggle="popover"]').popover({
		trigger: 'hover',
		'placement': 'top'
	});
	var obat_alkes_columns = new Array("id", "kode", "nama", "id_jenis_barang", "kode_jenis_barang", "nama_jenis_barang", "harga_pbf", "formularium", "alkes", "berlogo", "generik", "narkotika", "okt", "prekursor", "satuan", "konversi", "satuan_konversi", "margin_jual", "bpjs", "kode_dpho", "nama_dpho");
	obat_alkes = new ObatAlkesAction(
		"obat_alkes",
		"perencanaan",
		"obat_alkes",
		obat_alkes_columns
	);
	jenis_obat_alkes = new JenisObatAlkesAction(
		"jenis_obat_alkes",
		"perencanaan",
		"obat_alkes",
		new Array()
	);
	jenis_obat_alkes.setSuperCommand("jenis_obat_alkes");
	dpho = new TableAction(
		"dpho",
		"perencanaan",
		"obat_alkes",
		new Array()
	);
	dpho.showModal = function() {
		$("#dpho_modal").smodal("show");
	};
	dpho.search = function() {
		if ($("#dpho_search").val().length == 0) {
            return;
        }
        var data = this.getRegulerData();
        data['command'] = "get_list_dpho";
        data['criteria'] = $("#dpho_search").val();
        showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					dismissLoading();
					return;
				}
				$("#dpho_list").html(json.list);
				dismissLoading();
			}
		);
	};
	dpho.select = function(r_num) {
		var kode_dpho = $("#dpho_list tr:eq(" + r_num + ") td:eq(1)").text();
		var nama_dpho = $("#dpho_list tr:eq(" + r_num + ") td:eq(2)").text();
		$("#obat_alkes_kode_dpho").val(kode_dpho);
		$("#obat_alkes_nama_dpho").val(nama_dpho);
		$("#dpho_search").val("");
		$("#dpho_list").html("");
		$("#dpho_modal").smodal("hide");
	};
	$("#dpho_search").on("keydown", function(e) {
		if (e.which == 13) {
			e.preventDefault();
		}
	});
	obat_alkes.view();
});