<?php 
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("perencanaan/table/RKBUTable.php");
	require_once("perencanaan/adapter/RKBUAdapter.php");
	require_once("perencanaan/service_consumer/SetRKBUStatusServiceConsumer.php");
	require_once("perencanaan/responder/RKBUDBResponder.php");
	global $db;
	
	$rkbu_table = new RKBUTable(
		array("Unit", "Nomor", "Tahun RKBU", "Bulan", "Tanggal Diajukan", "Tanggal Ditinjau", "Status"),
		"",
		null,
		true
	);
	$rkbu_table->setName("rkbu");
	$rkbu_table->setAddButtonEnable(false);
	$unit_search_text = new Text("search_unit", "search_unit", "");
	$unit_search_text->setClass("search");
	$nomor_search_text = new Text("search_nomor", "search_nomor", "");
	$nomor_search_text->setClass("search");
	$tahun_search_text = new Text("search_tahun", "search_tahun", "");
	$tahun_search_text->setClass("search");
	$bulan_option = new OptionBuilder();
	$bulan_option->add("SEMUA", "%%", "1");
	$bulan_option->add("1 - Januari", "Januari");
	$bulan_option->add("2 - Februari", "Februari");
	$bulan_option->add("3 - Maret", "Maret");
	$bulan_option->add("4 - April", "April");
	$bulan_option->add("5 - Mei", "Mei");
	$bulan_option->add("6 - Juni", "Juni");
	$bulan_option->add("7 - Juli", "Juli");
	$bulan_option->add("8 - Agustus", "Agustus");
	$bulan_option->add("9 - September", "September");
	$bulan_option->add("10 - Oktober", "Oktober");
	$bulan_option->add("11 - Nopember", "Nopember");
	$bulan_option->add("12 - Desember", "Desember");
	$bulan_search_select = new Select("search_bulan", "search_bulan", $bulan_option->getContent());
	$bulan_search_select->setClass("search_select");
	$tanggal_diajukan_search_text = new Text("search_tanggal_diajukan", "search_tanggal_diajukan", "");
	$tanggal_diajukan_search_text->setModel(Text::$DATE);
	$tanggal_diajukan_search_text->setClass("search");
	$tanggal_ditinjau_search_text = new Text("search_tanggal_ditinjau", "search_tanggal_ditinjau", "");
	$tanggal_ditinjau_search_text->setModel(Text::$DATE);
	$tanggal_ditinjau_search_text->setClass("search");
	$status_option = new OptionBuilder();
	$status_option->add("SEMUA", "%%", "1");
	$status_option->add("Disetujui", "sudah");
	$status_option->add("Belum Disetujui", "belum");
	$status_search_select = new Select("search_status", "search_status", $status_option->getContent());
	$status_search_select->setClass("search_select");
	$header = 	"<tr class='rkbu_header'>
					<td>" . $unit_search_text->getHtml() . "</td>
					<td>" . $nomor_search_text->getHtml() . "</td>
					<td>" . $tahun_search_text->getHtml() . "</td>
					<td>" . $bulan_search_select->getHtml() . "</td>
					<td>" . $tanggal_diajukan_search_text->getHtml() . "</td>
					<td>" . $tanggal_ditinjau_search_text->getHtml() . "</td>
					<td>" . $status_search_select->getHtml() . "</td>
					<td></td>
				 </tr>";
	$rkbu_table->addHeader("after", $header);
	
	if (isset($_POST['command'])) {
		$rkbu_adapter = new RKBUAdapter();
		$rkbu_dbtable = new DBTable(
			$db,
			"smis_pr_rkbu"
		);
		$filter = "";
		if (isset($_POST['search_unit']) || isset($_POST['search_nomor']) || isset($_POST['search_tahun']) || isset($_POST['search_bulan']) || isset($_POST['search_tanggal_diajukan']) || isset($_POST['search_tanggal_ditinjau']) || isset($_POST['search_status'])) {
			$filter .= "unit LIKE '%" . $_POST['search_unit'] . "%' AND f_id LIKE '%" . $_POST['search_nomor'] . "%' AND tahun LIKE '%" . $_POST['search_tahun'] . "%' AND daftar_bulan LIKE '%" . $_POST['search_bulan'] . "%' AND IF(tanggal_diajukan IS NULL, '0000-00-00', tanggal_diajukan) LIKE '%" . $_POST['search_tanggal_diajukan'] . "%' AND IF(tanggal_ditinjau IS NULL, '0000-00-00', tanggal_ditinjau) LIKE '%" . $_POST['search_tanggal_ditinjau'] . "%' AND disetujui LIKE '%" . $_POST['search_status'] . "%'";
		}
		$query_value = "
			SELECT *
			FROM (
				SELECT a.*, GROUP_CONCAT(DISTINCT CONCAT('<li>', b.bulan, '</li>') ORDER BY FIELD(b.bulan, 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'Nopember', 'Desember') SEPARATOR '') AS 'daftar_bulan'
				FROM smis_pr_rkbu a LEFT JOIN smis_pr_drkbu b ON a.id = b.id_rkbu
				WHERE a.prop NOT LIKE 'del' AND a.locked = '1' AND b.prop NOT LIKE 'del'
				GROUP BY b.id_rkbu
			) v
			WHERE " . $filter . "
			ORDER BY id DESC
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (
				SELECT a.*, GROUP_CONCAT(DISTINCT CONCAT('<li>', b.bulan, '</li>') ORDER BY FIELD(b.bulan, 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'Nopember', 'Desember') SEPARATOR '') AS 'daftar_bulan'
				FROM smis_pr_rkbu a LEFT JOIN smis_pr_drkbu b ON a.id = b.id_rkbu
				WHERE a.prop NOT LIKE 'del' AND a.locked = '1' AND b.prop NOT LIKE 'del'
				GROUP BY b.id_rkbu
			) v
			WHERE " . $filter . "
			ORDER BY id DESC
		";
		$rkbu_dbtable->setPreferredQuery(true, $query_value, $query_count);
		
		$rkbu_dbresponder = new RKBUDBResponder(
			$rkbu_dbtable,
			$rkbu_table,
			$rkbu_adapter
		);
		$data = $rkbu_dbresponder->command($_POST['command']);
		//set_rkbu_status_service:
		if (isset($_POST['push_command'])) {
			
			$rkbu_dbtable = new DBTable($db, "smis_pr_rkbu");
			$rkbu_row = $rkbu_dbtable->get_row("
				SELECT *
				FROM smis_pr_rkbu
				WHERE id = '" . $data['content']['id'] . "'
			");
			$drkbu_dbtable = new DBTable($db, "smis_pr_drkbu");
			$drkbu_rows = $drkbu_dbtable->get_result("
				SELECT *
				FROM smis_pr_drkbu
				WHERE id_rkbu = '" . $data['content']['id'] . "'
			");
			$command = "push_" . $_POST['push_command'];
			$set_rkbu_status_service_consumer = new SetRKBUStatusServiceConsumer($db, $rkbu_row->f_id, $rkbu_row->tanggal_ditinjau, $rkbu_row->tinjauan, $rkbu_row->disetujui, $drkbu_rows, $command, $rkbu_row->unit);
			$set_rkbu_status_service_consumer->execute();
		}
		echo json_encode($data);
		return;
	}
	
	$rkbu_modal = new Modal("rkbu_add_form", "smis_form_container", "rkbu");
	$rkbu_modal->setTitle("RKBU");
	$rkbu_modal->setClass(Modal::$FULL_MODEL);
	$id_hidden = new Hidden("rkbu_id", "rkbu_id", "");
	$rkbu_modal->addElement("", $id_hidden);
	$fid_hidden = new Hidden("rkbu_fid", "rkbu_fid", "");
	$rkbu_modal->addElement("", $fid_hidden);
	$unit_text = new Text("rkbu_unit", "rkbu_unit", "");
	$unit_text->setAtribute("disabled", "disabled");
	$rkbu_modal->addElement("Unit", $unit_text);
	$tahun_text = new Text("rkbu_tahun", "rkbu_tahun", "");
	$tahun_text->setAtribute("disabled='disabled'");
	$rkbu_modal->addElement("Tahun", $tahun_text);
	$tanggal_diajukan_text = new Text("rkbu_tanggal_diajukan", "rkbu_tanggal_diajukan", "");
	$tanggal_diajukan_text->setAtribute("disabled='disabled'");
	$rkbu_modal->addElement("Tgl. Diajukan", $tanggal_diajukan_text);
	$tanggal_ditinjau_text = new Text("rkbu_tanggal_ditinjau", "tanggal_ditinjau", date('Y-m-d'));
	$tanggal_ditinjau_text->setClass("mydate");
	$tanggal_ditinjau_text->setAtribute("data-date-format='yyyy-m-d'");
	$rkbu_modal->addElement("Tgl. Ditinjau", $tanggal_ditinjau_text);
	$persetujuan_option = array(
		array(
			'name'	=> "Setuju",
			'value'	=> "sudah"
		),
		array(
			'name'	=> "Belum Ditinjau",
			'value'	=> "belum"
		),
		array(
			'name'	=> "Revisi Belum Ditinjau",
			'value'	=> "revisi"
		)
	);
	$status_select = new Select("rkbu_status", "rkbu_status", $persetujuan_option);
	$rkbu_modal->addElement("Status", $status_select);
	$keterangan_edit_button = new Button("", "", "Ubah");
	$keterangan_edit_button->setAction("smis_summernote_write('rkbu', 'rkbu_keterangan', 'rkbu_add_form')");
	$keterangan_edit_button->setIcon("icon-black " . Button::$icon_pencil);
	$keterangan_edit_button->setIsButton(Button::$ICONIC);
	$keterangan_edit_button->setAtribute("id='rkbu_edit_keterangan'");
	$keterangan_view_button = new Button("", "", "Lihat");
	$keterangan_view_button->setAction("smis_summernote_show('rkbu', 'rkbu_keterangan', 'rkbu_add_form')");
	$keterangan_view_button->setClass("btn-inverse");
	$keterangan_view_button->setIcon("icon-white " . Button::$icon_eye_open);
	$keterangan_view_button->setIsButton(Button::$ICONIC);
	$keterangan_textarea = new TextArea("rkbu_keterangan", "rkbu_keterangan", "");
	$keterangan_textarea->setClass("hide");
	$keterangan_button_group = new ButtonGroup("summernote-button-group noprint");
	$keterangan_button_group->addButton($keterangan_edit_button);
	$keterangan_button_group->addButton($keterangan_textarea);
	$keterangan_button_group->addButton($keterangan_view_button);
	$rkbu_modal->addElement("Keterangan", $keterangan_button_group);
	$tinjauan_edit_button = new Button("", "", "Ubah");
	$tinjauan_edit_button->setAction("smis_summernote_write('rkbu', 'rkbu_tinjauan', 'rkbu_add_form')");
	$tinjauan_edit_button->setIcon("icon-black " . Button::$icon_pencil);
	$tinjauan_edit_button->setIsButton(Button::$ICONIC);
	$tinjauan_edit_button->setAtribute("id='rkbu_edit_tinjauan");
	$tinjauan_view_button = new Button("", "", "Lihat");
	$tinjauan_view_button->setAction("smis_summernote_show('rkbu', 'rkbu_tinjauan', 'rkbu_add_form')");
	$tinjauan_view_button->setClass("btn-inverse");
	$tinjauan_view_button->setIcon("icon-white " . Button::$icon_eye_open);
	$tinjauan_view_button->setIsButton(Button::$ICONIC);
	$tinjauan_textarea = new TextArea("rkbu_tinjauan", "rkbu_tinjauan", "");
	$tinjauan_textarea->setClass("hide");
	$tinjauan_button_group = new ButtonGroup("summernote-button-group noprint");
	$tinjauan_button_group->addButton($tinjauan_edit_button);
	$tinjauan_button_group->addButton($tinjauan_textarea);
	$tinjauan_button_group->addButton($tinjauan_view_button);
	$rkbu_modal->addElement("Tinjauan", $tinjauan_button_group);
	$drkbu_table = new Table(
		array("Bulan", "Barang", "Jumlah", "Disetujui"),
		"",
		null,
		true
	);
	$drkbu_table->setName("drkbu");
	$drkbu_table->setAddButtonEnable(false);
	$drkbu_table->setPrintButtonEnable(false);
	$drkbu_table->setReloadButtonEnable(false);
	$drkbu_table->setFooterVisible(false);
	$rkbu_modal->addBody("drkbu_table", $drkbu_table);
	$rkbu_button = new Button("", "", "Simpan");
	$rkbu_button->setClass("btn-success");
	$rkbu_button->setAtribute("id='rkbu_save'");
	$rkbu_button->setIcon("fa fa-floppy-o");
	$rkbu_button->setIsButton(Button::$ICONIC);
	$rkbu_modal->addFooter($rkbu_button);
	$rkbu_button = new Button("", "", "OK");
	$rkbu_button->setClass("btn-success");
	$rkbu_button->setAtribute("id='rkbu_ok'");
	$rkbu_button->setAction("$($(this).data('target')).smodal('hide')");
	$rkbu_modal->addFooter($rkbu_button);
	
	$drkbu_modal = new Modal("drkbu_add_form", "smis_form_container", "drkbu");
	$drkbu_modal->setTitle("Detail RKBU");
	$id_hidden = new Hidden("drkbu_id", "drkbu_id", "");
	$drkbu_modal->addElement("", $id_hidden);
	$bulan_text = new Text("drkbu_bulan", "drkbu_bulan", "");
	$bulan_text->setAtribute("disabled='disabled'");
	$drkbu_modal->addElement("Bulan", $bulan_text);
	$nama_barang_text = new Text("drkbu_nama_barang", "drkbu_nama_barang", "");
	$nama_barang_text->setAtribute("disabled='disabled'");
	$drkbu_modal->addELement("Nama Barang", $nama_barang_text);
	$jenis_barang_text = new Text("drkbu_jenis_barang", "drkbu_jenis_barang", "");
	$jenis_barang_text->setAtribute("disabled='disabled'");
	$drkbu_modal->addElement("Jenis Barang", $jenis_barang_text);
	$jumlah_diajukan_text = new Text("drkbu_jumlah_diajukan", "drkbu_jumlah_diajukan", "");
	$jumlah_diajukan_text->setAtribute("disabled='disabled'");
	$drkbu_modal->addElement("Jml. Diajukan", $jumlah_diajukan_text);
	$jumlah_disetujui_text = new Text("drkbu_jumlah_disetujui", "drkbu_jumlah_disetujui", "");
	$drkbu_modal->addElement("Jml. Disetujui", $jumlah_disetujui_text);
	$satuan_disetujui_text = new Text("drkbu_satuan_disetujui", "drkbu_satuan_disetujui", "");
	$drkbu_modal->addElement("Satuan", $satuan_disetujui_text);
	$drkbu_button = new Button("", "", "Simpan");
	$drkbu_button->setClass("btn-success");
	$drkbu_button->setAtribute("id='drkbu_save'");
	$drkbu_button->setIcon("fa fa-floppy-o");
	$drkbu_button->setIsButton(Button::$ICONIC);
	$drkbu_modal->addFooter($drkbu_button);
	
	echo $drkbu_modal->getHtml();
	echo $rkbu_modal->getHtml();
	echo $rkbu_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("farmasi/js/rkbu_action.js", false);
	echo addJS("farmasi/js/drkbu_action.js", false);
	echo addJS("farmasi/js/rkbu.js", false);
?>
<style type="text/css">
	tr.rkbu_header td input, tr.reghead td select {
		width:100%;
		max-width:100% !important;
	}
</style>