<?php
	class PembuatanOPLTable extends Table {
		public function getHeaderButton() {
			$btn_group = new ButtonGroup("noprint");
			$btn_group->setMax(2, "Tambah OPL");
			$btn_add_reguler_opl = new Button("", "", "Reguler");
			$btn_add_reguler_opl->setAction("pembuatan_opl.show_reguler_opl_add_form()");
			$btn_add_reguler_opl->setAtribute("id='reguler_opl_add'");
			$btn_add_reguler_opl->setClass("btn-primary");
			$btn_add_reguler_opl->setIcon("icon-plus icon-white");
			$btn_add_reguler_opl->setIsButton(Button::$ICONIC_TEXT);
			$btn_group->addElement($btn_add_reguler_opl);
			$btn_add_mandiri_opl = new Button("", "", "Mandiri");
			$btn_add_mandiri_opl->setAction("pembuatan_opl.show_mandiri_opl_add_form()");
			$btn_add_mandiri_opl->setAtribute("id='mandiri_opl_add'");
			$btn_add_mandiri_opl->setClass("btn-inverse");
			$btn_add_mandiri_opl->setIcon("icon-plus icon-white");
			$btn_add_mandiri_opl->setIsButton(Button::$ICONIC_TEXT);
			$btn_group->addElement($btn_add_mandiri_opl);
			$btn_add_prekursor_farmasi_opl = new Button("", "", "Prekursor Farmasi");
			$btn_add_prekursor_farmasi_opl->setAction("pembuatan_opl.show_prekursor_farmasi_opl_add_form()");
			$btn_add_prekursor_farmasi_opl->setAtribute("id='prekursor_farmasi_opl_add'");
			$btn_add_prekursor_farmasi_opl->setClass("btn-inverse");
			$btn_add_prekursor_farmasi_opl->setIcon("icon-plus icon-white");
			$btn_add_prekursor_farmasi_opl->setIsButton(Button::$ICONIC_TEXT);
			$btn_group->addElement($btn_add_prekursor_farmasi_opl);
			$btn_add_oot_opl = new Button("", "", "Obat-Obat Tertentu");
			$btn_add_oot_opl->setAction("pembuatan_opl.show_oot_opl_add_form()");
			$btn_add_oot_opl->setAtribute("id='oot_opl_add'");
			$btn_add_oot_opl->setClass("btn-inverse");
			$btn_add_oot_opl->setIcon("icon-plus icon-white");
			$btn_add_oot_opl->setIsButton(Button::$ICONIC_TEXT);
			$btn_group->addElement($btn_add_oot_opl);
			return $btn_group->getHtml();
		}
		public function getBodyContent() {
			$content = "";
			if ($this->content!=NULL) {
				foreach ($this->content as $d) {
					$content .= "<tr>";
					foreach ($this->header as $h) {
						$content .= "<td>" . $d[$h] . "</td>";
					}
					if ($this->is_action) {
						$content .= "<td>" . $this->getFilteredContentButton($d['id'], $d['lock_opl'], $d['lock_acc'], $d['archived'], $d['status'])->getHtml() . "</td>";
					}
					$content .= "</tr>";
				}
			}
			return $content;
		}
		public function getFilteredContentButton($id, $lock_opl, $lock_acc, $archived, $status) {
			$btn_group = new ButtonGroup("noprint");
			$btn_group->setMax(4, "");
			if ($lock_opl == false) {
				$btn = new Button("", "", "Ubah");
				$btn->setAction($this->action . ".edit('" . $id . "')");
				$btn->setClass("btn-warning");
				$btn->setAtribute("data-content='Ubah' data-toggle='popover'");
				$btn->setIcon("icon-edit icon-white");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
				$btn = new Button("", "", "Hapus");
				$btn->setAction($this->action . ".del('" . $id . "')");
				$btn->setClass("btn-danger");
				$btn->setAtribute("data-content='Hapus' data-toggle='popover'");
				$btn->setIcon("icon-remove icon-white");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
				$btn = new Button("", "", "Kunci");
				$btn->setAction($this->action . ".lock_opl('" . $id . "')");
				$btn->setClass("btn-success");
				$btn->setAtribute("data-content='Terbitkan' data-toggle='popover'");
				$btn->setIcon("fa fa-lock");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
			} else {
				$btn = new Button("", "", "View");
				$btn->setAction($this->action . ".detail('" . $id . "')");
				$btn->setClass("btn-success");
				$btn->setAtribute("data-content='View' data-toggle='popover'");
				$btn->setIcon("icon-eye-open icon-white");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
			}
			if ($lock_acc) {
				if ($archived == 0) {
					global $db;
					$btn = new Button("", "", "Eksport XLS");
					$btn->setAction($this->action . ".export_xls('" . $id . "')");
					if (getSettings($db, "opl_export", "xls") == "pdf") {
						$btn = new Button("", "", "Eksport PDF");
						$btn->setAction($this->action . ".export_pdf('" . $id . "')");
					}
					$btn->setClass("btn-inverse");
					$btn->setAtribute("data-content='Eksport OPL' data-toggle='popover'");
					$btn->setIcon("fa fa-download");
					$btn->setIsButton(Button::$ICONIC);
					$btn_group->addElement($btn);
					if ($status != "sudah") {
						$btn = new Button("", "", "Arsipkan");
						$btn->setAction($this->action . ".archieve('" . $id . "')");
						$btn->setClass("btn-danger");
						$btn->setAtribute("data-content='Arsipkan OPL' data-toggle='popover'");
						$btn->setIcon("fa fa-trash");
						$btn->setIsButton(Button::$ICONIC);
						$btn_group->addElement($btn);
					}
				} else {
					$btn = new Button("", "", "Buka Arsip");
					$btn->setAction($this->action . ".unarchieve('" . $id . "')");
					$btn->setClass("btn-info");
					$btn->setAtribute("data-content='Buka Arsip OPL' data-toggle='popover'");
					$btn->setIcon("fa fa-undo");
					$btn->setIsButton(Button::$ICONIC);
					$btn_group->addElement($btn);
				}
			}
			return $btn_group;
		}
	}
?>