<?php
	global $db;

    $form = new Form("", "", "Pembelian : Riwayat OPL");
    $tanggal_dari_text = new Text("opl_tanggal_dari", "opl_tanggal_dari", date("Y-m-d"));
    $tanggal_dari_text->setAtribute("data-date-format='yyyy-mm-dd'");
    $tanggal_dari_text->setClass("mydate");
    $form->addElement("Tgl. Awal", $tanggal_dari_text);
    $tanggal_sampai_text = new Text("opl_tanggal_sampai", "opl_tanggal_sampai", date("Y-m-d"));
    $tanggal_sampai_text->setAtribute("data-date-format='yyyy-mm-dd'");
    $tanggal_sampai_text->setClass("mydate");
    $form->addElement("Tgl. Akhir", $tanggal_sampai_text);
    $nomor_opl_text = new Text("opl_nomor_opl", "opl_nomor_opl", "");
    $form->addElement("No. OPL", $nomor_opl_text);
	$klinik_rows = $db->get_result("
		SELECT
			*
		FROM
			smis_rg_faskes
		WHERE
			prop = ''
				AND nama NOT LIKE ''
		ORDER BY
			nama ASC
	");
	$klinik_option = new OptionBuilder();
	$klinik_option->add("", "", "1");
	if ($klinik_rows != null) {
		foreach ($klinik_rows as $klinik_row) {
			$klinik_option->addSingle($klinik_row->nama);
		}
	}
	$klinik_select = new Select("opl_klinik", "opl_klinik", $klinik_option->getContent());
	$form->addElement("Klinik", $klinik_select);
    $show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("riwayat_opl.view()");
	$form->addElement("", $show_button);
	
	$table = new Table(
		array("No.", "No. OPL", "Tanggal", "Kode Vendor", "Nama Vendor", "Nama Klinik", "Medis/Non-Medis", "Prekursor Farmasi"),
		"",
		null,
		true
	);
	$table->setName("riwayat_opl");
	$table->setAddButtonEnable(false);
	$table->setPrintButtonEnable(false);
    $table->setReloadButtonEnable(false);
    $table->setEditButtonEnable(false);
    $table->setDelButtonEnable(false);
    $button = new Button("", "", "Detail");
    $button->setIsButton(Button::$ICONIC)->setIcon("icon-eye-open icon-white")->setClass("btn-success");
    $table->addContentButton("detail", $button);
    $button = new Button("", "", "Download");
    $button->setIsButton(Button::$ICONIC)->setIcon("fa fa-download")->setClass("btn-inverse");
    if (getSettings($db, "opl_export", "xls") == "pdf") {
        $table->addContentButton("export_pdf", $button);
    } else {
        $table->addContentButton("export_xls", $button);
    }

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			require_once("pembelian/pembuatan_opl_export_xls.php");
			return;
		}
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("id", "id");
		$adapter->add("lock_opl", "lock_opl");
		$adapter->add("lock_acc", "lock_acc");
		$adapter->add("status", "status");
		$arr['prekursor_farmasi'] = $row->prekursor_farmasi;
		$arr['oot'] = $row->oot;
		$adapter->add("No. OPL", "nomor");
		$adapter->add("Tanggal", "tanggal", "date d-m-Y");
		$adapter->add("Kode Vendor", "kode_vendor");
		$adapter->add("Nama Vendor", "nama_vendor");
		$adapter->add("Nama Klinik", "klinik");
		$adapter->add("Medis/Non-Medis", "medis", "trivial_0_Non-Medis_Medis");
		$adapter->add("Prekursor Farmasi", "prekursor_farmasi", "trivial_0_Non-Prekursor Farmasi_Prekursor Farmasi");
		$dbtable = new DBTable($db, "smis_pb_opl");
		if ($_POST['command'] == "list") {
			$filter_klinik = "";
			if ($_POST['klinik'] != "")
				$filter_klinik = " AND klinik LIKE '" . $_POST['klinik'] . "' ";
			$query_value = "
				SELECT
					*
				FROM
					smis_pb_opl
				WHERE
					prop = ''
						AND lock_opl = 1
						AND lock_acc = 1
						AND tanggal >= '" . $_POST['tanggal_dari'] . "'
						AND tanggal <= '" . $_POST['tanggal_sampai'] . "'
						AND nomor LIKE '%" . $_POST['nomor_opl'] . "%'
						" . $filter_klinik . "
				ORDER BY
					id DESC
			";
			$query_count = "
				SELECT
					COUNT(*)
				FROM
					(" . $query_value . ") v
			";
			$dbtable->setPreferredQuery(true, $query_value, $query_count);
		}
		require_once("pembelian/responder/PembuatanOPLDBResponder.php");
		$dbresponder = new PembuatanOPLDBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$modal = new Modal("download_pdf_confirm", "smis_form_container half", "");
	$modal->setTitle("Download PDF - OPL Farmasi Reguler");
	$id_hidden = new Hidden("opl_id", "opl_id", "");
	$modal->addElement("", $id_hidden);
	$format_option = new OptionBuilder();
	$format_option->add("Tanpa Harga", "tanpa_harga", "1");
	$format_option->add("Dengan Harga", "dengan_harga");
	$format_select = new Select("opl_format", "opl_format", $format_option->getContent());
	$modal->addElement("Format", $format_select);
	$button = new Button("", "", "Download PDF");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-download");
	$button->setClass("btn-inverse");
	$button->setAction("riwayat_opl.download_pdf()");
	$modal->addFooter($button);	
	
	echo $modal->getHtml();
    echo $form->getHtml();
	echo $table->getHtml();
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("pembelian/js/riwayat_opl_action.js", false);
	echo addJS("pembelian/js/riwayat_opl.js", false);
?>