<?php
	require_once("smis-base/smis-include-duplicate.php");

	class PembuatanOPLDBResponder extends DuplicateResponder {
		public function command($command) {
			if ($command != "export_pdf")
				return parent::command($command);
			$pack = null;
			if ($command == "export_pdf") {
				$pack = new ResponsePackage();
				$content = $this->export_pdf();
				$pack->setContent($content);
				$pack->setStatus(ResponsePackage::$STATUS_OK);
			}
			return $pack->getPackage();
		}
		private function export_pdf() {
			$id = $_POST['id'];
			$format_opl = isset($_POST['format_opl']) ? $_POST['format_opl'] : "tanpa_harga";
			
			$opl_row = $this->dbtable->get_db()->get_row("
				SELECT *
				FROM smis_pb_opl
				WHERE id = '" . $id . "'
			");

			if ($opl_row->prekursor_farmasi == 1)
				return $this->export_pdf_prekursor_farmasi($opl_row);
			else if ($opl_row->oot == 1)
				return $this->export_pdf_oot($opl_row);

			$nama_instansi = "KLINIK CASA MEDICAL PANBIL";
			$alamat_instansi_1 = "Komp. Panbil Komersil Area Blok A";
			$alamat_instansi_2 = "No. 3A Kelurahan Muka Kuning";
			$no_izin_instansi = getSettings($this->dbtable->get_db(), "instansi_no_ijin", "");
			if ($opl_row->medis == 1) {
				$nama_instansi = ($opl_row->klinik == null || $opl_row->klinik == "") ? "KLINIK CASA MEDICAL" : strtoupper($opl_row->klinik);
				$alamat_instansi_1 = ($opl_row->alamat_klinik == null || $opl_row->alamat_klinik == "") ? "Komp. Panbil Komersil Area Blok A" : strtoupper($opl_row->alamat_klinik);
				$alamat_instansi_2 = ($opl_row->telpon_klinik == null || $opl_row->telpon_klinik == "") ? "No. 3A Kelurahan Muka Kuning" : $opl_row->telpon_klinik;
				$no_izin_instansi = ($opl_row->no_ijin_klinik == null || $opl_row->no_ijin_klinik == "") ? getSettings($this->dbtable->get_db(), "instansi_no_ijin", "") : $opl_row->no_ijin_klinik;
			}

			$nomor_opl = $opl_row->nomor;
			$tanggal = ArrayAdapter::format("date d-m-Y", $opl_row->tanggal);
			$nama_vendor = $opl_row->nama_vendor;
			$kode_vendor = $opl_row->kode_vendor;
			$alamat_vendor = $opl_row->alamat_vendor;
			if ($alamat_vendor == "" || $alamat_vendor == null) {
				$alamat_vendor = $this->dbtable->get_db()->get_var("
					SELECT
						alamat
					FROM
						smis_pb_vendor
					WHERE
						id = '" . $opl_row->id_vendor . "'
				");
			}
			$kota_vendor = $opl_row->kota_vendor;
			$kodepos_vendor = $opl_row->kodepos_vendor;
			$medis = $opl_row->medis;	

			$manager_umum = getSettings($this->dbtable->get_db(), "nama_manager_umum", "");		
			$verifikator = getSettings($this->dbtable->get_db(), "nama_verifikator", "");

			$nama_pj_farmasi = "_____________";
			$sipa_pj_farmasi = "No. SIPA _____________";
			if ($medis == 1) {
				$apoteker_row = $this->dbtable->get_row("
					SELECT 
						a.nomor_sipa, a.nama, a.unit_kerja, b.nama jabatan 
					FROM 
						smis_hrd_employee a INNER JOIN smis_hrd_job b ON a.jabatan = b.id 
					WHERE 
						b.nama LIKE 'Apoteker' AND a.prop = '' AND a.unit_kerja LIKE '%" . str_replace('Klinik ', '', $opl_row->klinik) . "%' AND a.keluar = 0
					LIMIT 0, 1
				");
				if ($apoteker_row != null) {
					$nama_pj_farmasi = $apoteker_row->nama;
					if ($apoteker_row->nomor_sipa != "")
						$sipa_pj_farmasi = "No. SIPA " . $apoteker_row->nomor_sipa;
				}
			}

			$margin_left = 10;
			$margin_top = 10;
			$total = 0;
			$jumlah_item = 0;
			$jumlah_item_per_halaman = 10;
			if ($format_opl == "tanpa_harga")
				$jumlah_item_per_halaman = 15;
			$dopl_rows = $this->dbtable->get_db()->get_result("
				SELECT *
				FROM smis_pb_dopl
				WHERE id_opl = '" . $id . "' AND prop NOT LIKE 'del' AND jumlah_dipesan > 0
			");
			if ($dopl_rows != null) {
				foreach ($dopl_rows as $dopl_row) {
					$hna = $dopl_row->hpp / 1.1;
					if ($opl_row->use_ppn == 0)
						$hna = $dopl_row->hpp;
					$subtotal = $hna * $dopl_row->jumlah_dipesan;
					if ($dopl_row->t_diskon == "nominal")
						$subtotal = $subtotal - $dopl_row->diskon;
					else
						$subtotal = $subtotal - ($dopl_row->diskon * $subtotal) / 100;
					$subtotal = round($subtotal);
					$total += $subtotal;
					$jumlah_item += 1;
				}
			}
			$diskon_global = $opl_row->diskon;
			$f_diskon_global = ArrayAdapter::format("only-money", $opl_row->diskon);
			if ($opl_row->t_diskon == "persen") {
				$diskon_global = $total * $opl_row->diskon / 100;
				$f_diskon_global = ArrayAdapter::format("only-money", $diskon_global);
			}
			$total_2 = $total - $diskon_global;
			$ppn = $total * 0.1;
			if ($opl_row->use_ppn == 0)
				$ppn = 0;
			$total_3 = $total_2 + $ppn;
			$jumlah_halaman = floor($jumlah_item / $jumlah_item_per_halaman) + 1;

			require_once("smis-libs-out/fpdf/fpdf.php");
			$fpdf = new FPDF("L", "mm", "A4");
			$fpdf->SetMargins($margin_left, $margin_top);

			$number = 1;
			for ($i_halaman = 0; $i_halaman < $jumlah_halaman; $i_halaman++) {
				$fpdf->AddPage();
				$fpdf->Cell(85, 20, "", 1, 0);
				$fpdf->SetFont("Arial", "B", 12);
				$fpdf->Cell(127.5, 20	, "SURAT PESANAN", 1, 0, "C");
				$fpdf->SetFont("Arial", "B", 8);
				$fpdf->Cell(63, 20, "", 1, 0);
				$last_y = $fpdf->GetY();
				
				$fpdf->SetY($fpdf->GetY() + 1);
				$fpdf->SetX(53);
				$fpdf->Image(getLogo(), 11, 11, 20, 20);
				$fpdf->Cell(20, 5, $nama_instansi, 0, 0, "C");
				$fpdf->Cell(150.5, 5, "", 0, 0);
				$fpdf->Cell(20, 5, "Nomor", 0, 0);
				$fpdf->Cell(40, 5, ": " . $nomor_opl, 0, 0);
				$fpdf->Ln(4);
				$fpdf->SetX(53);
				$fpdf->Cell(20, 5, $alamat_instansi_1, 0, 0, "C");
				$fpdf->Cell(150.5, 5, "", 0, 0);
				$fpdf->Cell(20, 5, "Tanggal", 0, 0);
				$fpdf->Cell(40, 5, ": " . $tanggal, 0, 0);
				$fpdf->Ln(4);
				$fpdf->SetX(53);
				$fpdf->Cell(20, 5, $alamat_instansi_2, 0, 0, "C");
				$fpdf->Cell(150.5	, 5, "", 0, 0);
				$fpdf->Cell(20, 5, "Halaman", 0, 0);
				$fpdf->Cell(40, 5, ": " . ($i_halaman + 1) . " / " . $jumlah_halaman, 0, 0);
				$fpdf->Ln(4);
				$fpdf->SetX(53);
				$fpdf->SetFont("Arial", "", 7);
				$fpdf->Cell(20, 5, "NO. IZIN KLINIK : " . $no_izin_instansi, 0, 0, "C");
				$fpdf->SetFont("Arial", "", 8);

				$fpdf->SetY($last_y + 20);
				$fpdf->SetX(10);
				$fpdf->Ln(2);
				$fpdf->Cell(275.5, 15, "", 1, 0);
				$fpdf->SetY($last_y + 23);
				$fpdf->Cell(30, 5, "Kepada Yth.", 0, 0);
				$fpdf->Cell(140, 5, ": " . $nama_vendor, 0, 0);
				$fpdf->Ln(4);
				$fpdf->Cell(30, 5, "Kode Rekanan", 0, 0);
				$fpdf->Cell(140, 5, ": " . $kode_vendor, 0, 0);
				$fpdf->Ln(4);
				$fpdf->Cell(30, 5, "Alamat", 0, 0);
				$fpdf->Cell(140, 5, ": " . $alamat_vendor, 0, 0);
				$last_y = $fpdf->GetY();

				$fpdf->SetY($last_y + 5);
				$fpdf->SetX(10);
				$fpdf->Ln(2.5);
				$fpdf->Cell(170, 5, "Harap dikirim barang-barang berikut ini dengan syarat pembelian yang tercantum di bawah order ini :", 0, 0);

				$fpdf->SetY($last_y + 10);
				$fpdf->SetX(10);
				$fpdf->Ln(4);
				$fpdf->Cell(10, 10, "No.", 1, 0, "C");
				$fpdf->Cell(110.5, 10, "Nama Barang", 1, 0, "C");
				$fpdf->Cell(30, 10, "Satuan", 1, 0, "C");
				$fpdf->Cell(20, 10, "Jml.", 1, 0, "C");

				if ($format_opl == "tanpa_harga")
					$fpdf->Cell(105, 10, "Ket.", 1, 0, "C");
				else {
					$fpdf->Cell(35, 10, "", 1, 0, "C");
					$fpdf->Cell(20, 10, "Diskon", 1, 0, "C");
					$fpdf->Cell(35, 10, "", 1, 0, "C");
					$fpdf->Cell(15, 10, "Ket.", 1, 0, "C");
				}	

				$fpdf->Ln(10);
				$fpdf->Cell(10, 5, "1", 1, 0, "C");
				$fpdf->Cell(110.5, 5, "2", 1, 0, "C");
				$fpdf->Cell(30, 5, "3", 1, 0, "C");
				$fpdf->Cell(20, 5, "4", 1, 0, "C");

				if ($format_opl == "tanpa_harga")
					$fpdf->Cell(105, 5, "5", 1, 0, "C");
				else {
					$fpdf->Cell(35, 5, "5", 1, 0, "C");
					$fpdf->Cell(20, 5, "6", 1, 0, "C");
					$fpdf->Cell(35, 5, "7", 1, 0, "C");
					$fpdf->Cell(15, 5, "8", 1, 0, "C");
				}

				$fpdf->SetY($last_y + 14);
				$fpdf->SetX(10);
				$fpdf->Cell(10, 5, "", 0, 0, "C");
				$fpdf->Cell(110.5, 5, "", 0, 0, "C");
				$fpdf->Cell(30, 5, "", 0, 0, "C");
				$fpdf->Cell(20, 5, "", 0, 0, "C");
				
				if ($format_opl == "tanpa_harga")
					$fpdf->Cell(105, 5, "", 0, 0, "C");
				else {
					$fpdf->Cell(35, 5, "Harga Sat.", 0, 0, "C");
					$fpdf->Cell(20, 5, "", 0, 0, "C");
					$fpdf->Cell(35, 5, "Jumlah Harga", 0, 0, "C");
					$fpdf->Cell(15, 5, "", 0, 0, "C");
				}

				$fpdf->Ln(4);
				$fpdf->SetX(10);
				$fpdf->Cell(10, 5, "", 0, 0, "C");
				$fpdf->Cell(110.5, 5, "", 0, 0, "C");
				$fpdf->Cell(30, 5, "", 0, 0, "C");
				$fpdf->Cell(20, 5, "", 0, 0, "C");

				if ($format_opl == "tanpa_harga")
					$fpdf->Cell(105, 5, "", 0, 0, "C");
				else {
					$fpdf->Cell(35, 5, "(Rp.)", 0, 0, "C");
					$fpdf->Cell(20, 5, "", 0, 0, "C");
					$fpdf->Cell(35, 5, "(Rp.)", 0, 0, "C");
					
					$fpdf->Cell(15, 5, "", 0, 0, "C");
				}
				$fpdf->Ln(11);

				$dopl_rows = $this->dbtable->get_db()->get_result("
					SELECT *
					FROM smis_pb_dopl
					WHERE id_opl = '" . $id . "' AND prop NOT LIKE 'del' AND jumlah_dipesan > 0
					LIMIT " . $i_halaman * $jumlah_item_per_halaman . ", " . $jumlah_item_per_halaman . "
				");

				if ($dopl_rows != null) {
					foreach ($dopl_rows as $dopl_row) {
						$hna = $dopl_row->hpp / 1.1;
						if ($opl_row->use_ppn == 0)
							$hna = $dopl_row->hpp;
						$subtotal = $hna * $dopl_row->jumlah_dipesan;
						$f_diskon = $dopl_row->diskon . " %";
						if ($dopl_row->t_diskon == "nominal") {
							$f_diskon = ArrayAdapter::format("only-money", $dopl_row->diskon);
							$subtotal = $subtotal - $dopl_row->diskon;
						} else {
							$subtotal = $subtotal - ($dopl_row->diskon * $subtotal) / 100;
						}
						$subtotal = round($subtotal);
						$f_subtotal = ArrayAdapter::format("only-money", $subtotal);
						$fpdf->SetX(10);
						$fpdf->Cell(10, 5, $number++, 1, 0);
						$fpdf->Cell(110.5, 5, substr($dopl_row->nama_barang, 0, 33), 1, 0);
						$fpdf->Cell(30, 5, $dopl_row->satuan . " (" . $dopl_row->konversi . " " . $dopl_row->satuan_konversi . ")", 1, 0);
						$fpdf->Cell(20, 5, $dopl_row->jumlah_dipesan, 1, 0, "R");
						if ($format_opl == "tanpa_harga")
							$fpdf->Cell(105, 5, "", 1, 0, "C");	
						else {
							$fpdf->Cell(35, 5, ArrayAdapter::format("only-money", $hna), 1, 0, "R");
							$fpdf->Cell(20, 5, $f_diskon, 1, 0, "R");
							$fpdf->Cell(35, 5, $f_subtotal, 1, 0, "R");
							$fpdf->Cell(15, 5, "", 1, 0, "C");
						}
						$fpdf->Ln(5);
					}
				}
				for ($i = $number; $i <= $jumlah_item_per_halaman; $i++) {
					$fpdf->SetX(10);
					$fpdf->Cell(10, 5, "", 1, 0);
					$fpdf->Cell(110.5, 5, "", 1, 0);
					$fpdf->Cell(30, 5, "", 1, 0);
					$fpdf->Cell(20, 5, "", 1, 0);
					if ($format_opl == "tanpa_harga")
						$fpdf->Cell(105, 5, "", 1, 0, "C");
					else {
						$fpdf->Cell(35, 5, "", 1, 0);
						$fpdf->Cell(20, 5, "", 1, 0);
						$fpdf->Cell(35, 5, "", 1, 0);
						$fpdf->Cell(15, 5, "", 1, 0);
					}
					$fpdf->Ln(5);
				}
				if ($format_opl == "dengan_harga") {
					$fpdf->SetX(10);
					$fpdf->Cell(205.5, 5, "", 1, 0);
					$fpdf->Cell(20, 5, "Total I", 1, 0, "R");
					$fpdf->Cell(35, 5, ArrayAdapter::format("only-money", $total), 1, 0, "R");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Ln(5);
					$fpdf->SetX(10);
					$fpdf->Cell(205.5, 5, "", 1, 0);
					$fpdf->Cell(20, 5, "Diskon", 1, 0, "R");
					$fpdf->Cell(35, 5, $f_diskon_global, 1, 0, "R");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Ln(5);
					$fpdf->SetX(10);
					$fpdf->Cell(205.5, 5, "", 1, 0);
					$fpdf->Cell(20, 5, "Total II", 1, 0, "R");
					$fpdf->Cell(35, 5, ArrayAdapter::format("only-money", $total_2), 1, 0, "R");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Ln(5);
					$fpdf->SetX(10);
					$fpdf->Cell(205.5, 5, "", 1, 0);
					if ($opl_row->use_ppn == 1)
						$fpdf->Cell(20, 5, "PPn (10%)", 1, 0, "R");
					else
						$fpdf->Cell(20, 5, "PPn (0%)", 1, 0, "R");
					$fpdf->Cell(35, 5, ArrayAdapter::format("only-money", $ppn), 1, 0, "R");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Ln(5);
					$fpdf->SetX(10);
					$fpdf->Cell(205.5, 5, "", 1, 0);
					$fpdf->Cell(20, 5, "Total", 1, 0, "R");
					$fpdf->Cell(35, 5, ArrayAdapter::format("only-money", $total_3), 1, 0, "R");
					$fpdf->Cell(15, 5, "", 1, 0, "C");
					$fpdf->Ln(5);
				}

				$last_y = $fpdf->GetY();
				$fpdf->Cell(275.5, 25, "", 1, 0, "C");
				$fpdf->Ln(5);

				$fpdf->SetY($last_y + 0.25);
				$fpdf->SetX(10);

				if ($medis == 1) {
					$fpdf->Cell(100, 5, "Disetujui,", 0, 0, "C");
					$fpdf->Cell(4, 5, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "Diperiksa oleh,", 0, 0, "C");
					$fpdf->Cell(19, 5, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "Disetujui oleh,", 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->Cell(100, 5, "Manager Umum", 0, 0, "C");
					$fpdf->Cell(4, 5, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "Verifikator,", 0, 0, "C");
					$fpdf->Cell(19, 5, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "Apoteker Penanggung Jawab", 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->Cell(188, 10, "", 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->Cell(100, 5, "(" . $manager_umum . ")", 0, 0, "C");
					$fpdf->Cell(4, 5, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "(" . $verifikator . ")", 0, 0, "C");
					$fpdf->Cell(19, 5, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "(" . $nama_pj_farmasi . ")", 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->Cell(173, 10, "", 0, 0, "C");
					$fpdf->Cell(50, 5, $sipa_pj_farmasi, 0, 0, "C");
				} else {
					$fpdf->Cell(100, 5, "Disetujui,", 0, 0, "C");
					$fpdf->Cell(4, 5, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "Diperiksa oleh,", 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->Cell(100, 5, "Manager Umum", 0, 0, "C");
					$fpdf->Cell(4, 5, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "Verifikator,", 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->Cell(188, 10, "", 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->Cell(100, 5, "(" . $manager_umum . ")", 0, 0, "C");
					$fpdf->Cell(4, 5, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "(" . $verifikator . ")", 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->Cell(173, 10, "", 0, 0, "C");
					$fpdf->Cell(50, 5, "", 0, 0, "C");
				}

				$fpdf->SetY($last_y + 26);
				$fpdf->SetX(10);
				$fpdf->SetFont("Arial", "IB", 7);
				$fpdf->Cell(25, 4, "", 0, 0, "R");
				$fpdf->Cell(213, 4, "Syarat pembelian:", 0, 0);
				$fpdf->Ln(4);
				$fpdf->SetFont("Arial", "", 7);
				$fpdf->Cell(25, 4, "1.", 0, 0, "R");
				$fpdf->Cell(213, 4, "Barang sudah harus kami terima selambat-lambatnya 7 (tujuh) hari setelah diterimanya OPL. Faktur Penjualan, faktur pajak Standard agar segera diterbitkan setelah barang kami terima.", 0, 0);
				$fpdf->Ln(4);
				$fpdf->Cell(25, 4, "2.", 0, 0, "R");
				$fpdf->Cell(213, 4, "Kami berhak memeriksa barang-barang tersebut pada saat diterima, dan kami berhak. menolak atau mengembalikan barang-barang tersebut apabila tidak sesuai dengan spek teknis yang tercantum.", 0, 0);
				$fpdf->Ln(4);
				$fpdf->Cell(25, 4, "3.", 0, 0, "R");
				$fpdf->Cell(213, 4, "Pembayaran akan dilaksanakan sesuai dengan jatuh tempo pembayaran yang telah disepakati.", 0, 0);
			}

			global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "opl.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			return $pathfile;
		}
		private function export_pdf_prekursor_farmasi($opl_row) {
			loadLibrary("smis-libs-function-math");

			$nama_klinik = "";
			$alamat_klinik = "";
			$no_ijin_klinik = "";
			$telpon_klinik = "";
			$klinik_row = $this->dbtable->get_row("
				SELECT
					*
				FROM 
					smis_rg_faskes
				WHERE
					nama = '" . $opl_row->klinik . "'
			");
			if ($klinik_row != null) {
				$nama_klinik = $klinik_row->nama;
				$alamat_klinik = $klinik_row->alamat;
				$no_ijin_klinik = $klinik_row->no_ijin;
				$telpon_klinik = $klinik_row->telpon;
			}

			$nama_apoteker = "";
			$no_sipa_apoteker = "";
			$jabatan_apoteker = "";
			$alamat_apoteker = "";
			$apoteker_row = $this->dbtable->get_row("
				SELECT 
					a.nomor_sipa, a.nama, a.unit_kerja, b.nama jabatan, a.alamat
				FROM 
					smis_hrd_employee a INNER JOIN smis_hrd_job b ON a.jabatan = b.id 
				WHERE 
					b.nama LIKE 'Apoteker' AND a.prop = '' AND a.unit_kerja LIKE '%" . str_replace('Klinik ', '', $opl_row->klinik) . "%' AND a.keluar = 0
				LIMIT 0, 1
			");
			if ($apoteker_row != null) {
				$nama_apoteker = $apoteker_row->nama;
				if (
					strpos($nama_apoteker, ", S.Farm") == false && 
					strpos($nama_apoteker, ",S.Farm") == false && 
					strpos($nama_apoteker, ", S. Farm") == false && 
					strpos($nama_apoteker, ",S. Farm") == false &&
					strpos($nama_apoteker, ", S Farm") == false && 
					strpos($nama_apoteker, ",S Farm") == false
				)
					$nama_apoteker .= ", S.Farm., Apt.";
				if ($apoteker_row->nomor_sipa != "")
					$no_sipa_apoteker = $apoteker_row->nomor_sipa;
				if ($apoteker_row->jabatan != "")
					$jabatan_apoteker = $apoteker_row->jabatan;
				if ($apoteker_row->alamat != "")
					$alamat_apoteker = $apoteker_row->alamat;
			}

			$dopl_rows = $this->dbtable->get_db()->get_result("
				SELECT *
				FROM smis_pb_dopl
				WHERE id_opl = '" . $opl_row->id . "' AND prop NOT LIKE 'del' AND jumlah_dipesan > 0
			");
			$number_of_detail = $dopl_rows == null ? 0 : count($dopl_rows);

			require_once("smis-libs-out/fpdf/fpdf.php");
			$fpdf = new FPDF("P", "mm", "A4");
			$fpdf->SetMargins(10, 10);

			$show_stroke = 0;

			$fpdf->AddPage();
			$fpdf->Image(getLogo(), 30, 10, 20, 20);
			$fpdf->SetFont("Arial", "B", 20);
			$fpdf->Cell(20, 10, "", $show_stroke, 0);
			$fpdf->Cell(20, 10, "", $show_stroke, 0);
			$fpdf->Cell(130, 10	, strtoupper($nama_klinik), $show_stroke, 0, "C");
			$fpdf->Cell(20, 10, "", $show_stroke, 1);
			$fpdf->SetFont("Arial", "", 10);
			$fpdf->Cell(20, 5, "", $show_stroke, 0);
			$fpdf->Cell(20, 5, "", $show_stroke, 0);
			$fpdf->Cell(130, 5	, $alamat_klinik, $show_stroke, 0, "C");
			$fpdf->Cell(20, 5, "", $show_stroke, 1);
			$fpdf->Cell(20, 5, "", $show_stroke, 0);
			$fpdf->Cell(20, 5, "", $show_stroke, 0);
			$fpdf->Cell(130, 5, "Telp. " . $telpon_klinik, $show_stroke, 0, "C");
			$fpdf->Cell(20, 5, "", $show_stroke, 1);
			
			$last_x = $fpdf->GetX();
			$last_y = $fpdf->GetY();
			$fpdf->SetLineWidth(0.5);
			$fpdf->Line($last_x, $last_y + 2.5, 200, $last_y + 2.5);
			$fpdf->SetLineWidth(0.25);
			$fpdf->Line($last_x, $last_y + 3.5, 200, $last_y + 3.5);
			
			$fpdf->SetFont("Arial", "B", 12);
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(190, 20, "SURAT PESANAN PREKURSOR", $show_stroke, 1, "C");
			$fpdf->SetFont("Arial", "B", 11);
			$fpdf->Cell(165, 5, "Nomor :", $show_stroke, 0, "R");
			$fpdf->Cell(25, 5, $opl_row->nomor, $show_stroke, 1, "R");
			$fpdf->SetFont("Arial", "", 11);
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(190, 5, "Yang bertanda tangan dibawah ini", $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(35, 5, "Nama", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $nama_apoteker, $show_stroke, 1, "L");
			$fpdf->Cell(35, 5, "Alamat", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $alamat_apoteker, $show_stroke, 1, "L");
			$fpdf->Cell(35, 5, "Jabatan", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $jabatan_apoteker, $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(190, 5, "Mengajukan permohonan kepada", $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(35, 5, "Nama", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $opl_row->nama_vendor, $show_stroke, 1, "L");
			$fpdf->Cell(35, 5, "Alamat", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $opl_row->alamat_vendor, $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(190, 5, "Jenis obat yang mengandung prekursor farmasi adalah sebagai berikut.", $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->SetFont("Arial", "B", 10);
			$last_x = $fpdf->GetX();
			$last_y = $fpdf->GetY();
			$fpdf->Cell(10, 10, "No.", $show_stroke, 0, "C");
			$fpdf->Cell(40, 10, "Nama Obat", $show_stroke, 0, "C");
			$fpdf->Cell(40, 5, "Zat Aktif", $show_stroke, 0, "C");
			$fpdf->Cell(34, 5, "Bentuk & Kekutan", $show_stoke, 0, "C");
			$fpdf->Cell(20, 10, "Satuan", $show_stroke, 0, "C");
			$fpdf->Cell(20, 10, "Jumlah", $show_stroke, 0, "C");
			$fpdf->Cell(26, 10, "Keterangan", $show_stroke, 1, "C");
			$fpdf->SetX($last_x);
			$fpdf->SetY($last_y);
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(50, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(40, 5, "Prekursor Farmasi", $show_stroke, 0, "C");
			$fpdf->Cell(34, 5, "Sediaan", $show_stroke, 1, "C");
			$fpdf->SetX($last_x);
			$fpdf->SetY($last_y);
			$fpdf->Cell(10, 10, "", 1, 0, "C");
			$fpdf->Cell(40, 10, "", 1, 0, "C");
			$fpdf->Cell(40, 10, "", 1, 0, "C");
			$fpdf->Cell(34, 10, "", 1, 0, "C");
			$fpdf->Cell(20, 10, "", 1, 0, "C");
			$fpdf->Cell(20, 10, "", 1, 0, "C");
			$fpdf->Cell(26, 10, "", 1, 1, "C");

			$fpdf->SetFont("Arial", "", 8);
			$nomor = 1;
			if ($dopl_rows != null) {
				foreach ($dopl_rows as $dopl_row) {
					$fpdf->Cell(10, 5, $nomor++, 1, 0, "R");
					$fpdf->Cell(40, 5, $dopl_row->nama_barang, 1, 0, "L");
					$fpdf->Cell(40, 5, $dopl_row->zat_aktif, 1, 0, "L");
					$fpdf->Cell(34, 5, $dopl_row->bentuk_sediaan . " (" . $dopl_row->kekuatan_sediaan . ")", 1, 0, "L");
					$fpdf->Cell(20, 5, $dopl_row->satuan, 1, 0, "L");
					$fpdf->Cell(20, 5, $dopl_row->jumlah_dipesan, 1, 0, "R");
					$fpdf->Cell(26, 5, numbertell($dopl_row->jumlah_dipesan) . " " . $dopl_row->satuan, 1, 1, "L");
				}
			}
			if ($number_of_detail < 6) {
				$number_extra_row = 6 - $number_of_detail;
				for ($i = 0; $i < $number_extra_row; $i++) {
					$fpdf->Cell(10, 5, "", 1, 0, "C");
					$fpdf->Cell(40, 5, "", 1, 0, "C");
					$fpdf->Cell(40, 5, "", 1, 0, "C");
					$fpdf->Cell(34, 5, "", 1, 0, "C");
					$fpdf->Cell(20, 5, "", 1, 0, "C");
					$fpdf->Cell(20, 5, "", 1, 0, "C");
					$fpdf->Cell(26, 5, "", 1, 1, "C");
				}
			}
			$fpdf->SetFont("Arial", "", 11);
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(190, 5, "Untuk keperluan PBF/APOTEK/RS/TOKO OBAT BERIZIN", $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(35, 5, "Nama", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . strtoupper($opl_row->klinik), $show_stroke, 1, "L");
			$fpdf->Cell(35, 5, "Alamat", $show_stroke, 0, "L");
			$fpdf->MultiCell(155, 5, ": " . $alamat_klinik, $show_stroke, "L");
			$fpdf->Cell(35, 5, "No. Ijin", $show_stroke, 0, "L");
			$fpdf->MultiCell(155, 5, ": " . $no_ijin_klinik, $show_stroke, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(110, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(80, 5, "Batam, ........................................", $show_stroke, 1, "C");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(110, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(80, 5, "Penanggung Jawab", $show_stroke, 1, "C");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->SetFont("Arial", "BU", 11);
			$fpdf->Cell(110, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(80, 5, "(" . $nama_apoteker . ")", $show_stroke, 1, "C");
			$fpdf->SetFont("Arial", "B", 11);
			$fpdf->Cell(110, 5, "Catatan :", $show_stroke, 0, "L");
			$fpdf->SetFont("Arial", "", 11);
			$fpdf->Cell(80, 5, "SIPA : " . $no_sipa_apoteker, $show_stroke, 1, "C");
			$fpdf->Cell(5, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(185, 5, "1. Asli putih untuk perusahaan yang bersangkutan", $show_stroke, 1, "L");
			$fpdf->Cell(5, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(185, 5, "2. Copy merah untuk accounting", $show_stroke, 1, "L");
			$fpdf->Cell(5, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(185, 5, "3. Copy kuning untuk bagian purchasing", $show_stroke, 1, "L");
			$fpdf->Cell(5, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(185, 5, "4. Copy hijau untuk copy resep", $show_stroke, 1, "L");

			global $user;
			$md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "opl_prekursor.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			return $pathfile;
		}
		private function export_pdf_oot($opl_row) {
			loadLibrary("smis-libs-function-math");

			$nama_klinik = "";
			$alamat_klinik = "";
			$no_ijin_klinik = "";
			$telpon_klinik = "";
			$klinik_row = $this->dbtable->get_row("
				SELECT
					*
				FROM 
					smis_rg_faskes
				WHERE
					nama = '" . $opl_row->klinik . "'
			");
			if ($klinik_row != null) {
				$nama_klinik = $klinik_row->nama;
				$alamat_klinik = $klinik_row->alamat;
				$no_ijin_klinik = $klinik_row->no_ijin;
				$telpon_klinik = $klinik_row->telpon;
			}

			$nama_apoteker = "";
			$no_sipa_apoteker = "";
			$jabatan_apoteker = "";
			$alamat_apoteker = "";
			$apoteker_row = $this->dbtable->get_row("
				SELECT 
					a.nomor_sipa, a.nama, a.unit_kerja, b.nama jabatan, a.alamat
				FROM 
					smis_hrd_employee a INNER JOIN smis_hrd_job b ON a.jabatan = b.id 
				WHERE 
					b.nama LIKE 'Apoteker' AND a.prop = '' AND a.unit_kerja LIKE '%" . str_replace('Klinik ', '', $opl_row->klinik) . "%' AND a.keluar = 0
				LIMIT 0, 1
			");
			if ($apoteker_row != null) {
				$nama_apoteker = $apoteker_row->nama;
				if (strpos($nama_apoteker, ", S.Farm") == false)
					$nama_apoteker .= ", S.Farm., Apt.";
				if ($apoteker_row->nomor_sipa != "")
					$no_sipa_apoteker = $apoteker_row->nomor_sipa;
				if ($apoteker_row->jabatan != "")
					$jabatan_apoteker = $apoteker_row->jabatan;
				if ($apoteker_row->alamat != "")
					$alamat_apoteker = $apoteker_row->alamat;
			}

			$dopl_rows = $this->dbtable->get_db()->get_result("
				SELECT *
				FROM smis_pb_dopl
				WHERE id_opl = '" . $opl_row->id . "' AND prop NOT LIKE 'del' AND jumlah_dipesan > 0
			");
			$number_of_detail = $dopl_rows == null ? 0 : count($dopl_rows);

			require_once("smis-libs-out/fpdf/fpdf.php");
			$fpdf = new FPDF("P", "mm", "A4");
			$fpdf->SetMargins(10, 10);

			$show_stroke = 0;

			$fpdf->AddPage();
			$fpdf->Image(getLogo(), 30, 10, 20, 20);
			$fpdf->SetFont("Arial", "B", 20);
			$fpdf->Cell(20, 10, "", $show_stroke, 0);
			$fpdf->Cell(20, 10, "", $show_stroke, 0);
			$fpdf->Cell(130, 10	, strtoupper($nama_klinik), $show_stroke, 0, "C");
			$fpdf->Cell(20, 10, "", $show_stroke, 1);
			$fpdf->SetFont("Arial", "", 10);
			$fpdf->Cell(20, 5, "", $show_stroke, 0);
			$fpdf->Cell(20, 5, "", $show_stroke, 0);
			$fpdf->Cell(130, 5	, $alamat_klinik, $show_stroke, 0, "C");
			$fpdf->Cell(20, 5, "", $show_stroke, 1);
			$fpdf->Cell(20, 5, "", $show_stroke, 0);
			$fpdf->Cell(20, 5, "", $show_stroke, 0);
			$fpdf->Cell(130, 5, "Telp. " . $telpon_klinik, $show_stroke, 0, "C");
			$fpdf->Cell(20, 5, "", $show_stroke, 1);
			
			$last_x = $fpdf->GetX();
			$last_y = $fpdf->GetY();
			$fpdf->SetLineWidth(0.5);
			$fpdf->Line($last_x, $last_y + 2.5, 200, $last_y + 2.5);
			$fpdf->SetLineWidth(0.25);
			$fpdf->Line($last_x, $last_y + 3.5, 200, $last_y + 3.5);
			
			$fpdf->SetFont("Arial", "B", 12);
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(190, 20, "SURAT PESANAN OBAT-OBAT TERTENTU", $show_stroke, 1, "C");
			$fpdf->SetFont("Arial", "B", 11);
			$fpdf->Cell(165, 5, "Nomor :", $show_stroke, 0, "R");
			$fpdf->Cell(25, 5, $opl_row->nomor, $show_stroke, 1, "R");
			$fpdf->SetFont("Arial", "", 11);
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(190, 5, "Yang bertanda tangan dibawah ini", $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(35, 5, "Nama", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $nama_apoteker, $show_stroke, 1, "L");
			$fpdf->Cell(35, 5, "Alamat", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $alamat_apoteker, $show_stroke, 1, "L");
			$fpdf->Cell(35, 5, "Jabatan", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $jabatan_apoteker, $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(190, 5, "Mengajukan permohonan kepada", $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(35, 5, "Nama", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $opl_row->nama_vendor, $show_stroke, 1, "L");
			$fpdf->Cell(35, 5, "Alamat", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . $opl_row->alamat_vendor, $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(190, 5, "Jenis obat yang mengandung obat-obat tertentu adalah sebagai berikut.", $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->SetFont("Arial", "B", 10);
			$last_x = $fpdf->GetX();
			$last_y = $fpdf->GetY();
			$fpdf->Cell(10, 10, "No.", $show_stroke, 0, "C");
			$fpdf->Cell(40, 10, "Nama Obat", $show_stroke, 0, "C");
			$fpdf->Cell(40, 5, "Zat Aktif", $show_stroke, 0, "C");
			$fpdf->Cell(34, 5, "Bentuk & Kekutan", $show_stoke, 0, "C");
			$fpdf->Cell(20, 10, "Satuan", $show_stroke, 0, "C");
			$fpdf->Cell(20, 10, "Jumlah", $show_stroke, 0, "C");
			$fpdf->Cell(26, 10, "Keterangan", $show_stroke, 1, "C");
			$fpdf->SetX($last_x);
			$fpdf->SetY($last_y);
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(50, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(40, 5, "Prekursor Farmasi", $show_stroke, 0, "C");
			$fpdf->Cell(34, 5, "Sediaan", $show_stroke, 1, "C");
			$fpdf->SetX($last_x);
			$fpdf->SetY($last_y);
			$fpdf->Cell(10, 10, "", 1, 0, "C");
			$fpdf->Cell(40, 10, "", 1, 0, "C");
			$fpdf->Cell(40, 10, "", 1, 0, "C");
			$fpdf->Cell(34, 10, "", 1, 0, "C");
			$fpdf->Cell(20, 10, "", 1, 0, "C");
			$fpdf->Cell(20, 10, "", 1, 0, "C");
			$fpdf->Cell(26, 10, "", 1, 1, "C");

			$fpdf->SetFont("Arial", "", 8);
			$nomor = 1;
			if ($dopl_rows != null) {
				foreach ($dopl_rows as $dopl_row) {
					$fpdf->Cell(10, 5, $nomor++, 1, 0, "R");
					$fpdf->Cell(40, 5, $dopl_row->nama_barang, 1, 0, "L");
					$fpdf->Cell(40, 5, $dopl_row->zat_aktif, 1, 0, "L");
					$fpdf->Cell(34, 5, $dopl_row->bentuk_sediaan . " (" . $dopl_row->kekuatan_sediaan . ")", 1, 0, "L");
					$fpdf->Cell(20, 5, $dopl_row->satuan, 1, 0, "L");
					$fpdf->Cell(20, 5, $dopl_row->jumlah_dipesan, 1, 0, "R");
					$fpdf->Cell(26, 5, numbertell($dopl_row->jumlah_dipesan) . " " . $dopl_row->satuan, 1, 1, "L");
				}
			}
			if ($number_of_detail < 6) {
				$number_extra_row = 6 - $number_of_detail;
				for ($i = 0; $i < $number_extra_row; $i++) {
					$fpdf->Cell(10, 5, "", 1, 0, "C");
					$fpdf->Cell(40, 5, "", 1, 0, "C");
					$fpdf->Cell(40, 5, "", 1, 0, "C");
					$fpdf->Cell(34, 5, "", 1, 0, "C");
					$fpdf->Cell(20, 5, "", 1, 0, "C");
					$fpdf->Cell(20, 5, "", 1, 0, "C");
					$fpdf->Cell(26, 5, "", 1, 1, "C");
				}
			}
			$fpdf->SetFont("Arial", "", 11);
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(190, 5, "Untuk keperluan PBF/APOTEK/RS/TOKO OBAT BERIZIN", $show_stroke, 1, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(35, 5, "Nama", $show_stroke, 0, "L");
			$fpdf->Cell(155, 5, ": " . strtoupper($opl_row->klinik), $show_stroke, 1, "L");
			$fpdf->Cell(35, 5, "Alamat", $show_stroke, 0, "L");
			$fpdf->MultiCell(155, 5, ": " . $alamat_klinik, $show_stroke, "L");
			$fpdf->Cell(35, 5, "No. Ijin", $show_stroke, 0, "L");
			$fpdf->MultiCell(155, 5, ": " . $no_ijin_klinik, $show_stroke, "L");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");

			$fpdf->Cell(110, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(80, 5, "Batam, ........................................", $show_stroke, 1, "C");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(110, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(80, 5, "Penanggung Jawab", $show_stroke, 1, "C");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->Cell(190, 5, "", $show_stroke, 1, "C");
			$fpdf->SetFont("Arial", "BU", 11);
			$fpdf->Cell(110, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(80, 5, "(" . $nama_apoteker . ")", $show_stroke, 1, "C");
			$fpdf->SetFont("Arial", "B", 11);
			$fpdf->Cell(110, 5, "Catatan :", $show_stroke, 0, "L");
			$fpdf->SetFont("Arial", "", 11);
			$fpdf->Cell(80, 5, "SIPA : " . $no_sipa_apoteker, $show_stroke, 1, "C");
			$fpdf->Cell(5, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(185, 5, "1. Asli putih untuk perusahaan yang bersangkutan", $show_stroke, 1, "L");
			$fpdf->Cell(5, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(185, 5, "2. Copy merah untuk accounting", $show_stroke, 1, "L");
			$fpdf->Cell(5, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(185, 5, "3. Copy kuning untuk bagian purchasing", $show_stroke, 1, "L");
			$fpdf->Cell(5, 5, "", $show_stroke, 0, "C");
			$fpdf->Cell(185, 5, "4. Copy hijau untuk copy resep", $show_stroke, 1, "L");

			global $user;
			$md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "opl_oot.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			return $pathfile;
		}
		public function save() {
			$header_data = $this->postToArray();
			$id['id'] = $_POST['id'];

			if ($id['id'] == 0 || $id['id'] == "") {
				$result = $this->dbtable->insert($header_data);
				$id['id'] = $this->dbtable->get_inserted_id();
				$success['type'] = "insert";
				if (isset($_POST['detail'])) {
					$detail_dbtable = new DBTable($this->dbtable->get_db(), "smis_pb_dopl");
					$detail = json_decode($_POST['detail']);
					foreach ($detail as $d) {
						$detail_data = array();
						$detail_data['id_opl'] = $id['id'];
						if ($d->f_id != null)
							$detail_data['f_id'] = $d->f_id;
						if ($d->id_barang != null)
							$detail_data['id_barang'] = $d->id_barang;
						if ($d->kode_barang != null)
							$detail_data['kode_barang'] = $d->kode_barang;
						if ($d->nama_barang != null)
							$detail_data['nama_barang'] = $d->nama_barang;
						if ($d->nama_jenis_barang != null)
							$detail_data['nama_jenis_barang'] = $d->nama_jenis_barang;
						if ($d->jumlah_diajukan != null)
							$detail_data['jumlah_diajukan'] = $d->jumlah_diajukan;
						if ($d->jumlah_dipesan != null)
							$detail_data['jumlah_dipesan'] = $d->jumlah_dipesan;
						if ($d->jumlah_dipesan != null)
							$detail_data['sisa'] = $d->jumlah_dipesan;
						if ($d->satuan != null)
							$detail_data['satuan'] = $d->satuan;
						if ($d->konversi != null)
							$detail_data['konversi'] = $d->konversi;
						if ($d->satuan_konversi != null)
							$detail_data['satuan_konversi'] = $d->satuan_konversi;
						if ($d->hpp != null)
							$detail_data['hpp'] = $d->hpp;
						if ($d->medis != null)
							$detail_data['medis'] = $d->medis;
						if ($d->inventaris != null)
							$detail_data['inventaris'] = $d->inventaris;
						if ($d->diskon != null)
							$detail_data['diskon'] = $d->diskon;
						if ($d->t_diskon != null)
							$detail_data['t_diskon'] = $d->t_diskon;
						if ($d->zat_aktif != null)
							$detail_data['zat_aktif'] = $d->zat_aktif;
						if ($d->bentuk_sediaan != null)
							$detail_data['bentuk_sediaan'] = $d->bentuk_sediaan;
						if ($d->kekuatan_sediaan != null)
							$detail_data['kekuatan_sediaan'] = $d->kekuatan_sediaan;
						$detail_data['autonomous'] = "[".$this->getAutonomous()."]";
				        $detail_data['duplicate'] = 0;
				        $detail_data['time_updated'] = date("Y-m-d H:i:s");
				        $detail_data['origin_updated'] = $this->getAutonomous();
						$detail_dbtable->insert($detail_data);
					}
				}
			} else {
				$result = $this->dbtable->update($header_data, $id);
				$success['type'] = "update";
				if (isset($_POST['detail'])) {
					$detail_dbtable = new DBTable($this->dbtable->get_db(), "smis_pb_dopl");
					$detail = json_decode($_POST['detail']);
					foreach ($detail as $d) {
						$detail_id['id'] = $d->id;
						$detail_data = array();
						if ($d->f_id != null)
							$detail_data['f_id'] = $d->f_id;
						if ($d->id_barang != null)
							$detail_data['id_barang'] = $d->id_barang;
						if ($d->kode_barang != null)
							$detail_data['kode_barang'] = $d->kode_barang;
						if ($d->nama_barang != null)
							$detail_data['nama_barang'] = $d->nama_barang;
						if ($d->nama_jenis_barang != null)
							$detail_data['nama_jenis_barang'] = $d->nama_jenis_barang;
						if ($d->jumlah_diajukan != null)
							$detail_data['jumlah_diajukan'] = $d->jumlah_diajukan;
						if ($d->jumlah_dipesan != null)
							$detail_data['jumlah_dipesan'] = $d->jumlah_dipesan;
						if ($d->jumlah_dipesan != null)
							$detail_data['sisa'] = $d->jumlah_dipesan;
						if ($d->satuan != null)
							$detail_data['satuan'] = $d->satuan;
						if ($d->konversi != null)
							$detail_data['konversi'] = $d->konversi;
						if ($d->satuan_konversi != null)
							$detail_data['satuan_konversi'] = $d->satuan_konversi;
						if ($d->hpp != null)
							$detail_data['hpp'] = $d->hpp;
						if ($d->medis != null)
							$detail_data['medis'] = $d->medis;
						if ($d->inventaris != null)
							$detail_data['inventaris'] = $d->inventaris;
						if ($d->diskon != null)
							$detail_data['diskon'] = $d->diskon;
						if ($d->t_diskon != null)
							$detail_data['t_diskon'] = $d->t_diskon;
						if ($d->zat_aktif != null)
							$detail_data['zat_aktif'] = $d->zat_aktif;
						if ($d->bentuk_sediaan != null)
							$detail_data['bentuk_sediaan'] = $d->bentuk_sediaan;
						if ($d->kekuatan_sediaan != null)
							$detail_data['kekuatan_sediaan'] = $d->kekuatan_sediaan;
						if ($d->id == "" || $d->id == 0) {
							$detail_data['id_opl'] = $id['id'];
							$detail_data['autonomous'] = "[".$this->getAutonomous()."]";
					        $detail_data['duplicate'] = 0;
					        $detail_data['time_updated'] = date("Y-m-d H:i:s");
					        $detail_data['origin_updated'] = $this->getAutonomous();
							$detail_dbtable->insert($detail_data);
						} else {
							if ($d->deleted)
								$detail_data['prop'] = "del";
							$detail_data['autonomous'] = "[".$this->autonomous."]";
					        $detail_data['duplicate'] = 0;
					        $detail_data['time_updated'] = date("Y-m-d H:i:s");
							$detail_dbtable->update($detail_data, $detail_id);
						}
					}
				}
			}
		}
	}
?>