<?php
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("pembelian/responder/PembuatanOPLDBResponder.php");
	global $db;
	
	$header_form = new Form("", "", "Pembelian : Persetujuan OPL");

	$id = isset($_POST['id']) ? $_POST['id'] : "";
	$f_id = isset($_POST['f_id']) ? $_POST['f_id'] : "";
	$tanggal = !isset($_POST['tanggal']) || $_POST['tanggal'] == "" ? date("Y-m-d") : $_POST['tanggal'];
	$nomor = isset($_POST['nomor']) ? $_POST['nomor'] : "";
	$id_vendor = isset($_POST['id_vendor']) ? $_POST['id_vendor'] : "";
	$kode_vendor = isset($_POST['kode_vendor']) ? $_POST['kode_vendor'] : "";
	$nama_vendor = isset($_POST['nama_vendor']) ? $_POST['nama_vendor'] : "";
	$alamat_vendor = isset($_POST['alamat_vendor']) ? $_POST['alamat_vendor'] : "";
	$kota_vendor = isset($_POST['kota_vendor']) ? $_POST['kota_vendor'] : "";
	$kodepos_vendor = isset($_POST['kodepos_vendor']) ? $_POST['kodepos_vendor'] : "";
	$klinik = isset($_POST['klinik']) ? $_POST['klinik'] : "";
	$alamat_klinik = isset($_POST['alamat_klinik']) ? $_POST['alamat_klinik'] : "";
	$telpon_klinik = isset($_POST['telpon_klinik']) ? $_POST['telpon_klinik'] : "";
	$no_ijin_klinik = isset($_POST['no_ijin_klinik']) ? $_POST['no_ijin_klinik'] : "";
	$medis = isset($_POST['medis']) ? $_POST['medis'] : 1;
	$tipe = isset($_POST['tipe']) ? $_POST['tipe'] : "hutang";
	$diskon = isset($_POST['diskon']) ? $_POST['diskon'] : "0,00";
	$t_diskon = isset($_POST['t_diskon']) ? $_POST['t_diskon'] : "persen";
	$use_ppn = isset($_POST['use_ppn']) ? $_POST['use_ppn'] : "";
	$editable = isset($_POST['editable']) ? $_POST['editable'] : "false";
	
	$id_hidden = new Hidden("persetujuan_opl_id", "persetujuan_opl_id", $id);
	$header_form->addElement("", $id_hidden);
	$f_id_hidden = new Hidden("persetujuan_opl_f_id", "persetujuan_opl_f_id", $f_id);
	$header_form->addElement("", $f_id_hidden);
	$medis_hidden = new Hidden("persetujuan_opl_medis", "persetujuan_opl_medis", $medis);
	$header_form->addElement("", $medis_hidden);
	$tanggal_text = new Text("persetujuan_opl_tanggal", "persetujuan_opl_tanggal", $tanggal);
	if ($editable == "true") {
		$tanggal_text->setAtribute("data-date-format='yyyy-mm-dd'");
		$tanggal_text->setClass("mydate");
	}
	else
		$tanggal_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Tanggal", $tanggal_text);
	$nomor_text = new Text("persetujuan_opl_nomor", "persetujuan_opl_nomor", $nomor);
	$nomor_text->setAtribute("disabled='disabled'");
	$header_form->addElement("No. OPL", $nomor_text);
	$id_vendor_hidden = new Hidden("persetujuan_opl_id_vendor", "persetujuan_opl_id_vendor", $id_vendor);
	$header_form->addElement("", $id_vendor_hidden);
	$nama_vendor_text = new Text("persetujuan_opl_nama_vendor", "persetujuan_opl_nama_vendor", $nama_vendor);
	$nama_vendor_text->setAtribute("disabled='disabled'");
	if ($editable == "true")
		$nama_vendor_text->setClass("smis-one-option-input");
	$vendor_browse_button = new Button("", "", "Pilih");
	$vendor_browse_button->setClass("btn-info");
	$vendor_browse_button->setIsButton(Button::$ICONIC);
	$vendor_browse_button->setIcon("icon-white ".Button::$icon_list_alt);
	$vendor_browse_button->setAction("rencana_pembelian_farmasi.chooser('rencana_pembelian_farmasi', 'rencana_pembelian_farmasi', 'rencana_pembelian_farmasi', rencana_pembelian_farmasi)");
	$vendor_browse_button->setAtribute("id='rencana_pembelian_farmasi_browse'");
	$vendor_input_group = new InputGroup("");
	$vendor_input_group->addComponent($nama_vendor_text);
	$vendor_input_group->addComponent($vendor_browse_button);
	if ($editable == "true")
		$header_form->addElement("Nama Vendor", $vendor_input_group);
	else
		$header_form->addElement("Nama Vendor", $nama_vendor_text);
	$kode_vendor_hidden = new Hidden("persetujuan_opl_kode_vendor", "persetujuan_opl_kode_vendor", $kode_vendor);
	$header_form->addElement("", $kode_vendor_hidden);
	$alamat_vendor_hidden = new Hidden("persetujuan_opl_alamat_vendor", "persetujuan_opl_alamat_vendor", "");
	$header_form->addElement("", $alamat_vendor_hidden);
	$kota_vendor_hidden = new Hidden("persetujuan_opl_kota_vendor", "persetujuan_opl_kota_vendor", "");
	$header_form->addElement("", $kota_vendor_hidden);
	$kodepos_vendor_hidden = new Hidden("persetujuan_opl_kodepos_vendor", "persetujuan_opl_kodepos_vendor", "");
	$header_form->addElement("", $kodepos_vendor_hidden);
	$klinik_option = new OptionBuilder();
	if ($klinik == "")
		$klinik_option->add("", "", "1");
	else
		$klinik_option->add("", "");
	$faskes_rows = $db->get_result("
		SELECT *
		FROM smis_rg_faskes
		WHERE prop = ''
		ORDER BY nama ASC
	");
	if ($faskes_rows != null) {
		foreach ($faskes_rows as $fr) {
			if ($fr->nama == $klinik)
				$klinik_option->add($fr->nama, $fr->nama, "1");
			else
				$klinik_option->add($fr->nama, $fr->nama);
		}
	}
	$klinik_select = new Select("persetujuan_opl_klinik", "persetujuan_opl_klinik", $klinik_option->getContent());
	$klinik_select->setAtribute("disabled='disabled'");
	$header_form->addElement("Klinik", $klinik_select);
	$alamat_klinik_text = new Text("pembuatan_opl_alamat_klinik", "pembuatan_opl_alamat_klinik", $alamat_klinik);
	$alamat_klinik_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Alamat Klinik", $alamat_klinik_text);
	$telpon_klinik_text = new Text("pembuatan_opl_telpon_klinik", "pembuatan_opl_telpon_klinik", $telpon_klinik);
	$telpon_klinik_text->setAtribute("disabled='disabled'");
	$header_form->addElement("Telpon Klinik", $telpon_klinik_text);
	$no_ijin_klinik_text = new Text("pembuatan_opl_no_ijin_klinik", "pembuatan_opl_no_ijin_klinik", $no_ijin_klinik);
	$no_ijin_klinik_text->setAtribute("disabled='disabled'");
	$header_form->addElement("No. Ijin Klinik", $no_ijin_klinik_text);
	$diskon_text = new Text("persetujuan_opl_diskon", "persetujuan_opl_diskon", $diskon);
	if ($editable == "true") {
		$diskon_text->setTypical("money");
		$diskon_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
	} else {
		$diskon_text->setAtribute("disabled='disabled'");
	}
	$header_form->addElement("Diskon", $diskon_text);
	$t_diskon_option = new OptionBuilder();
	if ($t_diskon != "") {
		$t_diskon_option->add("Persen (%)", "persen", "1");
		$t_diskon_option->add("Nominal (Rp.)", "nominal");
	} else {
		$t_diskon_option->add("Persen (%)", "persen", $t_diskon == "persen" ? "1" : "0");
		$t_diskon_option->add("Nominal (Rp.)", "nominal", $t_diskon == "nominal" ? "1" : "0");
	}
	$t_diskon_select = new Select("persetujuan_opl_t_diskon", "persetujuan_opl_t_diskon", $t_diskon_option->getContent());
	if ($editable == "false")
		$t_diskon_select->setAtribute("disabled='disabled'");
	$header_form->addElement("T. Diskon", $t_diskon_select);
	$tipe_option = new OptionBuilder();
	$tipe_option->add("Tunai", "tunai", $tipe == "tunai" ? "1" : "0");
	$tipe_option->add("Hutang", "hutang", $tipe == "hutang" ? "1" : "0");
	$tipe_select = new Select("persetujuan_opl_tipe", "persetujuan_opl_tipe", $tipe_option->getContent());
	if ($editable == "false")
		$tipe_select->setAtribute("disabled='disabled'");
	$header_form->addElement("Tunai/Hutang", $tipe_select);
	$use_ppn_option = new OptionBuilder();
	if ($use_ppn == "") {
		$use_ppn_option->add("Ya", 1, 1);
		$use_ppn_option->add("Tidak", 0);
	} else {
		if ($use_ppn == 1) {
			$use_ppn_option->add("Ya", 1, 1);
			$use_ppn_option->add("Tidak", 0);
		} else {
			$use_ppn_option->add("Ya", 1);
			$use_ppn_option->add("Tidak", 0, 1);
		}
	}
	$use_ppn_select = new Select("persetujuan_opl_use_ppn", "persetujuan_opl_use_ppn", $use_ppn_option->getContent());
	if ($editable == "false")
		$use_ppn_select->setAtribute("disabled='disabled'");
	$header_form->addElement("Inc. PPn", $use_ppn_select);
	
	$table = new Table(
		array("No.", "Kode Barang", "Nama Barang", "Jenis Barang", "No. BBM", "Tgl. Masuk", "Jml. Dipesan", "Jml. Diterima", "Stok Riil", "Satuan", "HNA", "Diskon", "Subtotal"),
		"",
		null,
		true
	);
	$table->setName("dpersetujuan_opl");
	$table->setFooterVisible(false);
	$table->setAction(false);

	$button_group = new ButtonGroup("");
	$back_button = new Button("", "", "Kembali");
	$back_button->setClass("btn-inverse");
	$back_button->setIsButton(Button::$ICONIC_TEXT);
	$back_button->setIcon("fa fa-chevron-left");
	$back_button->setAction("persetujuan_opl.back()");
	$back_button->setAtribute("id='persetujuan_opl_back'");
	$button_group->addButton($back_button);
	$approve_button = new Button("", "", "Setujui OPL");
	$approve_button->setClass("btn-success");
	$approve_button->setIsButton(Button::$ICONIC_TEXT);
	$approve_button->setIcon("fa fa-lock");
	$approve_button->setAction("persetujuan_opl.approve()");
	$approve_button->setAtribute("id='persetujuan_opl_approve'");
	$button_group->addButton($approve_button);
	$disapprove_button = new Button("", "", "Kembalikan OPL");
	$disapprove_button->setClass("btn-danger");
	$disapprove_button->setIsButton(Button::$ICONIC_TEXT);
	$disapprove_button->setIcon("fa fa-unlock");
	$disapprove_button->setAction("persetujuan_opl.disapprove()");
	$disapprove_button->setAtribute("id='persetujuan_opl_disapprove'");
	$button_group->addButton($disapprove_button);
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "show_detail") {
			$id = $_POST['id'];
			$dbtable = new DBTable($db, "smis_pb_opl");
			$header_row = $dbtable->select($id);
			$depo_farmasi = "";
			if ($header_row->klinik == "Klinik Casa Batam Centre") {
				$depo_farmasi = "depo_farmasi_batam_centre";
			} else if ($header_row->klinik == "Klinik Casa Medical Batu Aji") {
				$depo_farmasi = "depo_farmasi_batu_aji";
			} else if ($header_row->klinik == "Klinik Casa Medical Bengkong") {
				$depo_farmasi = "depo_farmasi_bengkong";
			} else if ($header_row->klinik == "Klinik Casa Medical Jodoh") {
				$depo_farmasi = "depo_farmasi_jodoh";
			} else if ($header_row->klinik == "Klinik Casa Medical Panbil") {
				$depo_farmasi = "depo_farmasi_panbil";
			} else if ($header_row->klinik == "Klinik Tanjung Piayu") {
				$depo_farmasi = "depo_farmasi_piayu";
			} else if ($header_row->klinik == "Klinik Casa Medical Sekupang") {
				$depo_farmasi = "depo_farmasi_sekupang";
			} else if ($header_row->klinik == "Klinik Casa Medical Tanjung Uncang") {
				$depo_farmasi = "depo_farmasi_tanjung_uncang";
			} else if ($header_row->klinik == "Klinik Casa Medical Utama") {
				$depo_farmasi = "depo_farmasi_utama";
			}
			$detail_rows = $dbtable->get_result("
				SELECT *
				FROM smis_pb_dopl
				WHERE id_opl = '" . $id . "' AND prop NOT LIKE 'del'
			");
			$locked = $header_row->lock_opl;
			$html = "";
			$num = 0;
			if ($detail_rows != null) {
				foreach ($detail_rows as $row) {
					$hpp = $row->hpp;
					$hna = $row->hpp / 1.1;
					if ($header_row->use_ppn == 0)
						$hna = $row->hpp;
					$subtotal = $hna * $row->jumlah_dipesan;
					$f_diskon = $row->diskon . " %";
					if ($row->t_diskon == "nominal") {
						$f_diskon = ArrayAdapter::format("only-money", $row->diskon);
						$subtotal = $subtotal - $row->diskon;
					} else {
						$subtotal = $subtotal - ($row->diskon * $subtotal) / 100;
					}
					$subtotal = round($subtotal);
					$f_subtotal = ArrayAdapter::format("money", $subtotal);

					$stok = 0;
					if ($depo_farmasi != "") {
						require_once($depo_farmasi . "/library/InventoryLibrary.php");
						$stok_row = $dbtable->get_row("
							SELECT 
								SUM(a.sisa) jumlah
							FROM 
								" . InventoryLibrary::$_TBL_STOK_OBAT . " a 
									INNER JOIN " . InventoryLibrary::$_TBL_OBAT_MASUK . " b ON a.id_obat_masuk = b.id
							WHERE 
								a.prop = '' 
									AND b.prop = ''
									AND a.sisa > 0 
									AND a.id_obat = '" . $row->id_barang . "'
						");
						if ($stok_row != null)
							$stok = $stok_row->jumlah;

						$konversi = $dbtable->get_var("
							SELECT
								konversi
							FROM
								smis_pr_barang
							WHERE
								id = '" . $row->id_barang . "'
						");
						if ($konversi > 0) {
							$stok = round($stok / $konversi);
						}
					}

					$html .= "
						<tr id='data_" . $num . "' class='detail'>
							<td id='nomor'></td>
							<td id='id' style='display: none;'>" . $row->id . "</td>
							<td id='f_id' style='display: none;'>" . $row->f_id . "</td>
							<td id='id_barang' style='display: none;'>" . $row->id_barang . "</td>
							<td id='kode_barang'><small>" . $row->kode_barang . "</small></td>
							<td id='nama_barang'><small>" . $row->nama_barang . "</small></td>
							<td id='nama_jenis_barang'><small>" . $row->nama_jenis_barang . "</small></td>
							<td></td>
							<td></td>
							<td id='jumlah_diajukan' style='display: none;'>" . $row->jumlah_diajukan . "</td>
							<td id='jumlah_dipesan' style='display: none;'>" . $row->jumlah_dipesan . "</td>
							<td id='f_jumlah_dipesan'><small>" . $row->jumlah_dipesan . "</small></td>
							<td></td>
							<td id='f_stok'><small>" . ArrayAdapter::format("number", $stok) . "</small></td>
							<td id='satuan'><small>" . $row->satuan . "</small></td>
							<td id='hpp' style='display: none;'>" . $hpp . "</td>
							<td id='hna' style='display: none;'>" . $hna . "</td>
							<td id='f_hna'><small>" . ArrayAdapter::format("money", $hna) . "</small></td>
							<td id='diskon' style='display: none;'>" . $row->diskon . "</td>
							<td id='t_diskon' style='display: none;'>" . $row->t_diskon . "</td>
							<td id='f_diskon'><small><div align='right'>" . $f_diskon . "</div></small></td>
							<td id='subtotal' style='display: none;'>" . $subtotal . "</td>
							<td id='f_subtotal'><small>" . $f_subtotal . "</small></td>
							<td id='medis' style='display: none;'>" . $row->medis . "</td>
							<td id='inventaris' style='display: none;'>" . $row->inventaris . "</td>
						</tr>
					";

					$bbm_row = $dbtable->get_row("
						SELECT a.tanggal_datang, a.use_ppn, a.no_bbm, b.*
						FROM smis_fr_obat_f_masuk a INNER JOIN smis_fr_dobat_f_masuk b ON a.id = b.id_obat_f_masuk
						WHERE a.prop = '' AND b.prop = '' AND b.id_obat = '" . $row->id_barang . "' AND b.jumlah > 0 AND b.id_dpo > 0
						ORDER BY a.id DESC
						LIMIT 0, 1
					");
					if ($bbm_row != null) {
						$bbm_hpp = $bbm_row->hna;
						$bbm_hna = $bbm_row->hna / 1.1;
						if ($bbm_row->use_ppn == 0)
							$bbm_hna = $bbm_row->hna;
						$bbm_subtotal = $bbm_hna * $bbm_row->jumlah;
						$bbm_f_diskon = $bbm_row->diskon . " %";
						if ($bbm_row->t_diskon == "nominal") {
							$bbm_f_diskon = ArrayAdapter::format("only-money", $row->diskon);
							$bbm_subtotal = $bbm_subtotal - $bbm_row->diskon;
						} else {
							$bbm_subtotal = $bbm_subtotal - ($bbm_row->diskon * $bbm_subtotal) / 100;
						}
						$bbm_subtotal = round($bbm_subtotal);
						$bbm_f_subtotal = ArrayAdapter::format("money", $bbm_subtotal);
						$opl_row = $dbtable->get_row("
							SELECT *
							FROM smis_pb_dopl
							WHERE id = '" . $bbm_row->id_dpo . "'
						");
						$jumlah_dipesan = $opl_row->jumlah_dipesan;
						$html .= 	"<tr class='bbm_terakhir'>" .
										"<td></td>" .
										"<td><small>" . $bbm_row->kode_obat . "</small></td>" .
										"<td><small>" . $bbm_row->nama_obat . "</small></td>" .
										"<td><small>" . $bbm_row->nama_jenis_obat . "</small></td>" .
										"<td><small>" . $bbm_row->no_bbm . "</small></td>" . 
										"<td><small>" . ArrayAdapter::format("date d-m-Y", $bbm_row->tanggal_datang) . "</small></td>" . 
										"<td><small>" . ArrayAdapter::format("number", $opl_row->jumlah_dipesan) . "</small></td>" .
										"<td><small>" . ArrayAdapter::format("number", $bbm_row->jumlah) . "</small></td>" .
										"<td></td>" .
										"<td><small>" . $bbm_row->satuan . "</small></td>" .
										"<td><small>" . ArrayAdapter::format("money", $bbm_hna) . "</small></td>" .
										"<td><small><div align='right'>" . $bbm_f_diskon . "</div></small></td>" .
										"<td><small>" . $bbm_f_subtotal . "</small></td>" .
									"</tr>";
					}
					$num++;
				}
			}
			$data = array();
			$data['html'] = $html;
			$data['row_num'] = $num;
			$data['editable'] = $editable;
			echo json_encode($data);
		} else if ($_POST['command'] == "show_footer") {
			$html = "<tfoot>
						<tr>
							<td colspan='12'><div align='right'><small><strong>Total I</strong></small></div></td>
							<td id='total'></td>
						</tr>
						<tr>
							<td colspan='12'><div align='right'><small><strong>Diskon</strong></small></div></td>
							<td id='diskon_global'></td>
						</tr>
						<tr>
							<td colspan='12'><div align='right'><small><strong>Total II</strong></small></div></td>
							<td id='total_2'></td>
						</tr>
						<tr>
							<td colspan='12'><div align='right'><small><strong>PPn</strong></small></div></td>
							<td id='ppn'></td>
						</tr>
						<tr>
							<td colspan='12'><div align='right'><small><strong>Total II + PPn</strong></small></div></td>
							<td id='tagihan'></td>
						</tr>
					</tfoot>";
			$data = array();
			$data['html'] = $html;
			echo json_encode($data);
		} else {
			$adapter = new SimpleAdapter(true, "No.");
			$adapter->add("No. RP", "id", "digit8");
			$adapter->add("Tanggal", "tanggal", "date d-m-Y");
			$adapter->add("Kode Vendor", "kode_vendor");
			$adapter->add("Nama Vendor", "nama_vendor");
			$dbtable = new DBTable($db, "smis_pb_opl");
			$dbresponder = new PembuatanOPLDBResponder(
				$dbtable,
				$table,
				$adapter
			);
			$data = $dbresponder->command($_POST['command']);
			echo json_encode($data);
		}
		return;
	}
	
	echo $header_form->getHtml();
	echo "<div id='table_content'>" .
			 "<div class='row-fluid'>";
		echo	 "<div class='span12'>" .
					 $table->getHtml() .
				 "</div>";
	echo 	 "</div>" .
			 "<div class='row-fluid'>" .
				 "<div class='span12' align='right'>" .
					$button_group->getHtml() .
				 "</div>" .
			 "</div>" .
		 "</div>";
	echo addJS("pembelian/js/persetujuan_opl_action.js", false);
	echo addJS("pembelian/js/persetujuan_opl_form.js", false);
?>
<style type="text/css">
	tr.bbm_terakhir td {
		background-color: #d9edf7 !important;
	}
</style>