<?php
	require_once("smis-base/smis-include-duplicate.php");
	require_once("pembelian/table/PembuatanOPLNMTable.php");
	require_once("pembelian/responder/PembuatanOPLDBResponder.php");
	global $db;
	
	$table = new PembuatanOPLNMTable(
		array("No. OPL", "Tanggal", "Kode Vendor", "Nama Vendor"),
		"Pembelian : Pembuatan OPL Non-Farmasi",
		null,
		true
	);
	$table->setName("pembuatan_opl");
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			require_once("pembelian/pembuatan_opl_nm_export_xls.php");
			return;
		}
		class PembuatanOPLAdapter extends ArrayAdapter {
			public function adapt($row) {
				$arr = array();
				$arr['id'] = $row->id;
				$arr['lock_opl'] = $row->lock_opl;
				$arr['lock_acc'] = $row->lock_acc;
				$arr['archived'] = $row->archived;
				$arr['status'] = $row->status;
				$arr['No. OPL'] = $row->nomor;
				$arr['Tanggal'] = ArrayAdapter::format("date d-m-Y", $row->tanggal);
				$arr['Kode Vendor'] = $row->kode_vendor;
				$arr['Nama Vendor'] = $row->nama_vendor;
				if ($row->archived == 0) {
					if ($row->status == "sudah")
						$arr['Status BBM'] = "SELURUH ITEM SUDAH DITERIMA PADA BBM";
					else if ($row->lock_opl == 0)
						$arr['Status BBM'] = "BELUM DIAJUKAN PERSETUJUAN OPL";
					else if ($row->lock_acc == 0)
						$arr['Status BBM'] = "BELUM ADA PERSETUJUAN OPL";
					else
						$arr['Status BBM'] = "SELURUH ITEM BELUM DITERIMA PADA BBM";
				} else
					$arr['Status BBM'] = "DIARSIPKAN";
				return $arr;
			}
		}
		$adapter = new PembuatanOPLAdapter();
		$dbtable = new DBTable($db, "smis_pb_opl");
		$dbtable->addCustomKriteria(" medis ", " = 0 ");
		$dbtable->addCustomKriteria(" lock_opl ", " = 0 ");
		$dbtable->addCustomKriteria(" lock_acc ", " = 0 ");
		$dbtable->setOrder(" id DESC ");
		$dbresponder = new PembuatanOPLDBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $table->getHtml();
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("pembelian/js/pembuatan_opl_nm_action.js", false);
	echo addJS("pembelian/js/pembuatan_opl_nm.js", false);
?>