<?php
	global $db;
	require_once("smis-libs-out/php-excel/PHPExcel.php");
	
	$id = $_POST['id'];
	$dbtable = new DBTable($db, "smis_pb_opl");
	$header_row = $dbtable->select($id);
	$detail_info = $dbtable->get_result("
		SELECT *
		FROM smis_pb_dopl
		WHERE id_opl = '" . $id . "' AND prop NOT LIKE 'del' AND jumlah_dipesan > 0
	");
	$jumlah_item = count($detail_info);

	if ($header_row->prekursor_farmasi == 0) {
		$jumlah_item_per_halaman = 15;
		$jumlah_halaman = ceil($jumlah_item / $jumlah_item_per_halaman);
		$start_row_index = 1;
		$end_row_index = 41;
		$value_index_incr = 41;

		$objPHPExcel = PHPExcel_IOFactory::load("pembelian/templates/opl_template.xlsx");
		
		$objPHPExcel->setActiveSheetIndexByName("OPL");
		$objWorksheet = $objPHPExcel->getActiveSheet();
		
		$objWorksheet->setCellValue("C5", "No. Izin Klinik : " . getSettings($db, "instansi_no_ijin", ""));
		$objWorksheet->setCellValue("J2", ": " . $header_row->nomor);
		$objWorksheet->setCellValue("J3", ": " . ArrayAdapter::format("date d-m-Y", $header_row->tanggal));
		$objWorksheet->setCellValue("D6", ": " . strtoupper($header_row->nama_vendor));
		$objWorksheet->setCellValue("D7", ": " . $header_row->kode_vendor);
		$objWorksheet->setCellValue("D8", ": " . strtoupper($header_row->alamat_vendor));
		if ($header_row->use_ppn == 1) {
			$objWorksheet->setCellValue("G31", "PPn (10%)");
			$objWorksheet->setCellValue("H31", "=H30*0.1");
		} else {
			$objWorksheet->setCellValue("G31", "PPn (0%)");
			$objWorksheet->setCellValue("H31", "0");
		}
		$objWorksheet->setCellValue("C34", "(" . getSettings($db, "nama_manager_umum", "") . ")");
		$objWorksheet->setCellValue("D34", "(" . getSettings($db, "nama_verifikator", "") . ")");
		$objWorksheet->setCellValue("F34", "\n(" . getSettings($db, "nama_pj_farmasi", "") . ")\n" . getSettings($db, "sipa_pj_farmasi", ""));
		$objWorksheet->getStyle("F34")->getAlignment()->setWrapText(true);
		
		$cur_item_index = 0;
		$print_area_str = "";
		$total = 0;
		for ($cur_page = 1; $cur_page <= $jumlah_halaman; $cur_page++) {
			$objWorksheet->setCellValue("J" . (4 + (($cur_page - 1) * $value_index_incr)), ": " . $cur_page . " / " . $jumlah_halaman);
			$cur_row_index = ($start_row_index + 12) + ($cur_page - 1) * $value_index_incr;
			$start_print_area = $start_row_index + $value_index_incr * ($cur_page - 1);
			$end_print_area = $end_row_index + $value_index_incr * ($cur_page - 1);
			$print_area_str .= "A" . $start_print_area . ":K" . $end_print_area . ",";
			for ($cur_item_num = 1; $cur_item_num <= $jumlah_item_per_halaman && $cur_item_index < $jumlah_item; $cur_item_num++) {
				$objWorksheet->getStyle("H" . (28 + (($cur_page - 1) * $value_index_incr)))->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("H" . (29 + (($cur_page - 1) * $value_index_incr)))->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("H" . (30 + (($cur_page - 1) * $value_index_incr)))->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("H" . (31 + (($cur_page - 1) * $value_index_incr)))->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("H" . (32 + (($cur_page - 1) * $value_index_incr)))->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->setCellValue("B" . $cur_row_index, $cur_item_index + 1);
				$objWorksheet->setCellValue("C" . $cur_row_index, $detail_info[$cur_item_index]->nama_barang);
				$objWorksheet->setCellValue("D" . $cur_row_index, $detail_info[$cur_item_index]->satuan);
				$objWorksheet->setCellValue("E" . $cur_row_index, $detail_info[$cur_item_index]->jumlah_dipesan);
				$objWorksheet->setCellValue("F" . $cur_row_index, $detail_info[$cur_item_index]->hpp / 1.1);
				$objWorksheet->getStyle("F" . $cur_row_index)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->setCellValue("H" . $cur_row_index, "=E" . $cur_row_index . "*F" . $cur_row_index);
				$objWorksheet->getStyle("H" . $cur_row_index)->getNumberFormat()->setFormatCode("#,##0.00");
				if ($header_row->use_ppn == 1)
					$total += ($detail_info[$cur_item_index]->hpp / 1.1 * $detail_info[$cur_item_index]->jumlah_dipesan);
				else
					$total += ($detail_info[$cur_item_index]->hpp * $detail_info[$cur_item_index]->jumlah_dipesan);
				$cur_item_index++;
				$cur_row_index++;
			}
		}
		$objWorksheet->setCellValue("H28", $total);
		$objWorksheet->getPageSetup()->setPrintArea(rtrim($print_area_str, ","));
			
		header("Content-type: application/vnd.ms-excel");	
		header("Content-Disposition: attachment; filename=OPL_" . $header_row->nomor . "_" . ArrayAdapter::format("date Ymd", $header_row->tanggal) . "_" . date("Ymd_His") . ".xlsx");
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		$objWriter->save("php://output");
	} else {
		loadLibrary("smis-libs-function-math");

		$nama_klinik = "";
		$alamat_klinik = "";
		$no_ijin_klinik = "";
		$telpon_klinik = "";
		$klinik_row = $db->get_row("
			SELECT
				*
			FROM 
				smis_rg_faskes
			WHERE
				nama = '" . $header_row->klinik . "'
		");
		if ($klinik_row != null) {
			$nama_klinik = $klinik_row->nama;
			$alamat_klinik = $klinik_row->alamat;
			$no_ijin_klinik = $klinik_row->no_ijin;
			$telpon_klinik = $klinik_row->telpon;
		}

		$nama_apoteker = "";
		$no_sipa_apoteker = "";
		$jabatan_apoteker = "";
		$alamat_apoteker = "";
		$apoteker_row = $db->get_row("
			SELECT 
				a.nomor_sipa, a.nama, a.unit_kerja, b.nama jabatan, a.alamat
			FROM 
				smis_hrd_employee a INNER JOIN smis_hrd_job b ON a.jabatan = b.id 
			WHERE 
				b.nama LIKE 'Apoteker' AND a.prop = '' AND a.unit_kerja LIKE '%" . str_replace('Klinik ', '', $header_row->klinik) . "%' AND a.keluar = 0
			LIMIT 0, 1
		");
		if ($apoteker_row != null) {
			$nama_apoteker .= $apoteker_row->nama;
			if (strpos($nama_apoteker, ", S.Farm") == false)
				$nama_apoteker .= ", S.Farm., Apt.";
			if ($apoteker_row->nomor_sipa != "")
				$no_sipa_apoteker .= $apoteker_row->nomor_sipa;
			if ($apoteker_row->jabatan != "")
				$jabatan_apoteker .= $apoteker_row->jabatan;
			if ($apoteker_row->alamat != "")
				$alamat_apoteker .= $apoteker_row->alamat;
		}

		$objPHPExcel = PHPExcel_IOFactory::load("pembelian/templates/opl_prekursor_template.xlsx");
		$objPHPExcel->setActiveSheetIndexByName("OPL");
		$objWorksheet = $objPHPExcel->getActiveSheet();

		$objWorksheet->setCellValue("L10", $header_row->nomor);
		$objWorksheet->setCellValue("D2", strtoupper($header_row->klinik));
		$objWorksheet->setCellValue("D4", $alamat_klinik);
		$objWorksheet->setCellValue("D5", "Telp. " . $telpon_klinik);
		$objWorksheet->setCellValue("C14", ": " . $nama_apoteker);
		$objWorksheet->setCellValue("C15", ": " . $alamat_apoteker);
		$objWorksheet->setCellValue("C16", ": " . $jabatan_apoteker);
		$objWorksheet->setCellValue("C20", ": " . $header_row->nama_vendor);
		$objWorksheet->setCellValue("C21", ": " . $header_row->alamat_vendor);
		$objWorksheet->setCellValue("C35", ": " . strtoupper($header_row->klinik));
		$objWorksheet->setCellValue("C36", ": " . $alamat_klinik);
		$objWorksheet->setCellValue("B37", "No. Ijin");
		$objWorksheet->setCellValue("C37", ": " . $no_ijin_klinik);
		$objWorksheet->setCellValue("J44", "(" . $nama_apoteker . ")");
		$objWorksheet->setCellValue("J45", "No. SIPA : " . $no_sipa_apoteker);

		$tambahan_baris = $jumlah_item - 6;
		if ($tambahan_baris > 0)
			$objWorksheet->insertNewRowBefore(30, $tambahan_baris);
		
		$row_num = 27;
		$nomor = 1;
		foreach ($detail_info as $d) {
			$col_num = 1;
			$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $nomor++);
			$col_num++;
			$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_barang);
			$col_num+=2;
			$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->zat_aktif);
			$col_num+=2;
			$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->bentuk_sediaan . " (" . $d->kekuatan_sediaan . ")");
			$col_num+=2;
			$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->satuan);
			$col_num++;
			$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jumlah_dipesan);
			$col_num++;
			$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, numbertell($d->jumlah_dipesan) . " " . $d->satuan);
			$row_num++;
		}

		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=OPL_PREKURSOR_" . $header_row->nomor . "_" . ArrayAdapter::format("date Ymd", $header_row->tanggal) . "_" . date("Ymd_His") . ".xlsx");
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		$objWriter->save("php://output");
	}
?>