<?php
	require_once("pembelian/table/PembuatanOPLTable.php");
	require_once("pembelian/responder/PembuatanOPLDBResponder.php");
	global $db;
	
	$table = new PembuatanOPLTable(
		array("No. OPL", "Tanggal", "Kode Vendor", "Nama Vendor", "Nama Klinik", "Prekursor Farmasi", "Status BBM"),
		"Pembelian : Pembuatan OPL",
		null,
		true
	);
	$table->setName("pembuatan_opl");
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			require_once("pembelian/pembuatan_opl_export_xls.php");
			return;
		} else if ($_POST['command'] == "get_info_klinik") {
			$klinik = $_POST['klinik'];
			$klinik_row = $db->get_row("
				SELECT *
				FROM smis_rg_faskes
				WHERE prop = '' AND nama = '" . $klinik . "'
				ORDER BY id DESC
				LIMIT 0,1
			");
			$alamat = "";
			$telpon = "";
			$no_ijin = "";
			if ($klinik_row != null) {
				$alamat = $klinik_row->alamat;
				$telpon = $klinik_row->telpon;
				$no_ijin = $klinik_row->no_ijin;
			}
			$data = array(
				'alamat' 	=> $alamat,
				'telpon'	=> $telpon,
				'no_ijin'	=> $no_ijin
			);
			echo json_encode($data);
			return;
		}
		class PembuatanOPLAdapter extends ArrayAdapter {
			public function adapt($row) {
				$arr = array();
				$arr['id'] = $row->id;
				$arr['lock_opl'] = $row->lock_opl;
				$arr['lock_acc'] = $row->lock_acc;
				$arr['archived'] = $row->archived;
				$arr['status'] = $row->status;
				$arr['No. OPL'] = $row->nomor;
				$arr['Tanggal'] = ArrayAdapter::format("date d-m-Y", $row->tanggal);
				$arr['Kode Vendor'] = $row->kode_vendor;
				$arr['Nama Vendor'] = $row->nama_vendor;
				$arr['Nama Klinik'] = $row->klinik;
				$arr['Prekursor Farmasi'] = $row->prekursor_farmasi == 0 ? "Non-Prekursor Farmasi" : "Prekursor Farmasi";
				if ($row->archived == 0) {
					if ($row->status == "sudah")
						$arr['Status BBM'] = "SELURUH ITEM SUDAH DITERIMA PADA BBM";
					else if ($row->lock_opl == 0)
						$arr['Status BBM'] = "BELUM DIAJUKAN PERSETUJUAN OPL";
					else if ($row->lock_acc == 0)
						$arr['Status BBM'] = "BELUM ADA PERSETUJUAN OPL";
					else
						$arr['Status BBM'] = "SELURUH ITEM BELUM DITERIMA PADA BBM";
				} else
					$arr['Status BBM'] = "DIARSIPKAN";
				return $arr;
			}
		}
		$adapter = new PembuatanOPLAdapter();
		$dbtable = new DBTable($db, "smis_pb_opl");
		$dbtable->addCustomKriteria(" medis ", " = 1 ");
		$dbtable->addCustomKriteria(" lock_opl ", " = 0 ");
		$dbtable->addCustomKriteria(" lock_acc ", " = 0 ");
		$dbtable->setOrder(" id DESC ");
		$dbresponder = new PembuatanOPLDBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $table->getHtml();
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("pembelian/js/pembuatan_opl_action.js", false);
	echo addJS("pembelian/js/pembuatan_opl.js", false);
?>