<?php
	global $db;

	$obat_table = new Table(
		array("ID", "Kode", "Nama Obat", "Jenis Obat"),
		"",
		null,
		true
	);
	$obat_table->setName("lrpb_obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new SimpleAdapter();
	$obat_adapter->add("ID", "id");
	$obat_adapter->add("Kode", "kode");
	$obat_adapter->add("Nama Obat", "nama");
	$obat_adapter->add("Jenis Obat", "nama_jenis_barang");
	$obat_dbtable = new DBTable($db, "smis_pr_barang");
	$obat_dbtable->addCustomKriteria(" medis ", " = 1 ");
	$obat_dbresponder = new DBResponder(
		$obat_dbtable,
		$obat_table,
		$obat_adapter
	);

	$jenis_obat_table = new Table(
		array("No.", "Kode", "Jenis Obat"),
		"",
		null,
		true
	);
	$jenis_obat_table->setName("lrpb_jenis_obat");
	$jenis_obat_table->setModel(Table::$SELECT);
	$jenis_obat_adapter = new SimpleAdapter(true, "No.");
	$jenis_obat_adapter->add("Kode", "kode");
	$jenis_obat_adapter->add("Jenis Obat", "nama");
	$jenis_obat_dbtable = new DBTable($db, "smis_pr_jenis_barang");
	$jenis_obat_dbtable->addCustomKriteria(" medis ", " = 1 ");
	$jenis_obat_dbresponder = new DBResponder(
		$jenis_obat_dbtable,
		$jenis_obat_table,
		$jenis_obat_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("lrpb_obat", $obat_dbresponder);
	$super_command->addResponder("lrpb_jenis_obat", $jenis_obat_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_jumlah_obat") {
			$jenis_filter = $_POST['jenis_filter'];
			$id_obat = $_POST['id_obat'];
			$nama_jenis_obat = $_POST['nama_jenis_obat'];

			$filter = "";
			if ($jenis_filter == "per_obat")
				$filter .= " AND id = '" . $id_obat . "' ";
			else if ($jenis_filter == "per_jenis")
				$filter .= " AND nama_jenis_barang LIKE '" . $nama_jenis_obat . "' ";

			$jumlah = $db->get_var("
				SELECT
					COUNT(*)
				FROM
					smis_pr_barang
				WHERE
					prop LIKE ''
						AND medis = 1
						AND inventaris = 0
						" . $filter . "
			");

			$data = array();
			$data['jumlah'] = $jumlah;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info_obat") {
			$jenis_filter = $_POST['jenis_filter'];
			$id_obat = $_POST['id_obat'];
			$nama_jenis_obat = $_POST['nama_jenis_obat'];
			$unit_slug = $_POST['unit_slug'];
			$unit_label = $_POST['unit_label'];
			$bulan = $_POST['bulan'];
			$tahun = $_POST['tahun'];
			$num = $_POST['num'];
			$nomor = $_POST['nomor'];

			$bulan_1 = $bulan - 3;
			$bulan_2 = $bulan - 2;
			$bulan_3 = $bulan - 1;
			$tahun_1 = $tahun;
			$tahun_2 = $tahun;
			$tahun_3 = $tahun;
			if ($bulan_1 <= 0) {
				$bulan_1 += 12;
				$tahun_1 = $tahun - 1;
			}
			if ($bulan_2 <= 0) {
				$bulan_2 += 12;
				$tahun_2 = $tahun - 1;
			}
			if ($bulan_3 <= 0) {
				$bulan_3 += 12;
				$tahun_3 = $tahun - 1;
			}

			$filter = "";
			if ($jenis_filter == "per_obat")
				$filter .= " AND id = '" . $id_obat . "' ";
			else if ($jenis_filter == "per_jenis")
				$filter .= " AND nama_jenis_barang LIKE '" . $nama_jenis_obat . "' ";

			$data_obat = $db->get_row("
				SELECT
					*
				FROM
					smis_pr_barang
				WHERE
					prop LIKE ''
						AND medis = 1
						AND inventaris = 0
						" . $filter . "
				ORDER BY
					nama ASC
				LIMIT
					" . $num . ", 1
			");

			$id_obat = $data_obat->id;
			$kode_obat = $data_obat->kode;
			$nama_obat = $data_obat->nama;
			$nama_jenis_obat = $data_obat->nama_jenis_barang;
			$satuan = $data_obat->satuan;
			$satuan_konversi = $data_obat->satuan_konversi;			

			$html = "";
			$unit_arr = array(
				"Klinik Batam Centre" => "depo_farmasi_batam_centre",
				"Klinik Batu Aji" => "depo_farmasi_batu_aji",
				"Klinik Bengkong" => "depo_farmasi_bengkong",
				"Klinik Jodoh" => "depo_farmasi_jodoh",
				"Klinik Panbil" => "depo_farmasi_panbil",
				"Klinik Tanjung Piayu" => "depo_farmasi_piayu",
				"Klinik Sekupang" => "depo_farmasi_sekupang",
				"Klinik Tanjung Uncang" => "depo_farmasi_tanjung_uncang",
				"Klinik Utama" => "depo_farmasi_utama"
			);
			if ($unit_slug != "semua") {
				$unit_arr = array(
					$unit_label => $unit_slug
				);
			}

			foreach ($unit_arr as $nama_unit => $slug_unit) {
				$prefix_table = str_replace("depo_farmasi", "smis_frm", $slug_unit);
				$table_penjualan_resep = $prefix_table . "_penjualan_resep";
				$table_penjualan_obat_jadi = $prefix_table . "_penjualan_obat_jadi";
				$table_penjualan_obat_racikan = $prefix_table . "_penjualan_obat_racikan";
				$table_bahan_pakai_obat_racikan = $prefix_table . "_bahan_pakai_obat_racikan";
				$table_stok_obat = $prefix_table . "_stok_obat";
				$table_obat_masuk = $prefix_table . "_obat_masuk";

				$query_jual_obat_jadi = "
					SELECT
						SUM(b.jumlah) jumlah
					FROM
						" . $table_penjualan_resep . " a
							INNER JOIN " . $table_penjualan_obat_jadi . " b ON a.id = b.id_penjualan_resep
					WHERE
						a.prop LIKE ''
							AND b.prop LIKE ''
							AND a.dibatalkan = 0
							AND b.id_obat = '" . $id_obat . "'
				";

				$query_jual_bahan_obat_racikan = "
					SELECT
						SUM(c.jumlah) jumlah
					FROM
						" . $table_penjualan_resep . " a
							INNER JOIN " . $table_penjualan_obat_racikan . " b ON a.id = b.id_penjualan_resep
							INNER JOIN " . $table_bahan_pakai_obat_racikan . " c ON b.id = c.id_penjualan_obat_racikan
					WHERE
						a.prop LIKE ''
							AND b.prop LIKE ''
							AND c.prop LIKE ''
							AND a.dibatalkan = 0
							AND c.id_obat = '" . $id_obat . "'
				";

				$query_jual_obat_jadi_1 = $query_jual_obat_jadi . " AND MONTH(a.tanggal) = '" . $bulan_1 . "' AND YEAR(a.tanggal) = '" . $tahun_1 . "' ";
				$query_jual_bahan_obat_racikan_1 = $query_jual_bahan_obat_racikan . " AND MONTH(a.tanggal) = '" . $bulan_1 . "' AND YEAR(a.tanggal) = '" . $tahun_1 . "' ";
				$jumlah_jual_1 = $db->get_var($query_jual_obat_jadi_1) + $db->get_var($query_jual_bahan_obat_racikan_1);

				$query_jual_obat_jadi_2 = $query_jual_obat_jadi . " AND MONTH(a.tanggal) = '" . $bulan_2 . "' AND YEAR(a.tanggal) = '" . $tahun_2 . "' ";
				$query_jual_bahan_obat_racikan_2 = $query_jual_bahan_obat_racikan . " AND MONTH(a.tanggal) = '" . $bulan_2 . "' AND YEAR(a.tanggal) = '" . $tahun_2 . "' ";
				$jumlah_jual_2 = $db->get_var($query_jual_obat_jadi_2) + $db->get_var($query_jual_bahan_obat_racikan_2);

				$query_jual_obat_jadi_3 = $query_jual_obat_jadi . " AND MONTH(a.tanggal) = '" . $bulan_3 . "' AND YEAR(a.tanggal) = '" . $tahun_3 . "' ";
				$query_jual_bahan_obat_racikan_3 = $query_jual_bahan_obat_racikan . " AND MONTH(a.tanggal) = '" . $bulan_3 . "' AND YEAR(a.tanggal) = '" . $tahun_3 . "' ";
				$jumlah_jual_3 = $db->get_var($query_jual_obat_jadi_3) + $db->get_var($query_jual_bahan_obat_racikan_3);

				if ($jumlah_jual_1 > 0 || $jumlah_jual_2 > 0 || $jumlah_jual_3 > 0) {
					$rerata_jual = floor(($jumlah_jual_1 + $jumlah_jual_2 + $jumlah_jual_3) / 3);
					$prediksi_beli = floor($rerata_jual * 1.3);
					if ($prediksi_beli % 100 > 0) {
						$mod = $prediksi_beli % 100;
						if ($mod > 50) {
							$prediksi_beli = $prediksi_beli - $mod + 100;
						} else {
							$prediksi_beli = $prediksi_beli - $mod;
						}
					}

					$stok = $db->get_var("
						SELECT
							SUM(a.sisa) jumlah
						FROM
							" . $table_stok_obat . " a
								INNER JOIN " . $table_obat_masuk . " b ON a.id_obat_masuk = b.id
						WHERE
							a.prop LIKE ''
								AND b.prop LIKE ''
								AND b.status LIKE 'sudah'
								AND a.id_obat = '" . $id_obat . "'
					");

					$html .= "
						<tr>
							<td id='nomor'>" . $nomor++ . "</td>
							<td id='id_obat' style='display: none;'>" .  $id_obat . "</td>
							<td id='kode_obat' style='display: none;'>" .  $kode_obat . "</td>
							<td id='nama_obat'><small>" .  $nama_obat . "</small></td>
							<td id='unit'><small>" .  $nama_unit . "</small></td>
							<td id='jumlah_jual_1' style='display: none;'><small>" .  $jumlah_jual_1 . "</small></td>
							<td id='f_jumlah_jual_1'><small>" .  ArrayAdapter::format("number", $jumlah_jual_1) . "</small></td>
							<td id='jumlah_jual_2' style='display: none;'><small>" .  $jumlah_jual_2 . "</small></td>
							<td id='f_jumlah_jual_2'><small>" .  ArrayAdapter::format("number", $jumlah_jual_2) . "</small></td>
							<td id='jumlah_jual_3' style='display: none;'><small>" .  $jumlah_jual_3 . "</small></td>
							<td id='f_jumlah_jual_3'><small>" .  ArrayAdapter::format("number", $jumlah_jual_3) . "</small></td>
							<td id='rerata_jual' style='display: none;'><small>" .  $rerata_jual . "</small></td>
							<td id='f_rerata_jual'><small>" .  ArrayAdapter::format("number", $rerata_jual) . "</small></td>
							<td id='prediksi_beli' style='display: none;'><small>" .  $prediksi_beli . "</small></td>
							<td id='f_prediksi_beli'><small>" .  ArrayAdapter::format("number", $prediksi_beli) . "</small></td>
							<td id='stok_akhir' style='display: none;'><small>" .  $stok . "</small></td>
							<td id='f_stok_akhir'><small>" .  ArrayAdapter::format("number", $stok) . "</small></td>
						</tr>
					";
				}
			}

			$data = array();
			$data['id_obat'] = ArrayAdapter::format("only-digit6", $id_obat);
			$data['kode_obat'] = $kode_obat;
			$data['nama_obat'] = $nama_obat;
			$data['nama_jenis_obat'] = $nama_jenis_obat;
			$data['html'] = $html;
			$data['nomor'] = $nomor;
			echo json_encode($data);
		} else if ($_POST['command'] == "export_pdf") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$alamat_entitas = getSettings($db, "smis_autonomous_address", "");
			$jenis_filter = $_POST['jenis_filter'];
			$nama_obat = $_POST['nama_obat'];
			$nama_jenis_obat = $_POST['nama_jenis_obat'];
			$unit_slug = $_POST['unit_slug'];
			$unit_label = $_POST['unit_label'];
			$bulan = $_POST['bulan'];
			$bulan_label = $_POST['bulan_label'];
			$tahun = $_POST['tahun'];

			$bulan_1_label = $_POST['bulan_1_label'];
			$bulan_2_label = $_POST['bulan_2_label'];
			$bulan_3_label = $_POST['bulan_3_label'];

			$margin_left = 5;
			$margin_top = 5;
			$total = 0;
			$jumlah_item = $_POST['num_rows'];
			$jumlah_item_per_halaman = 30;
			$jumlah_halaman = floor($jumlah_item / $jumlah_item_per_halaman) + 1;
			$data = json_decode($_POST['d_data'], true);

			require_once("pembelian/library/PDF.php");
			$fpdf = new PDF("L", "mm", array(200, 445));
			$fpdf->SetFont("Arial", "B", 8);
			$fpdf->SetMargins($margin_left, $margin_top);

			$detail_info = json_decode($_POST['d_data'], true);

			$jumlah_item = count($detail_info);
			$jumlah_item_per_halaman = 25;
			$jumlah_halaman = ceil($jumlah_item / $jumlah_item_per_halaman);

			$cur_item_index = 0;
			for ($cur_page = 1; $cur_page <= $jumlah_halaman; $cur_page++) {
				$fpdf->AddPage();
				$fpdf->SetY($last_y + 10);
				$fpdf->SetX(5);
				$fpdf->Ln(4);
				$fpdf->SetFont("Arial", "B", 9);
				$fpdf->Cell(435, 5, "LAPORAN RENCANA PEMBELIAN", 0, 0, "C");
				$fpdf->Ln(5);
				$fpdf->SetFont("Arial", "B", 7);

				$filter_data = "Semua";
				if ($jenis_filter == "per_obat") {
					$filter_data = "Per Obat (" . $nama_obat . ")";
				} else if ($jenis_filter == "per_jenis") {
					$filter_data = "Per Jenis (" . $nama_jenis_obat . ")";
				}

				$fpdf->Cell(435, 5, "Periode : " . $bulan_label . " " . $tahun . " | Klinik : " . $unit_label . " | Filter Data : " . $filter_data . " | Halaman : " . $cur_page . " / " . $jumlah_halaman, 0, 0, "C");
				$fpdf->Ln(7);
				$fpdf->SetFont("Arial", "B", 8);
				$lastX = $fpdf->GetX();
				$lastY = $fpdf->GetY();
				$fpdf->Cell(10, 10, "No.", 1, 0, "C");
				$fpdf->Cell(100, 10, "Nama Obat", 1, 0, "C");
				$fpdf->Cell(70, 10, "Nama Klinik", 1, 0, "C");
				$fpdf->Cell(135, 5, "Jumlah Penjualan", 1, 0, "C");
				$fpdf->Cell(30, 10, "Rerata Penjualan", 1, 0, "C");
				$fpdf->Cell(40, 10, "", 1, 1, "C");
				$fpdf->SetX($lastX);
				$fpdf->SetY($lastY);
				$fpdf->Cell(345, 5, "", 0, 0, "C");
				$fpdf->Cell(40, 5, "Rencana Pembelian", 0, 0, "C");
				$fpdf->Cell(50, 10, "Stok Akhir", 1, 1, "C");
				$fpdf->SetX($lastX);
				$fpdf->SetY($lastY + 5);
				$fpdf->Cell(180, 5, "", 0, 0, "C");
				$fpdf->Cell(45, 5, $bulan_1_label, 1, 0, "C");
				$fpdf->Cell(45, 5, $bulan_2_label, 1, 0, "C");
				$fpdf->Cell(45, 5, $bulan_3_label, 1, 0, "C");
				$fpdf->Cell(30, 10, "", 0, 0, "C");
				$fpdf->Cell(40, 5, $bulan_label . " " . $tahun, 0, 0, "C");
				$fpdf->Cell(50, 5, "", 0, 1, "C");
				for ($cur_item_num = 1; $cur_item_num <= $jumlah_item_per_halaman && $cur_item_index < $jumlah_item; $cur_item_num++) {
					$fpdf->SetFont("Arial", "", 8);
					$lastX = $fpdf->GetX();
					$lastY = $fpdf->GetY();
					$fpdf->Cell(10, 5, $detail_info[$cur_item_index]['nomor'], 1, 0);
		            $fpdf->MultiCell(100, 5, $detail_info[$cur_item_index]['nama_obat'], 1, "L", false, 1);
		            $fpdf->SetX($lastX);
		            $fpdf->SetY($lastY);
		            $fpdf->Cell(110, 5, "", 0, 0);
		            $fpdf->MultiCell(70, 5, $detail_info[$cur_item_index]['unit'], 1, "L", false, 1);
		            $fpdf->SetX($lastX);
		            $fpdf->SetY($lastY);
		            $fpdf->Cell(180, 5, "", 0, 0);
		            $fpdf->Cell(45, 5, $detail_info[$cur_item_index]['jumlah_jual_1'], 1, 0, "R");
					$fpdf->Cell(45, 5, $detail_info[$cur_item_index]['jumlah_jual_2'], 1, 0, "R");
					$fpdf->Cell(45, 5, $detail_info[$cur_item_index]['jumlah_jual_3'], 1, 0, "R");
					$fpdf->Cell(30, 5, $detail_info[$cur_item_index]['rerata_jual'], 1, 0, "R");
					$fpdf->Cell(40, 5, $detail_info[$cur_item_index]['prediksi_beli'], 1, 0, "R");
					$fpdf->Cell(50, 5, $detail_info[$cur_item_index]['stok_akhir'], 1, 1, "R");
					$cur_item_index++;
				}
			}

			global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "laporan_rencana_pembelian.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			$pack = new ResponsePackage();
			$pack->setContent($pathfile);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
			echo json_encode($pack->getPackage());
		}
		return;
	}

	$form = new Form("", "", "Pembelian : Laporan Rencana Pembelian");

	$bulan_option = new OptionBuilder();
	$bulan_option->add("Januari", "1", date("m") == 1 ? "1" : "");
	$bulan_option->add("Pebruari", "2", date("m") == 2 ? "1" : "");
	$bulan_option->add("Maret", "3", date("m") == 3 ? "1" : "");
	$bulan_option->add("April", "4", date("m") == 4 ? "1" : "");
	$bulan_option->add("Mei", "5", date("m") == 5 ? "1" : "");
	$bulan_option->add("Juni", "6", date("m") == 6 ? "1" : "");
	$bulan_option->add("Juli", "7", date("m") == 7 ? "1" : "");
	$bulan_option->add("Agustus", "8", date("m") == 8 ? "1" : "");
	$bulan_option->add("September", "9", date("m") == 9 ? "1" : "");
	$bulan_option->add("Oktober", "10", date("m") == 10 ? "1" : "");
	$bulan_option->add("Nopember", "11", date("m") == 11 ? "1" : "");
	$bulan_option->add("Desember", "12", date("m") == 12 ? "1" : "");
	$bulan_select = new Select("lrpb_bulan", "lrpb_bulan", $bulan_option->getContent());
	$form->addElement("Bulan", $bulan_select);

	$tahun_option = new OptionBuilder();
	$tahun_option->addSingle(date("Y") - 2);
	$tahun_option->addSingle(date("Y") - 1);
	$tahun_option->add(date("Y"), date("Y"), "1");
	$tahun_option->addSingle(date("Y") + 1);
	$tahun_option->addSingle(date("Y") + 2);
	$tahun_select = new Select("lrpb_tahun", "lrpb_tahun", $tahun_option->getContent());
	$form->addElement("Tahun", $tahun_select);

	$jenis_filter_option = new OptionBuilder();
	$jenis_filter_option->add("SEMUA", "semua", "1");
	$jenis_filter_option->add("PER OBAT", "per_obat");
	$jenis_filter_option->add("PER JENIS", "per_jenis");
	$jenis_filter_select = new Select("lrpb_jenis_filter", "lrpb_jenis_filter", $jenis_filter_option->getContent());
	$form->addElement("Jenis Filter", $jenis_filter_select);
	$kode_jenis_obat_hidden = new Hidden("lrpb_kode_jenis_obat", "lrpb_kode_jenis_obat", "");
	$form->addElement("", $kode_jenis_obat_hidden);
	$id_obat_hidden = new Hidden("lrpb_id_obat", "lrpb_id_obat", "");
	$form->addElement("", $id_obat_hidden);
	$nama_obat_text = new Text("lrpb_nama_obat", "lrpb_nama_obat", "");
	$nama_obat_text->setAtribute("disabled='disabled'");
	$nama_obat_text->setClass("smis-one-option-input");
	$browse_button = new Button("", "", "Pilih");
	$browse_button->setClass("btn-info");
	$browse_button->setIcon("fa fa-list");
	$browse_button->setIsButton(Button::$ICONIC);
	$browse_button->setAction("lrpb_obat.chooser('lrpb_obat', 'lrpb_obat_button', 'lrpb_obat', lrpb_obat, 'Obat')");
	$browse_button->setAtribute("id='lrpb_browse_obat_button'");
	$input_group = new InputGroup("");
	$input_group->addComponent($nama_obat_text);
	$input_group->addComponent($browse_button);
	$form->addElement("Obat", $input_group);
	$nama_jenis_obat_text = new Text("lrpb_nama_jenis_obat", "lrpb_nama_jenis_obat", "");
	$nama_jenis_obat_text->setAtribute("disabled='disabled'");
	$nama_jenis_obat_text->setClass("smis-one-option-input");
	$browse_button = new Button("", "", "Pilih");
	$browse_button->setClass("btn-info");
	$browse_button->setIcon("fa fa-list");
	$browse_button->setIsButton(Button::$ICONIC);
	$browse_button->setAction("lrpb_jenis_obat.chooser('lrpb_jenis_obat', 'lrpb_jenis_obat_button', 'lrpb_jenis_obat', lrpb_jenis_obat, 'Jenis Obat')");
	$browse_button->setAtribute("id='lrpb_browse_jenis_obat_button'");
	$input_group = new InputGroup("");
	$input_group->addComponent($nama_jenis_obat_text);
	$input_group->addComponent($browse_button);
	$form->addElement("Jenis Obat", $input_group);

	$unit_option = new OptionBuilder();
	$unit_option->add("Semua", "semua", "1");
	$unit_option->add("Klinik Batam Centre", "depo_farmasi_batam_centre");
	$unit_option->add("Klinik Batu Aji", "depo_farmasi_batu_aji");
	$unit_option->add("Klinik Bengkong", "depo_farmasi_bengkong");
	$unit_option->add("Klinik Jodoh", "depo_farmasi_jodoh");
	$unit_option->add("Klinik Panbil", "depo_farmasi_panbil");
	$unit_option->add("Klinik Tanjung Piayu", "depo_farmasi_piayu");
	$unit_option->add("Klinik Sekupang", "depo_farmasi_sekupang");
	$unit_option->add("Klinik Tanjung Uncang", "depo_farmasi_tanjung_uncang");
	$unit_option->add("Klinik Utama", "depo_farmasi_utama");
	$unit_select = new Select("lrpb_unit", "lrpb_unit", $unit_option->getContent());
	$form->addElement("Klinik", $unit_select);

	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAtribute("id='lrpb_show_button'");
	$show_button->setAction("lrpb.view()");
	$download_button = new Button("", "", "Eksport XLS");
	$download_button->setClass("btn-inverse");
	$download_button->setIcon("fa fa-download");
	$download_button->setIsButton(Button::$ICONIC);
	$download_button->setAtribute("id='lrpb_export_button'");
	$form->addElement("", $show_button);
	$form->addElement("", $download_button);

	$table = new Table(
		array("No.", "Nama Obat", "Nama Klinik", "Jumlah Penjualan Bulan I", "Jumlah Penjualan Bulan II", "Jumlah Penjualan Bulan III", "Rata-Rata Penjualan", "Perkiraan Pembelian", "Stok Akhir"),
		"",
		null,
		true
	);
	$table->setName("lrpb");
	$table->setAction(false);
	$table->setFooterVisible(false);
	$table->setHeaderVisible(false);
	$table->addHeader("before", "
		<tr class='inverse lrpb_header_normal'>
			<th rowspan='2'>No</th>
			<th rowspan='2'>Nama Obat</th>
			<th rowspan='2'>Nama Klinik</th>
			<th colspan='3'>Jumlah Penjualan</th>
			<th rowspan='2'>Rerata Penjualan</th>
			<th rowspan='2'>Perkiraan Pembelian <span id='label_perkiraan_pembelian'></span></th>
			<th rowspan='2'>Stok Akhir</th>
		</tr>
		<tr class='inverse lrpb_header_normal'>
			<th><span id='label_bulan_1'></span></th>
			<th><span id='label_bulan_2'></span></th>
			<th><span id='label_bulan_3'></span></th>
		</tr>
	");

	$loading_bar = new LoadingBar("lrpb_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lrpb.cancel()");
	$loading_modal = new Modal("lrpb_loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);
	
	echo $loading_modal->getHtml();
	echo $form->getHtml();
	echo $table->getHtml();
	echo "<div id='lrpb_info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("base-js/smis-base-loading.js");
?>
<script type="text/javascript">
	function LRPBAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LRPBAction.prototype.constructor = LRPBAction;
	LRPBAction.prototype = new TableAction();
	LRPBAction.prototype.view = function() {
		var self = this;
		$("#lrpb_info").empty();
		$("#lrpb_loading_bar").sload("true", "Harap ditunggu...", 0);
		$("#lrpb_loading_modal").smodal("show");
		FINISHED = false;
		var data = this.getRegulerData();
		data['command'] = "get_jumlah_obat";
		data['jenis_filter'] = $("#lrpb_jenis_filter").val();
		data['id_obat'] = $("#lrpb_id_obat").val();
		data['nama_obat'] = $("#lrpb_nama_obat").val();
		data['nama_jenis_obat'] = $("#lrpb_nama_jenis_obat").val();
		data['']
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("#lrpb_list").empty();
				self.fillHtml(0, json.jumlah, 1);
			}
		);
	};
	LRPBAction.prototype.fillHtml = function(num, limit, nomor) {
		if (FINISHED || num == limit) {
			if (FINISHED == false && num == limit) {
				this.finalize();
			} else {
				$("#lrpb_loading_modal").smodal("hide");
				$("#lrpb_info").html(
					"<div class='alert alert-block alert-inverse'>" +
						 "<center><strong>PROSES DIBATALKAN</strong></center>" +
					 "</div>"
				);
				$("#lrpb_export_button").removeAttr("onclick");
				$("#lrpb_export_button").hide();
				$("#lrpb_show_button").show();
			}
			return;
		}
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "get_info_obat";
		data['num'] = num;
		data['jenis_filter'] = $("#lrpb_jenis_filter").val();
		data['id_obat'] = $("#lrpb_id_obat").val();
		data['nama_obat'] = $("#lrpb_nama_obat").val();
		data['nama_jenis_obat'] = $("#lrpb_nama_jenis_obat").val();
		data['unit_slug'] = $("#lrpb_unit").val();
		data['unit_label'] = $("#lrpb_unit option:selected").text();
		data['bulan'] = $("#lrpb_bulan").val();
		data['tahun'] = $("#lrpb_tahun").val();
		data['nomor'] = nomor;
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("tbody#lrpb_list").append(
					json.html
				);
				$("#lrpb_loading_bar").sload("true", json.id_obat + " - " + json.kode_obat + " - " + json.nama_obat + " - " + json.nama_jenis_obat + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
				self.fillHtml(num + 1, limit, json.nomor);
			}
		);
	};
	LRPBAction.prototype.finalize = function() {
		var num_rows = $("tbody#lrpb_list tr").length;
		$("#lrpb_loading_modal").smodal("hide");
		$("#lrpb_info").html(
			"<div class='alert alert-block alert-info'>" +
				 "<center><strong>PROSES SELESAI</strong></center>" +
			 "</div>"
		);
		$("#lrpb_export_button").removeAttr("onclick");
		$("#lrpb_export_button").attr("onclick", "lrpb.export_pdf()");
		$("#lrpb_export_button").show();
		$("#lrpb_show_button").hide();

		$("#lrpb_bulan").attr("disabled", "disabled");
		$("#lrpb_tahun").attr("disabled", "disabled");
		$("#lrpb_jenis_filter").attr("disabled", "disabled");
		$("#lrpb_browse_obat_button").removeAttr("onclick");
		$("#lrpb_browse_jenis_obat_button").removeAttr("onclick");
		$("#lrpb_unit").attr("disabled", "disabled");
	};
	LRPBAction.prototype.cancel = function() {
		FINISHED = true;
	};
	LRPBAction.prototype.export_pdf = function() {
		showLoading();
		var num_rows = $("#lrpb_list").children("tr").length;
		var d_data = {};
		for (var i = 0; i < num_rows; i++) {
			var nomor = $("tbody#lrpb_list tr:eq(" + i + ") td#nomor").text();
			var id_obat = $("tbody#lrpb_list tr:eq(" + i + ") td#id_obat").text();
			var kode_obat = $("tbody#lrpb_list tr:eq(" + i + ") td#kode_obat").text();
			var nama_obat = $("tbody#lrpb_list tr:eq(" + i + ") td#nama_obat").text();
			var unit = $("tbody#lrpb_list tr:eq(" + i + ") td#unit").text();
			var jumlah_jual_1 = $("tbody#lrpb_list tr:eq(" + i + ") td#jumlah_jual_1").text();
			var jumlah_jual_2 = $("tbody#lrpb_list tr:eq(" + i + ") td#jumlah_jual_2").text();
			var jumlah_jual_3 = $("tbody#lrpb_list tr:eq(" + i + ") td#jumlah_jual_3").text();
			var rerata_jual = $("tbody#lrpb_list tr:eq(" + i + ") td#rerata_jual").text();
			var prediksi_beli = $("tbody#lrpb_list tr:eq(" + i + ") td#prediksi_beli").text();
			var stok_akhir = $("tbody#lrpb_list tr:eq(" + i + ") td#stok_akhir").text();
			d_data[i] = {
				'nomor' : nomor,
				'id_obat' : id_obat,
				'kode_obat' : kode_obat,
				'nama_obat' : nama_obat,
				'unit' : unit,
				'jumlah_jual_1' : jumlah_jual_1,
				'jumlah_jual_2' : jumlah_jual_2,
				'jumlah_jual_3' : jumlah_jual_3,
				'rerata_jual' : rerata_jual,
				'prediksi_beli' : prediksi_beli,
				'stok_akhir' : stok_akhir
			};
		}
		var data = this.getRegulerData();
		data['command'] = "export_pdf";
		data['jenis_filter'] = $("#lrpb_jenis_filter").val();
		data['nama_obat'] = $("#lrpb_nama_obat").val();
		data['nama_obat'] = $("#lrpb_nama_obat").val();
		data['nama_jenis_obat'] = $("#lrpb_nama_jenis_obat").val();
		data['unit_slug'] = $("#lrpb_unit").val();
		data['unit_label'] = $("#lrpb_unit option:selected").text();
		data['bulan'] = $("#lrpb_bulan").val();
		data['bulan_label'] = $("#lrpb_bulan option:selected").text();
		data['tahun'] = $("#lrpb_tahun").val();
		data['bulan_1_label'] = $("#label_bulan_1").html();
		data['bulan_2_label'] = $("#label_bulan_2").html();
		data['bulan_3_label'] = $("#label_bulan_3").html();
		data['d_data'] = JSON.stringify(d_data);
		data['num_rows'] = num_rows;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					dismissLoading();
					return;
				}
				var getUrl = window.location['pathname'] + json;
	            window.open(getUrl, 'pdf');
	            dismissLoading();
			}
		);
	};

	function LRPBObatAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LRPBObatAction.prototype.constructor = LRPBObatAction;
	LRPBObatAction.prototype = new TableAction();
	LRPBObatAction.prototype.selected = function(json) {
		$("#lrpb_id_obat").val(json.id);
		$("#lrpb_nama_obat").val(json.nama);
	};
	
	function LRPBJenisObatAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LRPBJenisObatAction.prototype.constructor = LRPBJenisObatAction;
	LRPBJenisObatAction.prototype = new TableAction();
	LRPBJenisObatAction.prototype.selected = function(json) {
		$("#lrpb_kode_jenis_obat").val(json.kode);
		$("#lrpb_nama_jenis_obat").val(json.nama);
	};

	var lrpb;
	var lrpb_obat;
	var lrpb_jenis_obat;
	var FINISHED;
	$(document).ready(function() {
		lrpb_obat = new LRPBObatAction(
			"lrpb_obat",
			"pembelian",
			"laporan_rencana_pembelian",
			new Array()
		);
		lrpb_obat.setSuperCommand("lrpb_obat");
		lrpb_jenis_obat = new LRPBJenisObatAction(
			"lrpb_jenis_obat",
			"pembelian",
			"laporan_rencana_pembelian",
			new Array()
		);
		lrpb_jenis_obat.setSuperCommand("lrpb_jenis_obat");
		lrpb = new LRPBAction(
			"lrpb",
			"pembelian",
			"laporan_rencana_pembelian",
			new Array()
		);

		$("#laporan_rencana_pembelian > div.form-container > form > div:nth-child(7)").hide();
		$("#laporan_rencana_pembelian > div.form-container > form > div:nth-child(8)").hide();
		$("#lrpb_jenis_filter").on("change", function() {
			var jenis_filter = $(this).val();
			$("#lrpb_id_obat").val("");
			$("#lrpb_nama_obat").val("");
			$("#lrpb_kode_jenis_obat").val("");
			$("#lrpb_jenis_obat").val("");
			if (jenis_filter == "semua") {
				$("#laporan_rencana_pembelian > div.form-container > form > div:nth-child(7)").hide();
				$("#laporan_rencana_pembelian > div.form-container > form > div:nth-child(8)").hide();
			} else if (jenis_filter == "per_obat") {
				$("#laporan_rencana_pembelian > div.form-container > form > div:nth-child(7)").show();
				$("#laporan_rencana_pembelian > div.form-container > form > div:nth-child(8)").hide();
			} else if (jenis_filter == "per_jenis") {
				$("#laporan_rencana_pembelian > div.form-container > form > div:nth-child(7)").hide();
				$("#laporan_rencana_pembelian > div.form-container > form > div:nth-child(8)").show();
			}
		});
		$("#lrpb_loading_modal").on("show", function() {
			$("a.close").hide();
		});
		$("#lrpb_loading_modal").on("hide", function() {
			$("a.close").show();
		});
		$("tbody#lrpb_list").append(
			"<tr>" +
				"<td colspan='10'><strong><center><small>DATA RENCANA PEMBELIAN BELUM DIPROSES</small></center></strong></td>" +
			"</tr>"
		);

		function updateLabel() {
			var cur_bulan_val = $("#lrpb_bulan").val();
			var cur_bulan_label = $("#lrpb_bulan option:selected").text();
			var cur_tahun = $("#lrpb_tahun").val();

			var bulan_1_val = cur_bulan_val - 3;
			var bulan_2_val = cur_bulan_val - 2;
			var bulan_3_val = cur_bulan_val - 1;
			var tahun_1 = cur_tahun;
			var tahun_2 = cur_tahun;
			var tahun_3 = cur_tahun;
			if (bulan_1_val <= 0) {
				bulan_1_val += 12;
				tahun_1 = cur_tahun - 1;
			}
			if (bulan_2_val <= 0) {
				bulan_2_val += 12;
				tahun_2 = cur_tahun - 1;
			}
			if (bulan_3_val <= 0) {
				bulan_3_val += 12;
				tahun_3 = cur_tahun - 1;
			}
			var bulan_arr = {
				1 : "Januari",
				2 : "Pebruari",
				3 : "Maret",
				4 : "April",
				5 : "Mei",
				6 : "Juni",
				7 : "Juli",
				8 : "Agustus",
				9 : "September",
				10 : "Oktober",
				11 : "Nopember",
				12 : "Desember"
			};
			var bulan_1_label = bulan_arr[bulan_1_val];		
			var bulan_2_label = bulan_arr[bulan_2_val];
			var bulan_3_label = bulan_arr[bulan_3_val];

			$("#label_perkiraan_pembelian").html(cur_bulan_label + " " + cur_tahun);
			$("#label_bulan_1").html(bulan_1_label + " " + tahun_1);
			$("#label_bulan_2").html(bulan_2_label + " " + tahun_2);
			$("#label_bulan_3").html(bulan_3_label + " " + tahun_3);
		}

		$("#lrpb_bulan").on("change", updateLabel);
		$("#lrpb_tahun").on("change", updateLabel);

		$("#lrpb_bulan").trigger("change");
		$("#lrpb_tahun").trigger("change");

		$("#lrpb_export_button").hide();
	});
</script>