function RiwayatOPLAction(name, page, action, column) {
    this.initialize(name, page, action, column);
}
RiwayatOPLAction.prototype.constructor = RiwayatOPLAction;
RiwayatOPLAction.prototype = new TableAction();
RiwayatOPLAction.prototype.addRegulerData = function(data) {
    data['tanggal_dari'] = $("#opl_tanggal_dari").val();
    data['tanggal_sampai'] = $("#opl_tanggal_sampai").val();
    data['klinik'] = $("#opl_klinik").val();
    data['label_klinik'] = $("#opl_klinik option:selected").text();
    data['nomor_opl'] = $("#opl_nomor_opl").val();
    return data;
};
RiwayatOPLAction.prototype.export_xls = function (id) {
    var data = this.getRegulerData();
    data['command'] = "export_xls";
    data['id'] = id;
    postForm(data);
};
RiwayatOPLAction.prototype.export_pdf = function (id) {
    var self = this;
    var data = this.getRegulerData();
    data['command'] = "edit";
    data['id'] = id;
    showLoading();
    $.post(
        "",
        data,
        function(edit_response) {
            var edit_json = getContent(edit_response);
            if (edit_json == null) {
                dismissLoading();
                return;
            }
            if (edit_json.oot == 0 && edit_json.prekursor_farmasi == 0) {
                $("#opl_id").val(id);
                $("#download_pdf_confirm").smodal("show");
                dismissLoading();
            } else {
                data['command'] = "export_pdf";
                data['id'] = id;
                $.post(
                    "",
                    data,
                    function (response) {
                        var json = getContent(response);
                        if (json == null) {
                            dismissLoading();
                            return;
                        }
                        var getUrl = window.location['pathname'] + json;
                        window.open(getUrl, 'pdf');
                        dismissLoading();
                    }
                );
            }
        }
    );
};
RiwayatOPLAction.prototype.download_pdf = function() {
    var data = this.getRegulerData(); 
    data['command'] = "export_pdf";
    data['id'] = $("#opl_id").val();
    data['format_opl'] = $("#opl_format").val();
    $.post(
        "",
        data,
        function (response) {
            var json = getContent(response);
            if (json == null) {
                dismissLoading();
                return;
            }
            $("#download_pdf_confirm").smodal("hide");
            var getUrl = window.location['pathname'] + json;
            window.open(getUrl, 'pdf');
            dismissLoading();
        }
    );   
};
RiwayatOPLAction.prototype.detail = function (id) {
    var self = this;
    var data = this.getRegulerData();
    data['command'] = "edit";
    data['id'] = id;
    $.post(
        "",
        data,
        function (response) {
            var json = getContent(response);
            if (json == null)
                return;
            data = self.getRegulerData();
            if (json.medis == 1) {
                data['action'] = "pembuatan_opl_form";
            } else {
                data['action'] = "pembuatan_opl_nm_form";
            }
            data['super_command'] = "";
            data['id'] = json.id;
            data['f_id'] = json.f_id;
            data['nomor'] = json.nomor;
            data['tanggal'] = json.tanggal;
            data['id_vendor'] = json.id_vendor;
            data['kode_vendor'] = json.kode_vendor;
            data['nama_vendor'] = json.nama_vendor;
            data['alamat_vendor'] = json.alamat_vendor;
            data['kota_vendor'] = json.kota_vendor;
            data['kodepos_vendor'] = json.kodepos_vendor;
            data['klinik'] = json.klinik;
            data['alamat_klinik'] = json.alamat_klinik;
            data['telpon_klinik'] = json.telpon_klinik;
            data['no_ijin_klinik'] = json.no_ijin_klinik;
            data['medis'] = json.medis;
            data['tipe'] = json.tipe;
            data['use_ppn'] = json.use_ppn;
            data['diskon'] = json.diskon;
            data['t_diskon'] = json.t_diskon;
            data['editable'] = "false";
            data['prekursor_farmasi'] = json.prekursor_farmasi;
            data['main_page'] = "riwayat_opl";
            LoadSmisPage(data);
        }
    );
};