function PersetujuanOPLAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
PersetujuanOPLAction.prototype.constructor = PersetujuanOPLAction;
PersetujuanOPLAction.prototype = new TableAction();
PersetujuanOPLAction.prototype.approve = function() {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = $("#persetujuan_opl_id").val();
	data['lock_acc'] = "1";
	bootbox.dialog({
		message : "Yakin memberikan persetujuan OPL ini?",
		title	: "Konfirmasi",
		buttons	: {
			success : {
				label 		: "Lanjutkan",
				className 	: "btn-success",
				callback	: function() {
					showLoading();
					$.post(
						"",
						data,
						function() {
							dismissLoading();
							self.back();
						}
					);
				}
			},
			danger 	: {
				label 		: "Batal",
				className	: "btn-inverse"
			}
		}
	});
};
PersetujuanOPLAction.prototype.edit = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "edit";
	data['id'] = id;
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) 
				return;
			data = self.getRegulerData();
			data['action'] = "persetujuan_opl_form";
			data['super_command'] = "";
			data['id'] = json.id;
			data['f_id'] = json.f_id;
			data['nomor'] = json.nomor;
			data['tanggal'] = json.tanggal;
			data['id_vendor'] = json.id_vendor;
			data['kode_vendor'] = json.kode_vendor;
			data['nama_vendor'] = json.nama_vendor;
			data['alamat_vendor'] = json.alamat_vendor;
			data['kota_vendor'] = json.kota_vendor;
			data['kodepos_vendor'] = json.kodepos_vendor;
			data['medis'] = json.medis;
			data['tipe'] = json.tipe;
			data['use_ppn'] = json.use_ppn;
			data['diskon'] = json.diskon;
			data['t_diskon'] = json.t_diskon;
			data['klinik'] = json.klinik;
			data['alamat_klinik'] = json.alamat_klinik;
			data['telpon_klinik'] = json.telpon_klinik;
			data['no_ijin_klinik'] = json.no_ijin_klinik;
			data['editable'] = "false";
			LoadSmisPage(data);
		}
	);
};
PersetujuanOPLAction.prototype.cancel_acc = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = id;
	data['lock_acc'] = "0";
	bootbox.dialog({
		message : "Yakin membatalkan persetujuan OPL ini?",
		title	: "Konfirmasi",
		buttons	: {
			success : {
				label 		: "Lanjutkan",
				className 	: "btn-success",
				callback	: function() {
					showLoading();
					$.post(
						"",
						data,
						function() {
							dismissLoading();
							self.back();
						}
					);
				}
			},
			danger 	: {
				label 		: "Batal",
				className	: "btn-inverse"
			}
		}
	});
};
PersetujuanOPLAction.prototype.show_detail_form = function(id) {
	if ($("#total").length != 0)
		return;
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "show_detail";
	data['id'] = id;
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) return;
			console.log(json);
			$("#dpersetujuan_opl_list").html(json.html);
			self.update_total();
			row_num = json.row_num;
		}
	);
};
PersetujuanOPLAction.prototype.get_footer = function() {
	$("#table_dpersetujuan_opl tfoot").html("");
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "show_footer";
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) return;
			$("tbody#dpersetujuan_opl_list").after(json.html);
			self.update_total();
		}
	);
};
PersetujuanOPLAction.prototype.update_total = function() {
	var num_rows = $("tbody#dpersetujuan_opl_list").children("tr.detail").length;
	var total = 0;
	var nomor = 1;
	for (var i = 0; i < num_rows; i++) {
		var subtotal = parseFloat($("tbody#dpersetujuan_opl_list tr.detail:eq(" + i + ") td#subtotal").text());
		var deleted = $("tbody#dpersetujuan_opl_list tr.detail:eq(" + i + ")").attr("class") == "deleted" ? true : false;
		if (!deleted) {
			total += subtotal;
			$("tbody#dpersetujuan_opl_list tr.detail:eq(" + i + ") td:eq(0)").html("<small>" + nomor + "</small>");
			nomor++;
		}
	}
	var global_diskon = parseFloat($("#persetujuan_opl_diskon").val().replace(/[^0-9-,]/g, '').replace(",", "."));
	var global_t_diskon = $("#persetujuan_opl_t_diskon").val();
	if (global_t_diskon == "persen")
		global_diskon = global_diskon * total / 100;
	else
		global_diskon = global_diskon;
	global_diskon = Math.floor(global_diskon);
	var total_1 = total - global_diskon;
	var use_ppn = $("#persetujuan_opl_use_ppn").val();
	var ppn = Math.floor(total_1 * 0.1);
	if (use_ppn == 0)
		ppn = 0;
	var total_2 = total_1 + ppn;
	$("#total").html("<small><strong><div align='right'>" + total.formatMoney("2", ".", ",") + "</div></strong></small>");
	$("#diskon_global").html("<small><strong><div align='right'>" + global_diskon.formatMoney("2", ".", ",") + "</div></strong></small>");
	$("#total_2").html("<small><strong><div align='right'>" + total_1.formatMoney("2", ".", ",") + "</div></strong></small>");
	$("#ppn").html("<small><strong><div align='right'>" + ppn.formatMoney("2", ".", ",") + "</div></strong></small>");
	$("#tagihan").html("<small><strong><div align='right'>" + total_2.formatMoney("2", ".", ",") + "</div></strong></small>");
};
PersetujuanOPLAction.prototype.disapprove = function() {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = $("#persetujuan_opl_id").val();
	data['lock_opl'] = 0;
	bootbox.dialog({
		message : "Yakin mengembalikan OPL ini?",
		title	: "Konfirmasi",
		buttons	: {
			success : {
				label 		: "Lanjutkan",
				className 	: "btn-success",
				callback	: function() {
					showLoading();
					$.post(
						"",
						data,
						function() {
							dismissLoading();
							self.back();
						}
					);
				}
			},
			danger 	: {
				label 		: "Batal",
				className	: "btn-inverse"
			}
		}
	});
};
PersetujuanOPLAction.prototype.back = function() {
	var data = this.getRegulerData();
	data['action'] = "persetujuan_opl";
	data['super_command'] = "";
	data['kriteria'] = "";
	data['max'] = 5;
	data['number'] = 0;
	LoadSmisPage(data);
};