function PembuatanOPLAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
PembuatanOPLAction.prototype.constructor = PembuatanOPLAction;
PembuatanOPLAction.prototype = new TableAction();
PembuatanOPLAction.prototype.show_reguler_opl_add_form = function() {
	var data = this.getRegulerData();
	data['action'] = "pembuatan_opl_nm_form";
	data['super_command'] = "";
	data['id'] = "";
	data['f_id'] = "";
	data['nomor'] = "";
	data['tanggal'] = "";
	data['id_vendor'] = "";
	data['kode_vendor'] = "";
	data['nama_vendor'] = "";
	data['alamat_vendor'] = "";
	data['kota_vendor'] = "";
	data['kodepos_vendor'] = "";
	data['medis'] = "";
	data['editable'] = "true";
	LoadSmisPage(data);
};
PembuatanOPLAction.prototype.show_mandiri_opl_add_form = function() {
	var data = this.getRegulerData();
	data['action'] = "pembuatan_opl_nm_mandiri_form";
	data['super_command'] = "";
	data['id'] = "";
	data['f_id'] = "";
	data['nomor'] = "";
	data['tanggal'] = "";
	data['id_vendor'] = "";
	data['kode_vendor'] = "";
	data['nama_vendor'] = "";
	data['alamat_vendor'] = "";
	data['kota_vendor'] = "";
	data['kodepos_vendor'] = "";
	data['medis'] = "";
	data['editable'] = "true";
	LoadSmisPage(data);	
};
PembuatanOPLAction.prototype.show_detail_form = function(id, action) {
	if ($("#total").length != 0)
		return;
	var self = this;
	var data = this.getRegulerData();
	data['action'] = action;
	data['command'] = "show_detail";
	data['id'] = id;
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) return;
			$("#dpembuatan_opl_list").html(json.html);
			self.update_total();
			row_num = json.row_num;
		}
	);
};
PembuatanOPLAction.prototype.get_footer = function() {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "show_footer";
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) return;
			$("tbody#dpembuatan_opl_list").after(json.html);
			self.update_total();
		}
	);
};
PembuatanOPLAction.prototype.update_total = function() {
	var num_rows = $("tbody#dpembuatan_opl_list").children("tr").length;
	var nomor = 1;
	var total = 0;
	for (var i = 0; i < num_rows; i++) {
		var deleted = $("tbody#dpembuatan_opl_list tr:eq(" + i + ")").attr("class") == "deleted" ? true : false;
		if (!deleted) {
			var subtotal = parseFloat($("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#subtotal").text());
			total += subtotal;
			$("tbody#dpembuatan_opl_list tr:eq(" + i + ") td:eq(0)").html("<small>" + nomor + "</small>");
			nomor++;
		}
	}
	var global_diskon = parseFloat($("#pembuatan_opl_diskon").val().replace(/[^0-9-,]/g, '').replace(",", "."));
	var global_t_diskon = $("#pembuatan_opl_t_diskon").val();
	if (global_t_diskon == "persen")
		global_diskon = global_diskon * total / 100;
	else
		global_diskon = global_diskon;
	global_diskon = Math.floor(global_diskon);
	var total_1 = total - global_diskon;
	var use_ppn = $("#pembuatan_opl_use_ppn").val();
	var ppn = Math.floor(total_1 * 0.1);
	if (use_ppn == 0)
		ppn = 0;
	var total_2 = total_1 + ppn;

	total = parseFloat(total).formatMoney("2", ".", ",");
	global_diskon = parseFloat(global_diskon).formatMoney("2", ".", ",");
	total_1 = parseFloat(total_1).formatMoney("2", ".", ",");
	ppn = parseFloat(ppn).formatMoney("2", ".", ",");
	total_2 = parseFloat(total_2).formatMoney("2", ".", ",");

	$("#total").html("<small><strong><div align='right'>" + total + "</div></strong></small>");
	$("#diskon_global").html("<small><strong><div align='right'>" + global_diskon + "</div></strong></small>");
	$("#total_2").html("<small><strong><div align='right'>" + total_1 + "</div></strong></small>");
	$("#ppn").html("<small><strong><div align='right'>" + ppn + "</div></strong></small>");
	$("#tagihan").html("<small><strong><div align='right'>" + total_2 + "</div></strong></small>");
};
PembuatanOPLAction.prototype.getSaveData = function() {
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = $("#pembuatan_opl_id").val();
	data['f_id'] = $("#pembuatan_opl_f_id").val();
	data['tanggal'] = $("#pembuatan_opl_tanggal").val();
	data['id_vendor'] = $("#pembuatan_opl_id_vendor").val();
	data['kode_vendor'] = $("#pembuatan_opl_kode_vendor").val();
	data['nama_vendor'] = $("#pembuatan_opl_nama_vendor").val();
	data['alamat_vendor'] = $("#pembuatan_opl_alamat_vendor").val();
	data['kota_vendor'] = $("#pembuatan_opl_kota_vendor").val();
	data['kodepos_vendor'] = $("#pembuatan_opl_kodepos_vendor").val();
	data['medis'] = $("#pembuatan_opl_medis").val();
	data['use_ppn'] = $("#pembuatan_opl_use_ppn").val();
	data['diskon'] = $("#pembuatan_opl_diskon").val();
	data['t_diskon'] = $("#pembuatan_opl_t_diskon").val();
	data['tipe'] = $("#pembuatan_opl_tipe").val();
	data['keterangan'] = "-";
	var num_rows = $("tbody#dpembuatan_opl_list").children("tr").length;
	var detail = {};
	for (var i = 0; i < num_rows; i++) {
		var item = {
			id 					: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#id").text(),
			f_id				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#f_id").text(),
			id_barang			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#id_barang").text(),
			kode_barang			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#kode_barang").text(),
			nama_barang			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#nama_barang").text(),
			nama_jenis_barang	: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#nama_jenis_barang").text(),
			jumlah_diajukan		: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#jumlah_diajukan").text(),
			jumlah_dipesan		: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#jumlah_dipesan").text(),
			satuan				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#satuan").text(),
			konversi			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#konversi").text(),
			satuan_konversi		: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#satuan_konversi").text(),
			hpp					: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#hpp").text(),
			diskon				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#diskon").text(),
			t_diskon			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#t_diskon").text(),
			medis				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#medis").text(),
			inventaris			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#inventaris").text(),
			zat_aktif			: "",
			bentuk_sediaan		: "",
			kekuatan_sediaan	: "",
			deleted				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ")").hasClass("deleted")
		};
		detail[i] = item;
	}
	data['detail'] = JSON.stringify(detail);
	return data;
};
PembuatanOPLAction.prototype.validate = function() {
	var valid = true;
	var invalid_message = "";
	var tanggal = $("#pembuatan_opl_tanggal").val();
	var id_vendor = $("#pembuatan_opl_id_vendor").val();
	$(".error_field").removeClass("error_field");
	if (tanggal == "") {
		valid = false;
		invalid_message += "</br><strong>Tanggal</strong> tidak boleh kosong.";
		$("#pembuatan_opl_tanggal").addClass("error_field");
		$("#pembuatan_opl_tanggal").focus();
	}
	if (id_vendor == "") {
		valid = false;
		invalid_message += "</br><strong>Vendor</strong> tidak boleh kosong.";
		$("#pembuatan_opl_nama_vendor").addClass("error_field");
		$("#rencana_pembelian_farmasi_browse").focus();
	}
	if (!valid)
		bootbox.alert(invalid_message);
	return valid;
};
PembuatanOPLAction.prototype.save = function() {
	if (!this.validate())
		return;
	var self = this;
	var data = this.getSaveData();
	bootbox.dialog({
		message : "Yakin melakukan penyimpanan OPL ini?",
		title	: "Konfirmasi",
		buttons	: {
			success : {
				label 		: "Lanjutkan",
				className 	: "btn-success",
				callback	: function() {
					showLoading();
					$.post(
						"",
						data,
						function() {
							dismissLoading();
							self.back();
						}
					);
				}
			},
			danger 	: {
				label 		: "Batal",
				className	: "btn-inverse"
			}
		}
	});
};
PembuatanOPLAction.prototype.edit = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "edit";
	data['id'] = id;
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) 
				return;
			data = self.getRegulerData();
			console.log(json);
			if (json.f_id > 0)
				data['action'] = "pembuatan_opl_nm_form";
			else
				data['action'] = "pembuatan_opl_nm_mandiri_form";
			data['super_command'] = "";
			data['id'] = json.id;
			data['f_id'] = json.f_id;
			data['nomor'] = json.nomor;
			data['tanggal'] = json.tanggal;
			data['id_vendor'] = json.id_vendor;
			data['kode_vendor'] = json.kode_vendor;
			data['nama_vendor'] = json.nama_vendor;
			data['alamat_vendor'] = json.alamat_vendor;
			data['kota_vendor'] = json.kota_vendor;
			data['kodepos_vendor'] = json.kodepos_vendor;
			data['medis'] = json.medis;
			data['diskon'] = json.diskon;
			data['t_diskon'] = json.t_diskon;
			data['use_ppn'] = json.use_ppn;
			data['tipe'] = json.tipe;
			data['editable'] = "true";
			LoadSmisPage(data);
		}
	);
};
PembuatanOPLAction.prototype.detail = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "edit";
	data['id'] = id;
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) 
				return;
			data = self.getRegulerData();
			data['action'] = "pembuatan_opl_nm_form";
			data['super_command'] = "";
			data['id'] = json.id;
			data['f_id'] = json.f_id;
			data['nomor'] = json.nomor;
			data['tanggal'] = json.tanggal;
			data['id_vendor'] = json.id_vendor;
			data['kode_vendor'] = json.kode_vendor;
			data['nama_vendor'] = json.nama_vendor;
			data['alamat_vendor'] = json.alamat_vendor;
			data['kota_vendor'] = json.kota_vendor;
			data['kodepos_vendor'] = json.kodepos_vendor;
			data['medis'] = json.medis;
			data['diskon'] = json.diskon;
			data['t_diskon'] = json.t_diskon;
			data['use_ppn'] = json.use_ppn;
			data['tipe'] = json.tipe;
			data['editable'] = "false";
			LoadSmisPage(data);
		}
	);
};
PembuatanOPLAction.prototype.lock_opl = function(id) {
	if (!this.validate())
		return;
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = id;
	data['lock_opl'] = 1;
	bootbox.dialog({
		message : "Yakin melakukan penguncian OPL ini?",
		title	: "Konfirmasi",
		buttons	: {
			success : {
				label 		: "Lanjutkan",
				className 	: "btn-success",
				callback	: function() {
					showLoading();
					$.post(
						"",
						data,
						function() {
							dismissLoading();
							self.view();
						}
					);
				}
			},
			danger 	: {
				label 		: "Batal",
				className	: "btn-inverse"
			}
		}
	});
};
PembuatanOPLAction.prototype.export_xls = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "export_xls";
	data['id'] = id;
	postForm(data);
};
PembuatanOPLAction.prototype.export_pdf = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "export_pdf";
	data['id'] = id;
	showLoading();
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) {
				dismissLoading();
				return;
			}
			var getUrl = window.location['pathname'] + json;
            window.open(getUrl, 'pdf');
            dismissLoading();
		}
	);
};
PembuatanOPLAction.prototype.back = function() {
	var main_page = $("#pembuatan_opl_main_page").val();
	var data = this.getRegulerData();
	data['action'] = "pembuatan_opl_nm";
	if (main_page != "" && main_page != null) {
		data['action'] = main_page;
	}
	data['super_command'] = "";
	data['kriteria'] = "";
	data['max'] = 5;
	data['number'] = 0;
	LoadSmisPage(data);
};