function PembuatanOPLAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
PembuatanOPLAction.prototype.constructor = PembuatanOPLAction;
PembuatanOPLAction.prototype = new TableAction();
PembuatanOPLAction.prototype.show_reguler_opl_add_form = function() {
	var data = this.getRegulerData();
	data['action'] = "pembuatan_opl_form";
	data['super_command'] = "";
	data['id'] = "";
	data['f_id'] = "";
	data['nomor'] = "";
	data['tanggal'] = "";
	data['id_vendor'] = "";
	data['kode_vendor'] = "";
	data['nama_vendor'] = "";
	data['alamat_vendor'] = "";
	data['kota_vendor'] = "";
	data['kodepos_vendor'] = "";
	data['medis'] = "";
	data['klinik'] = "";
	data['alamat_klinik'] = "";
	data['telpon_klinik'] = "";
	data['no_ijin_klinik'] = "";
	data['editable'] = "true";
	LoadSmisPage(data);
};
PembuatanOPLAction.prototype.show_mandiri_opl_add_form = function() {
	var data = this.getRegulerData();
	data['action'] = "pembuatan_opl_mandiri_form";
	data['super_command'] = "";
	data['id'] = "";
	data['f_id'] = "";
	data['nomor'] = "";
	data['tanggal'] = "";
	data['id_vendor'] = "";
	data['kode_vendor'] = "";
	data['nama_vendor'] = "";
	data['alamat_vendor'] = "";
	data['kota_vendor'] = "";
	data['kodepos_vendor'] = "";
	data['medis'] = "";
	data['klinik'] = "";
	data['alamat_klinik'] = "";
	data['telpon_klinik'] = "";
	data['no_ijin_klinik'] = "";
	data['editable'] = "true";
	LoadSmisPage(data);	
};
PembuatanOPLAction.prototype.show_prekursor_farmasi_opl_add_form = function() {
	var data = this.getRegulerData();
	data['action'] = "pembuatan_opl_prekursor_farmasi_form";
	data['super_command'] = "";
	data['id'] = "";
	data['f_id'] = "";
	data['nomor'] = "";
	data['tanggal'] = "";
	data['id_vendor'] = "";
	data['kode_vendor'] = "";
	data['nama_vendor'] = "";
	data['alamat_vendor'] = "";
	data['kota_vendor'] = "";
	data['kodepos_vendor'] = "";
	data['medis'] = "";
	data['klinik'] = "";
	data['alamat_klinik'] = "";
	data['telpon_klinik'] = "";
	data['no_ijin_klinik'] = "";
	data['prekursor_farmasi'] = "1";
	data['editable'] = "true";
	LoadSmisPage(data);	
};
PembuatanOPLAction.prototype.show_oot_opl_add_form = function() {
	var data = this.getRegulerData();
	data['action'] = "pembuatan_opl_oot_form";
	data['super_command'] = "";
	data['id'] = "";
	data['f_id'] = "";
	data['nomor'] = "";
	data['tanggal'] = "";
	data['id_vendor'] = "";
	data['kode_vendor'] = "";
	data['nama_vendor'] = "";
	data['alamat_vendor'] = "";
	data['kota_vendor'] = "";
	data['kodepos_vendor'] = "";
	data['medis'] = "";
	data['klinik'] = "";
	data['alamat_klinik'] = "";
	data['telpon_klinik'] = "";
	data['no_ijin_klinik'] = "";
	data['oot'] = "1";
	data['editable'] = "true";
	LoadSmisPage(data);	
};
PembuatanOPLAction.prototype.show_detail_form = function(id) {
	if ($("#total").length != 0)
		return;
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "show_detail";
	data['id'] = id;
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) return;
			$("#dpembuatan_opl_list").html(json.html);
			self.update_total();
			row_num = json.row_num;
		}
	);
};
PembuatanOPLAction.prototype.get_footer = function() {
	$("#table_dpembuatan_opl tfoot").html("");
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "show_footer";
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) return;
			$("tbody#dpembuatan_opl_list").after(json.html);
			self.update_total();
		}
	);
};
PembuatanOPLAction.prototype.update_total = function() {
	var num_rows = $("tbody#dpembuatan_opl_list").children("tr").length;
	var nomor = 1;
	var total = 0;
	for (var i = 0; i < num_rows; i++) {
		var deleted = $("tbody#dpembuatan_opl_list tr:eq(" + i + ")").attr("class") == "deleted" ? true : false;
		if (!deleted) {
			var subtotal = parseFloat($("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#subtotal").text());
			total += subtotal;
			$("tbody#dpembuatan_opl_list tr:eq(" + i + ") td:eq(0)").html("<small>" + nomor + "</small>");
			nomor++;
		}
	}
	var global_diskon = parseFloat($("#pembuatan_opl_diskon").val().replace(/[^0-9-,]/g, '').replace(",", "."));
	var global_t_diskon = $("#pembuatan_opl_t_diskon").val();
	if (global_t_diskon == "persen")
		global_diskon = global_diskon * total / 100;
	else
		global_diskon = global_diskon;
	global_diskon = Math.floor(global_diskon);
	var total_1 = total - global_diskon;
	var use_ppn = $("#pembuatan_opl_use_ppn").val();
	var ppn = Math.floor(total_1 * 0.1);
	if (use_ppn == 0)
		ppn = 0;
	var total_2 = total_1 + ppn;

	total = parseFloat(total).formatMoney("2", ".", ",");
	global_diskon = parseFloat(global_diskon).formatMoney("2", ".", ",");
	total_1 = parseFloat(total_1).formatMoney("2", ".", ",");
	ppn = parseFloat(ppn).formatMoney("2", ".", ",");
	total_2 = parseFloat(total_2).formatMoney("2", ".", ",");

	$("#total").html("<small><strong><div align='right'>" + total + "</div></strong></small>");
	$("#diskon_global").html("<small><strong><div align='right'>" + global_diskon + "</div></strong></small>");
	$("#total_2").html("<small><strong><div align='right'>" + total_1 + "</div></strong></small>");
	$("#ppn").html("<small><strong><div align='right'>" + ppn + "</div></strong></small>");
	$("#tagihan").html("<small><strong><div align='right'>" + total_2 + "</div></strong></small>");
};
PembuatanOPLAction.prototype.getSaveData = function() {
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = $("#pembuatan_opl_id").val();
	data['f_id'] = $("#pembuatan_opl_f_id").val();
	data['tanggal'] = $("#pembuatan_opl_tanggal").val();
	data['id_vendor'] = $("#pembuatan_opl_id_vendor").val();
	data['kode_vendor'] = $("#pembuatan_opl_kode_vendor").val();
	data['nama_vendor'] = $("#pembuatan_opl_nama_vendor").val();
	data['alamat_vendor'] = $("#pembuatan_opl_alamat_vendor").val();
	data['kota_vendor'] = $("#pembuatan_opl_kota_vendor").val();
	data['kodepos_vendor'] = $("#pembuatan_opl_kodepos_vendor").val();
	data['klinik'] = $("#pembuatan_opl_klinik").val();
	data['alamat_klinik'] = $("#pembuatan_opl_alamat_klinik").val();
	data['telpon_klinik'] = $("#pembuatan_opl_telpon_klinik").val();
	data['no_ijin_klinik'] = $("#pembuatan_opl_no_ijin_klinik").val();
	data['medis'] = $("#pembuatan_opl_medis").val();
	data['keterangan'] = "-";
	data['tipe'] = $("#pembuatan_opl_tipe").val();
	data['use_ppn'] = $("#pembuatan_opl_use_ppn").val();
	data['diskon'] = $("#pembuatan_opl_diskon").val();
	data['t_diskon'] = $("#pembuatan_opl_t_diskon").val();
	if ($("#pembuatan_opl_prekursor_farmasi").length > 0)
		data['prekursor_farmasi'] = $("#pembuatan_opl_prekursor_farmasi").val();
	if ($("#pembuatan_opl_oot").length > 0)
		data['oot'] = $("#pembuatan_opl_oot").val();
	var num_rows = $("tbody#dpembuatan_opl_list").children("tr").length;
	var detail = {};
	for (var i = 0; i < num_rows; i++) {
		var item = {
			id 					: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#id").text(),
			f_id				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#f_id").text(),
			id_barang			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#id_barang").text(),
			kode_barang			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#kode_barang").text(),
			nama_barang			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#nama_barang").text(),
			nama_jenis_barang	: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#nama_jenis_barang").text(),
			jumlah_diajukan		: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#jumlah_diajukan").text(),
			jumlah_dipesan		: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#jumlah_dipesan").text(),
			satuan				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#satuan").text(),
			konversi			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#konversi").text(),
			satuan_konversi		: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#satuan_konversi").text(),
			hpp					: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#hpp").text(),
			diskon				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#diskon").text(),
			t_diskon			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#t_diskon").text(),
			medis				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#medis").text(),
			inventaris			: $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#inventaris").text(),
			deleted				: $("tbody#dpembuatan_opl_list tr:eq(" + i + ")").hasClass("deleted")
		};
		if ($("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#zat_aktif").length > 0)
			item['zat_aktif'] = $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#zat_aktif").text();
		if ($("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#bentuk_sediaan").length > 0)
			item['bentuk_sediaan'] = $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#bentuk_sediaan").text();
		if ($("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#kekuatan_sediaan").length > 0)
			item['kekuatan_sediaan'] = $("tbody#dpembuatan_opl_list tr:eq(" + i + ") td#kekuatan_sediaan").text();
		detail[i] = item;
	}
	data['detail'] = JSON.stringify(detail);
	return data;
};
PembuatanOPLAction.prototype.validate = function() {
	var valid = true;
	var invalid_message = "";
	var tanggal = $("#pembuatan_opl_tanggal").val();
	var id_vendor = $("#pembuatan_opl_id_vendor").val();
	$(".error_field").removeClass("error_field");
	if (tanggal == "") {
		valid = false;
		invalid_message += "</br><strong>Tanggal</strong> tidak boleh kosong.";
		$("#pembuatan_opl_tanggal").addClass("error_field");
		$("#pembuatan_opl_tanggal").focus();
	}
	if (id_vendor == "") {
		valid = false;
		invalid_message += "</br><strong>Vendor</strong> tidak boleh kosong.";
		$("#pembuatan_opl_nama_vendor").addClass("error_field");
		$("#rencana_pembelian_farmasi_browse").focus();
	}
	if (!valid)
		bootbox.alert(invalid_message);
	return valid;
};
PembuatanOPLAction.prototype.save = function() {
	if (!this.validate())
		return;
	var self = this;
	var data = this.getSaveData();
	bootbox.dialog({
		message : "Yakin melakukan penyimpanan OPL ini?",
		title	: "Konfirmasi",
		buttons	: {
			success : {
				label 		: "Lanjutkan",
				className 	: "btn-success",
				callback	: function() {
					showLoading();
					$.post(
						"",
						data,
						function() {
							dismissLoading();
							self.back();
						}
					);
				}
			},
			danger 	: {
				label 		: "Batal",
				className	: "btn-inverse"
			}
		}
	});
};
PembuatanOPLAction.prototype.edit = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "edit";
	data['id'] = id;
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) 
				return;
			data = self.getRegulerData();
			if (json.f_id > 0)
				data['action'] = "pembuatan_opl_form";
			else {
				if (json.prekursor_farmasi == 1)
					data['action'] = "pembuatan_opl_prekursor_farmasi_form";
				else
					data['action'] = "pembuatan_opl_mandiri_form";
			}
			data['super_command'] = "";
			data['id'] = json.id;
			data['f_id'] = json.f_id;
			data['nomor'] = json.nomor;
			data['tanggal'] = json.tanggal;
			data['id_vendor'] = json.id_vendor;
			data['kode_vendor'] = json.kode_vendor;
			data['nama_vendor'] = json.nama_vendor;
			data['alamat_vendor'] = json.alamat_vendor;
			data['kota_vendor'] = json.kota_vendor;
			data['kodepos_vendor'] = json.kodepos_vendor;
			data['klinik'] = json.klinik;
			data['alamat_klinik'] = json.alamat_klinik;
			data['telpon_klinik'] = json.telpon_klinik;
			data['no_ijin_klinik'] = json.no_ijin_klinik;
			data['medis'] = json.medis;
			data['tipe'] = json.tipe;
			data['use_ppn'] = json.use_ppn;
			data['diskon'] = json.diskon;
			data['t_diskon'] = json.t_diskon;
			data['editable'] = "true";
			data['prekursor_farmasi'] = json.prekursor_farmasi;
			data['oot'] = json.oot;
			LoadSmisPage(data);
		}
	);
};
PembuatanOPLAction.prototype.detail = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "edit";
	data['id'] = id;
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) 
				return;
			data = self.getRegulerData();
			data['action'] = "pembuatan_opl_form";
			data['super_command'] = "";
			data['id'] = json.id;
			data['f_id'] = json.f_id;
			data['nomor'] = json.nomor;
			data['tanggal'] = json.tanggal;
			data['id_vendor'] = json.id_vendor;
			data['kode_vendor'] = json.kode_vendor;
			data['nama_vendor'] = json.nama_vendor;
			data['alamat_vendor'] = json.alamat_vendor;
			data['kota_vendor'] = json.kota_vendor;
			data['kodepos_vendor'] = json.kodepos_vendor;
			data['klinik'] = json.klinik;
			data['alamat_klinik'] = json.alamat_klinik;
			data['telpon_klinik'] = json.telpon_klinik;
			data['no_ijin_klinik'] = json.no_ijin_klinik;
			data['medis'] = json.medis;
			data['tipe'] = json.tipe;
			data['use_ppn'] = json.use_ppn;
			data['diskon'] = json.diskon;
			data['t_diskon'] = json.t_diskon;
			data['editable'] = "false";
			data['prekursor_farmasi'] = json.prekursor_farmasi;
			data['oot'] = json.oot;
			LoadSmisPage(data);
		}
	);
};
PembuatanOPLAction.prototype.lock_opl = function(id) {
	if (!this.validate())
		return;
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = id;
	data['lock_opl'] = 1;
	bootbox.dialog({
		message : "Yakin melakukan penguncian OPL ini?",
		title	: "Konfirmasi",
		buttons	: {
			success : {
				label 		: "Lanjutkan",
				className 	: "btn-success",
				callback	: function() {
					showLoading();
					$.post(
						"",
						data,
						function() {
							dismissLoading();
							self.view();
						}
					);
				}
			},
			danger 	: {
				label 		: "Batal",
				className	: "btn-inverse"
			}
		}
	});
};
PembuatanOPLAction.prototype.export_xls = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "export_xls";
	data['id'] = id;
	postForm(data);
};
PembuatanOPLAction.prototype.export_pdf = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "export_pdf";
	data['id'] = id;
	showLoading();
	$.post(
		"",
		data,
		function(response) {
			var json = getContent(response);
			if (json == null) {
				dismissLoading();
				return;
			}
			var getUrl = window.location['pathname'] + json;
            window.open(getUrl, 'pdf');
            dismissLoading();
		}
	);
};
PembuatanOPLAction.prototype.archieve = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = id;
	data['archived'] = 1;
	bootbox.dialog({
		message : "Yakin mengarsipkan OPL ini?",
		title	: "Konfirmasi",
		buttons	: {
			success : {
				label 		: "Lanjutkan",
				className 	: "btn-success",
				callback	: function() {
					showLoading();
					$.post(
						"",
						data,
						function() {
							dismissLoading();
							self.view();
						}
					);
				}
			},
			danger 	: {
				label 		: "Batal",
				className	: "btn-inverse"
			}
		}
	});
};
PembuatanOPLAction.prototype.unarchieve = function(id) {
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "save";
	data['id'] = id;
	data['archived'] = 0;
	bootbox.dialog({
		message : "Yakin membuka arsip OPL ini?",
		title	: "Konfirmasi",
		buttons	: {
			success : {
				label 		: "Lanjutkan",
				className 	: "btn-success",
				callback	: function() {
					showLoading();
					$.post(
						"",
						data,
						function() {
							dismissLoading();
							self.view();
						}
					);
				}
			},
			danger 	: {
				label 		: "Batal",
				className	: "btn-inverse"
			}
		}
	});
};
PembuatanOPLAction.prototype.back = function() {
	var main_page = $("#pembuatan_opl_main_page").val();
	var data = this.getRegulerData();
	data['action'] = "pembuatan_opl";
	if (main_page != "" && main_page != null) {
		data['action'] = main_page;
	}
	data['super_command'] = "";
	data['kriteria'] = "";
	data['max'] = 5;
	data['number'] = 0;
	LoadSmisPage(data);
};
PembuatanOPLAction.prototype.getInfoKlinik = function(klinik) {
	var data = this.getRegulerData();
	data['command'] = "get_info_klinik";
	data['action'] = "pembuatan_opl";
	data['klinik'] = klinik;
	showLoading();
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) {
				dismissLoading();
				return;
			}
			$("#pembuatan_opl_alamat_klinik").val(json.alamat);
			$("#pembuatan_opl_telpon_klinik").val(json.telpon);
			$("#pembuatan_opl_no_ijin_klinik").val(json.no_ijin);
			dismissLoading();
		}
	);
};