function LOBSAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
LOBSAction.prototype.constructor = LOBSAction;
LOBSAction.prototype = new TableAction();
LOBSAction.prototype.getRegulerData = function() {
	var data = TableAction.prototype.getRegulerData.call(this);
	data['tanggal_from'] = $("#lobs_tanggal_from").val();
	data['tanggal_to'] = $("#lobs_tanggal_to").val();
	return data;
};
LOBSAction.prototype.view = function() {
	if ($("#lobs_tanggal_from").val() == "" || $("#lobs_tanggal_to").val() == "")
		return;
	var self = this;
	FINISHED = false;
	$("#lobs_info").empty();
	$("#table_lobs tfoot").remove();
	$("#lobs_list").empty();
	$("#lobs_loading_bar").sload("true", "Harap ditunggu...", 0);
	$("#lobs_loading_modal").smodal("show");
	var data = this.getRegulerData();
	data['command'] = "get_jumlah";
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) return;
			self.fillHtml(0, json.jumlah);
		}
	);
};
LOBSAction.prototype.fillHtml = function(num, limit) {
	if (FINISHED || num == limit) {
		if (FINISHED == false && num == limit) {
			this.finalize();
		} else {
			$("#lobs_loading_modal").smodal("hide");
			$("#lobs_info").html(
				"<div class='alert alert-block alert-inverse'>" +
					 "<center><strong>PROSES DIBATALKAN</strong></center>" +
				 "</div>"
			);
			$("#lobs_export_button").removeAttr("onclick");
		}
		return;
	}
	var self = this;
	var data = this.getRegulerData();
	data['command'] = "get_info";
	data['num'] = num;
	$.post(
		"",
		data,
		function(response) {
			var json = JSON.parse(response);
			if (json == null) return;
			console.log(json);
			$("tbody#lobs_list").append(
				json.html
			);
			$("#lobs_loading_bar").sload("true", json.nomor_transaksi + " - " + json.nomor + " - " + json.nama_vendor + " - " + json.tipe + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
			self.fillHtml(num + 1, limit);
		}
	);
};
LOBSAction.prototype.finalize = function() {
	var num_rows = $("tbody#lobs_list tr").length;
	for (var i = 0; i < num_rows; i++) {
		$("tbody#lobs_list tr:eq(" + i + ") td#lobs_no").html("<small>" + (i + 1) + "</small>");
	}
	$("#lobs_loading_modal").smodal("hide");
	$("#lobs_info").html(
		"<div class='alert alert-block alert-info'>" +
			 "<center><strong>PROSES SELESAI</strong></center>" +
		 "</div>"
	);
	$("#lobs_export_button").removeAttr("onclick");
	$("#lobs_export_button").attr("onclick", "lobs.export_xls()");
};
LOBSAction.prototype.cancel = function() {
	FINISHED = true;
};
LOBSAction.prototype.export_xls = function() {
	showLoading();
	var num_rows = $("#lobs_list").children("tr").length;
	var d_data = {};
	for (var i = 0; i < num_rows; i++) {
		var no = $("tbody#lobs_list tr:eq(" + i + ") td#lobs_no").text();
		var id = $("tbody#lobs_list tr:eq(" + i + ") td#lobs_id").text();
		var nomor = $("tbody#lobs_list tr:eq(" + i + ") td#lobs_nomor").text();
		var tanggal = $("tbody#lobs_list tr:eq(" + i + ") td#lobs_tanggal").text();
		var kode_vendor = $("tbody#lobs_list tr:eq(" + i + ") td#lobs_kode_vendor").text();
		var nama_vendor = $("tbody#lobs_list tr:eq(" + i + ") td#lobs_nama_vendor").text();
		var tipe = $("tbody#lobs_list tr:eq(" + i + ") td#lobs_tipe").text();
		d_data[i] = {
			"no" 				: no,
			"id"				: id,
			"nomor"				: nomor,
			"tanggal"			: tanggal,
			"kode_vendor"		: kode_vendor,
			"nama_vendor"		: nama_vendor,
			"tipe"				: tipe
		};
	}
	var data = this.getRegulerData();
	data['command'] = "export_xls";
	data['tanggal_from'] = $("#lobs_tanggal_from").val();
	data['tanggal_to'] = $("#lobs_tanggal_to").val();
	data['d_data'] = JSON.stringify(d_data);
	data['num_rows'] = num_rows;
	postForm(data);
	dismissLoading();
};