<?php 
/**
 * this file used for get all patient 
 * on certain room. the data will be 
 * parse into excel.
 * 
 * @author 		: Nurul Huda
 * @license 	: Apache v3
 * @copyright 	: goblooge@gmail.com
 * @used 		: /medical_record/resource/php/laporan_pasien/lap_sensus.php
 * @service 	: get_sensus
 * @since		: 29 Oct 2016
 * @version		: 1.0.0
 * @database	: smis_mr_sensus_harian
 * */



require_once "smis-libs-out/php-excel/PHPExcel.php"; 
global $db;
global $user;
$_dbtable=new DBTable($db,"smis_mr_sensus_harian");
$_dari=$_POST['dari'];
$_sampai=$_POST['sampai'];
$_slug_igd=getSettings($db,"smis-rs-igd-mr","igd");

/*start - BLOK RESOURCE*/
	$_thin = array ();
	$_thin['borders']=array();
	$_thin['borders']['allborders']=array();
	$_thin['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_DASHED ;

	$_center = array();
	$_center ['alignment']=array();
	$_center ['alignment']['horizontal']=PHPExcel_Style_Alignment::HORIZONTAL_CENTER;
/*end - BLOCK RESOURCE*/

/*start - BLOCK PROPERTIES FILE EXCEL*/
	$file = new PHPExcel ();
	$file->getProperties ()->setCreator ( $user->getUsername() );
	$file->getProperties ()->setLastModifiedBy ( $user->getNameOnly() );
	$file->getProperties ()->setTitle ( "Sensus Harian Pasien" );
	$file->getProperties ()->setSubject ( "Sensus Rekam Medis" );
	$file->getProperties ()->setDescription ( "Data Rekam Medis Sensus Harian Pasien ".$_POST['ruangan'] );
	$file->getProperties ()->setKeywords ( "sensus, harian, rekam, medis" );
	$file->getProperties ()->setCategory ( "Rekam Medis" );
/*end - BLOCK PROPERTIES FILE EXCEL*/

/*start - BLOCK PASIEN MASUK*/
	$file->setActiveSheetIndex ( 0 );
	$sheet = $file->getActiveSheet ( 0 );
	$sheet->setTitle ( "PASIEN MASUK" );
	$_dbtable->addCustomKriteria(NULL," tgl_masuk<'".$_sampai."' " );
	$_dbtable->addCustomKriteria(NULL," tgl_masuk>='".$_dari."' " );
	$_dbtable->addCustomKriteria(NULL," ( 	asal_ruangan='Pendaftaran' 
											OR asal_ruangan='' 
											OR asal_ruangan LIKE '%".$_slug_igd."%' 
										)" );
	$_dbtable->setShowAll(true);
	$package=$_dbtable->view("","0");
	$list=$package["data"];
	$sheet	->mergeCells('A1:K1');
	$sheet	->setCellValue ( "A1", "PASIEN MASUK" );
	$sheet	->setCellValue ( "A2", "No." )
			->setCellValue ( "B2", "Tanggal Masuk" )
			->setCellValue ( "C2", "NRM" )
			->setCellValue ( "D2", "No Reg" )
			->setCellValue ( "E2", "Nama" )
			->setCellValue ( "F2", "Umur" )
			->setCellValue ( "G2", "Diagnosa" )
            ->setCellValue ( "H2", "ICD" )
            ->setCellValue ( "I2", "DPJP" )
            ->setCellValue ( "J2", "Cara Bayar" )
            ->setCellValue ( "K2", "Kunjungan" );
	$sheet->getStyle ( 'A1:K1' )->applyFromArray ($_center);
		
	$sheet ->getColumnDimension ( "A" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "B" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "C" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "D" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "E" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "F" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "G" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "H" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "I" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "J" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "K" )->setAutoSize ( true );
	$sheet ->getStyle("A1:K2")->getFont()->setBold(true);
	
	$no=2;
	foreach($list as $x){
		$no++;
		$sheet	->setCellValue ( "A".$no, ($no-2)."." )
				->setCellValue ( "B".$no, $x->tgl_masuk )
				->setCellValue ( "C".$no, "'".ArrayAdapter::format("only-digit6",$x->nrm_pasien) )
				->setCellValue ( "D".$no, "'".ArrayAdapter::format("only-digit6",$x->noreg_pasien) )
				->setCellValue ( "E".$no, $x->nama_pasien )
				->setCellValue ( "F".$no, $x->umur )
				->setCellValue ( "G".$no, $x->diagnosa_masuk )
                ->setCellValue ( "H".$no, $x->icd_masuk )
                ->setCellValue ( "I".$no, $x->dpjp )
                ->setCellValue ( "J".$no, $x->carabayar )
                ->setCellValue ( "K".$no, $x->kunjungan );
	}
	$sheet->getStyle ( 'A2:K'.$no )->applyFromArray ($_thin);
	
/*end - BLOCK PASIEN MASUK*/

/*start - BLOCK PASIEN PINDAHAN*/
	$file->createSheet ( NULL,1);
	$file->setActiveSheetIndex ( 1 );
	$sheet = $file->getActiveSheet ( 1 );
	$sheet->setTitle ( "PASIEN PINDAHAN" );
	$_dbtable->setCustomKriteria(array());
	$_dbtable->addCustomKriteria(NULL," tgl_masuk<'".$_sampai."' " );
	$_dbtable->addCustomKriteria(NULL," tgl_masuk>='".$_dari."' " );
	$_dbtable->addCustomKriteria(NULL," ( 	asal_ruangan!='Pendaftaran' 
											AND asal_ruangan!='' 
										)" );
	$_dbtable->setShowAll(true);
	$package=$_dbtable->view("","0");
	$list=$package["data"];
	$sheet	->mergeCells('A1:L1');
	$sheet	->setCellValue ( "A1", "PASIEN PINDAHAN" );
	$sheet	->setCellValue ( "A2", "No." )
            ->setCellValue ( "B2", "Tanggal Masuk" )
			->setCellValue ( "C2", "NRM" )
			->setCellValue ( "D2", "No Reg" )
			->setCellValue ( "E2", "Nama" )
			->setCellValue ( "F2", "Umur" )
			->setCellValue ( "G2", "Pindahan Dari" )
			->setCellValue ( "H2", "Diagnosa" )
            ->setCellValue ( "I2", "ICD" )
            ->setCellValue ( "J2", "DPJP" )
            ->setCellValue ( "K2", "Cara Bayar" )
            ->setCellValue ( "L2", "Kunjungan" );
	$sheet->getStyle ( 'A1:L1' )->applyFromArray ($_center);
		
	$sheet ->getColumnDimension ( "A" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "B" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "C" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "D" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "E" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "F" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "G" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "H" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "I" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "J" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "K" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "L" )->setAutoSize ( true );
	$sheet ->getStyle("A1:L2")->getFont()->setBold(true);
	
	$no=2;
	foreach($list as $x){
		$no++;
		$sheet	->setCellValue ( "A".$no, ($no-2)."." )
				->setCellValue ( "B".$no, $x->tgl_masuk )
				->setCellValue ( "C".$no, "'".ArrayAdapter::format("only-digit6",$x->nrm_pasien) )
				->setCellValue ( "D".$no, "'".ArrayAdapter::format("only-digit6",$x->noreg_pasien) )
				->setCellValue ( "E".$no, $x->nama_pasien )
				->setCellValue ( "F".$no, $x->umur )
				->setCellValue ( "G".$no, ArrayAdapter::format("unslug",$x->asal_ruangan) )
				->setCellValue ( "H".$no, $x->diagnosa_ruang )
                ->setCellValue ( "I".$no, $x->icd_ruang )
                ->setCellValue ( "J".$no, $x->dpjp )
                ->setCellValue ( "K".$no, $x->carabayar )
                ->setCellValue ( "L".$no, $x->kunjungan );
	}
	$sheet->getStyle ( 'A2:L'.$no )->applyFromArray ($_thin);
/*end - BLOCK PASIEN PINDAHAN*/


/*start - BLOCK PASIEN MENINGGAL*/
	$file->createSheet ( NULL,2);
	$file->setActiveSheetIndex ( 2 );
	$sheet = $file->getActiveSheet ( 2 );
	$sheet->setTitle ( "PASIEN MENINGGAL" );
	$_dbtable->setCustomKriteria(array());
	$_dbtable->addCustomKriteria(" tgl_pulang "," !='0000-00-00 00:00:00' " );
    $_dbtable->addCustomKriteria(NULL," tgl_pulang<'".$_sampai."' " );
	$_dbtable->addCustomKriteria(NULL," tgl_pulang>='".$_dari."' " );
	$_dbtable->addCustomKriteria(" carapulang "," LIKE '%Mati%' " );
	$_dbtable->setShowAll(true);
	$package=$_dbtable->view("","0");
	$list=$package["data"];
	$sheet	->mergeCells('A1:I1');
	$sheet	->mergeCells('A2:A3');
	$sheet	->mergeCells('B2:B3');
	$sheet	->mergeCells('C2:C3');
	$sheet	->mergeCells('D2:D3');
	$sheet	->mergeCells('E2:E3');
	$sheet	->mergeCells('F2:F2');
	$sheet	->mergeCells('H2:H3');
	$sheet	->mergeCells('I2:I3');
	$sheet	->mergeCells('J2:J3');
	$sheet	->mergeCells('K2:K3');
	$sheet	->mergeCells('L2:L3');
	$sheet	->mergeCells('M2:M3');
	$sheet	->mergeCells('N2:N3');
	
	$sheet	->setCellValue ( "A1", "PASIEN MENINGGAL" );
	$sheet	->setCellValue ( "A2", "No." )
			->setCellValue ( "B2", "Tanggal Keluar" )
			->setCellValue ( "C2", "NRM" )
			->setCellValue ( "D2", "No Reg" )
			->setCellValue ( "E2", "Nama" )
			->setCellValue ( "F2", "Umur" )
			->setCellValue ( "G2", "Meninggal" )
			->setCellValue ( "G3", "<= 48 Jam" )
			->setCellValue ( "H3", "> 48 Jam" )
			->setCellValue ( "I2", "Lama Dirawat" )
			->setCellValue ( "J2", "Diagnosa" )
            ->setCellValue ( "K2", "ICD" )
            ->setCellValue ( "L2", "DPJP" )
            ->setCellValue ( "M2", "Cara Bayar" )
            ->setCellValue ( "N2", "Kunjungan" );
	$sheet->getStyle ( 'A1:N1' )->applyFromArray ($_center);
    
	
    
	$no=3;
	foreach($list as $x){
		$no++;
		$sheet	->setCellValue ( "A".$no, ($no-3)."." )
				->setCellValue ( "B".$no, $x->tgl_pulang )
                ->setCellValue ( "C".$no, "'".ArrayAdapter::format("only-digit6",$x->nrm_pasien) )
				->setCellValue ( "D".$no, "'".ArrayAdapter::format("only-digit6",$x->noreg_pasien) )
				->setCellValue ( "E".$no, $x->nama_pasien )
				->setCellValue ( "F".$no, $x->umur )
				->setCellValue ( "G".$no, strpos($x->carapulang,">48 Jam")===false?1:"" )
				->setCellValue ( "H".$no, strpos($x->carapulang,">48 Jam")===false?"":1 )
				->setCellValue ( "I".$no, $x->durasi )
				->setCellValue ( "J".$no, $x->diagnosa_ruang )
                ->setCellValue ( "K".$no, $x->icd_ruang )
                ->setCellValue ( "L".$no, $x->dpjp )
                ->setCellValue ( "M".$no, $x->carabayar )
                ->setCellValue ( "N".$no, $x->kunjungan );
	}
	$sheet	->setCellValue ( "F".($no+1), "JUMLAH" );
	$sheet	->setCellValue ( "G".($no+1), "=SUM(F4:F".$no.")" );
	$sheet	->setCellValue ( "H".($no+1), "=SUM(G4:G".$no.")" );
	$sheet ->getStyle("A1:N2")->getFont()->setBold(true);
	$sheet ->getStyle("F".($no+1).":H".($no+1))->getFont()->setBold(true);
	$sheet->getStyle ( 'A2:N'.$no )->applyFromArray ($_thin);
    
	$sheet ->getColumnDimension ( "A" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "B" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "C" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "D" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "E" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "F" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "G" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "H" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "I" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "J" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "K" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "L" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "M" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "N" )->setAutoSize ( true );
	
/*end - BLOCK PASIEN MENINGGAL*/


/*start - BLOCK PASIEN DIPINDAHKAN*/
	$file->createSheet ( NULL,3);
	$file->setActiveSheetIndex ( 3 );
	$sheet = $file->getActiveSheet ( 3 );
	$sheet->setTitle ( "PASIEN DIPINDAHKAN" );
	$_dbtable->setCustomKriteria(array());
	$_dbtable->addCustomKriteria(NULL," tgl_pulang!='0000-00-00 00:00:00' " );
	$_dbtable->addCustomKriteria(NULL," tgl_pulang<'".$_sampai."' " );
	$_dbtable->addCustomKriteria(NULL," tgl_pulang>='".$_dari."' " );
	$_dbtable->addCustomKriteria(" carapulang "," = 'Pindah Kamar' " );
	$_dbtable->setShowAll(true);
	$package=$_dbtable->view("","0");
	$list=$package["data"];
	$sheet	->mergeCells('A1:M1');
	$sheet	->setCellValue ( "A1", "PASIEN DIPINDAHKAN" );
	$sheet	->setCellValue ( "A2", "No." )
            ->setCellValue ( "B2", "Tanggal Keluar" )    
			->setCellValue ( "C2", "NRM" )
			->setCellValue ( "D2", "No Reg" )
			->setCellValue ( "E2", "Nama" )
			->setCellValue ( "F2", "Umur" )
			->setCellValue ( "G2", "Dipindahkan Ke" )
			->setCellValue ( "H2", "Lama Dirawat" )
			->setCellValue ( "I2", "Diagnosa" )
            ->setCellValue ( "J2", "ICD" )
            ->setCellValue ( "K2", "DPJP" )
            ->setCellValue ( "L2", "Cara Bayar" )
            ->setCellValue ( "M2", "Kunjungan" );
	$sheet->getStyle ( 'A1:M1' )->applyFromArray ($_center);
		
	$sheet ->getColumnDimension ( "A" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "B" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "C" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "D" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "E" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "F" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "G" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "H" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "I" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "J" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "K" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "L" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "M" )->setAutoSize ( true );
	$sheet ->getStyle("A1:M2")->getFont()->setBold(true);
	
	$no=2;
	foreach($list as $x){
		$no++;
		$sheet	->setCellValue ( "A".$no, ($no-2)."." )
                ->setCellValue ( "B".$no, $x->tgl_pulang )
				->setCellValue ( "C".$no, "'".ArrayAdapter::format("only-digit6",$x->nrm_pasien) )
				->setCellValue ( "D".$no, "'".ArrayAdapter::format("only-digit6",$x->noreg_pasien) )
				->setCellValue ( "E".$no, $x->nama_pasien )
				->setCellValue ( "F".$no, $x->umur )
				->setCellValue ( "G".$no, ArrayAdapter::format("unslug",$x->pindah_ke) )
				->setCellValue ( "H".$no, $x->durasi )
				->setCellValue ( "I".$no, $x->diagnosa_ruang )
                ->setCellValue ( "J".$no, $x->icd_ruang )
                ->setCellValue ( "K".$no, $x->dpjp )
                ->setCellValue ( "L".$no, $x->carabayar )
                ->setCellValue ( "M".$no, $x->kunjungan );
	}
	$sheet->getStyle ( 'A2:M'.$no )->applyFromArray ($_thin);
/*end - BLOCK PASIEN DIPINDAHKAN*/

/*start - BLOCK PASIEN KELUAR RS*/
	$file->createSheet ( NULL,4);
	$file->setActiveSheetIndex ( 4 );
	$sheet = $file->getActiveSheet ( 4 );
	$sheet->setTitle ( "PASIEN KELUAR RS" );
	$_dbtable->setCustomKriteria(array());
	$_dbtable->addCustomKriteria(NULL," tgl_pulang<'".$_sampai."' " );
    $_dbtable->addCustomKriteria(NULL," tgl_pulang>='".$_dari."' " );
	$_dbtable->addCustomKriteria(NULL," tgl_pulang!='0000-00-00 00:00:00' " );
	$_dbtable->setShowAll(true);
	$package=$_dbtable->view("","0");
	$list=$package["data"];
	$sheet	->mergeCells('A1:M1');
	$sheet	->setCellValue ( "A1", "PASIEN KELUAR RS" );
	$sheet	->setCellValue ( "A2", "No." )
			->setCellValue ( "B2", "Tanggal Keluar" )
			->setCellValue ( "C2", "NRM" )
			->setCellValue ( "D2", "No Reg" )
			->setCellValue ( "E2", "Nama" )
			->setCellValue ( "F2", "Umur" )
			->setCellValue ( "G2", "Cara Keluar" )
			->setCellValue ( "H2", "Lama Dirawat" )
			->setCellValue ( "I2", "Diagnosa" )
            ->setCellValue ( "J2", "ICD" )
            ->setCellValue ( "K2", "DPJP" )
            ->setCellValue ( "L2", "Cara Bayar" )
            ->setCellValue ( "M2", "Kunjungan" );
	$sheet->getStyle ( 'A1:M1' )->applyFromArray ($_center);
		
	$sheet ->getColumnDimension ( "A" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "B" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "C" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "D" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "E" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "F" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "G" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "H" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "I" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "J" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "K" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "L" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "M" )->setAutoSize ( true );
	$sheet ->getStyle("A1:M2")->getFont()->setBold(true);
	
	$no=2;
	foreach($list as $x){
		$no++;
		$sheet	->setCellValue ( "A".$no, ($no-2)."." )
				->setCellValue ( "B".$no, $x->tgl_pulang )
				->setCellValue ( "C".$no, "'".ArrayAdapter::format("only-digit6",$x->nrm_pasien) )
				->setCellValue ( "D".$no, "'".ArrayAdapter::format("only-digit6",$x->noreg_pasien) )
				->setCellValue ( "E".$no, $x->nama_pasien )
				->setCellValue ( "F".$no, $x->umur )
				->setCellValue ( "G".$no, $x->carapulang )
				->setCellValue ( "H".$no, $x->durasi )
				->setCellValue ( "I".$no, $x->diagnosa_ruang )
                ->setCellValue ( "J".$no, $x->icd_ruang )
                ->setCellValue ( "K".$no, $x->dpjp )
                ->setCellValue ( "L".$no, $x->carabayar )
                ->setCellValue ( "M".$no, $x->kunjungan );
	}
	$sheet->getStyle ( 'A2:M'.$no )->applyFromArray ($_thin);
/*end - BLOCK PASIEN KELUAR RS*/

/*start - BLOCK RANGKUMAN*/
	$file->createSheet ( NULL,5);
	$file->setActiveSheetIndex ( 5 );
	$sheet = $file->getActiveSheet ( 5 );
	$sheet->setTitle ( "RANGKUMAN" );
	$_dbtable1=new DBTable($db,"smis_mr_sensus_harian");
	$_dbtable1->setShowAll(true);
	$package=$_dbtable1->view("","0");
	$list=$package["data"];
	$sheet	->mergeCells('A1:T1');
	$sheet	->setCellValue ( "A1", "RANGKUMAN" );
	$sheet	->setCellValue ( "A2", "No." )
			->setCellValue ( "B2", "No Reg" )
			->setCellValue ( "C2", "NRM" )
			->setCellValue ( "D2", "Nama" )
			->setCellValue ( "E2", "Diagnosa Masuk" )
			->setCellValue ( "F2", "Diagnosa Ruang" )
			->setCellValue ( "G2", "Cara Pulang" )
			->setCellValue ( "H2", "Cara Bayar" )
			->setCellValue ( "I2", "Asal" )
            ->setCellValue ( "J2", "Ruangan" )
            ->setCellValue ( "K2", "Pindah ke" )
            ->setCellValue ( "L2", "Umur" )
            ->setCellValue ( "M2", "Kelas" )
            ->setCellValue ( "N2", "Masuk" )
            ->setCellValue ( "O2", "Keluar" )
            ->setCellValue ( "P2", "Durasi" )
            ->setCellValue ( "Q2", "DPJP" )
            ->setCellValue ( "R2", "ICD Masuk" )
            ->setCellValue ( "S2", "ICD Keluar" )
            ->setCellValue ( "T2", "Kunjungan" );
	$sheet->getStyle ( 'A1:T1' )->applyFromArray ($_center);
		
	$sheet ->getColumnDimension ( "A" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "B" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "C" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "D" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "E" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "F" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "G" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "H" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "I" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "J" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "K" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "L" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "M" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "N" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "O" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "P" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "Q" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "R" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "S" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "T" )->setAutoSize ( true );
	$sheet ->getStyle("A1:T2")->getFont()->setBold(true);
	
	$no=2;
	foreach($list as $x){
		$no++;
		$sheet	->setCellValue ( "A".$no, ($no-2)."." )
				->setCellValue ( "B".$no, "'".ArrayAdapter::format("only-digit6",$x->noreg_pasien) )
				->setCellValue ( "C".$no, "'".ArrayAdapter::format("only-digit6",$x->nrm_pasien) )
				->setCellValue ( "D".$no, $x->nama_pasien )
				->setCellValue ( "E".$no, $x->diagnosa_masuk )
				->setCellValue ( "F".$no, $x->diagnosa_ruang )
				->setCellValue ( "G".$no, $x->carapulang )
				->setCellValue ( "H".$no, $x->carabayar )
				->setCellValue ( "I".$no, ArrayAdapter::format("unslug",$x->asal_ruangan) )
                ->setCellValue ( "J".$no, ArrayAdapter::format("unslug",$x->ruangan) )
                ->setCellValue ( "K".$no, ArrayAdapter::format("unslug",$x->pindah_ke) )
                ->setCellValue ( "L".$no, $x->umur )
                ->setCellValue ( "M".$no, $x->kelas )
                ->setCellValue ( "N".$no, $x->tgl_masuk )
                ->setCellValue ( "O".$no, $x->tgl_pulang )
                ->setCellValue ( "P".$no, $x->durasi )
                ->setCellValue ( "Q".$no, $x->dpjp )
                ->setCellValue ( "R".$no, $x->icd_masuk )
                ->setCellValue ( "S".$no, $x->icd_ruang )
                ->setCellValue ( "T".$no, $x->kunjungan );
	}
	$sheet->getStyle ( 'A2:T'.$no )->applyFromArray ($_thin);
/*end - BLOCK RANGKUMAN*/

$filename="DATA SENSUS - ".ArrayAdapter::format("unslug",$_POST['ruangan']).
					 " - ".ArrayAdapter::format("date d M Y H:i",$_dari).
					 " - ".ArrayAdapter::format("date d M Y H:i",$_sampai).".xls";

header ( 'Content-Type: application/vnd.ms-excel' );
header ( 'Content-Disposition: attachment;filename="'.$filename.'"' );
header ( 'Cache-Control: max-age=0' );
$writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
$writer->save ( 'php://output' );
?>