<?php
	global $db;

	$tanggal_from = $_POST['from_date'];
	$tanggal_to = $_POST['to_date'];
	$carabayar = $_POST['carabayar'];
	$unit_kerja = $_POST['unit_kerja'];
	$jenislayanan = $_POST['jenislayanan'];
	
	$daftar_kunjungan = $db->get_result("
		SELECT
			a.id AS id,
	        a.tanggal AS tanggal,
	        a.tanggal_inap AS tanggal_inap,
	        a.tanggal_pulang AS tanggal_pulang,
	        a.akunting_notify_date AS tanggal_post,
	        a.carabayar AS carabayar,
	        a.caradatang AS caradatang,
	        a.nobpjs AS no_bpjs,
	        a.jenispasien AS jenispasien,
	        a.rujukan AS rujukan,
	        a.nama_rujukan AS nama_rujukan,
	        a.uri AS uri,
	        a.nrm AS nrm,
	        a.lunas AS lunas,
	        a.no_urut AS no_urut,
	        a.no_kunjungan AS no_kunjungan,
	        a.besarbonus AS besarbonus,
	        a.ambilbonus AS ambilbonus,
	        a.jenislayanan AS jenislayanan,
	        a.kamar_inap AS kamar_inap,
	        a.kode_ppk AS kode_ppk,
	        a.ppk_bpjs AS ppk_bpjs,
	        a.synch AS synch,
	        a.duplicate AS duplicate,
	        a.karcis AS karcis,
	        a.carapulang AS carapulang,
	        a.nama_dokter AS nama_dokter,
	        a.origin AS origin,
	        a.total_tagihan AS total_tagihan,
	        a.administrasi_inap AS administrasi_inap,
	        a.jenis_kunjungan as jenis_kunjungan,
	        IF((a.ambilbonus = ''),'belum','sudah') AS bonus,
	        IF((a.no_kunjungan = 1),'Baru','Lama') AS baru,
	        IF(a.kelamin=0,'Laki-Laki','Perempuan') AS kelamin,
	        a.nama_pasien AS nama,
	        a.telpon_pasien AS telpon_pasien,
	        a.alamat_pasien AS alamat,
	        a.nama_provinsi AS nama_provinsi,
	        a.nama_kabupaten AS nama_kabupaten,
	        a.nama_kecamatan AS nama_kecamatan,
	        a.nama_kelurahan AS nama_kelurahan,
	        a.nama_kedusunan AS nama_kedusunan,
	        a.nama_perusahaan AS id_perusahaan,    
	        '' AS nama_perusahaan,
	        a.asuransi AS id_asuransi,
	        '' AS nama_asuransi,
	        a.id_rujukan AS id_rujukan,
	        '' as instansi_rujukan,         
	        a.prop AS prop,
	        a.unit_kerja,
	        '' AS nama_icd,
	        '' AS non_spesialis,
	        '' AS spesialis_subspesialis,
	        '' AS ppk_rujukan
	    FROM
	    	smis_rg_layananpasien a
	    WHERE
	    	a.prop LIKE ''
	    		AND DATE(a.tanggal) >= '" . $tanggal_from . "'
	    		AND DATE(a.tanggal) <= '" . $tanggal_to . "'
	    		AND a.carabayar LIKE '" . $carabayar . "'
	    		AND a.unit_kerja LIKE '" . $unit_kerja . "'
	    		AND a.jenislayanan LIKE '" . $jenislayanan . "'
	    ORDER BY
	    	(a.id + 0) ASC, 
	    	a.id ASC
	");
	$html = "";
	if ($daftar_kunjungan != null) {
		$nomor = 1;
		foreach ($daftar_kunjungan as $data_kunjungan) {
			$data_kunjungan->nama_perusahaan = $db->get_var("
				SELECT
					nama
				FROM
					smis_rg_perusahaan
				WHERE
					id = '" . $data_kunjungan->id_perusahaan . "'
			");
			$data_kunjungan->nama_asuransi = $db->get_var("
				SELECT
					nama
				FROM
					smis_rg_asuransi
				WHERE
					id = '" . $data_kunjungan->id_asuransi . "'
			");
			$data_kunjungan->instansi_rujukan = $db->get_var("
				SELECT
					instansi
				FROM
					smis_rg_perujuk
				WHERE
					id = '" . $data_kunjungan->id_rujukan . "'
			");
			$data_rm = $db->get_row("
				SELECT
					nama_icd, 
					non_spesialis,
					spesialis_subspesialis,
					ppk_rujukan
				FROM
					smis_mr_diagnosa
				WHERE
					noreg_pasien = '" . $data_kunjungan->id . "'
			");
			if ($data_rm != null) {
				$data_kunjungan->nama_icd = $data_rm->nama_icd;
				$data_kunjungan->non_spesialis = $data_rm->non_spesialis;
				$data_kunjungan->spesialis_subspesialis = $data_rm->spesialis_subspesialis;
				$data_kunjungan->ppk_rujukan = $data_rm->ppk_rujukan;
			}

			$html .= 	"<tr>" .
							"<td>" . $nomor++ . "</td>" .
							"<td>" . $data_kunjungan->nama . "</td>" .
							"<td>" . ArrayAdapter::format("digit8", $data_kunjungan->nrm) . "</td>" .
							"<td>" . $data_kunjungan->no_bpjs . "</td>" .
							"<td>" . $data_kunjungan->kelamin . "</td>" .
							"<td>" . ArrayAdapter::format("date d M Y", $data_kunjungan->tanggal) . "</td>" .
							"<td>" . $data_kunjungan->alamat . "</td>" .
							"<td>" . $data_kunjungan->nama_kecamatan . "</td>" .
							"<td>" . $data_kunjungan->carabayar . "</td>" .
							"<td>" . $data_kunjungan->ppk_bpjs . "</td>" .
							"<td>" . $data_kunjungan->telpon_pasien . "</td>" .
							"<td>" . $data_kunjungan->jenis_kunjungan . "</td>" .
							"<td>" . ArrayAdapter::format("unslug", $data_kunjungan->jenislayanan) . "</td>" .
							"<td>" . $data_kunjungan->nama_dokter . "</td>" .
							"<td>" . $data_kunjungan->nama_icd . "</td>" .
							"<td>" . $data_kunjungan->non_spesialis . "</td>" .
							"<td>" . $data_kunjungan->spesialis_subspesialis . "</td>" .
							"<td>" . $data_kunjungan->ppk_rujukan . "</td>" .
							"<td>" . ArrayAdapter::format("unslug", $data_kunjungan->carapulang) . "</td>" .
							"<td>" . $data_kunjungan->nama_perusahaan . "</td>" .
							"<td>" . $data_kunjungan->nama_asuransi . "</td>" .
							"<td>" . ArrayAdapter::format("unslug", $data_kunjungan->unit_kerja) . "</td>" .
						"</tr>";
		}
	}
	echo json_encode(array(
		'html' => $html
	));
?>