<?php
	function generatePDF($db, $id_diagnosa) {
        $data = $db->get_row("
            SELECT
                a.*, b.ukerja, b.kode_faskes, b.tgl_lahir, b.kelamin, c.tanggal tanggal_daftar, b.pisat, c.ppk_bpjs_tujuan, c.kode_ppk_tujuan
            FROM
                smis_mr_diagnosa a
                	LEFT JOIN smis_rg_patient b ON a.no_bpjs = b.nobpjs
                    LEFT JOIN smis_rg_layananpasien c ON a.noreg_pasien = c.id
            WHERE
                a.id = '" . $id_diagnosa . "'
        ");

        $template_url = "medical_record/resource/img/template_surat_rujukan_20230509.png";

        global $user;
        $nama_user = $user->getName();
		$font_face = "Arial";
		$left_margin = 0;
        $top_margin = 0;

        $paper_size_w = 210;
        $paper_size_h = 300;

		$img_width = 210;
        $img_height = 300;
		$img_x = 0;
        $img_y = 0;

        $divisi_regional = getSettings($db, "smis-mr-surat_rujukan-divisi_regional", "REGIONAL II - BATAM");
        $kantor_cabang = getSettings($db, "smis-mr-surat_rujukan-kantor_cabang", "BATAM");
        $nomor_rujukan = $data->no_kunjungan_pcare;
        $nama_faskes = $data->ppk_bpjs_tujuan;
        $kode_faskes = $data->kode_ppk_tujuan;
        $kabupaten_kota = getSettings($db, "smis-mr-surat_rujukan-kabupaten_kota", "KOTA BATAM");
        $kode_kabupaten_kota = substr($kode_faskes, 0, 4);
        $poli_tujuan = $data->spesialis_subspesialis;
        $faskes_tujuan = $data->ppk_rujukan;
        $nama_pasien = $data->nama_pasien;
        $usia = floor(abs(strtotime($data->tanggal_daftar) - strtotime($data->tgl_lahir)) / (365*60*60*24));
        $tanggal_lahir = ArrayAdapter::format("date d-m-Y", $data->tgl_lahir);
        $nomor_bpjs = $data->no_bpjs;
        $kode_status = "";
        if (trim(strtolower($data->pisat)) == "peserta")
            $kode_status = "1";
        else if (trim(strtolower($data->pisat)) == "suami")
            $kode_status = "2";
        else if (trim(strtolower($data->pisat)) == "istri")
            $kode_status = "3";
        else if (trim(strtolower($data->pisat)) == "anak")
            $kode_status = "4";
        else if (trim(strtolower($data->pisat)) == "tanggungan")
            $kode_status = "5";
        $jk = $data->kelamin == 1 ? "P" : "L";
        $diagnosa = $data->kode_icd == "" || $data->kode_icd == null ? "" : $data->kode_icd . " - " . $data->nama_icd;
        $catatan = $data->catatan;
        $telah_diberikan = $data->terapi_non_obat . " " . $data->terapi_obat;
        $tanggal_footer = ArrayAdapter::format("date d M Y", $data->tanggal);
        $tanggal_rencana_berkunjung = $data->tanggal_rencana_berkunjung == "0000-00-00" || $data->tanggal_rencana_berkunjung  == null ? "-" : ArrayAdapter::format("date d-m-Y", $data->tanggal_rencana_berkunjung);
        $jadwal = $data->jadwal;
        $tanggal_expired = $data->tanggal_rencana_berkunjung == "0000-00-00" || $data->tanggal_rencana_berkunjung  == null ? "-" : ArrayAdapter::format("date d-m-Y", date('Y-m-d',strtotime('+89 day', strtotime($data->tanggal_rencana_berkunjung))));
        $nama_dokter = $data->nama_dokter;

        require_once("finance/class/template/pdf.php");
		$fpdf = new PDF("P", "mm", "A4");
		$fpdf->SetTopMargin($top_margin);
		$fpdf->SetLeftMargin($left_margin);

        $fpdf->AddPage();
        $fpdf->Image($template_url, $img_x, $img_y, $img_width, $img_height);
        
        $fpdf->SetX(0);
        $fpdf->SetY(0);
        $border = 0;

        $fpdf->Cell($paper_size_w, 4, "", $border, 1);

        $fpdf->Cell($paper_size_w / 2 + 42.5, 5, "", $border, 0);
        $fpdf->SetFont($font_face, "", 10);
        $fpdf->Cell($paper_size_w - ($paper_size_w / 2 + 42.5) - 5, 5, $divisi_regional, $border, 1);

        $fpdf->Cell($paper_size_w, 1.5, "", $border, 1);

        $fpdf->Cell($paper_size_w / 2 + 42.5, 5, "", $border, 0);
        $fpdf->SetFont($font_face, "", 10);
        $fpdf->Cell($paper_size_w - ($paper_size_w / 2 + 42.5) - 5, 5, $kantor_cabang, $border, 1);

		$fpdf->Cell($paper_size_w, 19, "", $border, 1);     

		$fpdf->Cell(0.25 * $paper_size_w, 4.5, "", $border, 0);
		$fpdf->SetFont($font_face, "", 8);
        $fpdf->Cell($paper_size_w - (0.25 * $paper_size_w) - 7, 4.5, $nomor_rujukan, $border, 1);

        $fpdf->Cell($paper_size_w, 3, "", $border, 1);

        $lastX = $fpdf->GetX();
        $lastY = $fpdf->GetY();
        $fpdf->Cell(0.25 * $paper_size_w, 4.5, "", $border, 0);
		$fpdf->SetFont($font_face, "", 8);
        $fpdf->MultiCell($paper_size_w - (0.25 * $paper_size_w) - 80, 4.5, $nama_faskes . " (" . $kode_faskes . ")", $border, 'J', false, $paper_size_w - (0.25 * $paper_size_w) - 80);
        $fpdf->SetXY($lastX, $lastY);
        $fpdf->Cell(0.25 * $paper_size_w + $paper_size_w - (0.25 * $paper_size_w) - 80, 4.5, "", $border, 0);
        $lastX = $fpdf->GetX();
        $lastY = $fpdf->GetY();
        $fpdf->Code39($lastX, $lastY, $nomor_rujukan, 0.5, 5);
        $fpdf->Cell(1, 4.5, "", $border, 1);

        $fpdf->Cell($paper_size_w, 2.25, "", $border, 1);

        $fpdf->Cell(0.25 * $paper_size_w, 4.5, "", $border, 0);
		$fpdf->SetFont($font_face, "", 8);
        $fpdf->MultiCell($paper_size_w - (0.25 * $paper_size_w) - 7, 4.5, $kabupaten_kota . " (" . $kode_kabupaten_kota . ")", $border, 'J', false, $paper_size_w - (0.25 * $paper_size_w) - 7);

        $fpdf->Cell($paper_size_w, 9.25, "", $border, 1);

        $fpdf->Cell(0.26 * $paper_size_w, 4.5, "", $border, 0);
		$fpdf->SetFont($font_face, "", 8);
        $fpdf->Cell($paper_size_w - (0.26 * $paper_size_w) - 7, 4.5, $poli_tujuan, $border, 1);

        $fpdf->Cell($paper_size_w, 1.5, "", $border, 1);        

        $fpdf->Cell(0.26 * $paper_size_w, 4.5, "", $border, 0);
        $fpdf->SetFont($font_face, "", 8);
        $fpdf->Cell($paper_size_w - (0.26 * $paper_size_w) - 7, 4.5, $faskes_tujuan, $border, 1);

        $fpdf->Cell($paper_size_w, 18.5, "", $border, 1);

        $lastX = $fpdf->GetX();
        $lastY = $fpdf->GetY();
        $fpdf->Cell(0.215 * $paper_size_w, 4.5, "", $border, 0);
		$fpdf->SetFont($font_face, "", 8);
        $fpdf->MultiCell($paper_size_w - (0.215 * $paper_size_w) - 110, 4.5, $nama_pasien, $border, 'J', false, $paper_size_w - (0.215 * $paper_size_w) - 110);
        $fpdf->SetX($lastX);
        $fpdf->SetY($lastY);
        $fpdf->Cell(0.26 * $paper_size_w + $paper_size_w - (0.26 * $paper_size_w) - 110, 4.5, "", $border, 0);
        $fpdf->Cell(12, 4.5, "", $border, 0);
        $fpdf->Cell(30, 4.5, $usia, $border, 0, "C");
        $fpdf->Cell(12, 4.5, "", $border, 0);
        $fpdf->Cell(32, 4.5, $tanggal_lahir, $border, 1, "C");

        $fpdf->Cell($paper_size_w, 1, "", $border, 1);

        $lastX = $fpdf->GetX();
        $lastY = $fpdf->GetY();
        $fpdf->Cell(0.215 * $paper_size_w, 4.5, "", $border, 0);
		$fpdf->SetFont($font_face, "", 8);
        $fpdf->MultiCell($paper_size_w - (0.215 * $paper_size_w) - 110, 4.5, $nomor_bpjs, $border, 'J', false, $paper_size_w - (0.215 * $paper_size_w) - 110);
        $fpdf->SetX($lastX);
        $fpdf->SetY($lastY);
        $fpdf->Cell(0.26 * $paper_size_w + $paper_size_w - (0.26 * $paper_size_w) - 110, 4.5, "", $border, 0);
        $fpdf->Cell(22.5, 4.5, "", $border, 0);
        $fpdf->Cell(8, 4.5, $kode_status, $border, 0, "C");
        $fpdf->Cell(37.5, 4.5, "", $border, 0);
        $fpdf->Cell(8, 4.5, $jk, $border, 1, "C");

        $fpdf->Cell($paper_size_w, 1.25, "", $border, 1);

        $lastX = $fpdf->GetX();
        $lastY = $fpdf->GetY();
        $fpdf->Cell(0.215 * $paper_size_w, 4.5, "", $border, 0);
		$fpdf->SetFont($font_face, "", 8);
        $fpdf->MultiCell(0.265 * $paper_size_w, 4.5, $diagnosa, $border, "J", false, 0.265 * $paper_size_w * 2);
        $fpdf->SetXY($lastX, $lastY);
        $fpdf->Cell(0.215 * $paper_size_w + 0.265 * $paper_size_w + 15, 4.5, "", $border, 0);
        $fpdf->MultiCell(0.425 * $paper_size_w, 4.5, $catatan, $border, "J", false, 0.425 * $paper_size_w);

		$fpdf->Cell($paper_size_w, 7.5, "", $border, 1);

        $lastX = $fpdf->GetX();
        $lastY = $fpdf->GetY();
        $fpdf->Cell(0.215 * $paper_size_w, 4.5, "", $border, 0);
		$fpdf->SetFont($font_face, "", 8);
        $fpdf->MultiCell($paper_size_w - (0.215 * $paper_size_w) - 4.5, 4.5, $telah_diberikan, $border, "J", false, $paper_size_w - (0.215 * $paper_size_w) - 4.5);
        $fpdf->SetXY($lastX, $lastY);
        $fpdf->Cell($paper_size_w, 4.5, "", $border, 1);        

        $fpdf->Cell($paper_size_w, 22.5, "", $border, 1);

        $fpdf->Cell($paper_size_w - 50, 4.5, "", $border, 0);
        $fpdf->SetFont($font_face, "", 8);
        $fpdf->Cell(22.5, 4.5, $tanggal_footer, $border, 1, "C");

        $fpdf->Cell($paper_size_w, 3, "", $border, 1);

        $fpdf->Cell(0.23 * $paper_size_w, 4.5, "", $border, 0);
        $fpdf->Cell(0.75 * $paper_size_w - 5, 4.5, $tanggal_rencana_berkunjung, $border, 1);

        $fpdf->Cell($paper_size_w, 1, "", $border, 1);

        $fpdf->Cell(0.175 * $paper_size_w, 4.5, "", $border, 0);
        $fpdf->MultiCell($paper_size_w - (0.175 * $paper_size_w) - 60, 4.5, $jadwal, $border, "J", false, $paper_size_w - (0.175 * $paper_size_w) - 60);

        $fpdf->Cell($paper_size_w, 1, "", $border, 1);

        $fpdf->Cell(0.525 * $paper_size_w, 4.5, "", $border, 0);
        $fpdf->Cell($paper_size_w - (0.525 * $paper_size_w) - 60, 4.5, $tanggal_expired, $border, 0);
        $fpdf->Cell(40, 4.5, $nama_dokter, $border, 1, "C");

		$fpdf->Cell($paper_size_w, 35.75, "", $border, 1);		  
		
		$fpdf->Cell(0.3 * $paper_size_w, 4.5, "", $border, 0);
		$fpdf->SetFont($font_face, "", 8);
        $fpdf->Cell($paper_size_w - (0.3 * $paper_size_w) - 5, 4.5, $nama_pasien, $border, 1);    

	    $md5 = md5(date("Ymd_His") . "_" . $nama_user);
		$filename = "surat_rujukan.pdf";
		$pathfile = "smis-temp/" . $md5 . $filename;
		$fpdf->Output($pathfile, "F");
		return $pathfile;
	}
?>