<?php
	global $db;

	$tanggal_from = $_POST['from_date'];
	$tanggal_to = $_POST['to_date'];
	$carabayar = $_POST['carabayar'];
	$unit_kerja = $_POST['unit_kerja'];
	$jenislayanan = $_POST['jenislayanan'];
	$carabayar_label = $_POST['carabayar_label'];
	$unit_kerja_label = $_POST['unit_kerja_label'];
	$jenislayanan_label = $_POST['jenislayanan_label'];

	$daftar_kunjungan = $db->get_result("
		SELECT
			a.id AS id,
	        a.tanggal AS tanggal,
	        a.tanggal_inap AS tanggal_inap,
	        a.tanggal_pulang AS tanggal_pulang,
	        a.akunting_notify_date AS tanggal_post,
	        a.carabayar AS carabayar,
	        a.caradatang AS caradatang,
	        a.nobpjs AS no_bpjs,
	        a.jenispasien AS jenispasien,
	        a.rujukan AS rujukan,
	        a.nama_rujukan AS nama_rujukan,
	        a.uri AS uri,
	        a.nrm AS nrm,
	        a.lunas AS lunas,
	        a.no_urut AS no_urut,
	        a.no_kunjungan AS no_kunjungan,
	        a.besarbonus AS besarbonus,
	        a.ambilbonus AS ambilbonus,
	        a.jenislayanan AS jenislayanan,
	        a.kamar_inap AS kamar_inap,
	        a.kode_ppk AS kode_ppk,
	        a.ppk_bpjs AS ppk_bpjs,
	        a.synch AS synch,
	        a.duplicate AS duplicate,
	        a.karcis AS karcis,
	        a.carapulang AS carapulang,
	        a.nama_dokter AS nama_dokter,
	        a.origin AS origin,
	        a.total_tagihan AS total_tagihan,
	        a.administrasi_inap AS administrasi_inap,
	        a.jenis_kunjungan as jenis_kunjungan,
	        IF((a.ambilbonus = ''),'belum','sudah') AS bonus,
	        IF((a.no_kunjungan = 1),'Baru','Lama') AS baru,
	        IF(a.kelamin=0,'Laki-Laki','Perempuan') AS kelamin,
	        a.nama_pasien AS nama,
	        a.telpon_pasien AS telpon_pasien,
	        a.alamat_pasien AS alamat,
	        a.nama_provinsi AS nama_provinsi,
	        a.nama_kabupaten AS nama_kabupaten,
	        a.nama_kecamatan AS nama_kecamatan,
	        a.nama_kelurahan AS nama_kelurahan,
	        a.nama_kedusunan AS nama_kedusunan,
	        a.nama_perusahaan AS id_perusahaan,    
	        '' AS nama_perusahaan,
	        a.asuransi AS id_asuransi,
	        '' AS nama_asuransi,
	        a.id_rujukan AS id_rujukan,
	        '' as instansi_rujukan,         
	        a.prop AS prop,
	        a.unit_kerja,
	        '' AS nama_icd,
	        '' AS non_spesialis,
	        '' AS spesialis_subspesialis,
	        '' AS ppk_rujukan
	    FROM
	    	smis_rg_layananpasien a
	    WHERE
	    	a.prop LIKE ''
	    		AND DATE(a.tanggal) >= '" . $tanggal_from . "'
	    		AND DATE(a.tanggal) <= '" . $tanggal_to . "'
	    		AND a.carabayar LIKE '" . $carabayar . "'
	    		AND a.unit_kerja LIKE '" . $unit_kerja . "'
	    		AND a.jenislayanan LIKE '" . $jenislayanan . "'
	    ORDER BY
	    	(a.id + 0) ASC, 
	    	a.id ASC
	");

	require_once("smis-libs-out/php-excel/PHPExcel.php");
	$workbook = new PHPExcel(); 
	global $user;
	$workbook->getProperties()->setCreator($user->getUsername());
	$workbook->getProperties()->setLastModifiedBy($user->getNameOnly());
	$workbook->getProperties()->setTitle("Laporan Kunjungan (Ext.)");
	$workbook->getProperties()->setSubject("Laporan Kunjungan (Ext.)");
	$workbook->getProperties()->setDescription("Data Laporan Kunjungan (Ext.)");
	$workbook->getProperties()->setKeywords("pasien, kunjungan, rekam, medis");
	$workbook->getProperties()->setCategory("Rekam Medis");

	$workbook->setActiveSheetIndex(0);
	$worksheet = $workbook->getActiveSheet(0);
	$worksheet->setTitle("Laporan Kunjungan");

	$i_row = 1;
	$worksheet->mergeCells("A" . $i_row . ":V" . $i_row)->setCellValue("A" . $i_row, "LAPORAN KUNJUNGAN");
	$i_row++;
	$worksheet->mergeCells("A" . $i_row . ":V" . $i_row)->setCellValue("A" . $i_row, "Periode : " . ArrayAdapter::format("date d-m-Y", $tanggal_from) . " s.d. " . ArrayAdapter::format("date d-m-Y", $tanggal_to) . " | Cara Bayar : " . $carabayar_label . " | Asal Data : " . $unit_kerja_label . " | Ruangan : " . $jenislayanan_label);
	$i_row += 2;

	$start_stroke = $i_row;
	$columns = array("No.", "Nama", "NRM", "No. BPJS", "L/P", "Tanggal", "Alamat", "Kecamatan", "Cara Bayar", "PPK", "No. Telp", "Jenis Kunjungan", "Ruangan", "Dokter Rawat Jalan", "Nama Diagnosa", "Jenis Diagnosa", "Dirujuk ke Poli", "Dirujuk ke RS", "Pulang", "Perusahaan", "Asuransi", "Asal Data");
	$i_col = "A";
	foreach ($columns as $column) {
		$worksheet->setCellValue($i_col . $i_row, $column);
		$i_col++;
	}
	$i_row++;

	if ($daftar_kunjungan != null) {
		$nomor = 1;
		foreach ($daftar_kunjungan as $data_kunjungan) {
			$data_kunjungan->nama_perusahaan = $db->get_var("
				SELECT
					nama
				FROM
					smis_rg_perusahaan
				WHERE
					id = '" . $data_kunjungan->id_perusahaan . "'
			");
			$data_kunjungan->nama_asuransi = $db->get_var("
				SELECT
					nama
				FROM
					smis_rg_asuransi
				WHERE
					id = '" . $data_kunjungan->id_asuransi . "'
			");
			$data_kunjungan->instansi_rujukan = $db->get_var("
				SELECT
					instansi
				FROM
					smis_rg_perujuk
				WHERE
					id = '" . $data_kunjungan->id_rujukan . "'
			");
			$data_rm = $db->get_row("
				SELECT
					nama_icd, 
					non_spesialis,
					spesialis_subspesialis,
					ppk_rujukan
				FROM
					smis_mr_diagnosa
				WHERE
					noreg_pasien = '" . $data_kunjungan->id . "'
			");
			if ($data_rm != null) {
				$data_kunjungan->nama_icd = $data_rm->nama_icd;
				$data_kunjungan->non_spesialis = $data_rm->non_spesialis;
				$data_kunjungan->spesialis_subspesialis = $data_rm->spesialis_subspesialis;
				$data_kunjungan->ppk_rujukan = $data_rm->ppk_rujukan;
			}

			$worksheet->setCellValue("A" . $i_row, $nomor++);
			$worksheet->setCellValue("B" . $i_row, $data_kunjungan->nama);
			$worksheet->setCellValue("C" . $i_row, ArrayAdapter::format("only-digit8", $data_kunjungan->nrm));
			$worksheet->setCellValue("D" . $i_row, $data_kunjungan->no_bpjs);
			$worksheet->setCellValue("E" . $i_row, $data_kunjungan->kelamin);
			$worksheet->setCellValue("F" . $i_row, ArrayAdapter::format("date d M Y", $data_kunjungan->tanggal));
			$worksheet->setCellValue("G" . $i_row, $data_kunjungan->alamat);
			$worksheet->setCellValue("H" . $i_row, $data_kunjungan->nama_kecamatan);
			$worksheet->setCellValue("I" . $i_row, $data_kunjungan->carabayar);
			$worksheet->setCellValue("J" . $i_row, $data_kunjungan->ppk_bpjs);
			$worksheet->setCellValue("K" . $i_row, $data_kunjungan->telpon_pasien);
			$worksheet->setCellValue("L" . $i_row, $data_kunjungan->jenis_kunjungan);
			$worksheet->setCellValue("M" . $i_row, ArrayAdapter::format("unslug", $data_kunjungan->jenislayanan));
			$worksheet->setCellValue("N" . $i_row, $data_kunjungan->nama_dokter);
			$worksheet->setCellValue("O" . $i_row, $data_kunjungan->nama_icd);
			$worksheet->setCellValue("P" . $i_row, $data_kunjungan->non_spesialis);
			$worksheet->setCellValue("Q" . $i_row, $data_kunjungan->spesialis_subspesialis);
			$worksheet->setCellValue("R" . $i_row, $data_kunjungan->ppk_rujukan);
			$worksheet->setCellValue("S" . $i_row, ArrayAdapter::format("unslug", $data_kunjungan->carapulang));
			$worksheet->setCellValue("T" . $i_row, $data_kunjungan->nama_perusahaan);
			$worksheet->setCellValue("U" . $i_row, $data_kunjungan->nama_asuransi);
			$worksheet->setCellValue("V" . $i_row, ArrayAdapter::format("unslug", $data_kunjungan->unit_kerja));
			$i_row++;
		}
	}

	$i_col = "A";
	foreach ($columns as $column) {
		$worksheet->getColumnDimension($i_col)->setAutoSize(true);
		$i_col++;
	}

	$_thin = array ();
	$_thin['borders']=array();
	$_thin['borders']['allborders']=array();
	$_thin['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;

	$_center = array();
	$_center ['alignment']=array();
	$_center ['alignment']['horizontal']=PHPExcel_Style_Alignment::HORIZONTAL_CENTER;

	$worksheet->getStyle('A1:V' . $start_stroke)->applyFromArray($_center);
	$worksheet->getStyle('A1:V' . $start_stroke)->getFont()->setBold(true);
	$worksheet->getStyle('A' . $start_stroke . ':V' . ($i_row - 1))->applyFromArray($_thin);

	$filename = "LAPORAN KUNJUNGAN_" . ArrayAdapter::format("date Ymd", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd", $tanggal_to) . "_" . date("Ymd_His") . ".xls";
	ob_clean();
	header('Content-Type: application/vnd.ms-excel');
	header('Content-Disposition: attachment;filename=' . $filename);
	header('Cache-Control: max-age=0');
	ob_clean();

	$writer = PHPExcel_IOFactory::createWriter($workbook, 'Excel5');
	$writer->save('php://output');	
?>