<?php 
/**
 * this file used for get all patient 
 * that go out from the hospital in
 * given date and export it as excel
 * 
 * @author 		: Nurul Huda
 * @license 	: Apache v3
 * @copyright 	: goblooge@gmail.com
 * @used 		: /medical_record/resource/php/laporan_pasien/lap_kunjungan.php
 * @service 	: get_sensus
 * @since		: 01 Feb 2017
 * @version		: 1.0.0
 * @database	: smis_mr_pasien_pulang
 * */

require_once "smis-libs-out/php-excel/PHPExcel.php"; 
require_once "smis-base/smis-include-service-consumer.php";

global $db;
$dbtable=new DBTable($db, "smis_mr_pasien_pulang");
$dbtable->setOrder(" tgl_masuk ASC");
$dbtable->setShowAll(true);
$data=$dbtable->view("","0");
$list=$data['data'];

show_error();
/*start - BLOK RESOURCE*/
	$_thin = array ();
	$_thin['borders']=array();
	$_thin['borders']['allborders']=array();
	$_thin['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;

	$_center = array();
	$_center ['alignment']=array();
	$_center ['alignment']['horizontal']=PHPExcel_Style_Alignment::HORIZONTAL_CENTER;
/*end - BLOCK RESOURCE*/

/*start - BLOCK PROPERTIES FILE EXCEL*/
	$file = new PHPExcel ();
	$file->getProperties ()->setCreator ( $user->getUsername() );
	$file->getProperties ()->setLastModifiedBy ( $user->getNameOnly() );
	$file->getProperties ()->setTitle ( "Laporan Pasien Pulang" );
	$file->getProperties ()->setSubject ( "Laporan Pasien Pulang" );
	$file->getProperties ()->setDescription ( "Data Laporan Pasien Pulang " );
	$file->getProperties ()->setKeywords ( "pasien, pulang, rekam, medis" );
	$file->getProperties ()->setCategory ( "Rekam Medis" );
/*end - BLOCK PROPERTIES FILE EXCEL*/

/*start - BLOCK PASIEN MASUK*/
	$file->setActiveSheetIndex ( 0 );
	$sheet = $file->getActiveSheet ( 0 );
	$sheet  ->setTitle ( "PASIEN" );	
    $sheet	->mergeCells('A1:V1');
	$sheet	->setCellValue ( "A1", "PASIEN MASUK RUMAH SAKIT" );
	$sheet	->setCellValue ( "A2", "No." )
			->setCellValue ( "B2", "No. Reg" )
			->setCellValue ( "C2", "NRM" )
			->setCellValue ( "D2", "Nama" )
			->setCellValue ( "E2", "Masuk" )
            ->setCellValue ( "F2", "Kelamin" )
            ->setCellValue ( "G2", "Kunjungan" )
            ->setCellValue ( "H2", "Kelurahan" )
            ->setCellValue ( "I2", "Kecamatan" )
            ->setCellValue ( "J2", "Kabupaten" )
            ->setCellValue ( "K2", "Pendidikan" )
            ->setCellValue ( "L2", "Pekerjaan" )
            ->setCellValue ( "M2", "Agama" )
            ->setCellValue ( "N2", "Kasus" )
            ->setCellValue ( "O2", "Ruangan" )
			->setCellValue ( "P2", "ICD 10" )
            ->setCellValue ( "Q2", "Diagnosa" )
            ->setCellValue ( "R2", "DPJP" )
            ->setCellValue ( "S2", "Carabayar" )
            ->setCellValue ( "T2", "Perusahaan" )
            ->setCellValue ( "U2", "Asuransi" )
            ->setCellValue ( "V2", "Kedatangan" );
	$sheet  ->getStyle ( 'A1:V1' )
            ->applyFromArray ($_center);
		
	$sheet ->getColumnDimension ( "A" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "B" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "C" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "D" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "E" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "F" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "G" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "H" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "I" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "J" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "K" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "L" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "M" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "N" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "O" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "P" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "Q" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "R" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "S" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "T" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "U" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "V" )->setAutoSize ( true );
	$sheet ->getStyle("A1:V2")->getFont()->setBold(true);
	$_ruang=array();
	$no=2;
	foreach($list as $x){
		$no++;
        if($x->tgl_masuk!="" && $x->tgl_masuk!="0000-00-00 00:00:00"){
            $pulang = new DateTime($x->tgl_masuk);
            $dateVal = PHPExcel_Shared_Date::PHPToExcel($pulang);
            $sheet  ->getStyle("E".$no)
                    ->getNumberFormat()
                    ->setFormatCode("dd-mm-yyyy HH:mm");
            $sheet  ->setCellValue("E".$no,$dateVal);            
        }
                
       
        $ruangan=ArrayAdapter::format("unslug",$x->ruang);
        if($ruangan=="") $ruangan="-";
		$sheet	->setCellValue ( "A".$no, ($no-2)."." )
				->setCellValue ( "B".$no, "'".ArrayAdapter::format("only-digit6",$x->noreg))
				->setCellValue ( "C".$no, "'".ArrayAdapter::format("only-digit6",$x->nrm) )
				->setCellValue ( "D".$no, $x->nama_pasien )
				->setCellValue ( "F".$no,  $x->jk==1?"P":"L")
                ->setCellValue ( "G".$no, strtoupper($x->kunjungan) )
				->setCellValue ( "H".$no, $x->kelurahan )
                ->setCellValue ( "I".$no, $x->kecamatan )
                ->setCellValue ( "J".$no, $x->kabupaten )
                ->setCellValue ( "K".$no, $x->pendidikan )
                ->setCellValue ( "L".$no, $x->pekerjaan )
                ->setCellValue ( "M".$no, $x->agama )
                ->setCellValue ( "N".$no, strtoupper($x->kasus) )
                ->setCellValue ( "O".$no, $ruangan )
                ->setCellValue ( "P".$no, $x->kode_diagnosa )
                ->setCellValue ( "Q".$no, $x->diagnosa )
                ->setCellValue ( "R".$no, $x->dokter_pj )
                ->setCellValue ( "S".$no, ArrayAdapter::format("unslug",$x->carabayar) )
                ->setCellValue ( "T".$no, $x->n_perusahaan )
                ->setCellValue ( "U".$no, $x->n_asuransi )
                ->setCellValue ( "V".$no, $x->caradatang );
        if(!in_array($ruangan,$_ruang)){
            $_ruang[]=$ruangan;
        }
	}
    
	$sheet->getStyle ( 'A2:V'.$no )->applyFromArray ($_thin);
/*end - BLOCK PASIEN MASUK*/



/*start - BLOCK SETTINGS*/
$END_NUM=$no;
$file   ->createSheet (1);
$file   ->setActiveSheetIndex ( 1 );
$sheet  = $file->getActiveSheet (1);
$sheet  ->setTitle("SETTINGS");
$sheet  ->setCellValue("A1","RUANGAN");
$sheet  ->setCellValue("B1","PASIEN!\$O\$3:\$O\$".$END_NUM);
$sheet  ->setCellValue("A2","KASUS");
$sheet  ->setCellValue("B2","PASIEN!\$N\$3:\$N\$".$END_NUM);
$sheet  ->setCellValue("A3","KUNJUNGAN");
$sheet  ->setCellValue("B3","PASIEN!\$G\$3:\$G\$".$END_NUM);
$sheet  ->setCellValue("A4","KEDATANGAN");
$sheet  ->setCellValue("B4","PASIEN!\$V\$3:\$V\$".$END_NUM);
$sheet  ->setCellValue("A5","CARABAYAR");
$sheet  ->setCellValue("B5","PASIEN!\$S\$3:\$S\$".$END_NUM);
$sheet  ->setCellValue("A6","ASURANSI");
$sheet  ->setCellValue("B6","PASIEN!\$U\$3:\$U\$".$END_NUM);
/*end - BLOCK SETTINGS*/


/* start - BLOCK RESUME PASIEN */
sort($_ruang);
$file   ->createSheet (2);
$file   ->setActiveSheetIndex ( 2 );
$sheet  = $file->getActiveSheet (2);
$sheet  ->setTitle("RESUME PASIEN");
$sheet	->mergeCells('A1:A3');
$sheet	->setCellValue("A1","RUANGAN");
$sheet	->mergeCells('B1:C2');
$sheet	->setCellValue("B1","KASUS");
$sheet	->setCellValue("B3","BARU");
$sheet	->setCellValue("C3","LAMA");

$sheet	->mergeCells('D1:E2');
$sheet	->setCellValue("D1","KUNJUNGAN");
$sheet	->setCellValue("D3","BARU");
$sheet	->setCellValue("E3","LAMA");

$sheet	->mergeCells('F1:N1');
$sheet	->setCellValue("F1","JENIS KUNJUNGAN");
$sheet	->mergeCells('F2:F3');
$sheet	->setCellValue("F2","DATANG SENDIRI");
$sheet	->mergeCells('G2:N2');
$sheet	->setCellValue("G2","RUJUKAN");
$sheet	->setCellValue("G3","DOKTER");
$sheet	->setCellValue("H3","MANTRI");
$sheet	->setCellValue("I3","BIDAN");
$sheet	->setCellValue("J3","PUSKESMAS");
$sheet	->setCellValue("K3","RS LAIN");
$sheet	->setCellValue("L3","BALAI PENGOBATAN LAIN");
$sheet	->setCellValue("M3","KARYAWAN");
$sheet	->setCellValue("N3","LAINYA");


/*START - PENCARIAN PASIEN BERDASARKAN CARABAYAR*/
$serv=new ServiceConsumer($db,"get_carabayar",NULL,"registration");
$serv->execute();
$database=$serv->getContent();
$total=count($database);

/*END - PENCARIAN PASIEN BERDASARKAN CARABAYAR*/
$HURUF=array();
$HURUF[1]="O";
$HURUF[2]="P";
$HURUF[3]="Q";
$HURUF[4]="R";
$HURUF[5]="S";
$HURUF[6]="T";
$HURUF[7]="U";
$HURUF[8]="V";
$HURUF[9]="W";
$HURUF[10]="X";
$HURUF[11]="Y";
$HURUF[12]="Z";
$HURUF[13]="AA";
$HURUF[14]="AB";
$HURUF[15]="AC";
$HURUF[16]="AD";
$HURUF[17]="AE";
$HURUF[18]="AF";
$HURUF[19]="AG";
$HURUF[20]="AH";
$HURUF[21]="AI";
$HURUF[22]="AJ";
$LAST_ALPHABET=$HURUF[$total];
$sheet	->mergeCells('O1:'.$LAST_ALPHABET.'2');
$sheet	->setCellValue("O1","CARA BAYAR");
$total=0;
foreach($database as $d){
    $total++;
    $LAST_ALPHABET=$HURUF[$total];
    $sheet	->setCellValue($LAST_ALPHABET."3",ArrayAdapter::format("unslug",$d['slug']));
}
 $_LAST_CARABAYAR_ALPHABET=$LAST_ALPHABET;
if($_POST['detail']=="1"){
   
    $total++;
    $_FIRST_ASURANSI_ALPHABET=$HURUF[$total];
    $LAST_ALPHABET=$HURUF[$total];

    $sheet	->setCellValue($LAST_ALPHABET."3","SKM");
    $total++;
    $LAST_ALPHABET=$HURUF[$total];
    $sheet	->setCellValue($LAST_ALPHABET."3","SEHATI");
    $total++;
    $LAST_ALPHABET=$HURUF[$total];
    $sheet	->setCellValue($LAST_ALPHABET."3","SPM");
    $total++;
    $LAST_ALPHABET=$HURUF[$total];
    $sheet	->setCellValue($LAST_ALPHABET."3","SKTM");
    $total++;
    $LAST_ALPHABET=$HURUF[$total];
    $sheet	->setCellValue($LAST_ALPHABET."3","JAMKESDA");
    $total++;
    $LAST_ALPHABET=$HURUF[$total];
    $sheet	->setCellValue($LAST_ALPHABET."3","JASA RAHARJA");
    $total++;
    $LAST_ALPHABET=$HURUF[$total];
}




$sheet  ->getStyle( 'A1:'.$LAST_ALPHABET.'3' )->applyFromArray ($_center);
$sheet  ->getStyle("A1:".$LAST_ALPHABET."3")->getFont()->setBold(true);

$sheet ->getColumnDimension ( "A" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "C" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "D" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "E" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "G" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "I" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "J" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "K" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "L" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "M" )->setAutoSize ( true );
$sheet ->getColumnDimension ( "N" )->setAutoSize ( true );



$no=3;
foreach($_ruang as $r){
    $no++;
    $sheet	->setCellValue("A".$no,$r);  
   
    //$sheet  ->setCellValue("B".$no,'=COUNTIFS(INDIRECT(SETTINGS!$B$2),CONCATENATE("*",B$2,"*"),INDIRECT(SETTINGS!$B$1),$A1)');
    //$sheet  ->setCellValueExplicit("F".$no,"=COUNTIFS(INDIRECT(SETTINGS!\$B\$3);CONCATENATE(\"*\";F\$2;\"*\");INDIRECT(SETTINGS!\$B\$1);\$A1)");
    //$sheet  ->setCellValueExplicit("H".$no,"=COUNTIFS(INDIRECT(SETTINGS!\$B\$4);CONCATENATE(\"*\";H\$2;\"*\");INDIRECT(SETTINGS!\$B\$1);\$A1)");

}

$SEPARATOR=$_POST['separator'];
$sheet  ->setCellValueExplicit("B4",'=COUNTIFS(INDIRECT(SETTINGS!$B$2)'.$SEPARATOR.'CONCATENATE("*"'.$SEPARATOR.'B$3'.$SEPARATOR.'"*")'.$SEPARATOR.'INDIRECT(SETTINGS!$B$1)'.$SEPARATOR.'$A4)');
$sheet  ->setCellValueExplicit("D4",'=COUNTIFS(INDIRECT(SETTINGS!$B$3)'.$SEPARATOR.'CONCATENATE("*"'.$SEPARATOR.'D$3'.$SEPARATOR.'"*")'.$SEPARATOR.'INDIRECT(SETTINGS!$B$1)'.$SEPARATOR.'$A4)');
$sheet  ->setCellValueExplicit("F4",'=COUNTIFS(INDIRECT(SETTINGS!$B$4)'.$SEPARATOR.'CONCATENATE("*"'.$SEPARATOR.'F$2'.$SEPARATOR.'"*")'.$SEPARATOR.'INDIRECT(SETTINGS!$B$1)'.$SEPARATOR.'$A4)');
$sheet  ->setCellValueExplicit("G4",'=COUNTIFS(INDIRECT(SETTINGS!$B$4)'.$SEPARATOR.'CONCATENATE("*"'.$SEPARATOR.'G$3'.$SEPARATOR.'"*")'.$SEPARATOR.'INDIRECT(SETTINGS!$B$1)'.$SEPARATOR.'$A4)');
$sheet  ->setCellValueExplicit("O4",'=COUNTIFS(INDIRECT(SETTINGS!$B$5)'.$SEPARATOR.'O$3'.$SEPARATOR.'INDIRECT(SETTINGS!$B$1)'.$SEPARATOR.'$A4)');
if($_POST['detail']=="1") 
    $sheet  ->setCellValueExplicit($_FIRST_ASURANSI_ALPHABET."4",'=COUNTIFS(INDIRECT(SETTINGS!$B$6)'.$SEPARATOR.'CONCATENATE("*"'.$SEPARATOR.'Q$3'.$SEPARATOR.'"*")'.$SEPARATOR.'INDIRECT(SETTINGS!$B$1)'.$SEPARATOR.'$A4)');
$_total_ruang=count($_ruang)+3;

$backgroound['fill']=array();
$backgroound['fill']['type']=PHPExcel_Style_Fill::FILL_SOLID;
$backgroound['fill']['color']=array();

$backgroound['fill']['color']['rgb']='99FFFF';
$sheet->getStyle ( 'B4:C'.($_total_ruang+1) )->applyFromArray ($backgroound);
$backgroound['fill']['color']['rgb']='FF99FF';
$sheet->getStyle ( 'D4:E'.($_total_ruang+1) )->applyFromArray ($backgroound);
$backgroound['fill']['color']['rgb']='FFFF99';
$sheet->getStyle ( 'F4:F'.($_total_ruang+1) )->applyFromArray ($backgroound);
$backgroound['fill']['color']['rgb']='FF9999';
$sheet->getStyle ( 'G4:N'.($_total_ruang+1) )->applyFromArray ($backgroound);
$backgroound['fill']['color']['rgb']='99FF99';
$sheet->getStyle ( 'O4:'.$_LAST_CARABAYAR_ALPHABET.($_total_ruang+1) )->applyFromArray ($backgroound);
if($_POST['detail']=="1"){
    $backgroound['fill']['color']['rgb']='9999FF';
    $sheet->getStyle ( $_FIRST_ASURANSI_ALPHABET.'4:'.$LAST_ALPHABET.($_total_ruang+1) )->applyFromArray ($backgroound);
}


$sheet	->setCellValue("A".($_total_ruang+1),"TOTAL");
$sheet	->setCellValue("B".($_total_ruang+1),"=SUM(B3:B".$_total_ruang.")");
$sheet	->setCellValue("C".($_total_ruang+1),"=SUM(C3:C".$_total_ruang.")");
$sheet	->setCellValue("D".($_total_ruang+1),"=SUM(D3:D".$_total_ruang.")");
$sheet	->setCellValue("E".($_total_ruang+1),"=SUM(E3:E".$_total_ruang.")");
$sheet	->setCellValue("F".($_total_ruang+1),"=SUM(F3:F".$_total_ruang.")");
$sheet	->setCellValue("G".($_total_ruang+1),"=SUM(G3:G".$_total_ruang.")");
$sheet	->setCellValue("H".($_total_ruang+1),"=SUM(H3:H".$_total_ruang.")");
$sheet	->setCellValue("I".($_total_ruang+1),"=SUM(I3:I".$_total_ruang.")");
$sheet	->setCellValue("J".($_total_ruang+1),"=SUM(J3:J".$_total_ruang.")");
$sheet	->setCellValue("K".($_total_ruang+1),"=SUM(K3:K".$_total_ruang.")");
$sheet	->setCellValue("L".($_total_ruang+1),"=SUM(L3:L".$_total_ruang.")");
$sheet	->setCellValue("M".($_total_ruang+1),"=SUM(M3:M".$_total_ruang.")");
$sheet	->setCellValue("N".($_total_ruang+1),"=SUM(N3:N".$_total_ruang.")");

foreach($HURUF as $nomor=>$h){
    if($_total_ruang!=0)
        $sheet	->setCellValue($h.($_total_ruang+1),"=SUM(".$h."3:".$h.$_total_ruang.")");
    if($h==$LAST_ALPHABET) 
        break;
}

$sheet ->getStyle("A".($_total_ruang+1).":".$LAST_ALPHABET.($_total_ruang+1))->getFont()->setBold(true);
$sheet->getStyle ( 'A1:'.$LAST_ALPHABET.($_total_ruang+1) )->applyFromArray ($_thin);
/* end - BLOCK RESUME PASIEN */

$filename= "DATA PASIEN MASUK - ".
           " - ".ArrayAdapter::format("date d M Y",$_POST['dari']).
           " - ".ArrayAdapter::format("date d M Y",$_POST['sampai']).".xls";

header ( 'Content-Type: application/vnd.ms-excel' );
header ( 'Content-Disposition: attachment;filename="'.$filename.'"' );
header ( 'Cache-Control: max-age=0' );
$writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
$writer->save ( 'php://output' );

?>