<?php 
/**
 * this file used for get all patient 
 * that go out from the hospital in
 * given date and export it as excel
 * special case for hospitalized patient
 * 
 * @author 		: Nurul Huda
 * @license 	: Apache v3
 * @copyright 	: goblooge@gmail.com
 * @used 		: /medical_record/resource/php/lap_index/lap_index_penyakit.php
 * @since		: 17 Feb 2017
 * @version		: 1.0.0
 * @database	: smist_mr_lap_ranap
 * */

require_once "smis-libs-out/php-excel/PHPExcel.php"; 
require_once "smis-base/smis-include-service-consumer.php";
loadLibrary("smis-libs-function-excel");
global $db;
$query_view="
			SELECT nama_icd, tanggal,nrm_pasien,tgl_masuk,tgl_keluar,lama_dirawat,
			if(gol_umur_ip='0 - 28 HR','x','') as '28hr',
			if(gol_umur_ip='28 HR - 1 TH','x','') as '1th',
			if(gol_umur_ip='1-4 TH','x','') as '4th',
			if(gol_umur_ip='5-14 TH','x','') as '14th',
			if(gol_umur_ip='15-24 TH','x','') as '24th',
			if(gol_umur_ip='25-44 TH','x','') as '44th',
			if(gol_umur_ip='45-59 TH','x','') as '59th',
			if(gol_umur_ip='60-64 TH','x','') as '64th',
			if(gol_umur_ip='65 TH+','x','') as '65th',
			if(jk=0,'x','') as laki,
			if(jk=1,'x','') as pr,
			keterangan,
			ruangan as ruangan,
			ifnull(kelas,ruangan) as kelas,
			if(carapulang='Dipulangkan Mati <=48 Jam' OR carapulang='Dipulangkan Mati < 1 Jam Post Operasi','x','') as mk48,
			if(carapulang='Dipulangkan Mati >48 Jam','x','') as ml48,
			if(carapulang='Pulang Paksa','x','') as paksa,
			if(carapulang='Kabur','x','') as kabur,
			if(carapulang='Rujuk RS Lain','x','') as rslain,
			if(carapulang='Dikembalikan ke Perujuk','x','') as perujuk,
			if(carapulang='Dipulangkan Hidup','x','') as hidup
			FROM smis_mr_diagnosa			
	";
	$query_count="SELECT COUNT(*) FROM smis_mr_diagnosa";
	
	$dbtable=new DBTable($db, "smis_mr_diagnosa");
	$dbtable->setPreferredQuery(true,$query_view,$query_count);
	$dbtable->setUseWhereforView(true);
	$dbtable->setOrder(" tanggal ASC");	
	$dbtable->addCustomKriteria(" nama_icd "," like '".$_POST['nama_penyakit']."%' ");
	if($_POST['urji']!="-1"){
		$dbtable->addCustomKriteria(" urji "," = '".$_POST['urji']."' ");
	}
    $dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
    
$data=$dbtable->view("","0");
$list=$data['data'];

show_error();
/*start - BLOK RESOURCE*/
	$_thin = array ();
	$_thin['borders']=array();
	$_thin['borders']['allborders']=array();
	$_thin['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;

	$_center = array();
	$_center ['alignment']=array();
	$_center ['alignment']['horizontal']=PHPExcel_Style_Alignment::HORIZONTAL_CENTER;
/*end - BLOCK RESOURCE*/

/*start - BLOCK PROPERTIES FILE EXCEL*/
	$file = new PHPExcel ();
	$file->getProperties ()->setCreator ( $user->getUsername() );
	$file->getProperties ()->setLastModifiedBy ( $user->getNameOnly() );
	$file->getProperties ()->setTitle ( "Laporan Pasien Index Penyakit" );
	$file->getProperties ()->setSubject ( "Laporan Pasien Index Penyakit" );
	$file->getProperties ()->setDescription ( "Data Laporan Pasien Index Penyakit " );
	$file->getProperties ()->setKeywords ( "index, penyakit, rekam, medis" );
	$file->getProperties ()->setCategory ( "Rekam Medis" );
/*end - BLOCK PROPERTIES FILE EXCEL*/

/*start - BLOCK PASIEN MASUK*/
	$file->setActiveSheetIndex ( 0 );
	$sheet = $file->getActiveSheet ( 0 );
	
    $sheet ->getColumnDimension ( "A" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "B" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "C" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "D" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "E" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "F" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "G" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "H" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "I" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "J" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "K" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "L" )->setAutoSize ( true );
    $sheet ->getColumnDimension ( "M" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "N" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "O" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "P" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "Q" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "R" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "S" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "T" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "U" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "V" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "W" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "X" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "Y" )->setAutoSize ( true );
	$sheet ->getColumnDimension ( "Z" )->setAutoSize ( true );
    
    $sheet  ->setTitle ( "LAPORAN" );	
    $sheet	->mergeCells('A1:N1');
	$sheet	->setCellValue ( "A1", "LAPORAN INDEX PENYAKIT" );
	$sheet	->setCellValue ( "A2", "No." )
			->setCellValue ( "B2", "Tanggal" )
			->setCellValue ( "C2", "NRM" )
			->setCellValue ( "D2", "Ruangan" )
			->setCellValue ( "E2", "Masuk" )
			->setCellValue ( "F2", "Keluar" )
            ->setCellValue ( "G2", "Lama Dirawat" )
            ->setCellValue ( "H2", "L" )
            ->setCellValue ( "I2", "P" )
            ->setCellValue ( "J2", "0 - 28 HR" )
            ->setCellValue ( "K2", "28 HR - 1 TH" )
            ->setCellValue ( "L2", "1-4 TH" )
            ->setCellValue ( "M2", "5-14 TH" )
            ->setCellValue ( "N2", "15-24 TH" )
            ->setCellValue ( "O2", "25-44 TH" )
            ->setCellValue ( "P2", "45-59 TH" )
            ->setCellValue ( "Q2", "60-64 TH" )
            ->setCellValue ( "R2", "65 TH+" )
            ->setCellValue ( "S2", "Diagnosa Sekunder" )
            ->setCellValue ( "T2", "Kelas" )
            ->setCellValue ( "U2", "Dipulangkan Mati <=48 Jam" )
            ->setCellValue ( "V2", "Dipulangkan Mati >48 Jam" )
            ->setCellValue ( "W2", "Pulang Paksa" )
            ->setCellValue ( "X2", "Kabur" )
            ->setCellValue ( "Y2", "Rujuk RS Lain" )
            ->setCellValue ( "Z2", "Dikembalikan ke Perujuk" )
            ->setCellValue ( "AA2", "Dipulangkan Hidup" );
	$sheet  ->getStyle ( 'A1:AA1' )
            ->applyFromArray ($_center);
	
	$sheet ->getStyle("A1:AA2")->getFont()->setBold(true);
	$_ruang=array();
	$no=2;
	foreach($list as $x){
		$no++;
        date_excel_format($sheet,"B".$no,$x['tanggal']);
        date_excel_format($sheet,"E".$no,$x['tgl_masuk']);
        date_excel_format($sheet,"F".$no,$x['tgl_keluar']);
        
        $ruangan=ArrayAdapter::format("unslug",$x->ruang);
        if($ruangan=="") $ruangan="-";
		$sheet	->setCellValue ( "A".$no, ($no-2)."." )
				->setCellValue ( "C".$no, "'".ArrayAdapter::format("only-digit6",$x['nrm_pasien']) )
				->setCellValue ( "D".$no, ArrayAdapter::format("unslug",$x['ruangan']) )
				->setCellValue ( "G".$no, $x['lama_dirawat'])
				->setCellValue ( "H".$no, $x['laki'])
                ->setCellValue ( "I".$no, $x['pr'])
                ->setCellValue ( "J".$no, $x['28hr'] )
                ->setCellValue ( "K".$no, $x['1th'] )
                ->setCellValue ( "L".$no, $x['4th'] )
                ->setCellValue ( "M".$no, $x['14th'] )
                ->setCellValue ( "N".$no, $x['24th'] )
                ->setCellValue ( "O".$no, $x['44th'] )
                ->setCellValue ( "P".$no, $x['59th'] )
                ->setCellValue ( "Q".$no, $x['64th'] )
                ->setCellValue ( "R".$no, $x['65th'] )
                ->setCellValue ( "S".$no, $x['keterangan'] )
                ->setCellValue ( "T".$no, $x['kelas'] )
                ->setCellValue ( "U".$no, $x['mk48'] )
                ->setCellValue ( "V".$no, $x['ml48'] )
                ->setCellValue ( "W".$no, $x['paksa'] )
                ->setCellValue ( "X".$no, $x['kabur'] )
                ->setCellValue ( "Y".$no, $x['rslain'] )
                ->setCellValue ( "Z".$no, $x['perujuk'] )
                ->setCellValue ( "AA".$no,$x['hidup']  );
        if(!in_array($ruangan,$_ruang)){
            $_ruang[]=$ruangan;
        }
	}
    $sheet	->setCellValue ( "H".$no, "=counta(H3:H".($no-1).")" );
    $sheet	->setCellValue ( "I".$no, "=counta(I3:I".($no-1).")" );
    $sheet	->setCellValue ( "J".$no, "=counta(J3:J".($no-1).")" );
    $sheet	->setCellValue ( "K".$no, "=counta(K3:K".($no-1).")" );
    $sheet	->setCellValue ( "L".$no, "=counta(L3:L".($no-1).")" );
    $sheet	->setCellValue ( "M".$no, "=counta(M3:M".($no-1).")" );
    $sheet	->setCellValue ( "N".$no, "=counta(N3:N".($no-1).")" );
    $sheet	->setCellValue ( "O".$no, "=counta(O3:O".($no-1).")" );
    $sheet	->setCellValue ( "P".$no, "=counta(P3:P".($no-1).")" );
    $sheet	->setCellValue ( "Q".$no, "=counta(Q3:Q".($no-1).")" );
    $sheet	->setCellValue ( "R".$no, "=counta(R3:R".($no-1).")" );
    
    $sheet	->setCellValue ( "U".$no, "=counta(U3:U".($no-1).")" );
	$sheet	->setCellValue ( "V".$no, "=counta(V3:V".($no-1).")" );
	$sheet	->setCellValue ( "W".$no, "=counta(W3:W".($no-1).")" );
	$sheet	->setCellValue ( "X".$no, "=counta(X3:X".($no-1).")" );
	$sheet	->setCellValue ( "Y".$no, "=counta(Y3:Y".($no-1).")" );
	$sheet	->setCellValue ( "Z".$no, "=counta(Z3:Z".($no-1).")" );
	$sheet	->setCellValue ( "AA".$no, "=counta(AA3:AA".($no-1).")" );
	$sheet->getStyle ( 'A2:AA'.$no )->applyFromArray ($_thin);
/*end - BLOCK PASIEN MASUK*/
        
$filename= "DATA LAPORAN INDEX DOKTER - ".
           " - ".ArrayAdapter::format("date d M Y",$_POST['dari']).
           " - ".ArrayAdapter::format("date d M Y",$_POST['sampai']).".xls";

header ( 'Content-Type: application/vnd.ms-excel' );
header ( 'Content-Disposition: attachment;filename="'.$filename.'"' );
header ( 'Cache-Control: max-age=0' );
$writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
$writer->save ( 'php://output' );

?>