<?php 
require_once 'smis-libs-class/MasterSlaveTemplate.php';
require_once "medical_record/class/responder/PasienVakumDBResponder.php";
global $db;

$button = new Button("", "", "");
$button ->setAction("laporan_vakum.view()");
$button ->setClass("btn-primary");
$button ->setIsButton(Button::$ICONIC);
$button ->setIcon("fa fa-refresh");

$excel = new Button("", "", "Excel");
$excel ->setAction("laporan_vakum.excel()");
$excel ->setClass("btn-primary");
$excel ->setIsButton(Button::$ICONIC_TEXT);
$excel ->setIcon("fa fa-file-excel-o");

$pdf = new Button("", "", "PDF");
$pdf ->setAction("laporan_vakum.pdf()");
$pdf ->setClass("btn-primary");
$pdf ->setIsButton(Button::$ICONIC_TEXT);
$pdf ->setIcon("fa fa-file-pdf-o");

$laporan_vakum = new MasterSlaveTemplate($db, "smis_rg_patient", "medical_record", "laporan_vakum");

$responder = new PasienVakumDBResponder($laporan_vakum->getDBtable(),$laporan_vakum->getUItable(),$laporan_vakum->getAdapter());
$laporan_vakum ->setDBresponder($responder);

$uitable = $laporan_vakum->getUItable();
$uitable ->setAction(true);
$uitable ->setDelButtonEnable(false);
$uitable ->setEditButtonEnable(false);
$uitable ->setAddButtonEnable(false);
$uitable ->setPrintButtonEnable(false);
$uitable ->setReloadButtonEnable(false);
$uitable ->setFooterVisible(false);



if($laporan_vakum  ->getDBResponder()->isView() ||$laporan_vakum  ->getDBResponder()->isExcel() || $laporan_vakum  ->getDBResponder()->is("pdf") ){

    $button = new Button("","","");
    $button ->setIsButton(Button::$ICONIC);
    $button ->setClass("btn btn-danger");
    $button ->setIcon("fa fa-trash");
    $uitable ->addContentButton("del",$button);

	$query_view = " SELECT smis_rg_patient.id, 
                    smis_rg_patient.nrm, 
                    smis_rg_patient.nama, 
                    smis_rg_patient.last_noreg, 
                    smis_rg_patient.last_time_reg, 
                    smis_rg_layananpasien.carabayar, 
                    smis_rg_layananpasien.jenislayanan,  
                    smis_rg_layananpasien.umur,
                    DATEDIFF(NOW(),smis_rg_patient.last_time_reg) as selisih,
                    smis_rg_patient.prop
                    FROM smis_rg_patient LEFT JOIN smis_rg_layananpasien 
                    ON smis_rg_patient.last_noreg = smis_rg_layananpasien.id 
                    WHERE smis_rg_patient.prop!='del' AND smis_rg_patient.origin LIKE '".$_POST['origin_data']."'
                    HAVING ( selisih IS NULL OR selisih > ".$_POST['pilihan_tahun']." ) ";
    $query_count = "SELECT count(*) FROM smis_rg_patient ";

    $laporan_vakum  ->getDBtable()
                    ->setOrder(" last_time_reg ASC ")
                    ->setPreferredQuery(true,$query_view,$query_count)
                    ->setUseWhereforView(false)
                    ->setShowAll(true);
    
}

$header  = array("No.","Tanggal","Cara Bayar","No. Register","Layanan","No. RM","Nama Pasien","Umur");
$uitable ->setHeader($header);

$adapter = new SimpleAdapter();
$adapter ->setUseNumber(true, "No.","back.");
$adapter ->add("Tanggal", "last_time_reg","date d M Y")
		 ->add("Cara Bayar", "carabayar","unslug")
		 ->add("No. Register", "last_noreg")
         ->add("Layanan", "jenislayanan","unslug")
         ->add("No. RM", "nrm")
         ->add("Nama Pasien", "nama")
         ->add("Umur", "umur");

$laporan_vakum  ->setAdapter($adapter);
$laporan_vakum  ->addViewData("pilihan_tahun", "pilihan_tahun");
$laporan_vakum  ->addViewData("origin_data", "origin_data");
if($laporan_vakum->getDBResponder()->isPreload()){

    $query = "SELECT DISTINCT origin FROM smis_rg_patient";

    $origin = new OptionBuilder();
    $origin->add(" - Semua - ","",1);
    $res = $db->get_result($query);
    foreach ($res as $x){
        if ($x->origin == ""){
            continue;
        }
        $origin->add(ArrayAdapter::slugFormat("unslug",$x->origin),$x->origin);
    }

    $option = new OptionBuilder();
    $option ->add("1 Tahun",365,1);
    $option ->add("2 Tahun",365*2,1);
    $option ->add("3 Tahun",365*3,1);
    $option ->add("4 Tahun",365*4+1,1);
    $option ->add("5 Tahun",365*5+1,1);
  
	$laporan_vakum ->addFlag("pilihan_tahun", "Pilihan Tahun", "Silakan Pilih Tahun")
					->addNoClear("pilihan_tahun")
					->setDateEnable(true)
					->getUItable()
					->addModal("pilihan_tahun", "select", "Pilihan Tahun", $option ->getContent())
                    ->addModal("origin_data", "select", "Asal Data", $origin->getContent());

    $laporan_vakum  ->getForm()
                    ->addElement("", $button)
                    //->addElement("", $pdf)
                    ->addElement("", $excel);

}

if($laporan_vakum->getDBResponder()->isDel()){
    global $user;
    $_POST['command'] = "save";
    $_POST['prop'] = "del";
    $_POST['deleted_by'] = $user->getNameOnly();
    $_POST['deleted_date'] = date("Y-m-d");
}
$laporan_vakum  ->addResouce("js","medical_record/resource/js/laporan_vakum.js");

$laporan_vakum->initialize();