<?php

setChangeCookie ( false );
global $db;
require_once ("smis-base/smis-include-service-consumer.php");
require_once 'medical_record/class/responder/RL54Responder.php';

$header=array(
            'No',
            'Sebab Sakit', 
            "Kode",
            'Ruangan',
            '28hr Lk',
            '28hr Pr',
            "1th Lk",
            "1th Pr",
            "4th Lk",
            "4th Pr",
            "14th Lk",
            "14th Pr",
            "24th Lk",
            "24th Pr",
            "44th Lk",
            "44th Pr",
            "65th Lk",
            "65th Pr",
            "l65th Lk",
            "l65th Pr",
            "Kasus Baru Lk",
            "Kasus Baru Pr",
            "Kasus Baru Jmlh",
            "Kasus Lama Lk",
            "Kasus Lama Pr",
            "Kasus Lama Jmlh",
            "Kasus Jmlh",
            "Pasien Baru Lk",
            "Pasien Baru Pr",
            "Jumlah Pasien Baru", 
            "Pasien Lama Lk",
            "Pasien Lama Pr",
            "Jumlah Pasien Lama",
            "Jumlah Kunjungan" );
$uitable = new Report ( $header, "", NULL );
$uitable->setSeriesEnabled(false);
$uitable->setRangeEnabled(false);
$uitable->setModelEnabled(false);

$uitable->addHeader ( "before", "<tr>
                        <th rowspan='3'>No.</th>
                        <th rowspan='3'>Golongan Sebab-Sebab Sakit</th>
                        <th rowspan='3'>Kode</th>
                        <th rowspan='3'>Ruangan</th>
                        <th colspan='16'>Kasus Baru Menurut Golongn Umur</th>
                        <th colspan='7'>Jumlah Kasus</th>
                        <th colspan='3' rowspan='2'>Pasien Baru</th>
                        <th colspan='3' rowspan='2'>Pasien Lama</th>
                        <th rowspan='3'>Jumlah Kunjungan</th>
                    </tr>" );
$uitable->addHeader ( "before", "<tr>
                        <th colspan='2'>0-28 HR</th>
                        <th colspan='2'>28-1TH</th>
                        <th colspan='2'>1-4TH</th>
                        <th colspan='2'>5-14TH</th>
                        <th colspan='2'>15-24TH</th>
                        <th colspan='2'>25-44TH</th>
                        <th colspan='2'>45-65TH</th>
                        <th colspan='2'>>65TH</th>
                        <th colspan='3'>Baru</th>
                        <th colspan='3'>Lama</th>
                        <th rowspan='2'>Jumlah</th>
                    </tr>" );
$uitable->addHeader ( "before", "<tr>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Jumlah</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Jumlah</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Jumlah</th>
                        <th>Lk</th>
                        <th>Pr</th>
                        <th>Jumlah</th>
                    </tr>" );

$uitable->setHeaderVisible ( false );
$uitable->setName ( "rl5_4" );
$uitable->setDiagram ( true );

if (isset ( $_POST ['command'] )) {
	$adapter=new SimpleAdapter(true, "No");
	$adapter->add("Diagnosa", "nama_icd");
	$adapter->add("Sebab Sakit", "sebab_sakit");
	$adapter->add("Kode", "kode_icd");
	$adapter->add("Ruangan", "ruangan", "unslug");
	$adapter->add("28hr Lk", "u28hr_lk");
	$adapter->add("28hr Pr", "u28hr_pr");
	$adapter->add("1th Lk", "u1th_lk");
	$adapter->add("1th Pr", "u1th_pr");
	$adapter->add("4th Lk", "u4th_lk");
	$adapter->add("4th Pr", "u4th_pr");
	$adapter->add("14th Lk", "u14th_lk");
	$adapter->add("14th Pr", "u14th_pr");
	$adapter->add("24th Lk", "u24th_lk");
	$adapter->add("24th Pr", "u24th_pr");
	$adapter->add("44th Lk", "u44th_lk");
	$adapter->add("44th Pr", "u44th_pr");
	$adapter->add("65th Lk", "u65th_lk");
	$adapter->add("65th Pr", "u65th_pr");
	$adapter->add("l65th Lk", "ul65th_lk");
	$adapter->add("l65th Pr", "ul65th_pr");
	$adapter->add("Kasus Baru Lk", "kasus_baru_lk");
	$adapter->add("Kasus Baru Pr", "kasus_baru_pr");
	$adapter->add("Kasus Baru Jmlh", "kasus_baru_jmlh");
	$adapter->add("Kasus Lama Lk", "kasus_lama_lk");
	$adapter->add("Kasus Lama Pr", "kasus_lama_pr");
	$adapter->add("Kasus Lama Jmlh", "kasus_lama_jmlh");
	$adapter->add("Kasus Jmlh", "kasus_jmlh");
	$adapter->add("Pasien Baru Lk", "pasien_baru_lk");
	$adapter->add("Pasien Baru Pr", "pasien_baru_pr");
	$adapter->add("Jumlah Pasien Baru", "pasien_baru_jmlh");
    $adapter->add("Pasien Lama Lk", "pasien_lama_lk");
	$adapter->add("Pasien Lama Pr", "pasien_lama_pr");
	$adapter->add("Jumlah Pasien Lama", "pasien_lama_jmlh");
	$adapter->add("Jumlah Kunjungan", "jmlh_total");
	$adapter->setRemoveZeroEnable(false);
    
	$dbtable = new DBTable ( $db, "smis_vmr_rl54");
    $dbtable->addCustomKriteria(" urji "," =0 ");
    
    if(isset($_POST['filter_origin']) && $_POST['filter_origin'] != "") {
        $dbtable->addCustomKriteria ( " origin ", " LIKE '".$_POST['filter_origin']."'" );
    }
    if(isset($_POST['filter_ruangan']) && $_POST['filter_ruangan'] != "") {
        $dbtable->addCustomKriteria ( " ruangan ", " LIKE '".$_POST['filter_ruangan']."'" );
    }
    
    $dbres = new RL54Responder ( $dbtable, $uitable, $adapter, 'tanggal', DBReport::$DATE );
	$dbres->setDiagram ( false, null, null, null );
	$data = $dbres->command ( $_POST ['command'] );
	echo json_encode ( $data, JSON_NUMERIC_CHECK );
	return;
}

$query="SELECT DISTINCT origin FROM smis_mr_diagnosa WHERE prop!='del' ";
$option=new OptionBuilder();
$option->add(" - Semua - ","%",1);
$res=$db->get_result($query);
foreach($res as $x){
    if($x->origin==""){
        continue;
    }
    $option->add(ArrayAdapter::slugFormat("unslug",$x->origin),$x->origin);
}
$uitable->addModal( "filter_origin", "select", "Asal", $option->getContent() );

$query = "SELECT DISTINCT ruangan FROM smis_vmr_rl54 WHERE urji = 0";
$option=new OptionBuilder();
$option->add(" - Semua - ","%",1);
$res=$db->get_result($query);
foreach($res as $x){
    if($x->ruangan==""){
        continue;
    }
    $option->add(ArrayAdapter::slugFormat("unslug",$x->ruangan),$x->ruangan);
}
$uitable->addModal( "filter_ruangan", "select", "Ruangan", $option->getContent() );

/* This is Modal Form and used for add and edit the table */
$modal = $uitable->getAdvanceModal ();
$modal->setTitle ( "Surveilance Terpadu" );
$btn=new Button("", "", "");
$btn->setIsButton(Button::$ICONIC);
$btn->setClass("btn btn-primary");
$btn->setIcon("fa fa-file-excel-o");
$btn->setAction("rl5_4.excel()");

//$form=$modal->joinFooterAndForm();
$modal->addElement("",$btn);

echo addJS ( "framework/smis/js/table_action.js" );
echo addJS ( "framework/smis/js/report_action.js" );
echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
echo addCSS ( "framework/bootstrap/css/datepicker.css" );

echo $modal->getModalSkeleton();
echo "<div class='line clear'></div>";
echo $uitable->getHtml();

?>

<script type="text/javascript">

var rl5_4;
$(document).ready(function(){
	$('[data-toggle="popover"]').popover({trigger: 'hover','placement': 'top'});
	$('.mydate').datepicker();
	var column=new Array();
	rl5_4=new ReportAction("rl5_4","medical_record","rl5_4",column);
    
    /*rl5_4.addViewData=function(data){
        data['ruangan'] = $("#rl5_4_ruangan").val();
        return data;
    };*/
    
    rl5_4.addRegulerData = function(data) {
        data['filter_origin'] = $("#rl5_4_filter_origin").val();
        data['filter_ruangan'] = $("#rl5_4_filter_ruangan").val();
        return data;
    };
});
</script>