<?php
global $db;
require_once 'smis-base/smis-include-service-consumer.php';
require_once 'smis-libs-class/MasterTemplate.php';
require_once 'smis-libs-class/MasterSlaveTemplate.php';
require_once 'smis-libs-class/ServiceProviderList.php';
require_once 'medical_record/class/adapter/LapGigiMulutAdapter.php';
require_once 'medical_record/class/responder/RL33Responder.php';

$periksa=new MasterSlaveTemplate($db, "smis_mr_gigimulut", "medical_record", "rl33");

$excel=new Button("", "", "");
$excel->setAction("rl33.excel()");
$excel->setClass("btn-primary");
$excel->setIsButton(Button::$ICONIC);
$excel->setIcon("fa fa-file-excel-o");

$periksa->setDateEnable(true);
$dbtable=$periksa->getDBtable();
$qv="SELECT 
		SUM(tumpatan_gigi_tetap) as tumpatan_gigi_tetap,
		SUM(tumpatan_gigi_sulung) as tumpatan_gigi_sulung,
		SUM(pengobatan_pulpa) as pengobatan_pulpa,
		SUM(pencabutan_gigi_tetap) as pencabutan_gigi_tetap,
		SUM(pencabutan_gigi_tetap) as pencabutan_gigi_tetap,
		SUM(pengobatan_periodontal) as pengobatan_periodontal,
		SUM(pengobatan_abses) as pengobatan_abses,
		SUM(pembersihan_karang_gigi) as pembersihan_karang_gigi,
		SUM(prothese_lengkap) as prothese_lengkap,
		SUM(prothese_sebagian) as prothese_sebagian,
		SUM(prothese_cekat) as prothese_cekat,
		SUM(orthodonti) as orthodonti,
		SUM(jacket_bridge) as jacket_bridge,
		SUM(bedah_mulut) as bedah_mulut	
		FROM smis_mr_gigimulut
		";
$qc="SELECT 1 as total FROM smis_mr_gigimulut ";
$dbtable->setPreferredQuery(true, $qv, $qc);

$header=array ("No.","Layanan",'Total');
$btn=$periksa->addFlag("dari", "Pilih Tanggal Mulainya", "Silakan Pilih Tanggal Mulainya Dahulu")
			  ->addFlag("sampai", "Pilih Tanggal Sampainya", "Silakan Pilih Tanggal Sampainya Dahulu")
			  ->addNoClear("dari")
			  ->addNoClear("sampai")
			  ->getUItable()
			  ->setHeader($header)
			  ->setAddButtonEnable(false)
			  ->getHeaderButton();
$periksa->getUItable()
		 ->setAction(false)
		 ->setFooterVisible(false)
		 ->addModal("dari", "date", "Dari", "")
		 ->addModal("sampai", "date", "Sampai", "");
$periksa->getForm(true,"")
		->addElement("", $btn)
        ->addElement("", $excel);
$gm=new LapGigiMulutAdapter();
$periksa->setAdapter($gm);
$periksa->addViewData("dari", "dari")
		->addViewData("sampai", "sampai");

$periksa->setDBresponder(new RL33Responder($dbtable, $periksa->getUItable(), $periksa->getAdapter()));

if($periksa->getDBResponder()->isView()){
	$dbtable->addCustomKriteria(NULL, "tanggal>='".$_POST['dari']."'");
	$dbtable->addCustomKriteria(NULL, "tanggal<'".$_POST['sampai']."'");
	$dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
}
$periksa->initialize();
?>