<?php 
require_once 'smis-libs-class/MasterSlaveTemplate.php';
require_once 'medical_record/class/responder/RL32Responder.php';
global $db;

$button=new Button("", "", "");
$button->setAction("rl32.view()");
$button->setClass("btn-primary");
$button->setIsButton(Button::$ICONIC);
$button->setIcon("fa fa-refresh");

$cetak=new Button("", "", "");
$cetak->setAction("rl32.print()");
$cetak->setClass("btn-primary");
$cetak->setIsButton(Button::$ICONIC);
$cetak->setIcon("fa fa-print");

$excel=new Button("", "", "");
$excel->setAction("rl32.excel()");
$excel->setClass("btn-primary");
$excel->setIsButton(Button::$ICONIC);
$excel->setIcon("fa fa-file-excel-o");

$rl32=new MasterSlaveTemplate($db, "smis_mr_igd", "medical_record", "rl32");
if(isset($_POST['dari']) && $_POST['dari']!="" && isset($_POST['sampai']) && $_POST['sampai']!=""){
	$qv="SELECT pola_kasus,
	sum(if(ds=1,1,0)) as non_rujukan,
	sum(if(ds=0,1,0)) as rujukan,
	sum(if(kelanjutan!='RJK',1,0)) as dirawat,
	sum(if(kelanjutan='RJK',1,0)) as dirujuk,
	sum(if(kelanjutan='RJ' AND triage NOT LIKE 'Hitam%',1,0)) as rawat_jalan,
	sum(if(triage='Hitam Mati',1,0)) as mati,
	sum(if(triage='Hitam DOA',1,0)) as doa
	FROM smis_mr_igd
	 ";
	$qc="SELECT pola_kasus FROM smis_mr_igd ";
	
	$rl32	->getDBtable()
			->setShowAll(true)
			->setPreferredQuery(true, $qv, $qc)
			->setGroupBy(true, " pola_kasus ")
			->addCustomKriteria(NULL, "tanggal>='".$_POST['dari']."'")
			->addCustomKriteria(NULL, "tanggal<'".$_POST['sampai']."'");
}

$uitable=$rl32->getUItable();
$header=array("No.","Jenis","Rujukan","Non-Rujukan","Tindak Lanjut Dirawat","Tindak Lanjut Dirujuk","Pulang Rawat Jalan","Meninggal di UGD","DOA");
$uitable->setHeader($header);

$adapter=new SimpleAdapter();
$adapter->setUseNumber(true, "No.","back.");
$adapter->add("Jenis", "pola_kasus")
		->add("Rujukan", "rujukan")
		->add("Non-Rujukan", "non_rujukan")
		->add("Tindak Lanjut Dirawat", "dirawat")
		->add("Tindak Lanjut Dirujuk", "dirujuk")
		->add("Pulang Rawat Jalan", "rawat_jalan")
		->add("Meninggal di UGD", "mati")
		->add("DOA", "doa");
$rl32->setAdapter($adapter);
$rl32->addFlag("dari", "Tanggal Awal", "Silakan Masukan Tanggal Mulai")
->addFlag("sampai", "Tanggal Akhir", "Silakan Masukan Tanggal Akhir")
->addNoClear("dari")
->addNoClear("sampai")
->setDateEnable(true)
->getUItable()
->setActionEnable(false)
->setFooterVisible(false)
->addModal("dari", "date", "Awal", "")
->addModal("sampai", "date", "Akhir", "");
$rl32->getForm()->addElement("", $button)->addElement("", $cetak)->addElement("", $excel);

$rl32->setDBresponder(new RL32Responder($rl32->getDBtable(), $rl32->getUItable(), $rl32->getAdapter()));

$rl32 ->addViewData("dari", "dari")
		->addViewData("sampai", "sampai");
$rl32->initialize();
?>