<?php
global $db;
require_once 'smis-base/smis-include-service-consumer.php';
require_once 'smis-libs-class/MasterTemplate.php';
require_once 'smis-libs-class/MasterServiceTemplate.php';
require_once 'smis-libs-class/MasterSlaveServiceTemplate.php';
require_once 'smis-libs-class/ServiceProviderList.php';
require_once 'medical_record/class/responder/RL314Responder.php';

$periksa=new MasterSlaveServiceTemplate($db, "rl314", "medical_record", "rl314");
$periksa->setDateEnable(true);
$header=array ("No.","Layanan",'Rujukan PKM',"Rujukan RS Lain",'Rujukan Faskes Lain',"Kembali PKM","Kembali RS Lain","Kembali Faskes Lain","Rujukan Dirujuk","DS Dirujuk","Kembali");
$btn=$periksa->addFlag("dari", "Pilih Tanggal Mulainya", "Silakan Pilih Tanggal Mulainya Dahulu")
			  ->addFlag("sampai", "Pilih Tanggal Sampainya", "Silakan Pilih Tanggal Sampainya Dahulu")
			  ->addNoClear("dari")
			  ->addNoClear("sampai")
			  ->getUItable()
			  ->setHeader($header)
			  ->setAddButtonEnable(false)
			  ->getHeaderButton();

$excel=new Button("", "", "");
$excel->setAction("rl314.excel()");
$excel->setClass("btn-primary");
$excel->setIsButton(Button::$ICONIC);
$excel->setIcon("fa fa-file-excel-o");

$periksa->getUItable()
		 ->setAction(false)
		 ->setFooterVisible(false)
		 ->addModal("dari", "date", "Dari", "")
		 ->addModal("sampai", "date", "Sampai", "");

$periksa->getForm(true,"")
		->addElement("", $btn)
        ->addElement("", $excel);

$summary=new SummaryAdapter();
$summary->addSummary("Rujukan PKM", "dari_pkm")
		->addSummary("Rujukan RS Lain", "dari_rsl")
		->addSummary("Rujukan Faskes Lain", "dari_bpl")
		->addSummary("Kembali PKM", "kembali_pkm")
		->addSummary("Kembali RS Lain", "kembali_rsl")
		->addSummary("Kembali Faskes Lain", "kembali_bpl")
		->addSummary("Rujukan Dirujuk", "rujukan_dirujuk")
		->addSummary("DS Dirujuk", "ds_dirujuk")
		->addSummary("Kembali", "kembali")
		->addFixValue("Layanan","<strong>Total</strong>");

$periksa->setAdapter($summary)
		->getAdapter()
		->setUseNumber(true, "No.","back.")
		->add("Layanan", "jenislayanan","unslug")
		->add("Rujukan PKM", "dari_pkm")
		->add("Rujukan RS Lain", "dari_rsl")
		->add("Rujukan Faskes Lain", "dari_bpl")
		->add("Kembali PKM", "kembali_pkm")
		->add("Kembali RS Lain", "kembali_rsl")
		->add("Kembali Faskes Lain", "kembali_bpl")
		->add("Rujukan Dirujuk", "rujukan_dirujuk")
		->add("DS Dirujuk", "ds_dirujuk")
		->add("Kembali", "kembali");

$periksa->setDBresponder(new RL314Responder($db, $periksa->getUItable(), $periksa->getAdapter(), "rl314"));

$periksa->addViewData("dari", "dari")
		->addViewData("sampai", "sampai");

$periksa->initialize();
?>