<?php
show_error();
global $db;
require_once 'smis-base/smis-include-service-consumer.php';
require_once 'smis-libs-class/MasterTemplate.php';
require_once 'smis-libs-class/MasterSlaveTemplate.php';
require_once 'smis-libs-class/ServiceProviderList.php';
require_once 'medical_record/class/adapter/LapRL311Adapter.php';
require_once 'medical_record/class/responder/RL311Responder.php';

$periksa=new MasterSlaveTemplate($db, "smis_mr_pkhusus", "medical_record", "rl311");
$periksa->setDateEnable(true);
$dbtable=$periksa->getDBtable();
$qv="SELECT 
		SUM(psikotes) as psikotes,
		SUM(konsultasi) as konsultasi,
		SUM(medikamentosa) as medikamentosa,
		SUM(elektro_medik) as elektro_medik,
		SUM(psikoterapi) as psikoterapi,
		SUM(play_therapy) as play_therapy,
		SUM(rehab_medik_psikiatrik) as rehab_medik_psikiatrik
		FROM smis_mr_jiwa
		";
$qc="SELECT 1 as total FROM smis_mr_jiwa";
$dbtable->setPreferredQuery(true, $qv, $qc);


$header=array ("No.","Layanan",'Total');
$btn=$periksa->addFlag("dari", "Pilih Tanggal Mulainya", "Silakan Pilih Tanggal Mulainya Dahulu")
			  ->addFlag("sampai", "Pilih Tanggal Sampainya", "Silakan Pilih Tanggal Sampainya Dahulu")
			  ->addNoClear("dari")
			  ->addNoClear("sampai")
			  ->getUItable()
			  ->setHeader($header)
			  ->setAddButtonEnable(false)
			  ->getHeaderButton();

$excel=new Button("", "", "");
$excel->setAction("rl311.excel()");
$excel->setClass("btn-primary");
$excel->setIsButton(Button::$ICONIC);
$excel->setIcon("fa fa-file-excel-o");

$periksa->getUItable()
		 ->setAction(false)
		 ->setFooterVisible(false)
		 ->addModal("dari", "date", "Dari", "")
		 ->addModal("sampai", "date", "Sampai", "");
$periksa->getForm(true,"")
		->addElement("", $btn)
        ->addElement("", $excel);
        
$gm=new LapRL311Adapter();
$periksa->setAdapter($gm);
$periksa->addViewData("dari", "dari")
		->addViewData("sampai", "sampai");
        
$periksa->setDBresponder(new RL311Responder($dbtable, $periksa->getUItable(), $periksa->getAdapter()));

if($periksa->getDBResponder()->isView()){
	$dbtable->addCustomKriteria(NULL, "tanggal>='".$_POST['dari']."'");
	$dbtable->addCustomKriteria(NULL, "tanggal<'".$_POST['sampai']."'");
	$dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
}
$periksa->initialize();
?>