<?php
global $db;
require_once 'smis-base/smis-include-service-consumer.php';
require_once 'smis-libs-class/MasterTemplate.php';
require_once 'smis-libs-class/MasterSlaveTemplate.php';
require_once 'smis-libs-class/ServiceProviderList.php';
require_once 'medical_record/class/adapter/LapPKhususAdapter.php';
require_once 'medical_record/class/responder/RL310Responder.php';

$periksa=new MasterSlaveTemplate($db, "smis_mr_pkhusus", "medical_record", "rl310");
$periksa->setDateEnable(true);
$dbtable=$periksa->getDBtable();
$qv="SELECT 
		SUM(eeg) as eeg,
		SUM(ekg) as ekg,
		SUM(emg) as emg,
		SUM(ecg) as ecg,
		SUM(endoskopi) as endoskopi,
		SUM(hemodialisa) as hemodialisa,
		SUM(densometri_tulang) as densometri_tulang,
		SUM(koreksi_fraktur) as koreksi_fraktur,
		SUM(pungsi) as pungsi,
		SUM(spirometri) as spirometri,
		SUM(tes_kulit) as tes_kulit,
		SUM(topometri) as topometri,
		SUM(tredmil) as tredmil,
		SUM(akupuntur) as akupuntur,
		SUM(hiperbarik) as hiperbarik,
		SUM(herbal) as herbal,
		SUM(lain) as lain	
		FROM smis_mr_pkhusus
		";
$qc="SELECT 1 as total FROM smis_mr_pkhusus";
$dbtable->setPreferredQuery(true, $qv, $qc);


$header=array ("No.","Layanan",'Total');
$btn=$periksa->addFlag("dari", "Pilih Tanggal Mulainya", "Silakan Pilih Tanggal Mulainya Dahulu")
			  ->addFlag("sampai", "Pilih Tanggal Sampainya", "Silakan Pilih Tanggal Sampainya Dahulu")
			  ->addNoClear("dari")
			  ->addNoClear("sampai")
			  ->getUItable()
			  ->setHeader($header)
			  ->setAddButtonEnable(false)
			  ->getHeaderButton();
              
$excel=new Button("", "", "");
$excel->setAction("rl310.excel()");
$excel->setClass("btn-primary");
$excel->setIsButton(Button::$ICONIC);
$excel->setIcon("fa fa-file-excel-o");

$periksa->getUItable()
		 ->setAction(false)
		 ->setFooterVisible(false)
		 ->addModal("dari", "date", "Dari", "")
		 ->addModal("sampai", "date", "Sampai", "");
$periksa->getForm(true,"")
		->addElement("", $btn)
        ->addElement("", $excel);
        
$gm=new LapPKhususAdapter();
$periksa->setAdapter($gm);
$periksa->addViewData("dari", "dari")
		->addViewData("sampai", "sampai");
        
$periksa->setDBresponder(new RL310Responder($dbtable, $periksa->getUItable(), $periksa->getAdapter()));

if($periksa->getDBResponder()->isView()){
	$dbtable->addCustomKriteria(NULL, "tanggal>='".$_POST['dari']."'");
	$dbtable->addCustomKriteria(NULL, "tanggal<'".$_POST['sampai']."'");
	$dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
}
$periksa->initialize();
?>