<?php
global $db;
require_once 'smis-base/smis-include-service-consumer.php';
require_once 'smis-libs-class/MasterTemplate.php';
require_once 'smis-libs-class/MasterServiceTemplate.php';
require_once 'smis-libs-class/MasterSlaveServiceTemplate.php';
require_once 'smis-libs-class/ServiceProviderList.php';
require_once 'medical_record/class/responder/RL2Responder.php';

$periksa=new MasterSlaveServiceTemplate($db, "get_rl2", "medical_record", "rl2");
$header=array ("No.","PENDIDIKAN",'PRIA',"WANITA",'TOTAL');
$btn=$periksa->getUItable()
		 ->setHeader($header)
		 ->setFooterVisible(false)
		 ->setAddButtonEnable(false)
		 ->setAction(false)
		 ->getHeaderButton();
         
$excel=new Button("", "", "");
$excel->addClass("btn-primary")
		->setIsButton(Button::$ICONIC)
		->setIcon("fa fa-file-excel-o")
		->setAction("rl2.excel()");
        
$periksa->getForm(true,"")
		 ->addElement("", $btn)
         ->addElement("", $excel);
         
$summary=new SummaryAdapter();
$summary->addSummary("PRIA", "lk");
$summary->addSummary("WANITA", "pr");
$summary->addSummary("TOTAL", "total");
$summary->addFixValue("PENDIDIKAN","<strong>Total</strong>");

$periksa->setAdapter($summary)
		 ->getAdapter()
		 ->setUseNumber(true, "No.","back.")
		 ->add("PRIA", "lk")
		 ->add("WANITA", "pr")
		 ->add("PENDIDIKAN", "pendidikan")
		 ->add("TOTAL", "total");

$periksa->setDBresponder(new RL2Responder($db, $periksa->getUItable(), $periksa->getAdapter(), "get_rl2"));

$periksa->initialize();
?>