<?php
global $db;
show_error();
require_once 'smis-base/smis-include-service-consumer.php';
require_once 'medical_record/class/responder/RL12Responder.php';

/**
 * mencari semua entitas yang menmiliki data tagihan
 * - pertama hapus dahulu semua get_gizi tertentu
 * - kemudian cari semua entitas yang memiliki service tagian
 * - kembalikan ke javascript dan akan dilakukan penelusuran dengan javascript
 */
if( isset ( $_POST ['super_command'] ) &&  $_POST ['super_command']=="collect_ruang" ){
	require_once "smis-libs-class/ServiceProviderList.php";
	$dbtable=new DBTable($db, "smis_mr_rl12");
	$dbtable->truncate();
	$list_iklin=new ServiceProviderList($db, "get_indikator_pelayanan");
	$list_iklin->execute();
	$content=$list_iklin->getContent();
	$pack=new ResponsePackage();
	$pack->setContent($content);
	$pack->setStatus(ResponsePackage::$STATUS_OK);
	echo json_encode($pack->getPackage());
	return;
}

if (isset ( $_POST ['super_command'] ) && $_POST ['super_command'] == "sync") {
	require_once 'medical_record/class/adapter/SyncRL12Adapter.php';
	$service = new ServiceConsumer ( $db, "get_indikator_pelayanan",NULL,$_POST['ruang'] );
	$service->addData("dari", $_POST['dari']);
	$service->addData("sampai", $_POST['sampai']);
	$service->addData("origin", $_POST['origin']);
	$service->execute ();
	$content = $service->getContent ();
	if(!$content==NULL){
		$adapter = new SyncRL12Adapter ();
		$table_sync = $adapter->adapt($content);
		$rl12table = new DBTable ( $db, "smis_mr_rl12" );
		$rl12table->insert($table_sync);
	}
	$response = new ResponsePackage ();
	$response->setAlertVisible ( false );
	$response->setStatus ( ResponsePackage::$STATUS_OK );
	$response->setContent($content);
	echo json_encode ( $response->getPackage () );
	return;
}

$head=array ("No.",'Ruangan','BOR','ALOS',"BTO","TOI","NDR","GDR","Rata/Hari","Rata/Bulan");
$uitable = new Table ( $head, "", NULL, true );
$uitable->setName ( "rl12" );
$uitable->setFooterVisible(false);
$uitable->setAction(false);
if (isset ( $_POST ['command'] )) {
    require_once 'medical_record/class/adapter/RL12Adapter.php';
    $adapter = new RL12Adapter ();
    if($_POST['bor'] != "") {
        $adapter->setBor($_POST['bor']);
    }
    if($_POST['alos'] != "") {
        $adapter->setAlos($_POST['alos']);
    }
    if($_POST['toi'] != "") {
        $adapter->setToi($_POST['toi']);
    }
    if($_POST['bto'] != "") {
        $adapter->setBto($_POST['bto']);
    }
    if($_POST['ndr'] != "") {
        $adapter->setNdr($_POST['ndr']);
    }
    if($_POST['gdr'] != "") {
        $adapter->setGdr($_POST['gdr']);
    }
    $dbtable = new DBTable ( $db, "smis_mr_rl12f" );
    $dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
    
    if ($_POST['ruangan'] != ""){
        $dbtable->addCustomKriteria(NULL,"ruangan ='".$_POST['ruangan']."'");
    }
    
	$dbtable->setShowAll(true);
	//$dbres = new DBResponder ( $dbtable, $uitable, $adapter );
	$dbres = new RL12Responder ( $dbtable, $uitable, $adapter );
	$data = $dbres->command ( $_POST ['command'] );
    if($data!=null)
        echo json_encode ( $data );
	return;
}

$query="SELECT DISTINCT origin FROM smis_mr_diagnosa WHERE prop!='del' ";
$option=new OptionBuilder();
$option->add(" - Semua - ","",1);

$res=$db->get_result($query);
foreach($res as $x){
    if($x->origin==""){
        continue;
    }
    $option->add(ArrayAdapter::slugFormat("unslug",$x->origin),$x->origin);
}
 
$uitable->addModal ( "dari", "date", "Dari", "" );
$uitable->addModal ( "sampai", "date", "Sampai", "" );
$uitable->addModal( "origin", "select", "Asal", $option->getContent() );


//Untuk filter dropdown list Ruangan
$list_ruang = new ServiceConsumer ( $db, "get_ruangan_rl12");
$list_ruang->execute ();
$list_ruang->setMode(ServiceConsumer::$MULTIPLE_MODE);
$content = $list_ruang->getContent ();
$ruangan = array();
foreach($content as $cont) {
     foreach($cont as $k => $v){
          if($v == 1){
               $opt['value'] = $k;
               $opt['name'] = ArrayAdapter::format("unslug", $k);
               $ruangan[] = $opt;
          }
          
     }
}
$opt['value']="";
$opt['name']=" - SEMUA - ";
$ruangan[]=$opt;
$uitable->addModal( "ruangan", "select", "Ruangan", $ruangan );

if(getSettings($db,"smis-mr-lap-rl-tampil-filter-bor","0")=="1") {
    //Persentase
    $persen = array();
    for($i = 100; $i > 0; $i = $i - 10) {
        $p = array();
        $p['value'] = $i;
        $p['name'] = $i.'%';
        $persen[] = $p;
    }
    $uitable->addModal( "bor", "select", "BOR", $persen );
}

//Hari
$hari = array();
for($i = 31; $i >= 1; $i--) {
    $p = array();
    $p['value'] = $i;
    $p['name'] = $i;
    $hari[] = $p;
}
if(getSettings($db,"smis-mr-lap-rl-tampil-filter-alos","0")=="1"){
    $uitable->addModal( "alos", "select", "ALOS", $hari );
}

if(getSettings($db,"smis-mr-lap-rl-tampil-filter-toi","0")=="1"){
    $uitable->addModal( "toi", "select", "TOI", $hari );
}


//Permil
$permil = array();
for($i = 1000; $i >= 100; $i = $i - 100) {
    $p = array();
    $p['value'] = $i;
    $p['name'] = $i.' permil';
    $permil[] = $p;
}
if(getSettings($db,"smis-mr-lap-rl-tampil-filter-bto","0")=="1"){
    $uitable->addModal( "bto", "select", "BTO", $permil );
}

if(getSettings($db,"smis-mr-lap-rl-tampil-filter-ndr","0")=="1"){
    $uitable->addModal( "ndr", "select", "NDR", $permil );
}

if(getSettings($db,"smis-mr-lap-rl-tampil-filter-gdr","0")=="1"){
    $uitable->addModal( "gdr", "select", "GDR", $permil );
}


$modal = $uitable->getModal ();
$form=$modal->getForm();
$view=new Button("", "", "");
$view->addClass("btn-primary")
		->setIsButton(Button::$ICONIC)
		->setIcon("fa fa-search")
		->setAction("rl12.collect_ruang()");
$form->addElement("", $view);

$v = new Button("", "", "");
$v->addClass("btn-primary")
		->setIsButton(Button::$ICONIC)
		->setIcon("fa fa-refresh")
		->setAction("rl12.view()");
$form->addElement("", $v);

$excel=new Button("", "", "");
$excel->addClass("btn-primary")
		->setIsButton(Button::$ICONIC)
		->setIcon("fa fa-file-excel-o")
		->setAction("rl12.excel()");
$form->addElement("", $excel);

$load=new LoadingBar("rekap_mr_bar", "");
$modal=new Modal("rekap_mr_modal", "", "Processing...");
$modal	->addHTML($load->getHtml(),"after");

echo $form->getHtml();
echo $uitable->getHtml ();
echo $modal->getHtml ();
echo addJS ( "framework/smis/js/table_action.js" );
echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
echo addCSS ( "framework/bootstrap/css/datepicker.css" );
echo addJS ( "base-js/smis-base-loading.js");

echo addCSS("framework/bootstrap/css/morris.css");
echo addJS("framework/jquery/raphael-min.js");
echo addJS("framework/bootstrap/js/morris.min.js");
echo "<div  id='rl12_diagram' style='height:100%'></div>";
?>
<script type="text/javascript">

var rl12;
//var employee;
$(document).ready(function(){
	$(".mydate").datepicker();
	$('[data-toggle="popover"]').popover({trigger: 'hover','placement': 'top'});
	var column=new Array('id','nama','keterangan','slug');
	rl12=new TableAction("rl12","medical_record","rl12",column);
    
    rl12.addViewData=function(data){
        data['ruangan'] = $("#rl12_ruangan").val();
        data['bor']     = $("#rl12_bor").val();
		data['alos']    = $("#rl12_alos").val();
		data['toi']     = $("#rl12_toi").val();
		data['bto']     = $("#rl12_bto").val();
		data['ndr']     = $("#rl12_ndr").val();
		data['gdr']     = $("#rl12_gdr").val();
        return data;
    }
    
	rl12.sync=function(set,curpoint){
		var total=set.length;
		var data=this.getRegulerData();
		var current=set[curpoint];		
		data['ruang']=current.value;
		data['dari']=$("#rl12_dari").val();
		data['sampai']=$("#rl12_sampai").val();
		data['origin']=$("#rl12_origin").val();
		data['ruangan']=$("#rl12_ruangan").val();
		data['bor']=$("#rl12_bor").val();
		data['alos']=$("#rl12_alos").val();
		data['toi']=$("#rl12_toi").val();
		data['bto']=$("#rl12_bto").val();
		data['ndr']=$("#rl12_ndr").val();
		data['gdr']=$("#rl12_gdr").val();
		data['super_command']="sync";		
		$.post('',data,function(res){
			
			$("#rekap_mr_bar").sload("true","[ "+curpoint+" / "+total+" ] "+current.name+"...",(curpoint*100/total));
			var json=getContent(res);
			$("#layanan_table_list").append(json.row);
			
			if(curpoint+1>=total){
				$("#rekap_mr_modal").modal("hide");
				rl12.view();
				return;
			} else {
				curpoint++;
				setTimeout(function(){
					rl12.sync(set,curpoint);
				},500);
			}
			
		});
	};

	rl12.collect_ruang=function(){
		var data=this.getRegulerData();
		data['super_command']="collect_ruang";
		showLoading();
		$.post('',data,function(res){
			dismissLoading();
			var json=getContent(res);
			if(json==null){
				return;
			}else{
				$("#rekap_mr_bar").sload("true","Loading Data",0);
				$("#rekap_mr_modal").modal("show");
				$("#rl12_list").html("");
				rl12.sync(json,0);
			}
			
		});
	}
    
    $('#rl12_ruangan').on('change', function() {
        rl12.view();
    });
    
    $('#rl12_bor').on('change', function() {
        rl12.view();
    });
    
    $('#rl12_alos').on('change', function() {
        rl12.view();
    });
    
    $('#rl12_toi').on('change', function() {
        rl12.view();
    });
    
    $('#rl12_bto').on('change', function() {
        rl12.view();
    });
    
    $('#rl12_ndr').on('change', function() {
        rl12.view();
    });
    
    $('#rl12_gdr').on('change', function() {
        rl12.view();
    });
	/*
	Morris.Line({
		  element: $("#rl12_diagram"),
		  data: [
		         { y: '2006', a: 100, b: 90 },
		         { y: '2007', a: 75,  b: 65 },
		         { y: '2008', a: 50,  b: 40 },
		         { y: '2009', a: 75,  b: 65 },
		         { y: '2010', a: 50,  b: 40 },
		         { y: '2011', a: 75,  b: 65 },
		         { y: '2012', a: 100, b: 90 }
		       ],
		       xkey: 'y',
		       ykeys: ['a', 'b'],
		       labels: ['Series A', 'Series B']
	});
*/
	

});
</script>
