<?php

global $db;
require_once 'smis-base/smis-include-service-consumer.php';

$header = array ();
$header [] = "no";
$header [] = "tanggal";
$header [] = "no_kartu_peserta";
$header [] = "nama_peserta";
$header [] = "diagnosa";
$header [] = "dirujuk";
$header [] = "spesialistik";
$header [] = "non_spesialistik";
$header [] = "alasan";

$uitable = new Table ( $header, "", NULL, false );
$uitable->setName ( "lap_rujukan" );
$uitable->addHeader ( "before", "<tr>
								<th rowspan='2'>NO</th>
								<th rowspan='2'>TANGGAL</th>
								<th rowspan='2'>NO. KARTU PESERTA</th>
								<th rowspan='2'>NAMA PESERTA</th>
								<th rowspan='2'>DIAGNOSA</th>
								<th rowspan='2'>DI RUJUK</th>
								<th colspan='3'>KETERANGAN</th>
                                </tr>" );
$uitable->addHeader ( "before", "<tr>
								<th>RUJUKAN SPESIALISTIK</th>
								<th>RUJUKAN NON SPESIALISTIK</th>
								<th>ALASAN RUJUKAN NON SPESIALISTIK</th>
                                </tr>" );
$uitable->setHeaderVisible ( false );
$uitable->setFooterVisible ( false );

if(isset($_POST['command'])) {
    require_once 'medical_record/class/adapter/LapRujukanAdapter.php';
    $adapter = new LapRujukanAdapter();
	$dbtable = new DBTable ( $db, "smis_mr_rujukan" );
    
    if(isset ( $_POST ['dari'] ) && $_POST ['dari'] != "") {
        $dbtable->addCustomKriteria ( " tanggal ", ">='".$_POST['dari']."'" );
    }
    if(isset ( $_POST ['sampai'] ) && $_POST ['sampai'] != "") {
        $dbtable->addCustomKriteria ( " tanggal ", "<='".$_POST['sampai']."'" );
    }
    if(isset ( $_POST ['origin'] ) && $_POST ['origin'] != "") {
        $dbtable->addCustomKriteria ( " origin ", "='".$_POST['origin']."'" );
    }
    if(isset ( $_POST ['ruangan'] ) && $_POST ['ruangan'] != "") {
        $dbtable->addCustomKriteria ( " ruangan ", "='".$_POST['ruangan']."'" );
    }
    $dbtable->setShowAll ( true );
    
    $dbtable->setOrder ( " tanggal ASC " );
	$dbres = new DBResponder ( $dbtable, $uitable, $adapter );
	$data = $dbres->command ( $_POST ['command'] );
	echo json_encode ( $data );
	return;
}

$query="SELECT DISTINCT origin FROM smis_mr_rujukan WHERE prop!='del' ";
$origin=new OptionBuilder();
$origin->add(" - Semua - ","",1);
$res=$db->get_result($query);
foreach($res as $x){
    if($x->origin==""){
        continue;
    }
    $origin->add(ArrayAdapter::slugFormat("unslug",$x->origin),$x->origin);
}
loadClass ( "ServiceProviderList" );
$service = new ServiceProviderList ( $db, "push_antrian" );
$service->execute ();
$ruangan = $service->getContent ();
$ruang = array();
$option['value'] = '';
     $option['name'] = '- SEMUA -';
     $option['default'] = '1';
     $ruang[] = $option;
foreach($ruangan as $r) {
	 $option = array();
     $option['value'] = $r['value'];
     $option['name'] = $r['name'];
     $option['default'] = '0';
     $ruang[] = $option;
}

$uitable->addModal ( "dari", "date", "Dari", "" );
$uitable->addModal ( "sampai", "date", "Sampai", "" );
$uitable->addModal ( "origin", "select", "Asal Data",$origin->getContent() );
$uitable->addModal ( "ruangan", "select", "Ruangan",$ruang );

$modal = $uitable->getModal ();
$form = $modal->getForm ();

$button = new Button ( "", "", "" );
$button->setIsButton ( Button::$ICONIC );
$button->setIcon ( "fa fa-refresh" );
$button->setClass("btn-primary");
$button->setAction ( "lap_rujukan.view()" );
$form->addElement ( "", $button );
echo $form->getHtml ();

echo $uitable->getHtml ();

echo addJS ("framework/bootstrap/js/bootstrap-datepicker.js");
echo addJS ("framework/smis/js/table_action.js");
echo addCSS ("framework/bootstrap/css/datepicker.css");
echo addJS ( "medical_record/resource/js/lap_rujukan.js", false );

?>