<?php

/**
 * menampilkan data 
 * pasien diagnosa pasien
 * dan dihitung persentasenya 
 * 
 * @author 		: Nurul Huda
 * @copyright 	: goblooge@gmail.com
 * @license 	: LGPLv2
 * @database 	: - smis_mr_diagnosa
 * @since		: 06 Juli 2017
 * @version		: 1.0.0
 * 
 * */

global $db;
require_once 'smis-libs-class/MasterSlaveTemplate.php';
require_once 'medical_record/class/adapter/LaporanPersentaseDiagnosaAdapter.php';
require_once 'medical_record/class/responder/LapPersenDiagnosaResponder.php';

$header=array ('No.',"Diagnosa","Nama","ICD","Jumlah","Persentase");
$pemreg=new MasterSlaveTemplate($db, "smis_mr_diagnosa", "medical_record", "lap_persen_diagnosa");
$pemreg->setDateEnable(true);


$uitable=$pemreg->getUItable();
$uitable=new Table($header);
$uitable->setHeader($header);
$uitable->setAction(false);
$uitable->setFooterVisible(false);

$uitable->setName("lap_persen_diagnosa");
$pemreg->getDBtable()->setOrder(" tanggal DESC ");
$pemreg->setUITable($uitable);
if( ($pemreg->getDBResponder()->isView() || $pemreg->getDBResponder()->isExcel()) && $_POST['super_command']==""){
    
    $view="SELECT count(*) as total, nama_icd,kode_icd,sebab_sakit FROM smis_mr_diagnosa ";
    $pemreg	->getDBtable()
            ->setPreferredQuery(true,$view,"")
            ->setCountEnable(false)
            ->setGroupBy(true," nama_icd,kode_icd,sebab_sakit ")
            ->setShowAll(true)
            ->setUseWhereForView(true)
			->addCustomKriteria(NULL, "tanggal>='".$_POST['dari']."'")
            ->addCustomKriteria(NULL, "tanggal<'".$_POST['sampai']."'");
}

$pemreg  ->addFlag("dari", "Pilih Tanggal Dari", "Masukan Tanggal Awal Dahulu")
		 ->addFlag("sampai", "Pilih Tanggal Sampai", "Masukan Tanggal Akhir Dahulu")
		 ->addNoClear("dari")
		 ->addNoClear("sampai")
		 ->setDateTimeEnable(true)
		 ->getUItable()
		 ->addModal("dari", "date", "Dari", "")
		 ->addModal("sampai", "date", "Sampai", "");         
$form=$pemreg ->getForm();



$button = new Button ( "", "", "" );
$button->setIsButton ( Button::$ICONIC );
$button->setIcon ( "icon-white " . BUtton::$icon_refresh );
$button->setAction ( "lap_persen_diagnosa.view()" );
$button->setClass("btn-primary");
$form->addElement ( "", $button );

$excel = new Button ( "", "", "" );
$excel->setIsButton ( Button::$ICONIC );
$excel->setIcon ( "fa fa-file-excel-o");
$excel->setAction ( "lap_persen_diagnosa.excel()" );
$excel->setClass("btn-primary");
$form->addElement ( "", $excel );

$button = new Button ( "", "", "" );
$button->setIsButton ( Button::$ICONIC );
$button->setIcon ( "icon-white " . BUtton::$icon_print );
$button->setAction ( "smis_print($('#print_table_lap_persen_diagnosa').html())" );
$button->setClass("btn-primary");
$form->addElement ( "", $button );

$adapter=new LaporanPersentaseDiagnosaAdapter();
$pemreg->setAdapter($adapter);
$pemreg ->addRegulerData("dari","dari","id-value")
        ->addRegulerData("sampai","sampai","id-value");
        
$responder=new LapPersenDiagnosaResponder($pemreg->getDBtable(),$pemreg->getUItable(),$pemreg->getAdapter());
$pemreg->setDBresponder($responder);
$pemreg->initialize();
?>

