<?php 
global $db;
global $user;
require_once 'smis-base/smis-include-service-consumer.php';
require_once 'smis-libs-hrd/EmployeeResponder.php';

$dkadapter = new SimpleAdapter ();
$dkadapter->add ( "Jabatan", "nama_jabatan" );
$dkadapter->add ( "Nama", "nama" );
$dkadapter->add ( "NIP", "nip" );
$header=array ('Nama','Jabatan',"NIP" );
$dktable = new Table ( $header);
$dktable->setName ( "dokter_lap_index_dokter" );
$dktable->setModel ( Table::$SELECT );
$dokter = new EmployeeResponder ( $db, $dktable, $dkadapter, "dokter" );
$super = new SuperCommand ();
$super->addResponder ( "dokter_lap_index_dokter", $dokter );
$init = $super->initialize ();
if ($init != null) {
	echo $init;
	return;
}


if(isset($_POST['super_command']) && $_POST['super_command']=="total") {
	require_once 'smis-libs-class/ServiceProviderList.php';
	$dbtable=new DBTable($db, "smis_mr_index_dokter");
	$dbtable->truncate();
	$serv=new ServiceConsumer($db, "get_patient_rawat_inap");
	$serv->addData("command", "count");
	$serv->addData("dari", $_POST['dari']);
	$serv->addData("sampai", $_POST['sampai']);	
	$serv->execute();
	$data=$serv->getContent();
	$res=new ResponsePackage();
	$res->setStatus(ResponsePackage::$STATUS_OK);
	$res->setContent($data);
	echo json_encode($res->getPackage());
	return;
}


if(isset($_POST['super_command']) && $_POST['super_command']=="limit") {
	$data=array();
	$response=new ServiceConsumer($db, "get_patient_rawat_inap");
	$response->addData("command", "list");
	$response->addData("dari", $_POST['dari']);
	$response->addData("sampai", $_POST['sampai']);
	$response->addData("halaman", $_POST['halaman']);	
	$response->setMode(ServiceConsumer::$SINGLE_MODE);
	$response->execute();
	$list=$response->getContent();
	$dbtable=new DBTable($db, "smis_mr_index_dokter");
	
	
	foreach($list as $x){		
		$d['nrm_pasien']=$x['nrm'];
		$d['nama_pasien']=$x['nama_pasien'];
		$d['noreg_pasien']=$x['id'];
		$d['tgl_kunjungan']=$x['tanggal'];
		$d['tgl_lahir']=$x['tgl_lahir'];
		$d['nama_dokter']=$x['nama_dokter'];
		$d['id_dokter']=$x['id_dokter'];
		$d['jk']=$x['kelamin'];
		$d['kelas']=$x['kamar_inap'];
		
		$query="SELECT * FROM smis_mr_diagnosa WHERE noreg_pasien='".$x['id']."' AND diagnosa!='' AND prop!='del' ORDER BY id DESC;";
		$diag=$db->get_row($query);
		if($diag!=NULL){
			$d['diagnosa_utama']=$diag->diagnosa;
			$d['kode_icd']=$diag->kode_icd;
		}
		
		$dbtable->insert($d);		
	}
	$res=new ResponsePackage();
	$res->setStatus(ResponsePackage::$STATUS_OK);
	$res->setContent($list);
	echo json_encode($res->getPackage());
	return;
}

$header=array(	"No.","Noreg","NRM","Nama","Tgl Lahir",
				"Tgl Kunjungan","Ruang Kelas",
				"Jenis Kelamin","Diagnosa","Dokter");
$uitable=new Table($header);
$uitable->setName("lap_index_dokter")
		->setActionEnable(false)
		->setFooterVisible(false);

if(isset($_POST['command']) && $_POST['command']=="excel"){
	require_once "medical_record/snippet/create_excel_lap_index_dokter.php";
	return;
		
}

if(isset($_POST['command']) && $_POST['command']!=""){
	$dbtable=new DBTable($db, "smis_mr_index_dokter");
	$dbtable->setOrder(" tgl_kunjungan ASC");	
	$dbtable->addCustomKriteria(" nama_dokter "," like '".$_POST['nama_dokter']."%' ");
	$adapter=new SimpleAdapter();
	$adapter->setUseNumber(true, "No.","back.");
	$adapter->add("Noreg", "noreg_pasien","only-digit8");
	$adapter->add("NRM", "nrm_pasien","only-digit8");
	$adapter->add("Nama", "nama_pasien");
	$adapter->add("Ruang Kelas", "kelas","unslug");
	$adapter->add("Tgl Kunjungan", "tgl_kunjungan","date d-M-Y");
	$adapter->add("Tgl Lahir", "tgl_lahir","date d-M-Y");
	$adapter->add("Diagnosa", "diagnosa_utama");
	$adapter->add("Dokter", "nama_dokter");
	$adapter->add("Jenis Kelamin", "jk","trivial_0_Laki-Laki_Perempuan");
	$dbres=new DBResponder($dbtable, $uitable, $adapter);
	$hasil=$dbres->command($_POST['command']);
	echo json_encode($hasil);
	return;
}

$uitable->clearContent();
$uitable->addModal("dari", "date", "Dari", "")
		->addModal("sampai", "date", "Sampai", "")
		->addModal("nama_dokter", "chooser-lap_index_dokter-dokter_lap_index_dokter-Dokter", "Dokter", "");
$action=new Button("","","View");
$action->setClass("btn-primary")
	   ->setIsButton(Button::$ICONIC)
	   ->setIcon("icon-white fa fa-circle-o-notch")
	   ->setAction("lap_index_dokter.rekaptotal()");
$view=new Button("","","View");
$view->setClass("btn-primary")
		->setIsButton(Button::$ICONIC)
		->setIcon("fa fa-refresh")
		->setAction("lap_index_dokter.multiview()");
$excel=new Button("","","Excel");
$excel->setClass("btn-primary")
	->setIsButton(Button::$ICONIC)
	->setIcon("fa fa-file-excel-o")
	->setAction("lap_index_dokter.excel()");

$btng=new ButtonGroup("");
$btng->addButton($action);
$btng->addButton($view);
$btng->addButton($excel);

$form=$uitable
	  ->getModal()
	  ->setTitle("Medical Record")
	  ->getForm()
	  ->addElement("",$btng);

$close=new Button("", "", "Batal");
$close	->addClass("btn-primary")
		->setIsButton(Button::$ICONIC_TEXT)
		->setIcon("fa fa-close")
		->setAction("lap_index_dokter.batal()");

$load=new LoadingBar("rekap_lap_index_dokter_bar", "");
$modal=new Modal("rekap_lap_index_dokter_modal", "", "Processing...");
$modal	->addHTML($load->getHtml(),"after")
		->addFooter($close);

echo $form->getHtml();
echo "<div class='clear'></div>";
echo "<div id='result_lap_index_dokter'>".$uitable->getHtml()."</div>";
echo $modal->getHtml();
echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
echo addJS("framework/smis/js/table_action.js");
echo addCSS("framework/bootstrap/css/datepicker.css");
echo addJS ( "base-js/smis-base-loading.js");
?>

<script type="text/javascript">
	var lap_index_dokter;
	var dokter_lap_index_dokter;
	var IS_lap_index_dokter_RUNNING;
	$(document).ready(function(){
		$('.mydate').datepicker();
		lap_index_dokter=new TableAction("lap_index_dokter","medical_record","lap_index_dokter",new Array());
		lap_index_dokter.addRegulerData=function(data){
			data['dari']=$("#lap_index_dokter_dari").val();
			data['sampai']=$("#lap_index_dokter_sampai").val();
			data['nama_dokter']=$("#lap_index_dokter_nama_dokter").val();
			$("#dari_table_lap_index_dokter").html(getFormattedDate(data['dari']));
			$("#sampai_table_lap_index_dokter").html(getFormattedDate(data['sampai']));							
			return data;
		};

		lap_index_dokter.batal=function(){
			IS_lap_index_dokter_RUNNING=false;
			$("#rekap_lap_index_dokter_modal").modal("hide");
		};
		
		lap_index_dokter.afterview=function(json){
			if(json!=null){
				$("#kode_table_lap_index_dokter").html(json.nomor);
				$("#waktu_table_lap_index_dokter").html(json.waktu);
				lap_index_dokter_data=json;
			}
		};

		lap_index_dokter.rekaptotal=function(){
			if(IS_lap_index_dokter_RUNNING) return;
			$("#rekap_lap_index_dokter_bar").sload("true","Fetching total data",0);
			$("#rekap_lap_index_dokter_modal").modal("show");
			IS_lap_index_dokter_RUNNING=true;
			var d=this.getRegulerData();
			d['super_command']="total";
			$.post("",d,function(res){
				var all=getContent(res);
				if(all!=null) {
					var total=Number(all);
					lap_index_dokter.rekaploop(0,total);
				} else {
					$("#rekap_lap_index_dokter_modal").modal("hide");
					IS_lap_index_dokter_RUNNING=false;
				}
			});
		};

		lap_index_dokter.excel=function(){
			var d=this.getRegulerData();
			d['command']="excel";
			download(d);
		};

		lap_index_dokter.rekaploop=function(current,total){
			if(current>=total || !IS_lap_index_dokter_RUNNING) {
				//$("#rekap_lap_index_dokter_modal").modal("hide");
				IS_lap_index_dokter_RUNNING=false;
				lap_index_dokter.multiview();
				return;
			}
			var d=this.getRegulerData();
			d['super_command']="limit";
			d['halaman']=current;
			$.post("",d,function(res){
				var ct=getContent(res);
				var u=ct[0]['nama_pasien']+"  "+ct[0]['nrm'];
				$("#rekap_lap_index_dokter_bar").sload("true"," Processing - "+u+"... [ "+(current+1)+" / "+total+" ] ",(current*100/total));
				setTimeout(function(){lap_index_dokter.rekaploop(++current,total)},300);
			});
		};
		
		lap_index_dokter.multiview=function(){
			$("#rekap_lap_index_dokter_bar").sload("true","Viewing data...",0);
			$("#rekap_lap_index_dokter_modal").modal("show");
			IS_lap_index_dokter_RUNNING=true;
			var d=this.getViewData();
			$("#lap_index_dokter_list").html("");
			d['command']="multipart_view";
			$.post("",d,function(res){
				var total=Number(getContent(res));
				if(total==0){
					$("#rekap_lap_index_dokter_modal").modal("hide");
					IS_lap_index_dokter_RUNNING=false;
				}else{
					var pages=Math.ceil(total/5);
					lap_index_dokter.multipart_loop(0,pages);
				}
			});			
		};
		
		lap_index_dokter.multipart_loop=function(current,total){
			if(current>=total || !IS_lap_index_dokter_RUNNING) {
				IS_lap_index_dokter_RUNNING=false;
				$("#rekap_lap_index_dokter_modal").modal("hide");
				return;
			}
			$("#rekap_lap_index_dokter_bar").sload("true","Page Number [ "+(current+1)+" / "+total+" ] ",(current*100/total));
			var d=this.getViewData();
			d['number']=current;
			d['max']=5;		
			$.post("",d,function(res){
				var ct=getContent(res);
				$("#lap_index_dokter_list").append(ct.list);
				setTimeout(function(){lap_index_dokter.multipart_loop(++current,total)},300);
			});
		};
		
		

		
		dokter_lap_index_dokter=new TableAction("dokter_lap_index_dokter","medical_record","lap_index_dokter",new Array());
		dokter_lap_index_dokter.setSuperCommand("dokter_lap_index_dokter");
		dokter_lap_index_dokter.selected=function(json){
			$("#lap_index_dokter_nama_dokter").val(json.nama);
			lap_index_dokter.multiview();
		};
	});
</script>