<?php
global $db;
require_once 'smis-base/smis-include-service-consumer.php';

$array_mui=array ("Nama",'DTD','Kode');
$muitable = new Table ( $array_mui);
$muitable->setModel ( Table::$BOTH );
$muitable->setName ( "icdtindakan" );
$muitable->setDelButtonEnable(false);
$muitable->setPrintButtonEnable(false);
$muitable->setReloadButtonEnable(false);

$madapter = new SimpleAdapter ();
$madapter->add ( "Nama", "nama" );
$madapter->add ( "Kode", "icd" );
$madapter->add ( "DTD", "dtd" );
$madapter->add ( "Grup", "grup" );

$dbtable=new DBTable($db, "smis_mr_icdtindakan");
$mresponder = new DBResponder($dbtable, $muitable, $madapter );

$super = new SuperCommand ();
$super->addResponder ( "icdtindakan", $mresponder );
$init = $super->initialize ();
if ($init != null) {
	echo $init;
	return;
}



$head=array ('Tanggal','Pasien',"Tindakan",'Dokter',"Kode ICD","Nama","DTD","Grup");
$uitable = new Table ( $head, "", NULL, true );
$uitable->setName ( "tindakan" );
if (isset ( $_POST ['command'] )) {
	$adapter = new SimpleAdapter ();
	$adapter->add ( "Tanggal", "waktu","date d M Y" );
	$adapter->add ( "Pasien", "nama_pasien" );
	$adapter->add ( "Dokter", "nama_dokter" );
	$adapter->add ( "Tindakan", "nama_tindakan" );
	$adapter->add ( "Kode ICD", "kode_icd" );
	$adapter->add ( "Nama", "nama_icd" );
	$adapter->add ( "DTD", "kode_dtd" );
	$adapter->add ( "Grup", "kode_grup" );
	
	$dbres = new ServiceResponder($db, $uitable, $adapter, "get_tindakan",$_POST['ruang']) ;	
	$data = $dbres->command ( $_POST ['command'] );
	echo json_encode ( $data );
	return;
}

require_once 'smis-libs-class/ServiceProviderList.php';
$serv=new ServiceProviderList($db, "get_tindakan");
$serv->execute();
$ruang=$serv->getContent();


$tbl=new Table(array());
$tbl->setName("header");
$tbl->addModal("ruang", "select", "Ruang", $ruang);

$form=$tbl->getModal()->getForm();
$form->setTitle("Tindakan");
$btn=new Button("", "", "");
$btn->setClass("btn-primary");
$btn->setIsButton(Button::$ICONIC);
$btn->setIcon("fa fa-refresh");
$btn->setAction("tindakan.view()");
$form->addElement("",$btn);

$uitable->addModal ( "id", "hidden", "", "" );
$uitable->addModal ( "waktu", "text", "Tanggal", "","y",NULL,true  );
$uitable->addModal ( "nama_tindakan", "text", "Tindakan", "","y",NULL,true  );
$uitable->addModal ( "nama_pasien", "text", "Pasien", "","y",NULL,true  );
$uitable->addModal ( "nama_dokter", "text", "Dokter", "","y",NULL,true  );
$uitable->addModal ( "nama_icd", "chooser-tindakan-icdtindakan", "Nama", "","y",NULL,true);
$uitable->addModal ( "kode_icd", "text", "Kode ICD", "","y",NULL,true  );
$uitable->addModal ( "kode_grup", "text", "Grup", "","y",NULL,true  );
$uitable->addModal ( "kode_dtd", "text", "No DTD", "","y",NULL,true  );

$modal = $uitable->getModal ();
$modal->setTitle ( "tindakan" );

$muitable	->addModal("id", "hidden", "", "")
			->addModal("nama", "text", "Nama", "")
			->addModal("icd", "text", "ICD", "")
			->addModal("grup", "text", "Grup", "")
			->addModal("dtd","text", "DTD", "");
$mu_modal=$muitable->getModal();
$mu_modal->setTitle("Kode ICD");

echo $form->getHtml();
echo $uitable->getHtml ();
echo $modal->getHtml ();
echo $mu_modal->getHtml ();

echo addJS ( "framework/smis/js/table_action.js" );

?>
<script type="text/javascript">
var tindakan;
var icdtindakan;
$(document).ready(function(){
	$('[data-toggle="popover"]').popover({trigger: 'hover','placement': 'top'});
	var column=new Array('id',"nama_tindakan",'nama_pasien','nama_dokter','waktu',"kode_icd","nama_icd","kode_dtd","kode_grup");
	tindakan=new TableAction("tindakan","medical_record","tindakan",column);	
	tindakan.addRegulerData=function(reg_data){
		reg_data['ruang']=$("#header_ruang").val();
		return reg_data;
	};

	icdtindakan=new TableAction("icdtindakan","medical_record","tindakan",new Array("id","nama","icd","grup","dtd"));
	icdtindakan.setSuperCommand("icdtindakan");
	icdtindakan.selected=function(json){
		$("#tindakan_kode_icd").val(json.icd);
		$("#tindakan_nama_icd").val(json.nama);
		$("#tindakan_kode_dtd").val(json.dtd);						
		$("#tindakan_kode_grup").val(json.grup);						
	};
	
});
</script>
