
var laporan_pasien_daftar;
$(document).ready(function(){
        var column            = new Array("carabayar","diagram","kelamin","unit_kerja","ppk_bpjs");
        laporan_pasien_daftar = new ReportAction("laporan_pasien_daftar","medical_record","laporan_pasien_daftar",column);

        laporan_pasien_daftar.getViewData = function(){
            var view_data               = this.getRegulerData();
            view_data['command']        = "list";
            view_data['kriteria']       = $("#"+this.prefix+"_kriteria").val();
            view_data['number']         = $("#"+this.prefix+"_number").val();
            view_data['max']            = $("#"+this.prefix+"_max").val();
            view_data['mode']           = $("#"+this.prefix+"_mode_model").val();
            view_data['jenislayanan']   = $("#"+this.prefix+"_jenislayanan").val();            
            for(var i=0;i<this.column.length;i++){
                var name                = this.column[i];
                view_data[name]         = $("#"+this.prefix+"_"+name).val();
            }
            return view_data;
        };
        
        laporan_pasien_daftar.setDefaultDate = function() {
            /* Mendapatkan range tanggal 7 hari dari sekarang */
            var date        = new Date();
            var dd_date     = date.getDate();
            var mm_date     = date.getMonth()+1; 
            var yyyy_date   = date.getFullYear();
            if(dd_date<10){
                dd_date     = '0'+dd_date;
            } 
            if(mm_date<10){
                mm_date     = '0'+mm_date;
            } 
            var to_date     = yyyy_date+'-'+mm_date+'-'+dd_date;

            var dateOffset  = (24*60*60*1000) * 7; //7 days
            var date1       = new Date();
            date1.setTime(date1.getTime() - dateOffset);
            var dd_date1    = date1.getDate();
            var mm_date1    = date1.getMonth()+1;
            var yyyy_date1  = date1.getFullYear();
            if(dd_date1<10){
                dd_date1    = '0'+dd_date1;
            } 
            if(mm_date1<10){
                mm_date1    = '0'+mm_date1;
            } 
            var from_date   = yyyy_date1+'-'+mm_date1+'-'+dd_date1;
            
            $("#"+this.prefix+"_from_date").val(from_date);
            $("#"+this.prefix+"_to_date").val(to_date);
        }

        laporan_pasien_daftar.sourcePieAdapter=function(json){
            var so      = new Array();
            $(json).each(function(idx, obj){
                var a   = {label:obj.Lokasi,value:obj.jumlah};
                so.push(a);
            });
            return so;
        };
        
        laporan_pasien_daftar.proceed_loop=function(total_data,current,data){
            if(!smis_loader.isShown() || current>=total_data){
                smis_loader.hideLoader();
                laporan_pasien_daftar.view();
                return;
            }   
            current++;
            $.post("",data,function(res){
                var json    = getContent(res);
                smis_loader.updateLoader('true',"Processing "+json['nama']+" - "+json['id']+"... [ "+current+" / "+total_data+" ] ",current*100/total_data);
                laporan_pasien_daftar.proceed_loop(total_data,current,data);
            });
        
        };
        
        laporan_pasien_daftar.backup = function(){
            var reg_data             = this.getRegulerData();
            reg_data['command']      = "get_total_id";
            reg_data['origin_data']  = laporan_pasien_daftar.get("origin_data");
            smis_loader.updateLoader('true',"Processing... ",0);
            smis_loader.showLoader();
            $.post("",reg_data,function(res){
                var json             = getContent(res);
                reg_data['command']  = "backup_current_id";
                laporan_pasien_daftar.proceed_loop(json,0,reg_data);
            });
        };
        
    $('[data-toggle="popover"]').popover({trigger: 'hover','placement': 'top'});
    $('.mydate').datepicker();
    laporan_pasien_daftar.initDiagram("");
    laporan_pasien_daftar.setTitle("Pendaftaran Pasien");
    
    $("#laporan_pasien_daftar_caradatang").on("change",function(){
            $("#laporan_pasien_daftar_rujukan").val("%");
        });
        
    laporan_pasien_daftar.setDefaultDate();
    laporan_pasien_daftar.view();
});