<?php
	require_once 'smis-framework/smis/api/SettingsBuilder.php';
	global $db;	
	$smis = new SettingsBuilder ( $db, "mr_settings", "medical_record", "settings" );
	$smis->setShowDescription ( true );
	$smis->setTabulatorMode ( Tabulator::$POTRAIT );
	
	$smis->addTabs ( "pasien", "Pasien"," fa fa-user" );
    if($smis->isGroup("pasien")){
        $smis->addItem ( "pasien", new SettingsItem ( $db, "mr-label-nama", "Max Karakter Nama", "20", "text", "Nama" ) );
        $smis->addItem ( "pasien", new SettingsItem ( $db, "mr-label-alamat", "Max Karakter Alamat", "20", "text", "Alamat" ) );
        $smis->addItem ( "pasien", new SettingsItem ( $db, "mr-label-css", "CSS Label", "", "textarea", "CSS Label" ) );
        $smis->addItem ( "pasien", new SettingsItem ( $db, "mr-label-js", "JS Labe", "", "textarea", "JS Label" ) );
        $smis->addItem ( "pasien", new SettingsItem ( $db, "mr-label-repeat", "Jumlah Label di Cetak", "1", "text", "Berapa Kali Jumlah Label di Cetak , default 1 " ) );
    }
	
	$smis->addTabs ( "diagnosa", "Diagnosa","fa fa-list" );
    if($smis->isGroup("diagnosa")){
        $smis->addItem ( "diagnosa", new SettingsItem ( $db, "smis-rs-igd-all-area", "Bisa Menghapus Di semua Area", "", "checkbox", "jika ini diaktifkan maka semua area di semua ruangan bisa menghapus diagnosa walaupun berbeda ruangan dan berbeda nomor registrasi" ) );
        $smis->addItem ( "diagnosa", new SettingsItem ( $db, "smis-rs-igd-diagnosa-icd", "Aktifkan Diagnosa Mengikuti ICD", "", "checkbox", "jika di centang diagnosa langsung mengikuti ICD" ) );
        $smis->addItem ( "diagnosa", new SettingsItem ( $db, "smis-rs-igd-diagnosa-edit", "Aktifkan Edit Diagnosa di Rekam Medis", "", "checkbox", "jika aktif, maka rekam medis dapat mengubah diagnosa pasien yang manual" ) );
        $smis->addItem ( "diagnosa", new SettingsItem ( $db, "smis-rs-igd-mr", "Slug dari IGD", "", "text", "Slug IGD untuk kepentingan Pasien Rawat Inap IGD" ) );
        $smis->addItem ( "diagnosa", new SettingsItem ( $db, "smis-rs-igd-icu", "Slug dari ICU", "", "text", "Slug ICU untuk kepentingan Pasien Rawat Inap ICU" ) );
        $smis->addItem ( "diagnosa", new SettingsItem ( $db, "smis-rs-igd-ok", "Slug dari OK", "", "text", "Slug OK untuk kepentingan Pasien Rawat Inap OK" ) );
        $smis->addItem ( "diagnosa", new SettingsItem ( $db, "smis-rs-igd-vk", "Slug dari VK", "", "text", "Slug VK untuk kepentingan Pasien Rawat Inap VK" ) );    
    }
    
	
	$smis->addTabs ( "operasi", "Operasi"," fa fa-scissors" );
    if($smis->isGroup("operasi")){
        $option=new OptionBuilder();
        $smis->addItem ( "operasi", new SettingsItem ( $db, "mr-operasi-dokter-jaga", "Tampilkan Dokter Jaga", "", "checkbox", "Tampilkan Dokter Jaga" ) );
        $smis->addItem ( "operasi", new SettingsItem ( $db, "mr-slug-ruang-operasi", "Nama Slug Ruang Operasi", "", "text", "Prototype Slug dari Ruang Operasi" ) );
    }
	
	$smis->addTabs ( "laporan", "Laporan"," fa fa-book" );
    if($smis->isGroup("laporan")){
        $smis->addItem ( "laporan", new SettingsItem ( $db, "smis-rs-autosave-lap-kb", "Auto Save Laporan KB", "0", "checkbox", "Auto Save Laporan KB" ) );
        $smis->addItem ( "laporan", new SettingsItem ( $db, "smis-rs-autosave-lap-persalinan", "Auto Save Laporan Persalinan", "0", "checkbox", "Auto Save Laporan Persalinan" ) );
        $smis->addItem ( "laporan", new SettingsItem ( $db, "smis-rs-autosave-lap-igd", "Auto Save Laporan IGD", "0", "checkbox", "Auto Save Laporan Persalinan" ) );	
        $smis->addItem ( "laporan", new SettingsItem ( $db, "smis-rs-autosave-lap-operasi", "Auto Save Laporan Operasi", "0", "checkbox", "Auto Save Laporan Operasi" ) );
        $smis->addItem ( "laporan", new SettingsItem ( $db, "smis-rs-autosave-lap-imunisasi", "Auto Save Laporan Imunisasi", "0", "checkbox", "Auto Save Laporan Imunisasi" ) );
        $smis->addItem ( "laporan", new SettingsItem ( $db, "smis-rs-autosave-lap-prolanis", "Auto Save Laporan Prolanis dan Rujuk Balik", "0", "checkbox", "Auto Save Laporan Prolanis dan Rujuk Balik" ) );
    }
    
    $smis->addTabs ( "laporan_rl", "Laporan RL"," fa fa-book" );
    if($smis->isGroup("laporan_rl")){
        $smis->addItem ( "laporan_rl", new SettingsItem ( $db, "smis-mr-lap-rl-tampil-filter-bor", "Menampilkan Filter BOS pada Laporan RL 1.2 Indikator Pelayanan", "0", "checkbox", "Menampilkan Filter BOS pada Laporan RL 1.2 Indikator Pelayanan" ) );
        $smis->addItem ( "laporan_rl", new SettingsItem ( $db, "smis-mr-lap-rl-tampil-filter-alos", "Menampilkan Filter ALOS pada Laporan RL 1.2 Indikator Pelayanan", "0", "checkbox", "Menampilkan Filter ALOS pada Laporan RL 1.2 Indikator Pelayanan" ) );
        $smis->addItem ( "laporan_rl", new SettingsItem ( $db, "smis-mr-lap-rl-tampil-filter-toi", "Menampilkan Filter TOI pada Laporan RL 1.2 Indikator Pelayanan", "0", "checkbox", "Menampilkan Filter TOI pada Laporan RL 1.2 Indikator Pelayanan" ) );
        $smis->addItem ( "laporan_rl", new SettingsItem ( $db, "smis-mr-lap-rl-tampil-filter-bto", "Menampilkan Filter BTO pada Laporan RL 1.2 Indikator Pelayanan", "0", "checkbox", "Menampilkan Filter BTO pada Laporan RL 1.2 Indikator Pelayanan" ) );
        $smis->addItem ( "laporan_rl", new SettingsItem ( $db, "smis-mr-lap-rl-tampil-filter-ndr", "Menampilkan Filter NDR pada Laporan RL 1.2 Indikator Pelayanan", "0", "checkbox", "Menampilkan Filter NDR pada Laporan RL 1.2 Indikator Pelayanan" ) );
        $smis->addItem ( "laporan_rl", new SettingsItem ( $db, "smis-mr-lap-rl-tampil-filter-gdr", "Menampilkan Filter GDR pada Laporan RL 1.2 Indikator Pelayanan", "0", "checkbox", "Menampilkan Filter GDR pada Laporan RL 1.2 Indikator Pelayanan" ) );
        $smis->addItem ( "laporan_rl", new SettingsItem ( $db, "smis-mr-lap-rl-tampil-laporan-rl5_4", "Menampilkan Laporan RL 5.4 Penyakit Baru Rawat Jalan", "0", "checkbox", "Menampilkan Laporan RL 5.4 Penyakit Baru Rawat Jalan" ) );
    }
    
    $smis->addTabs ( "laporan_pasien", "Laporan Pasien"," fa fa-book" );
    if($smis->isGroup("laporan_pasien")){
        $smis->addItem ( "laporan_pasien", new SettingsItem ( $db, "smis-mr-lap-pasien-tampil-sensus-range", "Menampilkan Laporan Sensus dengan Filter Range Tanggal Dari - Tanggal Sampai", "0", "checkbox", "Menampilkan Laporan Sensus dengan Filter Range Tanggal Dari - Tanggal Sampai" ) );
        $smis->addItem ( "laporan_pasien", new SettingsItem ( $db, "smis-mr-lap-pasien-tampil-sensus-tgl", "Menampilkan Laporan Sensus per Tanggal", "1", "checkbox", "Menampilkan Laporan Sensus per Tanggal" ) );
    }

    $smis->addTabs ( "surat_rujukan", "Surat Rujukan"," fa fa-book" );
    if($smis->isGroup("surat_rujukan")){
        $smis->addItem ( "surat_rujukan", new SettingsItem ( $db, "smis-mr-surat_rujukan-divisi_regional", "Divisi Regional", "REGIONAL II - BATAM", "text", "Divisi Regional" ) );
        $smis->addItem ( "surat_rujukan", new SettingsItem ( $db, "smis-mr-surat_rujukan-kantor_cabang", "Kantor Cabang", "BATAM", "text", "Kantor Cabang" ) );
        $smis->addItem ( "surat_rujukan", new SettingsItem ( $db, "smis-mr-surat_rujukan-kabupaten_kota", "Kabupaten / Kota", "KOTA BATAM", "text", "Kabupaten / Kota" ) );
    }
    
    $smis->setPartialLoad(true);
	$smis->init ();
?>