<?php
require_once("smis-base/smis-include-service-consumer.php");
require_once('smis-libs-hrd/EmployeeResponder.php');
global $db;

$super = new SuperCommand();
if ($_POST['super_command'] == "lr_dokter") {
    $eadapt = new SimpleAdapter();
    $eadapt->add("Jabatan", "nama_jabatan");
    $eadapt->add("Nama", "nama");
    $eadapt->add("NIP", "nip");
    $head_karyawan = array('Nama', 'Jabatan', "NIP");
    $dktable = new Table($head_karyawan, "", null, true);
    $dktable->setName($_POST['super_command']);
    $dktable->setModel(Table::$SELECT);
    $employee = new EmployeeResponder($db, $dktable, $eadapt, "dokter");
    $super->addResponder($_POST['super_command'], $employee);
}
$init = $super->initialize();
if ($init != null) {
    echo $init;
    return;
}

if (isset($_POST['command'])) {
    if ($_POST['command'] == "initiate_table") {
        $html = "";
        $header_html_1 =    "<tr>" .
            "<th rowspan='2'>No.</th>" .
            "<th rowspan='2'>Tanggal</th>" .
            "<th rowspan='2'>No. Kartu Peserta</th>" .
            "<th rowspan='2'>Nama Peserta</th>" .
            "<th rowspan='2'>Diagnosa</th>" .
            "<th rowspan='2'>SP</th>" .
            "<th rowspan='2'>RS</th>" .
            "<th colspan='3'>Keterangan</th>" .
            "</tr>";
        $header_html_2 =    "<tr>" .
            "<th>Rujukan Spesialistik</th>" .
            "<th>Rujukan Non-Spesialistik</th>" .
            "<th>Alasan Rujukan Non-Spesialistik</th>" .
            "</tr>";

        $columns = array("No.", "Tanggal", "No. Kartu Peserta", "Nama Peserta", "Diagnosa", "SP", "RS", "Rujukan Spesialistik", "Rujukan Non-Spesialistik", "Alasan Rujukan Non-Spesialistik");

        $table = new Table($columns, "", null, true);
        $table->setName("lr");
        $table->setAction(false);
        $table->setFooterVisible(false);
        $table->setHeaderVisible(false);
        $table->addHeader("before", $header_html_1 . $header_html_2);
        $html = $table->getHtml();

        $data = array(
            'html'                => $html,
            'jumlah_kolom'        => count($columns)
        );
        echo json_encode($data);
    } else if ($_POST['command'] == "get_jumlah") {
        $tanggal_dari = $_POST['tanggal_dari'];
        $tanggal_sampai = $_POST['tanggal_sampai'];
        $nama_dokter = $_POST['nama_dokter'];
        if ($nama_dokter == "SEMUA")
            $nama_dokter = "%%";
        $ruangan = $_POST['ruangan'];
        $klinik = $_POST['klinik'];
        $jumlah = 0;
        $row = $db->get_row("
            SELECT 
                COUNT(a.id) jumlah
            FROM 
                smis_mr_diagnosa a
                    LEFT JOIN smis_rg_layananpasien b ON a.noreg_pasien = b.id
            WHERE 
                a.prop = '' AND 
                a.tanggal >= '" . $tanggal_dari . "' AND 
                a.tanggal <= '" . $tanggal_sampai . "' AND 
                a.nama_dokter LIKE '" . $nama_dokter . "' AND
                a.ruangan LIKE '" . $ruangan . "' AND
                a.is_jkn_member = 1 AND
                a.status_pulang LIKE '%Rujuk%' AND
                b.unit_kerja LIKE '" . $klinik . "'
        ");
        if ($row != null)
            $jumlah = $row->jumlah;
        $data = array(
            'jumlah' => $jumlah
        );
        echo json_encode($data);
    } else if ($_POST['command'] == "get_info") {
        $num = $_POST['num'];
        $tanggal_dari = $_POST['tanggal_dari'];
        $tanggal_sampai = $_POST['tanggal_sampai'];
        $nama_dokter = $_POST['nama_dokter'];
        if ($nama_dokter == "SEMUA")
            $nama_dokter = "%%";
        $ruangan = $_POST['ruangan'];
        $klinik = $_POST['klinik'];

        $row = $db->get_row("
            SELECT 
                a.*, b.unit_kerja
            FROM 
                smis_mr_diagnosa a
                    LEFT JOIN smis_rg_layananpasien b ON a.noreg_pasien = b.id
            WHERE 
                a.prop = '' AND 
                a.tanggal >= '" . $tanggal_dari . "' AND 
                a.tanggal <= '" . $tanggal_sampai . "' AND 
                a.nama_dokter LIKE '" . $nama_dokter . "' AND
                a.ruangan LIKE '" . $ruangan . "' AND
                a.is_jkn_member = 1 AND
                a.status_pulang LIKE '%Rujuk%' AND
                b.unit_kerja LIKE '" . $klinik . "'
            ORDER BY 
                a.tanggal ASC
            LIMIT 
                " . $num . ", 1
        ");
        $html = "";
        $tanggal = "";
        $nama_pasien = "";
        $diagnosa = "";
        if ($row != null) {
            $tanggal = ArrayAdapter::format("date d/m/Y", $row->tanggal);
            $nama_pasien = $row->nama_pasien;
            $diagnosa = $row->kode_icd . ". " . $row->nama_icd;
            if (
                $row->kode_icd_sekunder != null &&
                $row->kode_icd_sekunder != "" &&
                $row->nama_icd_sekunder != null &&
                $row->nama_icd_sekunder != ""
            )
                $diagnosa .= " + " . $row->kode_icd_sekunder . ". " . $row->nama_icd_sekunder;
            $rujukan_spesialis = "";
            $rujukan_non_spesialis = "";
            if ($row->non_spesialis == 0)
                $rujukan_spesialis = "<center>V</center>";
            else
                $rujukan_non_spesialis = "<center>V</center>";

            $html = "<tr>" .
                        "<td>" . ($num + 1) . "</td>" .
                        "<td>" . ArrayAdapter::format("date d/m/Y", $row->tanggal) . "</td>" .
                        "<td>" . $row->no_bpjs . "</td>" .
                        "<td>" . $row->nama_pasien . "</td>" .
                        "<td>" . $diagnosa . "</td>" .
                        "<td>" . $row->spesialis_subspesialis . "</td>" .
                        "<td>" . $row->ppk_rujukan . "</td>" .
                        "<td>" . $rujukan_spesialis . "</td>" .
                        "<td>" . $rujukan_non_spesialis . "</td>" .
                        "<td>" . $row->rv_kondisi_khusus_alasan . "</td>" .
                    "</tr>";
        }

        $data = array(
            'html'        => $html,
            'nama_pasien' => $nama_pasien,
            'tanggal'     => $tanggal,
            'diagnosa'    => $diagnosa
        );
        echo json_encode($data);
    } else if ($_POST['command'] == "export_xls") {
        $tanggal_dari = $_POST['tanggal_dari'];
        $tanggal_sampai = $_POST['tanggal_sampai'];
        $nama_dokter = $_POST['nama_dokter'];
        $ruangan_label = $_POST['ruangan_label'];
        $klinik_label = $_POST['klinik_label'];
        $data = json_decode($_POST['d_data'], true);
        $num_rows = $_POST['num_rows'];
        $num_columns = $_POST['num_columns'] + 1;
        $last_column = $num_columns > 26 ? "A" . chr(64 + ($num_columns % 26) - 1) : chr(64 + $num_columns - 1);

        require_once("smis-libs-out/php-excel/PHPExcel.php");

        $file = new PHPExcel();
        $sheet = $file->getActiveSheet();
        $sheet->setTitle("Laporan Rujukan");
        $i = 1;

        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Laporan Kunjungan Rujukan Peserta BPJS Kesehatan");
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 1;
        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Klinik : CASA MEDICAL " . $klinik_label);
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 1;
        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Periode : " . ArrayAdapter::format("date d-m-Y", $tanggal_dari) . " s.d. " . ArrayAdapter::format("date d-m-Y", $tanggal_sampai));
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 1;
        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Dokter : " . $nama_dokter . " | Ruangan : " . $ruangan_label);
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 2;

        $border_start = $i;
        $col = 65;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "No.");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("No.") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Tanggal");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Tanggal") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "No. Kartu Peserta");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("No. Kartu Peserta") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Nama Peserta");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nama Peserta") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Diagnosa");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Diagnosa") + 20);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "SP");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("SP") + 30);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "RS");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("RS") + 30);
        $col++;
        $sub_col = $col;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col + 2) . ($i))->setCellValue(chr($col) . $i, "Keterangan");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Keterangan") + 30);
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Rujukan Spesialistik");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Rujukan Spesialistik") + 5);
        $sub_col++;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Rujukan Non-Spesialistik");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Rujukan Non-Spesialistik") + 5);
        $sub_col++;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Alasan Rujukan Non-Spesialistik");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Alasan Rujukan Non-Spesialistik") + 5);
        $sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
        $sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getFont()->setBold(true);
        $i = $i + 2;

        if (count($data) > 0) {
            foreach ($data as $d) {
                if (count($d) > 0) {
                    $col = 65;
                    foreach ($d as $c) {
                        $sheet->setCellValue(chr($col) . $i, $c);
                        if ($col == 72 || $col == 73)
                            $sheet->getStyle(chr($col) . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                        $col++;
                    }
                    $i = $i + 1;
                }
            }
        }

        $thin = array();
        $thin['borders'] = array();
        $thin['borders']['allborders'] = array();
        $thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
        $sheet->getStyle("A" . $border_start . ":" . $last_column . ($i - 1))->applyFromArray($thin);

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Laporan Rujukan Peserta BPJS Kesehatan - ' . $klinik_label . ' - ' . $ruangan_label . ' - ' . $nama_dokter . ' - ' . ArrayAdapter::format("date Ymd", $tanggal_dari) . ' - ' . ArrayAdapter::format("date Ymd", $tanggal_sampai) . '.xls"');
        header('Cache-Control: max-age=0');
        $writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
        $writer->save('php://output');
    }
    return;
}

$laporan_form = new Form("", "", "Laporan Rujukan");
$tanggal_from_text = new Text("lr_tanggal_from", "lr_tanggal_from", date("Y-m-") . "01");
$tanggal_from_text->setClass("mydate");
$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
$laporan_form->addElement("Dari", $tanggal_from_text);
$tanggal_to_text = new Text("lr_tanggal_to", "lr_tanggal_from", date("Y-m-d"));
$tanggal_to_text->setClass("mydate");
$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
$laporan_form->addElement("Sampai", $tanggal_to_text);
$nama_dokter_text = new Text("lr_nama_dokter", "lr_nama_dokter", "SEMUA");
$nama_dokter_text->setAtribute("disabled='disabled'");
$nama_dokter_text->setClass("smis-two-option-input");
$browse_button = new Button("", "", "Pilih");
$browse_button->setClass("btn-info");
$browse_button->setIcon("fa fa-list");
$browse_button->setIsButton(Button::$ICONIC);
$browse_button->setAction("lr_dokter.chooser('lr_dokter', 'lr_dokter_button', 'lr_dokter', lr_dokter, 'Dokter')");
$clear_button = new Button("", "", "Hapus");
$clear_button->setClass("btn-inverse");
$clear_button->setIcon("fa fa-times");
$clear_button->setIsButton(Button::$ICONIC);
$clear_button->setAction("lr_dokter.clear()");
$input_group = new InputGroup("");
$input_group->addComponent($nama_dokter_text);
$input_group->addComponent($browse_button);
$input_group->addComponent($clear_button);
$laporan_form->addElement("Dokter", $input_group);
$ruangan_rows = $db->get_result("
    SELECT DISTINCT ruangan
    FROM smis_mr_diagnosa
    WHERE prop = '' AND ruangan IS NOT NULL AND ruangan NOT LIKE ''
    ORDER BY ruangan ASC
");
$ruangan_option = new OptionBuilder();
$ruangan_option->add("SEMUA RUANGAN", "%%", "1");
if ($ruangan_rows != null) {
    foreach ($ruangan_rows as $ruangan_row)
        $ruangan_option->add(ArrayAdapter::format("unslug", $ruangan_row->ruangan), $ruangan_row->ruangan);
}
$ruangan_select = new Select("lr_ruangan", "lr_ruangan", $ruangan_option->getContent());
$laporan_form->addElement("Ruangan", $ruangan_select);
$klinik_rows = $db->get_result("
    SELECT DISTINCT unit_kerja
    FROM smis_rg_layananpasien
    WHERE prop = '' AND unit_kerja IS NOT NULL AND unit_kerja NOT LIKE ''
    ORDER BY unit_kerja ASC
");
$klinik_option = new OptionBuilder();
$klinik_option->add("SEMUA CABANG", "%%", "1");
if ($klinik_rows != null) {
    foreach ($klinik_rows as $klinik_row)
        $klinik_option->add(ArrayAdapter::format("unslug", $klinik_row->unit_kerja), $klinik_row->unit_kerja);
}
$klinik_select = new Select("lr_klinik", "lr_klinik", $klinik_option->getContent());
$laporan_form->addElement("Klinik", $klinik_select);
$show_button = new Button("", "", "Tampilkan");
$show_button->setClass("btn-primary");
$show_button->setIcon("icon-white icon-repeat");
$show_button->setIsButton(Button::$ICONIC);
$show_button->setAction("lr.view()");
$download_button = new Button("", "", "Unduh");
$download_button->setClass("btn-inverse");
$download_button->setIcon("fa fa-download");
$download_button->setIsButton(Button::$ICONIC);
$download_button->setAtribute("id='export_button'");
$btn_group = new ButtonGroup("noprint");
$btn_group->addButton($show_button);
$btn_group->addButton($download_button);
$laporan_form->addElement("", $btn_group);

$loading_bar = new LoadingBar("loading_bar", "");
$button = new Button("", "", "Batal");
$button->addClass("btn-primary");
$button->setIsButton(Button::$ICONIC_TEXT);
$button->setIcon("fa fa-close");
$button->setAction("lr.cancel()");
$loading_modal = new Modal("loading_modal", "", "Proses..");
$loading_modal->addHtml($loading_bar->getHtml(), "after");
$loading_modal->addFooter($button);

echo $loading_modal->getHtml();
echo $laporan_form->getHtml();
echo "<div id='table_content'>";
echo "</div>";
echo "<div id='info'>";
echo     "<div class='alert alert-block alert-inverse'>";
echo         "<center><strong>DATA BELUM DIPROSES</strong></center>";
echo     "</div>";
echo "</div>";
echo addJS("framework/smis/js/table_action.js");
echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
echo addJS("base-js/smis-base-loading.js");
echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
    var lr;
    var jumlah_kolom;
    var lr_dokter;
    var FINISHED;
    $(document).ready(function() {
        $(".mydate").datepicker();
        lr_dokter = new TableAction(
            "lr_dokter",
            "medical_record",
            "laporan_rujukan",
            new Array()
        );
        lr_dokter.setSuperCommand("lr_dokter");
        lr_dokter.selected = function(json) {
            $("#lr_nama_dokter").val(json.nama);
        };
        lr_dokter.clear = function() {
            $("#lr_nama_dokter").val("SEMUA");
        };
        lr = new TableAction(
            "lr",
            "medical_record",
            "laporan_rujukan",
            new Array()
        );
        lr.view = function() {
            $("#info").empty();
            $("#loading_bar").sload("true", "Harap ditunggu...", 0);
            $("#loading_modal").smodal("show");
            FINISHED = false;
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "initiate_table";
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) return;
                    $("#table_content").html(json.html);
                    jumlah_kolom = json.jumlah_kolom;
                    data = self.getRegulerData();
                    data['command'] = "get_jumlah";
                    data['tanggal_dari'] = $("#lr_tanggal_from").val();
                    data['tanggal_sampai'] = $("#lr_tanggal_to").val();
                    data['nama_dokter'] = $("#lr_nama_dokter").val();
                    data['ruangan'] = $("#lr_ruangan").val();
                    data['klinik'] = $("#lr_klinik").val();
                    $("#loading_bar").sload("true", "Proses Pemuatan Jumlah Data");
                    $.post(
                        "",
                        data,
                        function(response_jumlah) {
                            var json_jumlah = JSON.parse(response_jumlah);
                            if (json_jumlah == null) return;
                            self.fillHtml(0, json_jumlah.jumlah);
                        }
                    );
                }
            );
        };
        lr.fillHtml = function(num, limit) {
            if (FINISHED || num == limit) {
                if (FINISHED == false && num == limit) {
                    this.finalize();
                } else {
                    $("#loading_modal").smodal("hide");
                    $("#info").html(
                        "<div class='alert alert-block alert-inverse'>" +
                        "<center><strong>PROSES DIBATALKAN</strong></center>" +
                        "</div>"
                    );
                    $("#export_button").removeAttr("onclick");
                }
                return;
            }
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "get_info";
            data['num'] = num;
            data['tanggal_dari'] = $("#lr_tanggal_from").val();
            data['tanggal_sampai'] = $("#lr_tanggal_to").val();
            data['nama_dokter'] = $("#lr_nama_dokter").val();
            data['ruangan'] = $("#lr_ruangan").val();
            data['klinik'] = $("#lr_klinik").val();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) return;
                    $("tbody#lr_list").append(
                        json.html
                    );
                    $("#loading_bar").sload("true", json.tanggal + " - " + json.nama_pasien + " - " + json.diagnosa + " (" + num + " / " + limit + ")", num * 100 / limit - 1);
                    self.fillHtml(num + 1, limit);
                }
            );
        };
        lr.finalize = function() {
            $("#loading_modal").smodal("hide");
            $("#info").html(
                "<div class='alert alert-block alert-info'>" +
                "<center><strong>PROSES SELESAI</strong></center>" +
                "</div>"
            );
            $("#export_button").removeAttr("onclick");
            $("#export_button").attr("onclick", "lr.export_xls()");
        };
        lr.export_xls = function() {
            showLoading();
            var num_rows = $("#lr_list").children("tr").length;
            var num_columns = jumlah_kolom;
            var d_data = {};
            for (var i = 0; i < num_rows; i++) {
                d_data[i] = {};
                for (var j = 0; j < num_columns; j++)
                    d_data[i][j] = $("tbody#lr_list tr:eq(" + i + ") td:eq(" + j + ")").text();
            }
            var data = this.getRegulerData();
            data['command'] = "export_xls";
            data['tanggal_dari'] = $("#lr_tanggal_from").val();
            data['tanggal_sampai'] = $("#lr_tanggal_to").val();
            data['nama_dokter'] = $("#lr_nama_dokter").val();
            data['ruangan_label'] = $("#lr_ruangan option:selected").text();
            data['klinik_label'] = $("#lr_klinik option:selected").text();
            data['d_data'] = JSON.stringify(d_data);
            data['num_rows'] = num_rows;
            data['num_columns'] = num_columns;
            postForm(data);
            dismissLoading();
        };
        lr.cancel = function() {
            FINISHED = true;
        };
        $("#loading_modal > div.modal-header > a").remove();
        $(document).keyup(function(e) {
            if (e.which == 27) {
                FINISHED = true;
            }
        });
    });
</script>