<?php
global $db;

$super = new SuperCommand();
if ($_POST['super_command'] == "lrns_dokter") {
    $eadapt = new SimpleAdapter();
    $eadapt->add("Jabatan", "nama_jabatan");
    $eadapt->add("Nama", "nama");
    $eadapt->add("NIP", "nip");
    $head_karyawan = array('Nama', 'Jabatan', "NIP");
    $dktable = new Table($head_karyawan, "", null, true);
    $dktable->setName($_POST['super_command']);
    $dktable->setModel(Table::$SELECT);
    $employee = new EmployeeResponder($db, $dktable, $eadapt, "dokter");
    $super->addResponder($_POST['super_command'], $employee);
}
$init = $super->initialize();
if ($init != null) {
    echo $init;
    return;
}

if (isset($_POST['command'])) {
    if ($_POST['command'] == "initiate_table") {
        $tanggal_dari = $_POST['tanggal_dari'];
        $tanggal_sampai = $_POST['tanggal_sampai'];
        $nama_dokter = $_POST['nama_dokter'];
        if ($nama_dokter == "SEMUA")
            $nama_dokter = "%%";
        $klinik = $_POST['klinik'];
        $ppk_rujukan = $_POST['ppk_rujukan'];
        $html = "";
        $arr_total = array();
        $arr_dokter = array();
        $dokter_rows = $db->get_result("
            SELECT 
                DISTINCT nama_dokter
            FROM 
                smis_mr_diagnosa
            WHERE 
                prop = '' AND 
                tanggal >= '" . $tanggal_dari . "' AND 
                tanggal <= '" . $tanggal_sampai . "' AND 
                nama_dokter LIKE '" . $nama_dokter . "' AND
                is_jkn_member = 1 AND
                status_pulang LIKE '%Rujuk%' AND
                origin LIKE '" . $klinik . "' AND
                ppk_rujukan LIKE '" . $ppk_rujukan . "'
        ");
        $header_html_1 =    "<tr>" .
            "<th rowspan='2'>No</th>" .
            "<th rowspan='2'>Tanggal</th>";
        $header_html_2 =    "<tr>";
        $columns = array("No", "Tanggal");
        if ($dokter_rows != null) {
            foreach ($dokter_rows as $dr) {
                $columns[] = $dr->nama_dokter . " Spesialistik";
                $columns[] = $dr->nama_dokter . " Non-Spesialistik";
                $arr_total[] = 0;
                $arr_total[] = 0;
                $arr_dokter[] = $dr->nama_dokter;
                $header_html_1 .= "<th colspan='2'>" . $dr->nama_dokter . "</th>";
                $header_html_2 .= "<th>Spesialistik</th><th>Non-Spesialistik</th>";
            }
        }
        $header_html_1 .= "</tr>";
        $header_html_2 .= "</tr>";

        $table = new Table($columns, "", null, true);
        $table->setName("lrns");
        $table->setAction(false);
        $table->setFooterVisible(false);
        $table->setHeaderVisible(false);
        $table->addHeader("before", $header_html_1 . $header_html_2);
        $html = $table->getHtml();

        $tanggal_arr = array();
        $tanggal_f = new DateTime($tanggal_dari);
        $tanggal_t = new DateTime($tanggal_sampai);
        $tanggal_t->modify('+1 day');
        $period = new DatePeriod(
            $tanggal_f,
            new DateInterval('P1D'),
            $tanggal_t
        );
        foreach ($period as $key => $value)
            $tanggal_arr[] = $value->format('Y-m-d');
        $jumlah_hari = count($tanggal_arr);
        $html_body = "";
        if ($jumlah_hari > 0) {
            $nomor = 1;
            foreach ($tanggal_arr as $tanggal) {
                $html_dokter = "";
                if ($dokter_rows != null) {
                    foreach ($dokter_rows as $dr) {
                        $html_dokter .= "<td><div align='right'>0</div></td><td><div align='right'>0</div></td>";
                    }
                }
                $html_body .=   "<tr>" .
                    "<td>" . $nomor++ . "</td>" .
                    "<td>" . ArrayAdapter::format("date d/m/Y", $tanggal) . "</td>" .
                    $html_dokter .
                    "</tr>";
            }
        }

        $data = array(
            'jumlah_kolom'  => count($columns),
            'data_dokter'   => $arr_dokter,
            'html'          => $html,
            'html_body'     => $html_body,
            'jumlah_hari'   => $jumlah_hari,
            'data_total'    => $arr_total
        );
        echo json_encode($data);
    } else if ($_POST['command'] == "get_info") {
        $tanggal_part = explode('/', $_POST['tanggal']);
        $tanggal = $tanggal_part[2] . "-" . $tanggal_part[1] . "-" . $tanggal_part[0];
        $klinik = $_POST['klinik'];
        $ppk_rujukan = $_POST['ppk_rujukan'];
        $arr_dokter = $_POST['data_dokter'];
        $i_total = 0;
        $data_total = $_POST['data_total'];
        $update_info = array();

        if (count($arr_dokter) > 0) {
            foreach ($arr_dokter as $dokter) {
                $spesialistik = 0;
                $non_spesialistik = 0;

                $spesialistik_row = $db->get_row("
                    SELECT
                        COUNT(id) jumlah
                    FROM
                        smis_mr_diagnosa
                    WHERE
                        prop = '' AND 
                        tanggal = '" . $tanggal . "' AND 
                        nama_dokter LIKE '" . $dokter . "' AND
                        is_jkn_member = 1 AND
                        jenis_rujuk_vertikal LIKE 'Spesialis' AND
                        status_pulang LIKE '%Rujuk%' AND
                        origin LIKE '" . $klinik . "'
                ");
                if ($spesialistik_row != null)
                    $spesialistik = $spesialistik_row->jumlah;
                $data_total[$i_total++] += $spesialistik;
                $update_info[] = $spesialistik;

                $non_spesialistik_row = $db->get_row("
                    SELECT
                        COUNT(id) jumlah
                    FROM
                        smis_mr_diagnosa
                    WHERE
                        prop = '' AND 
                        tanggal = '" . $tanggal . "' AND 
                        nama_dokter LIKE '" . $dokter . "' AND
                        is_jkn_member = 1 AND
                        jenis_rujuk_vertikal NOT LIKE 'Spesialis' AND
                        status_pulang LIKE '%Rujuk%' AND
                        origin LIKE '" . $klinik . "'
                ");
                if ($non_spesialistik_row != null)
                    $non_spesialistik = $non_spesialistik_row->jumlah;
                $data_total[$i_total++] += $non_spesialistik;
                $update_info[] = $non_spesialistik;
            }
        }
        $data = array(
            'update_info'   => $update_info,
            'data_total'    => $data_total
        );
        echo json_encode($data);
    } else if ($_POST['command'] == "export_xls") {
        $tanggal_from = $_POST['tanggal_dari'];
        $tanggal_to = $_POST['tanggal_sampai'];
        $origin_label = $_POST['klinik_label'];
        $nama_dokter = $_POST['nama_dokter'];
        $ppk_rujukan_label = $_POST['ppk_rujukan_label'];
        $data_dokter = json_decode($_POST['data_dokter'], true);
        $data = json_decode($_POST['d_data'], true);
        $num_rows = $_POST['num_rows'];
        $num_columns = $_POST['num_columns'];
        $last_column = chr(65 + $num_columns - 1);

        require_once("smis-libs-out/php-excel/PHPExcel.php");

        $file = new PHPExcel();
        $sheet = $file->getActiveSheet();
        $sheet->setTitle("Rujukan Non-Spesialistik");
        $i = 1;

        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Rekap Rujukan Non-Spesialistik");
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 1;
        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Periode : " . ArrayAdapter::format("date d-m-Y", $tanggal_dari) . " s.d. " . ArrayAdapter::format("date d-m-Y", $tanggal_to) . " (" . $origin_label . ")");
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 1;
        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Dokter : " . $nama_dokter);
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 2;

        $border_start = $i;
        $col = 65;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "No.");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("No.") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Tanggal");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Tanggal") + 5);
        $col++;
        if (count($data_dokter) > 0) {
            foreach ($data_dokter as $dokter) {
                $start_col = chr($col);
                $end_col = chr($col + 1);
                $sheet->mergeCells($start_col . $i . ":" . $end_col . $i)->setCellValue($start_col . $i, $dokter);
                $col_width = mb_strwidth($dokter) < 30 ? 30 : mb_strwidth($dokter);
                $sheet->getColumnDimension($start_col)->setWidth($col_width / 2 + 5);
                $sheet->getColumnDimension($end_col)->setWidth($col_width / 2 + 5);
                $sheet->setCellValue($start_col . ($i + 1), "Spesialistik");
                $sheet->setCellValue($end_col . ($i + 1), "Non-Spesialistik");
                $col += 2;
            }
        }
        $sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
        $sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getFont()->setBold(true);
        $i = $i + 2;

        if (count($data) > 0) {
            foreach ($data as $d) {
                if (count($d) > 0) {
                    $col = 65;
                    foreach ($d as $c) {
                        $sheet->setCellValue(chr($col) . $i, $c);
                        $col++;
                    }
                    $i = $i + 1;
                }
            }
        }
        $sheet->getStyle("A" . ($i - 1) . ":" . $last_column . ($i - 1))->getFont()->setBold(true);

        $thin = array();
        $thin['borders'] = array();
        $thin['borders']['allborders'] = array();
        $thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
        $sheet->getStyle("A" . $border_start . ":" . $last_column . ($i - 1))->applyFromArray($thin);

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Rekap Rujukan Non-Spesialistik - ' . ArrayAdapter::format("date Ymd", $tanggal_from) . ' - ' . ArrayAdapter::format("date Ymd", $tanggal_to) . ' - ' . $nama_dokter . ' - ' . $origin_label . '.xls"');
        header('Cache-Control: max-age=0');
        $writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
        $writer->save('php://output');
    }
    return;
}

$laporan_form = new Form("", "", "Rekap Rujukan Non-Spesialistik");
$tanggal_from_text = new Text("lrns_tanggal_from", "lrns_tanggal_from", date("Y-m-") . "01");
$tanggal_from_text->setClass("mydate");
$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
$laporan_form->addElement("Dari", $tanggal_from_text);
$tanggal_to_text = new Text("lrns_tanggal_to", "lrns_tanggal_from", date("Y-m-d"));
$tanggal_to_text->setClass("mydate");
$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
$laporan_form->addElement("Sampai", $tanggal_to_text);
$nama_dokter_text = new Text("lrns_nama_dokter", "lrns_nama_dokter", "SEMUA");
$nama_dokter_text->setAtribute("disabled='disabled'");
$nama_dokter_text->setClass("smis-two-option-input");
$browse_button = new Button("", "", "Pilih");
$browse_button->setClass("btn-info");
$browse_button->setIcon("fa fa-list");
$browse_button->setIsButton(Button::$ICONIC);
$browse_button->setAction("lrns_dokter.chooser('lrns_dokter', 'lrns_dokter_button', 'lrns_dokter', lrns_dokter, 'Dokter')");
$clear_button = new Button("", "", "Hapus");
$clear_button->setClass("btn-inverse");
$clear_button->setIcon("fa fa-times");
$clear_button->setIsButton(Button::$ICONIC);
$clear_button->setAction("lrns_dokter.clear()");
$input_group = new InputGroup("");
$input_group->addComponent($nama_dokter_text);
$input_group->addComponent($browse_button);
$input_group->addComponent($clear_button);
$laporan_form->addElement("Dokter", $input_group);
$klinik_rows = $db->get_result("
    SELECT DISTINCT origin
    FROM smis_mr_diagnosa
    WHERE prop = '' AND origin IS NOT NULL AND origin NOT LIKE ''
    ORDER BY origin ASC
");
$klinik_option = new OptionBuilder();
$klinik_option->add("SEMUA CABANG", "%%", "1");
if ($klinik_rows != null) {
    foreach ($klinik_rows as $klinik_row)
        $klinik_option->add(ArrayAdapter::format("unslug", $klinik_row->origin), $klinik_row->origin);
}
$klinik_select = new Select("lrns_klinik", "lrns_klinik", $klinik_option->getContent());
$laporan_form->addElement("Klinik", $klinik_select);
$ppk_rujukan_rows = $db->get_result("
    SELECT DISTINCT ppk_rujukan
    FROM smis_mr_diagnosa
    WHERE prop = '' AND ppk_rujukan IS NOT NULL AND ppk_rujukan NOT LIKE '' AND is_jkn_member = 1
    ORDER BY ppk_rujukan ASC
");
$ppk_rujukan_option = new OptionBuilder();
$ppk_rujukan_option->add("SEMUA PPK", "%%", "1");
if ($ppk_rujukan_rows != null) {
    foreach ($ppk_rujukan_rows as $ppk_rujukan_row)
        $ppk_rujukan_option->add($ppk_rujukan_row->ppk_rujukan, $ppk_rujukan_row->ppk_rujukan);
}
$ppk_rujukan_select = new Select("lrns_ppk_rujukan", "lrns_ppk_rujukan", $ppk_rujukan_option->getContent());
$laporan_form->addElement("PPK", $ppk_rujukan_select);
$show_button = new Button("", "", "Tampilkan");
$show_button->setClass("btn-primary");
$show_button->setIcon("icon-white icon-repeat");
$show_button->setIsButton(Button::$ICONIC);
$show_button->setAction("lrns.view()");
$download_button = new Button("", "", "Unduh");
$download_button->setClass("btn-inverse");
$download_button->setIcon("fa fa-download");
$download_button->setIsButton(Button::$ICONIC);
$download_button->setAtribute("id='export_button'");
$btn_group = new ButtonGroup("noprint");
$btn_group->addButton($show_button);
$btn_group->addButton($download_button);
$laporan_form->addElement("", $btn_group);

$loading_bar = new LoadingBar("loading_bar", "");
$button = new Button("", "", "Batal");
$button->addClass("btn-primary");
$button->setIsButton(Button::$ICONIC_TEXT);
$button->setIcon("fa fa-close");
$button->setAction("lrns.cancel()");
$loading_modal = new Modal("loading_modal", "", "Proses..");
$loading_modal->addHtml($loading_bar->getHtml(), "after");
$loading_modal->addFooter($button);

echo $loading_modal->getHtml();
echo $laporan_form->getHtml();
echo "<div id='table_content'>";
echo "</div>";
echo "<div id='info'>";
echo     "<div class='alert alert-block alert-inverse'>";
echo         "<center><strong>DATA BELUM DIPROSES</strong></center>";
echo     "</div>";
echo "</div>";
echo addJS("framework/smis/js/table_action.js");
echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
echo addJS("base-js/smis-base-loading.js");
echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
    var lrns;
    var data_dokter;
    var jumlah_kolom;
    var FINISHED;
    $(document).ready(function() {
        lrns = new TableAction(
            "lrns",
            "medical_record",
            "laporan_rekap_rujukan_non_spesialistik",
            new Array()
        );
        lrns.view = function() {
            $("#info").empty();
            $("#loading_bar").sload("true", "Harap ditunggu...", 0);
            $("#loading_modal").smodal("show");
            FINISHED = false;
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "initiate_table";
            data['tanggal_dari'] = $("#lrns_tanggal_from").val();
            data['tanggal_sampai'] = $("#lrns_tanggal_to").val();
            data['nama_dokter'] = $("#lrns_nama_dokter").val();
            data['ppk_rujukan'] = $("#lrns_ppk_rujukan").val();
            data['klinik'] = $("#lrns_klinik").val();
            data['klinik_label'] = $("#lrns_klinik option:selected").text();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) return;
                    $("#table_content").html(json.html);
                    $("#lrns_list").html(json.html_body);
                    data_dokter = json.data_dokter;
                    jumlah_kolom = json.jumlah_kolom;
                    self.fillHtml(0, json.jumlah_hari, json.data_total);
                }
            );
        };
        lrns.fillHtml = function(num, limit, data_total) {
            if (FINISHED || num == limit) {
                if (FINISHED == false && num == limit) {
                    this.finalize(data_total);
                } else {
                    $("#loading_modal").smodal("hide");
                    $("#info").html(
                        "<div class='alert alert-block alert-inverse'>" +
                        "<center><strong>PROSES DIBATALKAN</strong></center>" +
                        "</div>"
                    );
                    $("#export_button").removeAttr("onclick");
                }
                return;
            }
            var self = this;
            var data = this.getRegulerData();
            var tanggal = $("#lrns_list tr:eq(" + num + ") td:eq(1)").text();
            data['command'] = "get_info";
            data['tanggal'] = tanggal;
            data['ppk_rujukan'] = $("#lrns_ppk_rujukan").val();
            data['klinik'] = $("#lrns_klinik").val();
            data['data_dokter'] = data_dokter;
            data['data_total'] = data_total;
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) return;
                    data_total = json.data_total;
                    for (var col_index = 0; col_index < data_dokter.length * 2; col_index++) {
                        var nilai = json.update_info[col_index];
                        var td_index = col_index + 2;
                        $("tbody#lrns_list tr:eq(" + num + ") td:eq(" + td_index + ")").html("<div align='right'>" + nilai + "</div>");
                    }
                    $("#loading_bar").sload("true", tanggal + " (" + num + " / " + limit + ")", num * 100 / limit - 1);
                    self.fillHtml(num + 1, limit, data_total);
                }
            );
        };
        lrns.finalize = function(data_total) {
            var num_rows = $("tbody#lrns_list tr").length;
            var html_total = "";
            data_total.forEach(function(item, index) {
                html_total += "<td><b><div align='right'>" + item + "</div></b></td>";
            });
            $("tbody#lrns_list").append(
                "<tr>" +
                "<td></td>" +
                "<td><b>Total</b></td>" +
                html_total +
                "</tr>"
            );
            $("#loading_modal").smodal("hide");
            $("#info").html(
                "<div class='alert alert-block alert-info'>" +
                "<center><strong>PROSES SELESAI</strong></center>" +
                "</div>"
            );
            $("#export_button").removeAttr("onclick");
            $("#export_button").attr("onclick", "lrns.export_xls()");
        };
        lrns.export_xls = function() {
            showLoading();
            var num_rows = $("#lrns_list").children("tr").length;
            var num_columns = jumlah_kolom;
            var d_data = {};
            for (var i = 0; i < num_rows; i++) {
                d_data[i] = {};
                for (var j = 0; j < num_columns; j++)
                    d_data[i][j] = $("tbody#lrns_list tr:eq(" + i + ") td:eq(" + j + ")").text();
            }
            var data = this.getRegulerData();
            data['command'] = "export_xls";
            data['tanggal_dari'] = $("#lrns_tanggal_from").val();
            data['tanggal_sampai'] = $("#lrns_tanggal_to").val();
            data['nama_dokter'] = $("#lrns_nama_dokter").val();
            data['ppk_rujukan'] = $("#lrns_ppk_rujukan").val();
            data['ppk_rujukan_label'] = $("#lrns_ppk_rujukan option:selected").text();
            data['klinik'] = $("#lrns_klinik").val();
            data['klinik_label'] = $("#lrns_klinik option:selected").text();
            data['d_data'] = JSON.stringify(d_data);
            data['num_rows'] = num_rows;
            data['num_columns'] = num_columns;
            var d_dokter = {};
            var i = 0;
            data_dokter.forEach(function(item, index) {
                d_dokter[i++] = item;
            });
            data['data_dokter'] = JSON.stringify(d_dokter);
            postForm(data);
            dismissLoading();
        };
        lrns.cancel = function() {
            FINISHED = true;
        };
        $("#loading_modal > div.modal-header > a").remove();
        $(document).keyup(function(e) {
            if (e.which == 27) {
                FINISHED = true;
            }
        });
    });
</script>