<?php
	global $db;

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "initiate_table") {
			$html = "";
			$arr_total = array();
			$arr_dokter = array();
			$dokter_rows = $db->get_result("
				SELECT 
					DISTINCT nama_dokter
				FROM 
					smis_rg_layananpasien 
				WHERE 
					prop = '' AND 
					carabayar = 'bpjs' AND 
					MONTH(tanggal) = '" . $_POST['bulan'] . "' AND 
					YEAR(tanggal) = '" . $_POST['tahun'] . "' AND
					unit_kerja LIKE '" . $_POST['origin'] . "'
			");
			$header_html_1 =	"<tr>" .
				"<th rowspan='2'>Tanggal</th>";
			$header_html_2 =	"<tr>";
			$columns = array("Tanggal");
			if ($dokter_rows != null) {
				foreach ($dokter_rows as $dr) {
					$columns[] = $dr->nama_dokter . " BPJS";
					$columns[] = $dr->nama_dokter . " Rujukan";
					$arr_total[] = 0;
					$arr_total[] = 0;
					$arr_dokter[] = $dr->nama_dokter;
					$header_html_1 .= "<th colspan='2'>" . $dr->nama_dokter . "</th>";
					$header_html_2 .= "<th>BPJS</th><th>Rujukan</th>";
				}
			}
			$arr_total[] = 0;
			$columns[] = "Kunjungan Sehat";
			$header_html_1 .= "<th rowspan='2'>Kunjungan Sehat</th>";
			$arr_total[] = 0;
			$columns[] = "Kunjungan Kelompok Senam";
			$arr_total[] = 0;
			$columns[] = "Kunjungan Kelompok Penyuluhan";
			$header_html_1 .= "<th colspan='2'>Kunjungan Kelompok</th>";
			$header_html_2 .= "<th>Senam</th><th>Penyuluhan</th>";
			$arr_total[] = 0;
			$columns[] = "PU";
			$header_html_1 .= "<th rowspan='2'>PU</th>";
			$arr_total[] = 0;
			$columns[] = "SKS";
			$header_html_1 .= "<th rowspan='2'>SKS</th>";
			$arr_total[] = 0;
			$columns[] = "FFS";
			$header_html_1 .= "<th rowspan='2'>FFS</th>";
			$header_html_1 .= "</tr>";
			$header_html_2 .= "</tr>";

			$table = new Table($columns, "", null, true);
			$table->setName("lrpb");
			$table->setAction(false);
			$table->setFooterVisible(false);
			$table->setHeaderVisible(false);
			$table->addHeader("before", $header_html_1 . $header_html_2);
			$html = $table->getHtml();

			$jumlah_hari = cal_days_in_month(CAL_GREGORIAN, $_POST['bulan'], $_POST['tahun']);

			$data = array(
				'data_dokter'	=> $arr_dokter,
				'html'			=> $html,
				'jumlah_hari'	=> $jumlah_hari,
				'data_total'	=> $arr_total
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info") {
			$tanggal = $_POST['tanggal'];
			$bulan = $_POST['bulan'];
			$tahun = $_POST['tahun'];
			$origin = $_POST['origin'];
			$arr_dokter = $_POST['data_dokter'];
			$html = 	"<tr>";
			$html .= 		"<td id='tanggal'>" . $tanggal . "</td>";

			$i_total = 0;
			$data_total = $_POST['data_total'];

			if (count($arr_dokter) > 0) {
				foreach ($arr_dokter as $dokter) {
					$bpjs = 0;
					$f_bpjs = 0;
					$rujukan = 0;
					$f_rujukan = 0;

					$bpjs_row = $db->get_row("
						SELECT 
							COUNT(a.id) jumlah
						FROM 
							smis_rg_layananpasien a LEFT JOIN smis_rg_asuransi b ON a.asuransi = b.id
						WHERE 
							a.prop = '' AND 
							a.carabayar = 'bpjs' AND 
							a.jenis_kunjungan = 'Kunjungan Sakit' AND
							b.nama = 'BPJS - KESEHATAN' AND
							a.nama_dokter = '" . $dokter . "' AND 
							DATE(a.tanggal) = '" . $tahun . "-" . $bulan . "-" . $tanggal . "' AND
							a.unit_kerja LIKE '" . $origin . "'
					");
					if ($bpjs_row != null && $bpjs_row->jumlah != 0) {
						$bpjs = $bpjs_row->jumlah;
						$data_total[$i_total] += $bpjs;
						$f_bpjs = number_format($bpjs, 0, ".", ",");
					}
					$i_total++;

					$rujukan_row = $db->get_row("
						SELECT 
							COUNT(a.id) jumlah
						FROM 
							smis_rg_layananpasien a LEFT JOIN smis_rg_asuransi b ON a.asuransi = b.id
						WHERE 
							a.prop = '' AND 
							a.carabayar = 'bpjs' AND 
							a.jenis_kunjungan = 'Kunjungan Sakit' AND
							b.nama = 'BPJS - KESEHATAN' AND
							a.nama_dokter = '" . $dokter . "' AND 
							DATE(a.tanggal) = '" . $tahun . "-" . $bulan . "-" . $tanggal ."' AND
							a.carapulang = 'Rujuk' AND
							a.unit_kerja LIKE '" . $origin . "'
					");
					if ($rujukan_row != null && $rujukan_row->jumlah != 0) {
						$rujukan = $rujukan_row->jumlah;
						$data_total[$i_total] += $rujukan;
						$f_rujukan = number_format($rujukan, 0, ".", ",");
					}
					$i_total++;

					$html .= "<td><div align='right'>" . $f_bpjs . "</div></td>";
					$html .= "<td><div align='right'>" . $f_rujukan . "</div></td>";
				}
			}
			$kunjungan_sehat = 0;
			$f_kunjungan_sehat = 0;
			$kunjungan_sehat_row = $db->get_row("
				SELECT 
					COUNT(id) jumlah
				FROM 
					smis_rg_layananpasien
				WHERE 
					prop = '' AND 
					jenis_kunjungan = 'Kunjungan Sehat' AND 
					DATE(tanggal) = '" . $tahun . "-" . $bulan . "-" . $tanggal ."' AND
					unit_kerja LIKE '" . $origin . "'
			");
			if ($kunjungan_sehat_row != null && $kunjungan_sehat_row->jumlah != 0) {
				$kunjungan_sehat = $kunjungan_sehat_row->jumlah;
				$data_total[$i_total] += $kunjungan_sehat;
				$f_kunjungan_sehat = number_format($kunjungan_sehat, 0, ".", ",");
			}
			$i_total++;
			$html .= 	"<td><div align='right'>" . $f_kunjungan_sehat . "</div></td>";
			$kk_senam = 0;
			$data_total[$i_total++] += $kk_senam;
			$f_kk_senam = 0;
			$html .= 	"<td><div align='right'>" . $f_kk_senam . "</div></td>";
			$kk_penyuluhan = 0;
			$data_total[$i_total++] += $kk_penyuluhan;
			$f_kk_penyuluhan = 0;
			$html .= 	"<td><div align='right'>" . $f_kk_penyuluhan . "</div></td>";
			$pu = 0;
			$f_pu = 0;
			$pu_row = $db->get_row("
				SELECT 
					COUNT(id) jumlah
				FROM 
					smis_rg_layananpasien
				WHERE 
					prop = '' AND 
					carabayar = 'umum' AND 
					jenis_kunjungan = 'Kunjungan Sakit' AND
					DATE(tanggal) = '" . $tahun . "-" . $bulan . "-" . $tanggal ."' AND
					unit_kerja LIKE '" . $origin . "'
			");
			if ($pu_row != null && $pu_row->jumlah != 0) {
				$pu = $pu_row->jumlah;
				$data_total[$i_total] += $pu;
				$f_pu = number_format($pu, 0, ".", ",");
			}
			$i_total++;
			$html .= 	"<td><div align='right'>" . $f_pu . "</div></td>";
			$sks = 0;
			$f_sks = 0;
			$sks_row = $db->get_row("
				SELECT 
					COUNT(id) jumlah
				FROM 
					smis_rg_layananpasien
				WHERE 
					prop = '' AND 
					carabayar = 'umum' AND
					jenis_kunjungan = 'SKS' AND 
					DATE(tanggal) = '" . $tahun . "-" . $bulan . "-" . $tanggal ."' AND
					unit_kerja LIKE '" . $origin . "'
			");
			if ($sks_row != null && $sks_row->jumlah != 0) {
				$sks = $sks_row->jumlah;
				$data_total[$i_total] += $sks;
				$f_sks = number_format($sks, 0, ".", ",");
			}
			$i_total++;
			$html .= 	"<td><div align='right'>" . $f_sks . "</div></td>";
			$ffs = 0;
			$f_ffs = 0;
			$ffs_row = $db->get_row("
				SELECT 
					COUNT(id) jumlah
				FROM 
					smis_rg_layananpasien
				WHERE 
					prop = '' AND 
					(
						carabayar = 'asuransi' OR 
						carabayar = 'perusahaan'
					) AND
					DATE(tanggal) = '" . $tahun . "-" . $bulan . "-" . $tanggal ."' AND
					unit_kerja LIKE '" . $origin . "'
			");
			if ($ffs_row != null && $ffs_row->jumlah != 0) {
				$ffs = $ffs_row->jumlah;
				$data_total[$i_total] += $ffs;
				$f_ffs = number_format($ffs, 0, ".", ",");
			}
			$i_total++;
			$html .= 	"<td><div align='right'>" . $f_ffs . "</div></td>";
			$html .= "</tr>";
			$data = array(
				'html' 			=> $html,
				'data_total'	=> $data_total
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$bulan = $_POST['bulan'];
			$tahun = $_POST['tahun'];
			$origin_label = $_POST['origin_label'];
			$data_dokter = json_decode($_POST['data_dokter'], true);
			$data = json_decode($_POST['d_data'], true);
			$num_rows = $_POST['num_rows'];
			$num_columns = $_POST['num_columns'];
			$last_column = chr(65 + $num_columns - 1);

			require_once("smis-libs-out/php-excel/PHPExcel.php");

			$file = new PHPExcel();
			$sheet = $file->getActiveSheet();
			$sheet->setTitle("Laporan Rekap Pendaftaran BPJS");
			$i = 1;

			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Laporan Rekap Pendaftaran BPJS");
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Tahun : " . $tahun . ", Bulan : " . $bulan . " (" . $origin_label . ")");
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 2;

			$border_start = $i;
			$col = 65;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Tanggal");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Tanggal") + 5);
			$col++;
			if (count($data_dokter) > 0) {
				foreach ($data_dokter as $dokter) {
					$start_col = chr($col);
					$end_col = chr($col + 1);
					$sheet->mergeCells($start_col . $i . ":" . $end_col . $i)->setCellValue($start_col . $i, $dokter);
					$sheet->getColumnDimension($start_col)->setWidth(mb_strwidth($dokter) / 2 + 5);
					$sheet->getColumnDimension($end_col)->setWidth(mb_strwidth($dokter) / 2 + 5);
					$sheet->setCellValue($start_col . ($i + 1), "BPJS");
					$sheet->setCellValue($end_col . ($i + 1), "Rujukan");
					$col += 2;
				}
			}
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Kunjungan Sehat");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Kunjungan Sehat") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col + 1) . $i)->setCellValue(chr($col) . $i, "Kunjungan Kelompok");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Kunjungan Kelompok") / 2 + 5);
			$sheet->getColumnDimension(chr($col + 1))->setWidth(mb_strwidth("Kunjungan Kelompok") / 2 + 5);
			$sheet->setCellValue(chr($col) . ($i + 1), "Senam");
			$sheet->setCellValue(chr($col + 1) . ($i + 1), "Penyuluhan");
			$col += 2;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "PU");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("PU") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "SKS");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("SKS") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "FFS");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("FFS") + 5);
			$col++;
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getFont()->setBold(true);
			$i = $i + 2;

			if (count($data) > 0) {
				foreach ($data as $d) {
					if (count($d) > 0) {
						$col = 65;
						foreach ($d as $c) {
							$sheet->setCellValue(chr($col) . $i, $c);
							$col++;
						}
						$i = $i + 1;
					}
				}
			}
			$sheet->getStyle("A" . ($i - 1) . ":" . $last_column . ($i - 1))->getFont()->setBold(true);

			$thin = array();
			$thin['borders'] = array();
			$thin['borders']['allborders'] = array();
			$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
			$sheet->getStyle("A" . $border_start . ":" . $last_column . ($i - 1))->applyFromArray($thin);

			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Laporan Rekap Pendaftaran BPJS - ' . $bulan . ' ' . $tahun . ' - ' . $origin_label . '.xls"');
			header('Cache-Control: max-age=0');
			$writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
			$writer->save('php://output');
		}
		return;
	}

	$laporan_form = new Form("", "", "Data Pasien BPJS dan Rujukan Dokter Umum/Dokter Gigi");
	$bulan_option = new OptionBuilder();
	if (date("m") == 1)
		$bulan_option->add("Januari", "1", "1");
	else
		$bulan_option->add("Januari", "1");
	if (date("m") == 2)
		$bulan_option->add("Februari", "2", "1");
	else
		$bulan_option->add("Februari", "2");
	if (date("m") == 3)
		$bulan_option->add("Maret", "3", "1");
	else
		$bulan_option->add("Maret", "3");
	if (date("m") == 4)
		$bulan_option->add("April", "4", "1");
	else
		$bulan_option->add("April", "4");
	if (date("m") == 5)
		$bulan_option->add("Mei", "5", "1");
	else
		$bulan_option->add("Mei", "5");
	if (date("m") == 6)
		$bulan_option->add("Juni", "6", "1");
	else
		$bulan_option->add("Juni", "6");
	if (date("m") == 7)
		$bulan_option->add("Juli", "7", "1");
	else
		$bulan_option->add("Juli", "7");
	if (date("m") == 8)
		$bulan_option->add("Agustus", "8", "1");
	else
		$bulan_option->add("Agustus", "8");
	if (date("m") == 9)
		$bulan_option->add("September", "9", "1");
	else
		$bulan_option->add("September", "9");
	if (date("m") == 10)
		$bulan_option->add("Oktober", "10", "1");
	else
		$bulan_option->add("Oktober", "10");
	if (date("m") == 11)
		$bulan_option->add("Nopember", "11", "1");
	else
		$bulan_option->add("Nopember", "11");
	if (date("m") == 12)
		$bulan_option->add("Desember", "12", "1");
	else
		$bulan_option->add("Desember", "12");
	$bulan_select = new Select("lrpb_bulan", "lrpb_bulan", $bulan_option->getContent());
	$laporan_form->addElement("Bulan", $bulan_select);

	$tahun_rows = $db->get_result("
		SELECT DISTINCT YEAR(tanggal) tahun
		FROM smis_rg_layananpasien
		WHERE prop = '' AND YEAR(tanggal) > 0
		ORDER BY YEAR(tanggal) ASC
	");
	$tahun_option = new OptionBuilder();
	if ($tahun_rows != null) {
		foreach ($tahun_rows as $tahun_row) {
			if (date("Y") == $tahun_row->tahun)
				$tahun_option->add($tahun_row->tahun, $tahun_row->tahun, "1");
			else
				$tahun_option->add($tahun_row->tahun, $tahun_row->tahun);
		}
	}
	$tahun_select = new Select("lrpb_tahun", "lrpb_tahun", $tahun_option->getContent());
	$laporan_form->addElement("Tahun", $tahun_select);
	$origin_option = new OptionBuilder();
	// Data Server :
	// Klinik Casa Medical Utama
	// Klinik Casa Medical Batu Aji
	// Klinik Casa Medical Tanjung Uncang
	// Klinik Tanjung Piayu
	// Klinik Casa Medical Sekupang
	// Klinik Casa Medical Jodoh
	// Klinik Casa Batam Centre
	// Klinik Casa Medical Panbil
	// Klinik Casa Medical Bengkong
	$origin_option->addSingle("Klinik Casa Batam Centre");
	$origin_option->addSingle("Klinik Casa Medical Batu Aji");
	$origin_option->addSingle("Klinik Casa Medical Bengkong");
	$origin_option->addSingle("Klinik Casa Medical Jodoh");
	$origin_option->addSingle("Klinik Casa Medical Panbil");
	$origin_option->addSingle("Klinik Casa Medical Sekupang");
	$origin_option->addSingle("Klinik Casa Medical Utama");
	$origin_option->addSingle("Klinik Casa Medical Tanjung Uncang");
	$origin_option->addSingle("Klinik Tanjung Piayu");
	$origin_select = new Select("lrpb_origin", "lrpb_origin", $origin_option->getContent());
	$laporan_form->addElement("Asal Data", $origin_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lrpb.view()");
	$download_button = new Button("", "", "Unduh");
	$download_button->setClass("btn-inverse");
	$download_button->setIcon("fa fa-download");
	$download_button->setIsButton(Button::$ICONIC);
	$download_button->setAtribute("id='export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($download_button);
	$laporan_form->addElement("", $btn_group);

	$loading_bar = new LoadingBar("loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lrpb.cancel()");
	$loading_modal = new Modal("loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);

	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo "</div>";
	echo "<div id='info'>";
	echo 	"<div class='alert alert-block alert-inverse'>";
	echo 		"<center><strong>DATA BELUM DIPROSES</strong></center>";
	echo 	"</div>";
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	var lrpb;
	var data_dokter;
	var FINISHED;
	$(document).ready(function() {
		lrpb = new TableAction(
			"lrpb",
			"medical_record",
			"laporan_rekap_pendaftaran_bpjs",
			new Array()
		);
		lrpb.view = function() {
			$("#info").empty();
			$("#loading_bar").sload("true", "Harap ditunggu...", 0);
			$("#loading_modal").smodal("show");
			FINISHED = false;
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "initiate_table";
			data['bulan'] = $("#lrpb_bulan").val();
			data['tahun'] = $("#lrpb_tahun").val();
			data['origin'] = $("#lrpb_origin").val();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("#table_content").html(json.html);
					data_dokter = json.data_dokter;
					self.fillHtml(1, json.jumlah_hari, json.data_total);
				}
			);
		};
		lrpb.fillHtml = function(hari_num, jumlah_hari, data_total) {
			if (FINISHED || hari_num == jumlah_hari) {
				if (FINISHED == false && hari_num == jumlah_hari) {
					this.finalize(data_total);
				} else {
					$("#loading_modal").smodal("hide");
					$("#info").html(
						"<div class='alert alert-block alert-inverse'>" +
						"<center><strong>PROSES DIBATALKAN</strong></center>" +
						"</div>"
					);
					$("#export_button").removeAttr("onclick");
				}
				return;
			}
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "get_info";
			data['tanggal'] = hari_num;
			data['bulan'] = $("#lrpb_bulan").val();
			data['tahun'] = $("#lrpb_tahun").val();
			data['origin'] = $("#lrpb_origin").val();
			data['data_dokter'] = data_dokter;
			data['data_total'] = data_total;
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					data_total = json.data_total;
					$("tbody#lrpb_list").append(
						json.html
					);
					$("#loading_bar").sload("true", (Array(3).join('0') + hari_num).slice(-2) + "-" + (Array(3).join('0') + $("#lrpb_bulan").val()).slice(-2) + "-" + $("#lrpb_tahun").val() + " (" + hari_num + " / " + jumlah_hari + ")", hari_num * 100 / jumlah_hari - 1);
					self.fillHtml(hari_num + 1, jumlah_hari, data_total);
				}
			);
		};
		lrpb.finalize = function(data_total) {
			var num_rows = $("tbody#lrpb_list tr").length;
			var html_total = "";
			data_total.forEach(function(item, index) {
				html_total += "<td><b><div align='right'>" + item + "</div></b></td>";
			});
			$("tbody#lrpb_list").append(
				"<tr>" +
				"<td><b>Total</b></td>" +
				html_total +
				"</tr>"
			);
			$("#loading_modal").smodal("hide");
			$("#info").html(
				"<div class='alert alert-block alert-info'>" +
				"<center><strong>PROSES SELESAI</strong></center>" +
				"</div>"
			);
			$("#export_button").removeAttr("onclick");
			$("#export_button").attr("onclick", "lrpb.export_xls()");
		};
		lrpb.export_xls = function() {
			showLoading();
			var num_rows = $("#lrpb_list").children("tr").length;
			var num_columns = 7 + (data_dokter.length * 2);
			var d_data = {};
			for (var i = 0; i < num_rows; i++) {
				d_data[i] = {};
				for (var j = 0; j < num_columns; j++)
					d_data[i][j] = $("tbody#lrpb_list tr:eq(" + i + ") td:eq(" + j + ")").text();
			}
			var d_dokter = {};
			var i = 0;
			data_dokter.forEach(function(item, index) {
				d_dokter[i++] = item;
			});
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			data['bulan'] = $("#lrpb_bulan option:selected").text();
			data['tahun'] = $("#lrpb_tahun").val();
			data['origin_label'] = $("#lrpb_origin option:selected").text();
			data['data_dokter'] = JSON.stringify(d_dokter);
			data['d_data'] = JSON.stringify(d_data);
			data['num_rows'] = num_rows;
			data['num_columns'] = num_columns;
			postForm(data);
			dismissLoading();
		};
		lrpb.cancel = function() {
			FINISHED = true;
		};
		$("#loading_modal > div.modal-header > a").remove();
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		});
	});
</script>
<style type="text/css">
	th {
		text-align: center !important;
		vertical-align: middle !important;
	}
</style>