<?php
	global $db;

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "initiate_table") {
			$html = "";
			$arr_diagnosa = array(
				array(
					'kode' 	=> 'L02',
					'nama'	=> 'ABSES'
				),
				array(
					'kode' 	=> 'J45',
					'nama'	=> 'ASMA BRONCHIAL'
				),
				array(
					'kode' 	=> 'R51',
					'nama'	=> 'CEPALGIA'
				),
				array(
					'kode' 	=> 'H10',
					'nama'	=> 'CONJUNGTIVIS'
				),
				array(
					'kode' 	=> 'L30',
					'nama'	=> 'DERMATITIS'
				),
				array(
					'kode' 	=> 'R50',
					'nama'	=> 'FEBRIS'
				),
				array(
					'kode' 	=> 'A09',
					'nama'	=> 'GASTRO ENTERITIS'
				),
				array(
					'kode' 	=> 'K29',
					'nama'	=> 'GASTRITIS'
				),
				array(
					'kode' 	=> 'I84',
					'nama'	=> 'HEMORROID'
				),
				array(
					'kode' 	=> 'I10',
					'nama'	=> 'HYPERTENSI'
				),
				array(
					'kode' 	=> 'I95',
					'nama'	=> 'HIPOTENSI'
				),
				array(
					'kode' 	=> 'H00',
					'nama'	=> 'HORDEOLUM'
				),
				array(
					'kode' 	=> 'J06',
					'nama'	=> 'ISPA'
				),
				array(
					'kode' 	=> 'N36',
					'nama'	=> 'ISK'
				),
				array(
					'kode' 	=> 'K59',
					'nama'	=> 'KONSTIPASI'
				),
				array(
					'kode' 	=> 'M79',
					'nama'	=> 'MIALGIA'
				),
				array(
					'kode' 	=> 'B36',
					'nama'	=> 'MIKOSISI'
				),
				array(
					'kode' 	=> 'H66',
					'nama'	=> 'OTITIS'
				),
				array(
					'kode' 	=> 'L60',
					'nama'	=> 'PARANOKIA'
				),
				array(
					'kode' 	=> 'K12',
					'nama'	=> 'STOMATITIS'
				),
				array(
					'kode' 	=> 'B26',
					'nama'	=> 'PAROTITIS'
				),
				array(
					'kode' 	=> 'J03',
					'nama'	=> 'TONSILITIS'
				),
				array(
					'kode' 	=> 'A16',
					'nama'	=> 'TB PARU'
				),
				array(
					'kode' 	=> 'B01',
					'nama'	=> 'VARICELLA'
				),
				array(
					'kode' 	=> 'Z30',
					'nama'	=> 'AKBP'
				),
				array(
					'kode' 	=> 'Z36',
					'nama'	=> 'ANC'
				)
			);
			$jumlah_hari = cal_days_in_month(CAL_GREGORIAN, $_POST['bulan'], $_POST['tahun']);
			$header_html_1 =	"<tr>" .
									"<th rowspan='2'>No.</th>" .
									"<th rowspan='2'>Nama Penyakit</th>" .
									"<th colspan='" . ($jumlah_hari + 3) . "'>Daftar Kunjungan Harian Pasien</th>";
			$header_html_2 =	"<tr>";
			$columns = array("No.", "Nama Penyakit");
			for ($hari = 1; $hari <= $jumlah_hari; $hari++) {
				$columns[] = $hari;
				$header_html_2 .= "<th>" . $hari . "</th>";
			}
			$columns[] = "Pasien Baru";
			$header_html_2 .= "<th>Pasien Baru</th>";
			$columns[] = "Pasien Lama";
			$header_html_2 .= "<th>Pasien Lama</th>";
			$columns[] = "Jumlah";
			$header_html_2 .= "<th>Jumlah</th>";
			$header_html_1 .= "</tr>";
			$header_html_2 .= "</tr>";

			$table = new Table($columns, "", null, true);
			$table->setName("lrd");
			$table->setAction(false);
			$table->setFooterVisible(false);
			$table->setHeaderVisible(false);
			$table->addHeader("before", $header_html_1 . $header_html_2);
			$html = $table->getHtml();

			$data = array(
				'data_diagnosa'		=> $arr_diagnosa,
				'jumlah_diagnosa'	=> count($arr_diagnosa),
				'html'				=> $html,
				'jumlah_kolom'		=> count($columns)
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info") {
			$num = $_POST['num'];
			$kode_icd = $_POST['kode_icd'];
			$nama_icd = $_POST['nama_icd'];
			$bulan = $_POST['bulan'];
			$tahun = $_POST['tahun'];
			$ruangan = $_POST['ruangan'];
			$klinik = $_POST['klinik'];

			$jumlah_hari = cal_days_in_month(CAL_GREGORIAN, $_POST['bulan'], $_POST['tahun']);

			$html = "<tr>";
				$html .= "<td>" . $num . "</td>";
				$html .= "<td>" . $nama_icd . "</td>";
			for ($hari = 1; $hari <= $jumlah_hari; $hari++) {
				$tanggal = $tahun . "-" . $bulan . "-" . $hari;
				$jumlah = 0;
				$row = $db->get_row("
					SELECT
						COUNT(DISTINCT a.noreg_pasien) jumlah
					FROM
						(smis_mr_diagnosa a LEFT JOIN smis_rg_layananpasien b ON a.noreg_pasien = b.id) LEFT JOIN smis_rg_asuransi c ON b.asuransi = c.id
					WHERE 
						a.prop = '' AND 
						b.prop = '' AND 
						a.tanggal = '" . $tanggal . "' AND
						(
							a.kode_icd LIKE '" . $kode_icd . ".%' OR 
							a.kode_icd = '" . $kode_icd . "'
						) AND 
						a.origin LIKE '" . $klinik . "' AND 
						a.ruangan LIKE '" . $ruangan . "' AND
						b.carabayar = 'bpjs' AND
						c.nama = 'BPJS - KESEHATAN'
				");
				if ($row != null)
					$jumlah = $row->jumlah;
				$html .= "<td>" . ArrayAdapter::format("number", $jumlah) . "</td>";
			}
			$jumlah_lama = 0;
			$row = $db->get_row("
				SELECT
					COUNT(DISTINCT a.noreg_pasien) jumlah
				FROM
					(smis_mr_diagnosa a LEFT JOIN smis_rg_layananpasien b ON a.noreg_pasien = b.id) LEFT JOIN smis_rg_asuransi c ON b.asuransi = c.id
				WHERE 
					a.prop = '' AND 
					b.prop = '' AND 
					MONTH(a.tanggal) = '" . $bulan . "' AND 
					YEAR(a.tanggal) = '" . $tahun . "' AND 
					(
						a.kode_icd LIKE '" . $kode_icd . ".%' OR 
						a.kode_icd = '" . $kode_icd . "'
					) AND 
					a.origin LIKE '" . $klinik . "' AND 
					a.ruangan LIKE '" . $ruangan . "' AND
					b.carabayar = 'bpjs' AND
					c.nama = 'BPJS - KESEHATAN' AND
					b.barulama = 0
			");
			if ($row != null)
				$jumlah_lama = $row->jumlah;
			$jumlah_baru = 0;
			$row = $db->get_row("
				SELECT
					COUNT(DISTINCT a.noreg_pasien) jumlah
				FROM
					(smis_mr_diagnosa a LEFT JOIN smis_rg_layananpasien b ON a.noreg_pasien = b.id) LEFT JOIN smis_rg_asuransi c ON b.asuransi = c.id
				WHERE 
					a.prop = '' AND 
					b.prop = '' AND 
					MONTH(a.tanggal) = '" . $bulan . "' AND 
					YEAR(a.tanggal) = '" . $tahun . "' AND 
					(
						a.kode_icd LIKE '" . $kode_icd . ".%' OR 
						a.kode_icd = '" . $kode_icd . "'
					) AND 
					a.origin LIKE '" . $klinik . "' AND 
					a.ruangan LIKE '" . $ruangan . "' AND
					b.carabayar = 'bpjs' AND
					c.nama = 'BPJS - KESEHATAN' AND
					b.barulama = 1
			");
			if ($row != null)
				$jumlah_baru = $row->jumlah;
			$total = $jumlah_baru + $jumlah_lama;
			$html .= "<td>" . ArrayAdapter::format("number", $jumlah_baru) . "</td>";
			$html .= "<td>" . ArrayAdapter::format("number", $jumlah_lama) . "</td>";
			$html .= "<td>" . ArrayAdapter::format("number", $total) . "</td>";
			$html .= "</tr>";
			
			$data = array(
				'html' 			=> $html
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$bulan = $_POST['bulan'];
			$bulan_label = $_POST['bulan_label'];
			$tahun = $_POST['tahun'];
			$ruang_label = $_POST['ruang_label'];
			$klinik_label = $_POST['klinik_label'];
			$data = json_decode($_POST['d_data'], true);
			$num_rows = $_POST['num_rows'];
			$num_columns = $_POST['num_columns'] + 1;
			$last_column = $num_columns > 26 ? "A" . chr(64 + ($num_columns % 26) - 1) : chr(64 + $num_columns - 1);

			require_once ("smis-libs-out/php-excel/PHPExcel.php");

			$file = new PHPExcel();			
			$sheet = $file->getActiveSheet();
			$sheet->setTitle("Laporan Rekap Diagnosa");
			$i = 1;

			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Laporan Kunjungan Harian (Diagnosa) Peserta BPJS Kesehatan");
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Klinik : " . $klinik_label);
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Bulan Pelayanan " . $bulan_label . " Tahun " . $tahun);
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 2;

			$border_start = $i;
			$col = 65;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "No.");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("No.") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Nama Penyakit");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nama Penyakit") + 5);
			$col++;
			$sub_col = $col;
			$sheet->mergeCells(chr($col) . $i . ":" . "A" . chr(64 + (($col + $num_columns - 4) % 90)) . $i)->setCellValue(chr($col) . $i, "Daftar Kunjungan Pasien Harian");
			$jumlah_hari = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);
			for ($hari = 1; $hari <= $jumlah_hari; $hari++) {
				if ($sub_col <= 90)
					$sheet->setCellValue(chr($sub_col) . ($i + 1), $hari);
				else
					$sheet->setCellValue("A" . chr(64 + ($sub_col % 90)) . ($i + 1), $hari);
				$sub_col++;
			}
			$sheet->setCellValue("A" . chr(64 + ($sub_col % 90)) . ($i + 1), "PB");
			$sub_col++;
			$sheet->setCellValue("A" . chr(64 + ($sub_col % 90)) . ($i + 1), "PL");
			$sub_col++;
			$sheet->setCellValue("A" . chr(64 + ($sub_col % 90)) . ($i + 1), "JML");
			$sub_col++;
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getFont()->setBold(true);
			$i = $i + 2;

			if (count($data) > 0) {
				foreach ($data as $d) {
					if (count($d) > 0) {
						$col = 65;
						foreach ($d as $c) {
							if ($col <= 90)
								$sheet->setCellValue(chr($col) . $i, $c);
							else
								$sheet->setCellValue("A" . chr(64 + ($col % 90)) . $i, $c);								
							$col++;
						}
						$i = $i + 1;
					}
				}
			}

			$thin = array();
			$thin['borders'] = array();
			$thin['borders']['allborders'] = array();
			$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
			$sheet->getStyle("A" . $border_start . ":" . $last_column . ($i - 1))->applyFromArray($thin);

			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Laporan Rekap Diagnosa Peserta BPJS Kesehatan - ' . $bulan_label . ' ' . $tahun . '.xls"');
			header('Cache-Control: max-age=0');
			$writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
			$writer->save('php://output');
		}
		return;
	}

	$laporan_form = new Form("", "", "Laporan Kunjungan Harian (Diagnosa) Peserta BPJS Kesehatan");
	$bulan_option = new OptionBuilder();
	if (date("m") == 1)
		$bulan_option->add("Januari", "1", "1");
	else
		$bulan_option->add("Januari", "1");
	if (date("m") == 2)
		$bulan_option->add("Februari", "2", "1");
	else
		$bulan_option->add("Februari", "2");
	if (date("m") == 3)
		$bulan_option->add("Maret", "3", "1");
	else
		$bulan_option->add("Maret", "3");
	if (date("m") == 4)
		$bulan_option->add("April", "4", "1");
	else
		$bulan_option->add("April", "4");
	if (date("m") == 5)
		$bulan_option->add("Mei", "5", "1");
	else
		$bulan_option->add("Mei", "5");
	if (date("m") == 6)
		$bulan_option->add("Juni", "6", "1");
	else
		$bulan_option->add("Juni", "6");
	if (date("m") == 7)
		$bulan_option->add("Juli", "7", "1");
	else
		$bulan_option->add("Juli", "7");
	if (date("m") == 8)
		$bulan_option->add("Agustus", "8", "1");
	else
		$bulan_option->add("Agustus", "8");
	if (date("m") == 9)
		$bulan_option->add("September", "9", "1");
	else
		$bulan_option->add("September", "9");
	if (date("m") == 10)
		$bulan_option->add("Oktober", "10", "1");
	else
		$bulan_option->add("Oktober", "10");
	if (date("m") == 11)
		$bulan_option->add("Nopember", "11", "1");
	else
		$bulan_option->add("Nopember", "11");
	if (date("m") == 12)
		$bulan_option->add("Desember", "12", "1");
	else
		$bulan_option->add("Desember", "12");
	$bulan_select = new Select("lrd_bulan", "lrd_bulan", $bulan_option->getContent());
	$laporan_form->addElement("Bulan", $bulan_select);

	$tahun_rows = $db->get_result("
		SELECT DISTINCT YEAR(tanggal) tahun
		FROM smis_rg_layananpasien
		WHERE prop = '' AND YEAR(tanggal) > 0
		ORDER BY YEAR(tanggal) ASC
	");
	$tahun_option = new OptionBuilder();
	if ($tahun_rows != null) {
		foreach ($tahun_rows as $tahun_row) {
			if (date("Y") == $tahun_row->tahun)
				$tahun_option->add($tahun_row->tahun, $tahun_row->tahun, "1");
			else
				$tahun_option->add($tahun_row->tahun, $tahun_row->tahun);
		}
	}
	$tahun_select = new Select("lrd_tahun", "lrd_tahun", $tahun_option->getContent());
	$laporan_form->addElement("Tahun", $tahun_select);
	$ruangan_rows = $db->get_result("
		SELECT DISTINCT ruangan
		FROM smis_mr_diagnosa
		WHERE prop = '' AND ruangan IS NOT NULL AND ruangan NOT LIKE ''
		ORDER BY ruangan ASC
	");
	$ruangan_option = new OptionBuilder();
	$ruangan_option->add("SEMUA", "%%", "1");
	if ($ruangan_rows != null) {
		foreach ($ruangan_rows as $ruangan_row)
			$ruangan_option->add(ArrayAdapter::format("unslug", $ruangan_row->ruangan), $ruangan_row->ruangan);
	}
	$ruangan_select = new Select("lrd_ruangan", "lrd_ruangan", $ruangan_option->getContent());
	$laporan_form->addElement("Ruangan", $ruangan_select);
	$klinik_rows = $db->get_result("
		SELECT DISTINCT origin
		FROM smis_mr_diagnosa
		WHERE prop = '' AND origin IS NOT NULL AND origin NOT LIKE ''
		ORDER BY origin ASC
	");
	$klinik_option = new OptionBuilder();
	$klinik_option->add("SEMUA", "%%", "1");
	if ($klinik_rows != null) {
		foreach ($klinik_rows as $klinik_row)
			$klinik_option->add(ArrayAdapter::format("unslug", $klinik_row->origin), $klinik_row->origin);
	}
	$klinik_select = new Select("lrd_klinik", "lrd_klinik", $klinik_option->getContent());
	$laporan_form->addElement("Klinik", $klinik_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lrd.view()");
	$download_button = new Button("", "", "Unduh");
	$download_button->setClass("btn-inverse");
	$download_button->setIcon("fa fa-download");
	$download_button->setIsButton(Button::$ICONIC);
	$download_button->setAtribute("id='export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($download_button);
	$laporan_form->addElement("", $btn_group);

	$loading_bar = new LoadingBar("loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lrd.cancel()");
	$loading_modal = new Modal("loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);
	
	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo "</div>";
	echo "<div id='info'>";
	echo 	"<div class='alert alert-block alert-inverse'>";
	echo 		"<center><strong>DATA BELUM DIPROSES</strong></center>";
	echo 	"</div>";
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	var lrd;
	var data_diagnosa;
	var jumlah_kolom;
	var FINISHED;
	$(document).ready(function (){
		lrd = new TableAction(
			"lrd",
			"medical_record",
			"laporan_rekap_diagnosa",
			new Array()
		);
		lrd.view = function() {
			$("#info").empty();
			$("#loading_bar").sload("true", "Harap ditunggu...", 0);
			$("#loading_modal").smodal("show");
			FINISHED = false;
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "initiate_table";
			data['bulan'] = $("#lrd_bulan").val();
			data['tahun'] = $("#lrd_tahun").val();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("#table_content").html(json.html);
					data_diagnosa = json.data_diagnosa;
					jumlah_kolom = json.jumlah_kolom;
					self.fillHtml(1, json.jumlah_diagnosa);
				}
			);
		};
		lrd.fillHtml = function(num, limit) {
			if (FINISHED || num == limit) {
				if (FINISHED == false && num == limit) {
					this.finalize();
				} else {
					$("#loading_modal").smodal("hide");
					$("#info").html(
						"<div class='alert alert-block alert-inverse'>" +
							 "<center><strong>PROSES DIBATALKAN</strong></center>" +
						 "</div>"
					);
					$("#export_button").removeAttr("onclick");
				}
				return;
			}
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "get_info";
			data['num'] = num;
			data['kode_icd'] = data_diagnosa[num - 1]['kode'];
			data['nama_icd'] = data_diagnosa[num - 1]['nama'];
			data['bulan'] = $("#lrd_bulan").val();
			data['tahun'] = $("#lrd_tahun").val();
			data['ruangan'] = $("#lrd_ruangan").val();
			data['klinik'] = $("#lrd_klinik").val();
			data['data_diagnosa'] = data_diagnosa;
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("tbody#lrd_list").append(
						json.html
					);
					$("#loading_bar").sload("true", data_diagnosa[num - 1]['nama'] + " (" + num + " / " + limit + ")", num * 100 / limit - 1);
					self.fillHtml(num + 1, limit);
				}
			);
		};
		lrd.finalize = function() {
			$("#loading_modal").smodal("hide");
			$("#info").html(
				"<div class='alert alert-block alert-info'>" +
					 "<center><strong>PROSES SELESAI</strong></center>" +
				 "</div>"
			);
			$("#export_button").removeAttr("onclick");
			$("#export_button").attr("onclick", "lrd.export_xls()");
		};
		lrd.export_xls = function() {
			showLoading();
			var num_rows = $("#lrd_list").children("tr").length;
			var num_columns = jumlah_kolom;
			var d_data = {};
			for (var i = 0; i < num_rows; i++) {
				d_data[i] = {};
				for (var j = 0; j < num_columns; j++)
					d_data[i][j] = $("tbody#lrd_list tr:eq(" + i + ") td:eq(" + j + ")").text();
			}
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			data['bulan'] = $("#lrd_bulan").val();
			data['bulan_label'] = $("#lrd_bulan option:selected").text();
			data['tahun'] = $("#lrd_tahun").val();
			data['ruangan_label'] = $("#lrd_ruangan option:selected").text();
			data['klinik_label'] = $("#lrd_klinik option:selected").text();
			data['d_data'] = JSON.stringify(d_data);
			data['num_rows'] = num_rows;
			data['num_columns'] = num_columns;
			postForm(data);
			dismissLoading();
		};
		lrd.cancel = function() {
			FINISHED = true;
		};
		$("#loading_modal > div.modal-header > a").remove();
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		});
	});
</script>