<?php
	global $db;

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "initiate_table") {
			$html = "";

			$header_html_1 =	"<tr>" .
									"<th rowspan='2'>No.</th>" .
									"<th rowspan='2'>Nama Pasien/Peserta</th>" .
									"<th rowspan='2'>Tanggal Pelayanan</th>" .
									"<th rowspan='2'>Nomor Kartu BPJS Kesehatan</th>" .
									"<th rowspan='2'>Alamat dan No. Telp. Pasien</th>" .
									"<th colspan='4'>Hasil Pemeriksaan</th>" .
									"<th rowspan='2'>Diagnosa</th>" .
									"<th rowspan='2'>Teraphy</th>" .
								"</tr>";
			$header_html_2 =	"<tr>" .
									"<th>GDS</th>" .
									"<th>GDP</th>" .
									"<th>GDPP</th>" .
									"<th>Tek. Darah</th>" .
								"</tr>";
			
			$columns = array("No.", "Nama Pasien", "Tanggal Pelayanan", "No. BPJS", "Alamat dan Telp.", "GDS", "GDP", "GDPP", "Tekanan Darah", "Diagnosa", "Teraphy");

			$table = new Table($columns, "", null, true);
			$table->setName("lp");
			$table->setAction(false);
			$table->setFooterVisible(false);
			$table->setHeaderVisible(false);
			$table->addHeader("before", $header_html_1 . $header_html_2);
			$html = $table->getHtml();

			$data = array(
				'html'				=> $html,
				'jumlah_kolom'		=> count($columns)
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_jumlah") {
			$bulan = $_POST['bulan'];
			$tahun = $_POST['tahun'];
			$klinik = $_POST['klinik'];
			$jumlah = 0;
			$row = $db->get_row("
				SELECT COUNT(*) jumlah
				FROM smis_mr_prolanis
				WHERE prop = '' AND MONTH(tanggal) = '" . $bulan . "' AND YEAR(tanggal) = '" . $tahun . "' AND origin LIKE '" . $klinik . "'
			");
			if ($row != null)
				$jumlah = $row->jumlah;
			$data = array(
				'jumlah' => $jumlah
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info") {
			$num = $_POST['num'];
			$bulan = $_POST['bulan'];
			$tahun = $_POST['tahun'];
			$klinik = $_POST['klinik'];

			$row = $db->get_row("
				SELECT *
				FROM smis_mr_prolanis
				WHERE prop = '' AND MONTH(tanggal) = '" . $bulan . "' AND YEAR(tanggal) = '" . $tahun . "' AND origin LIKE '" . $klinik . "'
				ORDER BY tanggal ASC
				LIMIT " . $num . ", 1
			");
			$html = "";
			$tanggal = "";
			$nama_pasien = "";
			if ($row != null) {
				$tanggal = ArrayAdapter::format("date d/m/Y", $row->tanggal);
				$nama_pasien = $row->nama_pasien;

				require_once("smis-base/smis-include-service-consumer.php");
				$params = array();
				$params['noreg_pasien'] = $row->noreg_pasien;
				$consumer_service = new ServiceConsumer(
					$db,
					"get_terapi_prolanis",
					$params
				);
				$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
				$content = $consumer_service->execute()->getContent();

				if (count($content) == 0) {
					$html = "<tr>" .
								"<td>" . ($num + 1) . "</td>" .
								"<td>" . $row->nama_pasien . "</td>" .
								"<td>" . ArrayAdapter::format("date d/m/Y", $row->tanggal) . "</td>" .
								"<td>" . $row->no_bpjs . "</td>" .
								"<td>" . $row->alamat . "</td>" .
								"<td>" . $row->gds . "</td>" .
								"<td>" . $row->gdp . "</td>" .
								"<td>" . $row->gdpp . "</td>" .
								"<td>" . $row->tensi . "</td>" .
								"<td>" . $row->diagnosa . "</td>" .
								"<td><center>-</center></td>" .
							"</tr>";
				} else {
					sort($content);
					for ($i = 0; $i < count($content); $i++) {
						if ($i == 0) {
							$html .= 	"<tr>" .
											"<td>" . ($num + 1) . "</td>" .
											"<td>" . $row->nama_pasien . "</td>" .
											"<td>" . ArrayAdapter::format("date d/m/Y", $row->tanggal) . "</td>" .
											"<td>" . $row->no_bpjs . "</td>" .
											"<td>" . $row->alamat . "</td>" .
											"<td>" . $row->gds . "</td>" .
											"<td>" . $row->gdp . "</td>" .
											"<td>" . $row->gdpp . "</td>" .
											"<td>" . $row->tensi . "</td>" .
											"<td>" . $row->diagnosa . "</td>" .
											"<td>" . strtoupper($content[$i]) . "</td>" .
										"</tr>";
						} else {
						$html .= 	"<tr>" .
										"<td>&nbsp;</td>" .
										"<td>&nbsp;</td>" .
										"<td>&nbsp;</td>" .
										"<td>&nbsp;</td>" .
										"<td>&nbsp;</td>" .
										"<td>&nbsp;</td>" .
										"<td>&nbsp;</td>" .
										"<td>&nbsp;</td>" .
										"<td>&nbsp;</td>" .
										"<td>&nbsp;</td>" .
										"<td>" . strtoupper($content[$i]) . "</td>" .
									"</tr>";
						}
					}
				}
			}
			
			$data = array(
				'html' 			=> $html,
				'nama_pasien'	=> $nama_pasien,
				'tanggal'		=> $tanggal
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$bulan = $_POST['bulan'];
			$bulan_label = $_POST['bulan_label'];
			$tahun = $_POST['tahun'];
			$klinik_label = $_POST['klinik_label'];
			$data = json_decode($_POST['d_data'], true);
			$num_rows = $_POST['num_rows'];
			$num_columns = $_POST['num_columns'] + 1;
			$last_column = $num_columns > 26 ? "A" . chr(64 + ($num_columns % 26) - 1) : chr(64 + $num_columns - 1);

			require_once ("smis-libs-out/php-excel/PHPExcel.php");

			$file = new PHPExcel();			
			$sheet = $file->getActiveSheet();
			$sheet->setTitle("Laporan Prolanis");
			$i = 1;

			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Laporan Pelayanan Non-Kapitasi");
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "GDS, GDP, dan GDPP Peserta Prolanis / Rujuk Balik");
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "CASA MEDICAL " . $klinik_label);
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Bulan Pelayanan " . $bulan_label . " Tahun " . $tahun);
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 2;

			$border_start = $i;
			$col = 65;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "No.");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("No.") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Nama Pasien/Peserta");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nama Pasien/Peserta") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Tanggal Pelayanan");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Tanggal Pelayanan") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Nomor Kartu BPJS Kesehatan");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nomor Kartu BPJS Kesehatan") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Alamat dan No. Telp. Pasien");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Alamat dan No. Telp. Pasien") + 5);
			$col++;
			$sub_col = $col;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col + 3) . $i)->setCellValue(chr($col) . $i, "Hasil Pemeriksaan");
			$col+=4;
			$sheet->setCellValue(chr($sub_col) . ($i + 1), "GDS");
			$sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("GDS") + 5);
			$sub_col++;
			$sheet->setCellValue(chr($sub_col) . ($i + 1), "GDP");
			$sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("GDP") + 5);
			$sub_col++;
			$sheet->setCellValue(chr($sub_col) . ($i + 1), "GDPP");
			$sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("GDPP") + 5);
			$sub_col++;
			$sheet->setCellValue(chr($sub_col) . ($i + 1), "Tek. Darah");
			$sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Tek. Darah") + 5);
			$sub_col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Diagnosa");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Diagnosa") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Teraphy");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Teraphy") + 5);
			$col++;
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getFont()->setBold(true);
			$i = $i + 2;

			if (count($data) > 0) {
				foreach ($data as $d) {
					if (count($d) > 0) {
						$col = 65;
						foreach ($d as $c) {
							$sheet->setCellValue(chr($col) . $i, $c);
							if ($col == 74 || $col == 75)
								$sheet->getStyle(chr($col) . $i)->getAlignment()->setWrapText(true);
							$col++;
						}
						$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);
						$i = $i + 1;
					}
				}
			}

			$thin = array();
			$thin['borders'] = array();
			$thin['borders']['allborders'] = array();
			$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
			$sheet->getStyle("A" . $border_start . ":" . $last_column . ($i - 1))->applyFromArray($thin);

			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Laporan Pelayanan Non-Kapitasi Prolanis - ' . $klinik_label . ' - ' . $bulan_label . ' ' . $tahun . '.xls"');
			header('Cache-Control: max-age=0');
			$writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
			$writer->save('php://output');
		}
		return;
	}

	$laporan_form = new Form("", "", "Laporan Pelayanan Non-Kapitasi Prolanis");
	$bulan_option = new OptionBuilder();
	if (date("m") == 1)
		$bulan_option->add("Januari", "1", "1");
	else
		$bulan_option->add("Januari", "1");
	if (date("m") == 2)
		$bulan_option->add("Februari", "2", "1");
	else
		$bulan_option->add("Februari", "2");
	if (date("m") == 3)
		$bulan_option->add("Maret", "3", "1");
	else
		$bulan_option->add("Maret", "3");
	if (date("m") == 4)
		$bulan_option->add("April", "4", "1");
	else
		$bulan_option->add("April", "4");
	if (date("m") == 5)
		$bulan_option->add("Mei", "5", "1");
	else
		$bulan_option->add("Mei", "5");
	if (date("m") == 6)
		$bulan_option->add("Juni", "6", "1");
	else
		$bulan_option->add("Juni", "6");
	if (date("m") == 7)
		$bulan_option->add("Juli", "7", "1");
	else
		$bulan_option->add("Juli", "7");
	if (date("m") == 8)
		$bulan_option->add("Agustus", "8", "1");
	else
		$bulan_option->add("Agustus", "8");
	if (date("m") == 9)
		$bulan_option->add("September", "9", "1");
	else
		$bulan_option->add("September", "9");
	if (date("m") == 10)
		$bulan_option->add("Oktober", "10", "1");
	else
		$bulan_option->add("Oktober", "10");
	if (date("m") == 11)
		$bulan_option->add("Nopember", "11", "1");
	else
		$bulan_option->add("Nopember", "11");
	if (date("m") == 12)
		$bulan_option->add("Desember", "12", "1");
	else
		$bulan_option->add("Desember", "12");
	$bulan_select = new Select("lp_bulan", "lp_bulan", $bulan_option->getContent());
	$laporan_form->addElement("Bulan", $bulan_select);

	$tahun_rows = $db->get_result("
		SELECT DISTINCT YEAR(tanggal) tahun
		FROM smis_mr_prolanis
		WHERE prop = '' AND YEAR(tanggal) > 0
		ORDER BY YEAR(tanggal) ASC
	");
	$tahun_option = new OptionBuilder();
	if ($tahun_rows != null) {
		foreach ($tahun_rows as $tahun_row) {
			if (date("Y") == $tahun_row->tahun)
				$tahun_option->add($tahun_row->tahun, $tahun_row->tahun, "1");
			else
				$tahun_option->add($tahun_row->tahun, $tahun_row->tahun);
		}
	}
	$tahun_select = new Select("lp_tahun", "lp_tahun", $tahun_option->getContent());
	$laporan_form->addElement("Tahun", $tahun_select);
	$klinik_rows = $db->get_result("
		SELECT DISTINCT origin
		FROM smis_mr_prolanis
		WHERE prop = '' AND origin IS NOT NULL AND origin NOT LIKE ''
		ORDER BY origin ASC
	");
	$klinik_option = new OptionBuilder();
	$klinik_option->add("SEMUA CABANG", "%%", "1");
	if ($klinik_rows != null) {
		foreach ($klinik_rows as $klinik_row)
			$klinik_option->add(ArrayAdapter::format("unslug", $klinik_row->origin), $klinik_row->origin);
	}
	$klinik_select = new Select("lp_klinik", "lp_klinik", $klinik_option->getContent());
	$laporan_form->addElement("Klinik", $klinik_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lp.view()");
	$download_button = new Button("", "", "Unduh");
	$download_button->setClass("btn-inverse");
	$download_button->setIcon("fa fa-download");
	$download_button->setIsButton(Button::$ICONIC);
	$download_button->setAtribute("id='export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($download_button);
	$laporan_form->addElement("", $btn_group);

	$loading_bar = new LoadingBar("loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lp.cancel()");
	$loading_modal = new Modal("loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);
	
	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo "</div>";
	echo "<div id='info'>";
	echo 	"<div class='alert alert-block alert-inverse'>";
	echo 		"<center><strong>DATA BELUM DIPROSES</strong></center>";
	echo 	"</div>";
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	var lp;
	var jumlah_kolom;
	var FINISHED;
	$(document).ready(function (){
		lp = new TableAction(
			"lp",
			"medical_record",
			"laporan_prolanis",
			new Array()
		);
		lp.view = function() {
			$("#info").empty();
			$("#loading_bar").sload("true", "Harap ditunggu...", 0);
			$("#loading_modal").smodal("show");
			FINISHED = false;
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "initiate_table";
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("#table_content").html(json.html);
					jumlah_kolom = json.jumlah_kolom;
					data = self.getRegulerData();
					data['command'] = "get_jumlah";
					data['bulan'] = $("#lp_bulan").val();
					data['tahun'] = $("#lp_tahun").val();
					data['klinik'] = $("#lp_klinik").val();
					$("#loading_bar").sload("true", "Proses Pemuatan Jumlah Data");
					$.post(
						"",
						data,
						function(response_jumlah) {
							var json_jumlah = JSON.parse(response_jumlah);
							if (json_jumlah == null) return;
							self.fillHtml(0, json_jumlah.jumlah);
						}
					);
				}
			);
		};
		lp.fillHtml = function(num, limit) {
			if (FINISHED || num == limit) {
				if (FINISHED == false && num == limit) {
					this.finalize();
				} else {
					$("#loading_modal").smodal("hide");
					$("#info").html(
						"<div class='alert alert-block alert-inverse'>" +
							 "<center><strong>PROSES DIBATALKAN</strong></center>" +
						 "</div>"
					);
					$("#export_button").removeAttr("onclick");
				}
				return;
			}
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "get_info";
			data['num'] = num;
			data['bulan'] = $("#lp_bulan").val();
			data['tahun'] = $("#lp_tahun").val();
			data['klinik'] = $("#lp_klinik").val();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("tbody#lp_list").append(
						json.html
					);
					$("#loading_bar").sload("true", json.tanggal + " - " + json.nama_pasien + " (" + num + " / " + limit + ")", num * 100 / limit - 1);
					self.fillHtml(num + 1, limit);
				}
			);
		};
		lp.finalize = function() {
			$("#loading_modal").smodal("hide");
			$("#info").html(
				"<div class='alert alert-block alert-info'>" +
					 "<center><strong>PROSES SELESAI</strong></center>" +
				 "</div>"
			);
			$("#export_button").removeAttr("onclick");
			$("#export_button").attr("onclick", "lp.export_xls()");
		};
		lp.export_xls = function() {
			showLoading();
			var num_rows = $("#lp_list").children("tr").length;
			var num_columns = jumlah_kolom;
			var d_data = {};
			for (var i = 0; i < num_rows; i++) {
				d_data[i] = {};
				for (var j = 0; j < num_columns; j++)
					d_data[i][j] = $("tbody#lp_list tr:eq(" + i + ") td:eq(" + j + ")").text();
			}
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			data['bulan'] = $("#lp_bulan").val();
			data['bulan_label'] = $("#lp_bulan option:selected").text();
			data['tahun'] = $("#lp_tahun").val();
			data['klinik_label'] = $("#lp_klinik option:selected").text();
			data['d_data'] = JSON.stringify(d_data);
			data['num_rows'] = num_rows;
			data['num_columns'] = num_columns;
			postForm(data);
			dismissLoading();
		};
		lp.cancel = function() {
			FINISHED = true;
		};
		$("#loading_modal > div.modal-header > a").remove();
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		});
	});
</script>