<?php
	global $db;

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "initiate_table") {
			$html = "";

			$header_html_1 =	"<tr>" .
									"<th rowspan='2'>No.</th>" .
									"<th rowspan='2'>Nama Pasien/Peserta</th>" .
									"<th rowspan='2'>Nomor Kartu BPJS Kesehatan</th>" .
									"<th rowspan='2'>Umur</th>" .
									"<th colspan='4'>Status</th>" .
									"<th rowspan='2'>Alamat dan No. Telp. Pasien</th>" .
									"<th rowspan='2'>Tanggal Pelayanan</th>" .
									"<th rowspan='2'>Nama Tenaga Medis</th>" .
									"<th rowspan='2'>Jenis Pelayanan</th>" .
									"<th rowspan='2'>Jumlah Biaya</th>" .
								"</tr>";
			$header_html_2 =	"<tr>" .
									"<th>P</th>" .
									"<th>I</th>" .
									"<th>S</th>" .
									"<th>A</th>" .
								"</tr>";
			
			$columns = array("No.", "Nama Pasien", "No. BPJS", "Umur", "Status P", "Status I", "Status S", "Status A", "Alamat", "Tanggal Pelayanan", "Nama Tenaga Medis", "Jenis Pelayanan", "Jumlah Biaya");

			$table = new Table($columns, "", null, true);
			$table->setName("lmn");
			$table->setAction(false);
			$table->setFooterVisible(false);
			$table->setHeaderVisible(false);
			$table->addHeader("before", $header_html_1 . $header_html_2);
			$html = $table->getHtml();

			$data = array(
				'html'				=> $html,
				'jumlah_kolom'		=> count($columns)
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_jumlah") {
			$bulan = $_POST['bulan'];
			$tahun = $_POST['tahun'];
			$klinik = $_POST['klinik'];
			$jumlah = 0;
			$row = $db->get_row("
				SELECT COUNT(*) jumlah
				FROM smis_mr_maternal_neonatal
				WHERE prop = '' AND MONTH(tanggal) = '" . $bulan . "' AND YEAR(tanggal) = '" . $tahun . "' AND origin LIKE '" . $klinik . "'
			");
			if ($row != null)
				$jumlah = $row->jumlah;
			$data = array(
				'jumlah' => $jumlah
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info") {
			$num = $_POST['num'];
			$bulan = $_POST['bulan'];
			$tahun = $_POST['tahun'];
			$klinik = $_POST['klinik'];

			$row = $db->get_row("
				SELECT a.*, b.umur
				FROM smis_mr_maternal_neonatal a LEFT JOIN smis_rg_layananpasien b ON a.noreg_pasien = b.id
				WHERE a.prop = '' AND MONTH(a.tanggal) = '" . $bulan . "' AND YEAR(a.tanggal) = '" . $tahun . "' AND a.origin LIKE '" . $klinik . "'
				ORDER BY a.tanggal ASC
				LIMIT " . $num . ", 1
			");
			$html = "";
			$tanggal = "";
			$nama_pasien = "";
			$jenis_layanan = "";
			if ($row != null) {
				$tanggal = ArrayAdapter::format("date d/m/Y", $row->tanggal);
				$nama_pasien = $row->nama_pasien;
				$jenis_layanan = $row->jenis_layanan;
				$umur = "N/A";
				if (strlen($row->umur) > 0 && $row->umur != "TGL LAHIR TDK VALID") {
					$parts = explode(" Tahun", $row->umur);
					if (count($parts) > 1)
						$umur = $parts[0];
					else
						$umur = 0;
				}
				$status_p = $row->status == "P" ? "V" : "";
				$status_i = $row->status == "I" ? "V" : "";
				$status_s = $row->status == "S" ? "V" : "";
				$status_a = $row->status == "A" ? "V" : "";
				$html = "<tr>" .
							"<td>" . ($num + 1) . "</td>" .
							"<td>" . $row->nama_pasien . "</td>" .
							"<td>" . $row->no_bpjs . "</td>" .
							"<td>" . $umur . "</td>" .
							"<td>" . $status_p . "</td>" .
							"<td>" . $status_i . "</td>" .
							"<td>" . $status_s . "</td>" .
							"<td>" . $status_a . "</td>" .
							"<td>" . $row->alamat_pasien . "</td>" .
							"<td>" . ArrayAdapter::format("date d/m/Y", $row->tanggal) . "</td>" .
							"<td>" . $row->tenaga_medis . "</td>" .
							"<td>" . $row->jenis_layanan . "</td>" .
							"<td>" . ArrayAdapter::format("money", $row->biaya) . "</td>" .
						"</tr>";
			}
			
			$data = array(
				'html' 			=> $html,
				'nama_pasien'	=> $nama_pasien,
				'tanggal'		=> $tanggal,
				'jenis_layanan'	=> $jenis_layanan
			);
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$bulan = $_POST['bulan'];
			$bulan_label = $_POST['bulan_label'];
			$tahun = $_POST['tahun'];
			$klinik_label = $_POST['klinik_label'];
			$data = json_decode($_POST['d_data'], true);
			$num_rows = $_POST['num_rows'];
			$num_columns = $_POST['num_columns'] + 1;
			$last_column = $num_columns > 26 ? "A" . chr(64 + ($num_columns % 26) - 1) : chr(64 + $num_columns - 1);

			require_once ("smis-libs-out/php-excel/PHPExcel.php");

			$file = new PHPExcel();			
			$sheet = $file->getActiveSheet();
			$sheet->setTitle("Laporan Maternal - Neonatal");
			$i = 1;

			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Laporan Pelayanan Non-Kapitasi");
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Maternal dan Neonatal");
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "CASA MEDICAL " . $klinik_label);
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Bulan Pelayanan " . $bulan_label . " Tahun " . $tahun);
			$sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 2;

			$border_start = $i;
			$col = 65;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "No.");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("No.") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Nama Pasien/Peserta");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nama Pasien/Peserta") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Nomor Kartu BPJS Kesehatan");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nomor Kartu BPJS Kesehatan") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Umur");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Umur") + 5);
			$col++;
			$sub_col = $col;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col + 3) . $i)->setCellValue(chr($col) . $i, "Status");
			$col+=4;
			$sheet->setCellValue(chr($sub_col) . ($i + 1), "P");
			$sub_col++;
			$sheet->setCellValue(chr($sub_col) . ($i + 1), "I");
			$sub_col++;
			$sheet->setCellValue(chr($sub_col) . ($i + 1), "S");
			$sub_col++;
			$sheet->setCellValue(chr($sub_col) . ($i + 1), "A");
			$sub_col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Alamat dan No. Telp. Pasien");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Alamat dan No. Telp. Pasien") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Tanggal Pelayanan");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Tanggal Pelayanan") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Nama Tenaga Medis");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nama Tenaga Medis") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Jenis Pelayanan");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Jenis Pelayanan") + 5);
			$col++;
			$sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Jumlah Biaya");
			$sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Jumlah Biaya") + 5);
			$col++;
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getFont()->setBold(true);
			$i = $i + 2;

			if (count($data) > 0) {
				foreach ($data as $d) {
					if (count($d) > 0) {
						$col = 65;
						foreach ($d as $c) {
							$sheet->setCellValue(chr($col) . $i, $c);							
							if ($col >= 69 && $col <= 72)
								$sheet->getStyle(chr($col) . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
							$col++;
						}
						$i = $i + 1;
					}
				}
			}

			$thin = array();
			$thin['borders'] = array();
			$thin['borders']['allborders'] = array();
			$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
			$sheet->getStyle("A" . $border_start . ":" . $last_column . ($i - 1))->applyFromArray($thin);

			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Laporan Pelayanan Non-Kapitasi Maternal Neonatal - ' . $klinik_label . ' - ' . $bulan_label . ' ' . $tahun . '.xls"');
			header('Cache-Control: max-age=0');
			$writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
			$writer->save('php://output');
		}
		return;
	}

	$laporan_form = new Form("", "", "Laporan Pelayanan Non-Kapitasi Maternal - Neonatal");
	$bulan_option = new OptionBuilder();
	if (date("m") == 1)
		$bulan_option->add("Januari", "1", "1");
	else
		$bulan_option->add("Januari", "1");
	if (date("m") == 2)
		$bulan_option->add("Februari", "2", "1");
	else
		$bulan_option->add("Februari", "2");
	if (date("m") == 3)
		$bulan_option->add("Maret", "3", "1");
	else
		$bulan_option->add("Maret", "3");
	if (date("m") == 4)
		$bulan_option->add("April", "4", "1");
	else
		$bulan_option->add("April", "4");
	if (date("m") == 5)
		$bulan_option->add("Mei", "5", "1");
	else
		$bulan_option->add("Mei", "5");
	if (date("m") == 6)
		$bulan_option->add("Juni", "6", "1");
	else
		$bulan_option->add("Juni", "6");
	if (date("m") == 7)
		$bulan_option->add("Juli", "7", "1");
	else
		$bulan_option->add("Juli", "7");
	if (date("m") == 8)
		$bulan_option->add("Agustus", "8", "1");
	else
		$bulan_option->add("Agustus", "8");
	if (date("m") == 9)
		$bulan_option->add("September", "9", "1");
	else
		$bulan_option->add("September", "9");
	if (date("m") == 10)
		$bulan_option->add("Oktober", "10", "1");
	else
		$bulan_option->add("Oktober", "10");
	if (date("m") == 11)
		$bulan_option->add("Nopember", "11", "1");
	else
		$bulan_option->add("Nopember", "11");
	if (date("m") == 12)
		$bulan_option->add("Desember", "12", "1");
	else
		$bulan_option->add("Desember", "12");
	$bulan_select = new Select("lmn_bulan", "lmn_bulan", $bulan_option->getContent());
	$laporan_form->addElement("Bulan", $bulan_select);

	$tahun_rows = $db->get_result("
		SELECT DISTINCT YEAR(tanggal) tahun
		FROM smis_mr_maternal_neonatal
		WHERE prop = '' AND YEAR(tanggal) > 0
		ORDER BY YEAR(tanggal) ASC
	");
	$tahun_option = new OptionBuilder();
	if ($tahun_rows != null) {
		foreach ($tahun_rows as $tahun_row) {
			if (date("Y") == $tahun_row->tahun)
				$tahun_option->add($tahun_row->tahun, $tahun_row->tahun, "1");
			else
				$tahun_option->add($tahun_row->tahun, $tahun_row->tahun);
		}
	}
	$tahun_select = new Select("lmn_tahun", "lmn_tahun", $tahun_option->getContent());
	$laporan_form->addElement("Tahun", $tahun_select);
	$klinik_rows = $db->get_result("
		SELECT DISTINCT origin
		FROM smis_mr_maternal_neonatal
		WHERE prop = '' AND origin IS NOT NULL AND origin NOT LIKE ''
		ORDER BY origin ASC
	");
	$klinik_option = new OptionBuilder();
	$klinik_option->add("SEMUA CABANG", "%%", "1");
	if ($klinik_rows != null) {
		foreach ($klinik_rows as $klinik_row)
			$klinik_option->add(ArrayAdapter::format("unslug", $klinik_row->origin), $klinik_row->origin);
	}
	$klinik_select = new Select("lmn_klinik", "lmn_klinik", $klinik_option->getContent());
	$laporan_form->addElement("Klinik", $klinik_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lmn.view()");
	$download_button = new Button("", "", "Unduh");
	$download_button->setClass("btn-inverse");
	$download_button->setIcon("fa fa-download");
	$download_button->setIsButton(Button::$ICONIC);
	$download_button->setAtribute("id='export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($download_button);
	$laporan_form->addElement("", $btn_group);

	$loading_bar = new LoadingBar("loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lmn.cancel()");
	$loading_modal = new Modal("loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);
	
	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo "</div>";
	echo "<div id='info'>";
	echo 	"<div class='alert alert-block alert-inverse'>";
	echo 		"<center><strong>DATA BELUM DIPROSES</strong></center>";
	echo 	"</div>";
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	var lmn;
	var jumlah_kolom;
	var FINISHED;
	$(document).ready(function (){
		lmn = new TableAction(
			"lmn",
			"medical_record",
			"laporan_maternal_neonatal",
			new Array()
		);
		lmn.view = function() {
			$("#info").empty();
			$("#loading_bar").sload("true", "Harap ditunggu...", 0);
			$("#loading_modal").smodal("show");
			FINISHED = false;
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "initiate_table";
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("#table_content").html(json.html);
					jumlah_kolom = json.jumlah_kolom;
					data = self.getRegulerData();
					data['command'] = "get_jumlah";
					data['bulan'] = $("#lmn_bulan").val();
					data['tahun'] = $("#lmn_tahun").val();
					data['klinik'] = $("#lmn_klinik").val();
					$("#loading_bar").sload("true", "Proses Pemuatan Jumlah Data");
					$.post(
						"",
						data,
						function(response_jumlah) {
							var json_jumlah = JSON.parse(response_jumlah);
							if (json_jumlah == null) return;
							self.fillHtml(0, json_jumlah.jumlah);
						}
					);
				}
			);
		};
		lmn.fillHtml = function(num, limit) {
			if (FINISHED || num == limit) {
				if (FINISHED == false && num == limit) {
					this.finalize();
				} else {
					$("#loading_modal").smodal("hide");
					$("#info").html(
						"<div class='alert alert-block alert-inverse'>" +
							 "<center><strong>PROSES DIBATALKAN</strong></center>" +
						 "</div>"
					);
					$("#export_button").removeAttr("onclick");
				}
				return;
			}
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "get_info";
			data['num'] = num;
			data['bulan'] = $("#lmn_bulan").val();
			data['tahun'] = $("#lmn_tahun").val();
			data['klinik'] = $("#lmn_klinik").val();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("tbody#lmn_list").append(
						json.html
					);
					$("#loading_bar").sload("true", json.tanggal + " - " + json.nama_pasien + " - " + json.jenis_layanan + " (" + num + " / " + limit + ")", num * 100 / limit - 1);
					self.fillHtml(num + 1, limit);
				}
			);
		};
		lmn.finalize = function() {
			$("#loading_modal").smodal("hide");
			$("#info").html(
				"<div class='alert alert-block alert-info'>" +
					 "<center><strong>PROSES SELESAI</strong></center>" +
				 "</div>"
			);
			$("#export_button").removeAttr("onclick");
			$("#export_button").attr("onclick", "lmn.export_xls()");
		};
		lmn.export_xls = function() {
			showLoading();
			var num_rows = $("#lmn_list").children("tr").length;
			var num_columns = jumlah_kolom;
			var d_data = {};
			for (var i = 0; i < num_rows; i++) {
				d_data[i] = {};
				for (var j = 0; j < num_columns; j++)
					d_data[i][j] = $("tbody#lmn_list tr:eq(" + i + ") td:eq(" + j + ")").text();
			}
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			data['bulan'] = $("#lmn_bulan").val();
			data['bulan_label'] = $("#lmn_bulan option:selected").text();
			data['tahun'] = $("#lmn_tahun").val();
			data['klinik_label'] = $("#lmn_klinik option:selected").text();
			data['d_data'] = JSON.stringify(d_data);
			data['num_rows'] = num_rows;
			data['num_columns'] = num_columns;
			postForm(data);
			dismissLoading();
		};
		lmn.cancel = function() {
			FINISHED = true;
		};
		$("#loading_modal > div.modal-header > a").remove();
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		});
	});
</script>