<?php 
global $db;

/*this is respond when system have to response*/
if(isset($_POST['command'])){	
	if ($_POST['command'] == "list") {
		require_once("medical_record/snippet/get_detail_laporan_kunjungan_html.php");
	} else if ($_POST['command'] == "excel") {
		require_once("medical_record/snippet/create_excel_laporan_kunjungan.php");
	}
	return;
}

$header		= array("No.","Nama","NRM","No. BPJS","L/P","Tanggal","Alamat","Kecamatan","Cara Bayar","PPK","No. Telp","Jenis Kunjungan","Ruangan","Dokter Rawat Jalan", "Nama Diagnosa", "Jenis Diagnosa", "Dirujuk ke Poli", "Dirujuk ke RS","Pulang","Perusahaan","Asuransi","Asal Data");

$uitable = new Report($header,"", NULL);
$uitable ->setName("laporan_kunjungan_pasien")
		 ->setFooterVisible(false);

/**jenis pasien */
$jenis  			= new DBTable($db,"smis_rg_jenispasien");
$jenis  			->setShowAll(true);
$jenis  			->setOrder(" nama ASC ");
$data				= $jenis->view("","0");
$jenis_adapter		= new SelectAdapter("nama", "slug");
$jenis_pembayaran	= $jenis_adapter->getContent($data['data']);
$jenis_pembayaran[]	= array("name"=>"--- SEMUA ---","value"=>"%");

$query="SELECT DISTINCT unit_kerja FROM smis_rg_layananpasien WHERE prop!='del' ORDER BY unit_kerja ASC ";

$unit_kerja=new OptionBuilder();
$unit_kerja->add(" - Semua - ","%",1);
$res=$db->get_result($query);
foreach($res as $x){
    if($x->unit_kerja==""){
        continue;
    }
    $unit_kerja->add(ArrayAdapter::slugFormat("unslug",$x->unit_kerja),$x->unit_kerja);
}

require_once 'smis-base/smis-include-service-consumer.php';
require_once 'registration/class/RegistrationResource.php';
$content	= RegistrationResource::getURJIP($db);
foreach ($content as $autonomous=>$ruang){
	foreach($ruang as $nama_ruang=>$jip){
		if($jip[$nama_ruang]=="URJ" || $jip[$nama_ruang]=="UP" || $jip[$nama_ruang]=="URJI"){
			$option			 	 = array();
			$option['value'] 	 = $nama_ruang;
			if(isset($jip['name'])){
				$option['name']	 = $jip['name'];
			}else{
				$option['name']	 = ArrayAdapter::format("unslug", $nama_ruang);
			}
			$urj[]			 = $option;
		}
	}
}
$urj[]		= array("name"=>"","value"=>"%","default"=>"1");

/*This is Modal Form and used for add and edit the table*/
$mcolumn	= array("carabayar","unit_kerja", "jenislayanan");
$mname		= array("Cara Bayar","Asal Data", "Ruangan");
$mtype		= array("select","select","select");
$mvalue		= array($jenis_pembayaran,$unit_kerja->getContent(),$urj);
$uitable	->setModal($mcolumn, $mtype, $mname, $mvalue);

$modal = $uitable->getAdvanceModal();
$modal ->setTitle("Laporan Pendaftaran Pasien");
$form  = $modal->getForm();


$view   = new Button("","","Search");
$view   ->setClass("btn btn-primary")
	->setIcon(" fa fa-search")
	->setIsButton(Button::$ICONIC_TEXT)
	->setAction("laporan_kunjungan_pasien.view()");
$form	->addElement("",$view);

$excel   = new Button("","","Download Excel");
$excel   ->setClass("btn btn-primary")
	->setIcon(" fa fa-file-excel-o")
	->setIsButton(Button::$ICONIC_TEXT)
	->setAction("laporan_kunjungan_pasien.excel()");
$form	->addElement("",$excel);

echo "<div>".$form->getHtml()."</div>";
echo "<div class='clear line'></div>";
echo "<div>".$uitable->getHtml()."</div>";
echo addCSS ("framework/bootstrap/css/datepicker.css");
echo addJS  ("framework/smis/js/table_action.js");
echo addJS  ("framework/smis/js/report_action.js");
echo addJS  ("framework/bootstrap/js/bootstrap-datepicker.js");
echo addJS  ("medical_record/resource/js/laporan_kunjungan_pasien.js",false);
echo addCSS ("medical_record/resource/css/laporan_kunjungan_pasien.css",false);