<?php 
	require_once("smis-base/smis-include-service-consumer.php");
	global $db;

	$dokter_table = new Table(
		array("Nama", "Jabatan"),
		"",
		null,
		true
	);
	$dokter_table->setName("lid_dokter");
	$dokter_table->setModel(Table::$SELECT);
	$dokter_adapter = new SimpleAdapter();
	$dokter_adapter->add("Nama", "nama");
	$dokter_adapter->add("Jabatan", "nama_jabatan");
	class DokterServiceResponder extends ServiceResponder {
		public function getData() {
			$data = $_POST;
			if (isset($_POST['kriteria']) && $_POST['kriteria'] != "") {
				$kriteria = array(
						"multiple_kriteria"	=> 	array(
							"nip"		=> $_POST['kriteria'],
							"nama"		=> $_POST['kriteria'],
							"jabatan"	=> "dokter"
						)
				);
				$data['kriteria'] = json_encode($kriteria);
			} else {
				$data['kriteria'] = "dokter";
			}
			return $data;
		}
	}
	$dokter_service_responder = new DokterServiceResponder(
		$db, 
		$dokter_table, 
		$dokter_adapter,
		"employee"
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("lid_dokter", $dokter_service_responder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	$table = new Table(
		array("No.", "No. Reg.", "No. RM", "Nama Pasien", "Tanggal Lahir", "Tanggal Kunjungan", "Ruangan", "Jenis Kelamin", "Diagnosis", "Dokter"),
		"",
		null,
		true
	);
	$table->setName("lap_index_dokter");
	$table->setAction(false);

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$nama_dokter = $_POST['nama_dokter'];
			if ($nama_dokter == "")
				$nama_dokter = "%%";
			$label_dokter = $nama_dokter;
            if ($label_dokter == "%%")
            	$label_dokter = "Semua";
			$uri = $_POST['uri'];
			$label_uri = $_POST['label_uri'];

			require_once ("smis-libs-out/php-excel/PHPExcel.php");

			$file = new PHPExcel();
			$file->getProperties()->setCreator("PT. Inovasi Ide Utama");
			$file->getProperties()->setTitle("Laporan Index - Dokter " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s.d. " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']) . " Dokter - " . $label_dokter . " URJI - " . $label_uri);
			$file->getProperties()->setSubject("Laporan Index - Dokter " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s.d. " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']) . " Dokter - " . $label_dokter . " URJI - " . $label_uri);
			$file->getProperties()->setDescription("Laporan Index - Dokter " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s.d. " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']) . " Dokter - " . $label_dokter . " URJI - " . $label_uri . " Generated by System");
			$file->getProperties()->setKeywords("Laporan Index - Dokter " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s.d. " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']) . " Dokter - " . $label_dokter . " URJI - " . $label_uri);
			$file->getProperties()->setCategory("Laporan Index - Dokter " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s.d. " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']) . " Dokter - " . $label_dokter . " URJI - " . $label_uri);

			$sheet = $file->getActiveSheet();
			$sheet->setTitle("Laporan Index - Dokter");
			$i = 1;
            $sheet->mergeCells("A" . $i . ":J" . $i)->setCellValue("A" . $i, "Laporan Index - Dokter");
            $sheet->getStyle("A" . $i . ":J" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i)->getFont()->setBold(true);
            $i = $i + 1;
            $sheet->mergeCells("A" . $i . ":J" . $i)->setCellValue("A" . $i, getSettings($db, "smis_autonomous_title", "RUMAH SAKIT/KLINIK"));
            $sheet->getStyle("A" . $i . ":J" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i)->getFont()->setBold(true);
            $i = $i + 2;
            $sheet->setCellValue("B" . $i, "Periode");
            $sheet->getStyle("B" . $i)->getFont()->setBold(true);
            $sheet->setCellValue("C" . $i, ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s.d. " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']));
            $sheet->getStyle("C" . $i)->getFont()->setBold(true);
            $sheet->getStyle("C" . $i)->getAlignment()->applyFromArray(
                array(
                    'horizontal'    => "left"
                )
            );
            $i = $i + 1;
            $sheet->setCellValue("B" . $i, "Dokter");
            $sheet->getStyle("B" . $i)->getFont()->setBold(true);            
            $sheet->setCellValue("C" . $i, $label_dokter);
            $sheet->getStyle("C" . $i)->getFont()->setBold(true);
            $sheet->getStyle("C" . $i)->getAlignment()->applyFromArray(
                array(
                    'horizontal'    => "left"
                )
            );
            $i = $i + 1;
            $sheet->setCellValue("B" . $i, "Rawat Jalan/Inap");
            $sheet->getStyle("B" . $i)->getFont()->setBold(true);            
            $sheet->setCellValue("C" . $i, $label_uri);
            $sheet->getStyle("C" . $i)->getFont()->setBold(true);
            $sheet->getStyle("C" . $i)->getAlignment()->applyFromArray(
                array(
                    'horizontal'    => "left"
                )
            );
            $i = $i + 2;
            $border_start = $i;
            
            $sheet->setCellValue("A" . $i, "No.");
            $sheet->setCellValue("B" . $i, "No. Reg.");
            $sheet->setCellValue("C" . $i, "No. RM");
            $sheet->setCellValue("D" . $i, "Nama Pasien");
            $sheet->setCellValue("E" . $i, "Tanggal Lahir");
            $sheet->setCellValue("F" . $i, "Tanggal Kunjungan");
            $sheet->setCellValue("G" . $i, "Ruangan");
            $sheet->setCellValue("H" . $i, "Jenis Kelamin");
            $sheet->setCellValue("I" . $i, "Diagnosis");
            $sheet->setCellValue("J" . $i, "Dokter");
            $sheet->getStyle("A" . $i . ":J" . $i)->getAlignment()->applyFromArray(
                array(
                    'horizontal'    => "center",
                    'vertical'      => "center"
                )
            );
            $sheet->getStyle("A" . $i . ":J" . $i)->getFont()->setBold(true);
            $i = $i + 1;

            $detail_rows = $db->get_result("
                SELECT id, noreg_pasien, nrm_pasien, nama_pasien, tgl_lahir, tgl_masuk, ruangan, jk, CONCAT(kode_icd, ' - ', nama_icd) diagnosis, id_dokter, nama_dokter
				FROM smis_mr_diagnosa
				WHERE id IN (
					SELECT MAX(id) id
					FROM smis_mr_diagnosa 
					WHERE prop = '' AND tgl_masuk >= '" . $tanggal_from . "' AND tgl_masuk <= '" . $tanggal_to . "' AND nama_dokter LIKE '" . $nama_dokter . "' AND urji LIKE '" . $uri . "'
					GROUP BY noreg_pasien
				)
				ORDER BY nama_dokter ASC, tgl_masuk ASC
            ");

            if ($label_dokter == "Semua") {
	        	$nomor = 1;
	        	$huruf = "A";
	        	$nama_dokter_sebelumnya = "";
	        	$first = true;
				foreach ($detail_rows as $d) {
					if ($nama_dokter_sebelumnya != $d->nama_dokter) {
						if ($first)
							$first = false;
						else {
							$sheet->mergeCells("A" . $i . ":J" . $i)->setCellValue("A" . $i, "");
							$i = $i + 1;
						}
						$sheet->setCellValue("A" . $i, $huruf++);
						$sheet->mergeCells("B" . $i . ":J" . $i)->setCellValue("B" . $i, $d->nama_dokter);
			            $sheet->getStyle("A" . $i . ":J" . $i)->getFont()->setBold(true);
						$i = $i + 1;
						$nomor = 1;
					}
					$sheet->setCellValue("A" . $i, $nomor);
					$sheet->setCellValue("B" . $i, ArrayAdapter::format("only-digit6", $d->noreg_pasien));
					$sheet->setCellValue("C" . $i, ArrayAdapter::format("only-digit6", $d->nrm_pasien));
					$sheet->setCellValue("D" . $i, $d->nama_pasien);
					$sheet->setCellValue("E" . $i, ArrayAdapter::format("date d-m-Y", $d->tgl_lahir));
					$sheet->setCellValue("F" . $i, ArrayAdapter::format("date d-m-Y", $d->tgl_masuk));
					$sheet->setCellValue("G" . $i, ArrayAdapter::format("unslug", $d->ruangan));
					$sheet->setCellValue("H" . $i, ArrayAdapter::format("trivial_1_Perempuan_Laki-Laki", $d->jk));
					$sheet->setCellValue("I" . $i, $d->diagnosis);
					$sheet->setCellValue("J" . $i, $d->nama_dokter);
					$i = $i + 1;
	                $nomor++;
	                $nama_dokter_sebelumnya = $d->nama_dokter;
				}
			} else {
				$nomor = 1;
				foreach ($detail_rows as $d) {
					$sheet->setCellValue("A" . $i, $nomor);
					$sheet->setCellValue("B" . $i, ArrayAdapter::format("only-digit6", $d->noreg_pasien));
					$sheet->setCellValue("C" . $i, ArrayAdapter::format("only-digit6", $d->nrm_pasien));
					$sheet->setCellValue("D" . $i, $d->nama_pasien);
					$sheet->setCellValue("E" . $i, ArrayAdapter::format("date d-m-Y", $d->tgl_lahir));
					$sheet->setCellValue("F" . $i, ArrayAdapter::format("date d-m-Y", $d->tgl_masuk));
					$sheet->setCellValue("G" . $i, ArrayAdapter::format("unslug", $d->ruangan));
					$sheet->setCellValue("H" . $i, ArrayAdapter::format("trivial_1_Perempuan_Laki-Laki", $d->jk));
					$sheet->setCellValue("I" . $i, $d->diagnosis);
					$sheet->setCellValue("J" . $i, $d->nama_dokter);
					$i = $i + 1;
	                $nomor++;
				}
			}

            $border_end = $i - 1;
            $style = array();
            $style['borders'] = array();
            $style['borders']['allborders'] = array();
            $style['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
            $sheet->getStyle("A" . $border_start . ":J" . $border_end)->applyFromArray($style);
            $sheet->getStyle("A" . $border_start . ":J" . $border_end)->getFont()->setSize(10);

            $sheet->getColumnDimension('A')->setWidth(5);
            $sheet->getColumnDimension('B')->setWidth(23);
            $sheet->getColumnDimension('C')->setWidth(12);
            $sheet->getColumnDimension('D')->setWidth(40);
            $sheet->getColumnDimension('E')->setWidth(15);
            $sheet->getColumnDimension('F')->setWidth(18);
            $sheet->getColumnDimension('G')->setWidth(38);
            $sheet->getColumnDimension('H')->setWidth(14);
            $sheet->getColumnDimension('I')->setWidth(90);
            $sheet->getColumnDimension('J')->setWidth(30);

			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="Laporan Index - Dokter ' . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . ' s.d. ' . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']) . " Dokter - " . $label_dokter . " URJI - " . $label_uri . '.xls"');
			header('Cache-Control: max-age=0');
			$writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
			$writer->save('php://output');
			return;
		}

		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("No. Reg.", "noreg_pasien", "digit6");
		$adapter->add("No. RM", "nrm_pasien", "digit6");
		$adapter->add("Nama Pasien", "nama_pasien");
		$adapter->add("Tanggal Lahir", "tgl_lahir", "date d-m-Y");
		$adapter->add("Tanggal Kunjungan", "tgl_masuk", "date d-m-Y");
		$adapter->add("Ruangan", "ruangan", "unslug");
		$adapter->add("Jenis Kelamin", "jk", "trivial_1_Perempuan_Laki-Laki");
		$adapter->add("Diagnosis", "diagnosis");
		$adapter->add("Dokter", "nama_dokter");

		$dbtable = new DBTable($db, "smis_mr_diagnosa");
		
		$tanggal_from = $_POST['tanggal_from'];
		$tanggal_to = $_POST['tanggal_to'];
		$nama_dokter = $_POST['nama_dokter'];
		if ($nama_dokter == "")
			$nama_dokter = "%%";
		$uri = $_POST['uri'];
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter = " AND ( noreg_pasien LIKE '%" . $_POST['kriteria'] . "%' OR nrm_pasien LIKE '%" . $_POST['kriteria'] . "%' OR nama_pasien LIKE '%" . $_POST['kriteria'] . "%' OR kode_icd LIKE '%" . $_POST['kriteria']. "%' OR nama_icd LIKE '%" . $_POST['kriteria'] . "%' OR nama_dokter LIKE '%" . $_POST['kriteria'] . "%' ) ";
		}

		$query_value = "
			SELECT id, noreg_pasien, nrm_pasien, nama_pasien, tgl_lahir, tgl_masuk, ruangan, jk, CONCAT(kode_icd, ' - ', nama_icd) diagnosis, id_dokter, nama_dokter
			FROM smis_mr_diagnosa
			WHERE id IN (
				SELECT MAX(id) id
				FROM smis_mr_diagnosa 
				WHERE prop = '' AND tgl_masuk >= '" . $tanggal_from . "' AND tgl_masuk <= '" . $tanggal_to . "' AND nama_dokter LIKE '" . $nama_dokter . "' AND urji LIKE '" . $uri . "' " . $filter . "
				GROUP BY noreg_pasien
			)
			ORDER BY nama_dokter ASC, tgl_masuk ASC
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (" . $query_value . ") v
		";
		$dbtable->setPreferredQuery(true, $query_value, $query_count);

		$dbresponder = new DBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$form = new Form("ldi_form", "", "");
	$tanggal_from_text = new Text("lid_tanggal_from", "lid_tanggal_from", date("Y-m-") . "01");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$tanggal_from_text->setClass("mydate");
	$form->addElement("Dari", $tanggal_from_text);
	$tanggal_to_text = new Text("lid_tanggal_to", "lid_tanggal_to", date("Y-m-d"));
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$tanggal_to_text->setClass("mydate");
	$form->addElement("Sampai", $tanggal_to_text);
	$dokter_button = new Button("", "", "Pilih");
	$dokter_button->setClass("btn-info");
	$dokter_button->setIsButton(Button::$ICONIC);
	$dokter_button->setIcon("icon-white ".Button::$icon_list_alt);
	$dokter_button->setAction("lid_dokter.chooser('lid_dokter', 'lid_dokter_button', 'lid_dokter', lid_dokter, 'Dokter')");
	$dokter_button->setAtribute("id='lid_dokter_browse'");
	$delete_button = new Button("", "", "Hapus");
	$delete_button->setClass("btn-danger");
	$delete_button->setIsButton(Button::$ICONIC);
	$delete_button->setIcon("fa fa-times");
	$delete_button->setAction("lid_dokter.clear()");
	$delete_button->setAtribute("id='lid_dokter_clear'");
	$dokter_text = new Text("lid_nama_dokter", "lid_nama_dokter", "");
	$dokter_text->setAtribute("disabled='disabled'");
	$dokter_text->setClass("smis-two-option-input");
	$dokter_input_group = new InputGroup("");
	$dokter_input_group->addComponent($dokter_text);
	$dokter_input_group->addComponent($dokter_button);
	$dokter_input_group->addComponent($delete_button);
	$form->addElement("Dokter", $dokter_input_group);
	$uri_option = new OptionBuilder();
	$uri_option->add("Semua", "%%", "1");
	$uri_option->add("Rawat Jalan", "0");
	$uri_option->add("Rawat Inap", "1");
	$uri_select = new Select("lid_uri", "lid_uri", $uri_option->getContent());
	$form->addElement("Rawat Jalan/Inap", $uri_select);

	$button_group = new ButtonGroup("");
	$show_button = new Button("", "", "Tampilkan");
    $show_button->setClass("btn-info");
    $show_button->setAtribute("id='lid_show_button'");
    $show_button->setAction ("lap_index_dokter.view()");
    $button_group->addButton($show_button);
    $download_button = new Button("", "", "Download");
    $download_button->setClass("btn-inverse");
    $download_button->setAtribute("id='lid_download_button'");
    $download_button->setAction ( "lap_index_dokter.export_xls()" );
    $button_group->addButton($download_button);
    $form->addElement("", $button_group);

	echo $form->getHtml();
	echo $table->getHtml();
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("framework/smis/js/table_action.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>

<script type="text/javascript">
	var lap_index_dokter;
	var lid_dokter;
	$(document).ready(function() {
		$('.mydate').datepicker();
		lap_index_dokter = new TableAction(
			"lap_index_dokter",
			"medical_record",
			"laporan_indeks_dokter",
			new Array()
		);
		lap_index_dokter.getRegulerData = function() {
			var data = TableAction.prototype.getRegulerData.call(this);
			data['tanggal_from'] = $("#lid_tanggal_from").val();
			data['tanggal_to'] = $("#lid_tanggal_to").val();
			data['nama_dokter'] = $("#lid_nama_dokter").val();
			data['uri'] = $("#lid_uri").val();
			data['label_uri'] = $("#lid_uri option:selected").text();
			return data;
		};
		lap_index_dokter.export_xls = function() {
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			postForm(data);
		};
		lap_index_dokter.view();

		lid_dokter = new TableAction(
			"lid_dokter",
			"medical_record",
			"laporan_indeks_dokter",
			new Array()
		);
		lid_dokter.selected = function(json) {
			$("#lid_nama_dokter").val(json.nama);
		};
		lid_dokter.clear = function() {
			$("#lid_nama_dokter").val("");
		};
		lid_dokter.setSuperCommand("lid_dokter");
	});
</script>
<style type="text/css">
	#ldi_form label {
		width: 175px !important;
	}
</style>