<?php
global $db;

if (isset($_POST['command'])) {
    if ($_POST['command'] == "initiate_table") {
        $html = "";

        $header_html_1 =    "<tr>" .
            "<th rowspan='2'>No.</th>" .
            "<th colspan='10'>Identitas Bayi</th>" .
            "<th colspan='3'>Imunisasi I</th>" .
            "<th colspan='3'>Imunisasi II</th>" .
            "<th colspan='3'>Imunisasi III</th>" .
            "</tr>";
        $header_html_2 =    "<tr>" .
            "<th>Nama</th>" .
            "<th>Tanggal Lahir</th>" .
            "<th>Tempat Lahir</th>" .
            "<th>Nama Ibu</th>" .
            "<th>No. KTP Ibu</th>" .
            "<th>Jenis Kelamin (L/P)</th>" .
            "<th>Berat Lahir (kg)</th>" .
            "<th>Alamat</th>" .
            "<th>Desa/Kelurahan</th>" .
            "<th>No. Telp. Ibu</th>" .
            "<th>Jenis Imunisasi</th>" .
            "<th>Tanggal</th>" .
            "<th>Nama Tempat</th>" .
            "<th>Jenis Imunisasi</th>" .
            "<th>Tanggal</th>" .
            "<th>Nama Tempat</th>" .
            "<th>Jenis Imunisasi</th>" .
            "<th>Tanggal</th>" .
            "<th>Nama Tempat</th>" .
            "</tr>";

        $columns = array(
            "No.",
            "Nama", "Tanggal Lahir", "Tempat Lahir", "Nama Ibu", "No. KTP Ibu", "Jenis Kelamin", "Berat Lahir", "Alamat", "Desa Kelurahan", "No. Telp. Ibu",
            "Jenis Imunisasi I", "Tanggal I", "Tempat I",
            "Jenis Imunisasi II", "Tanggal II", "Tempat II",
            "Jenis Imunisasi III", "Tanggal III", "Tempat III"
        );

        $table = new Table($columns, "", null, true);
        $table->setName("lib");
        $table->setAction(false);
        $table->setFooterVisible(false);
        $table->setHeaderVisible(false);
        $table->addHeader("before", $header_html_1 . $header_html_2);
        $html = $table->getHtml();

        $data = array(
            'html'                => $html,
            'jumlah_kolom'        => count($columns)
        );
        echo json_encode($data);
    } else if ($_POST['command'] == "get_jumlah") {
        $tanggal_from = $_POST['tanggal_from'];
        $tanggal_to = $_POST['tanggal_to'];
        $jenis_imunisasi = $_POST['jenis_imunisasi'];
        $klinik = $_POST['klinik'];
        $jumlah = 0;
        $row = $db->get_row("
                SELECT 
                    COUNT(*) jumlah
                FROM ( 
                    SELECT 
                        DISTINCT nrm_pasien, nama_pasien, tanggal_lahir, tempat_lahir, nama_ibu, no_ktp_ibu, jk, berat_badan
                    FROM
                        smis_mr_imunisasi_bayi
                    WHERE 
                        prop = '' AND 
                        tanggal >= '" . $tanggal_from . "' AND 
                        tanggal <= '" . $tanggal_to . "' AND 
                        jenis_imunisasi LIKE '" . $jenis_imunisasi . "' AND 
                        origin LIKE '" . $klinik . "'
                ) v
			");
        if ($row != null)
            $jumlah = $row->jumlah;
        $data = array(
            'jumlah' => $jumlah
        );
        echo json_encode($data);
    } else if ($_POST['command'] == "get_info") {
        $tanggal_from = $_POST['tanggal_from'];
        $tanggal_to = $_POST['tanggal_to'];
        $jenis_imunisasi = $_POST['jenis_imunisasi'];
        $klinik = $_POST['klinik'];
        $num = $_POST['num'];
        $jumlah = 0;
        $row = $db->get_row("
            SELECT 
                nrm_pasien, nama_pasien, tanggal_lahir, tempat_lahir, nama_ibu, no_ktp_ibu, jk, berat_badan
            FROM ( 
                SELECT 
                    DISTINCT nrm_pasien, nama_pasien, tanggal_lahir, tempat_lahir, nama_ibu, no_ktp_ibu, jk, berat_badan
                FROM
                    smis_mr_imunisasi_bayi
                WHERE 
                    prop = '' AND 
                    tanggal >= '" . $tanggal_from . "' AND 
                    tanggal <= '" . $tanggal_to . "' AND 
                    jenis_imunisasi LIKE '" . $jenis_imunisasi . "' AND 
                    origin LIKE '" . $klinik . "'
            ) v
            LIMIT 
                " . $num . ", 1
        ");

        $html = "";
        $nrm_pasien = "";
        $nama_pasien = "";
        if ($row != null) {
            $nrm_pasien = $row->nrm_pasien;
            $nama_pasien = $row->nama_pasien;
            $tanggal_lahir = $row->tanggal_lahir;
            $tempat_lahir = $row->tempat_lahir;
            $nama_ibu = $row->nama_ibu;
            $no_ktp_ibu = $row->no_ktp_ibu;
            $jk = $row->jk;
            $berat_badan = $row->berat_badan;

            $alamat_pasien = "";
            $desa_kelurahan = "";
            $pasien_row = $db->get_row("
                    SELECT a.alamat, b.nama kelurahan
                    FROM smis_rg_patient a LEFT JOIN smis_rg_kelurahan b ON a.kelurahan = b.id
                    WHERE a.nrm = '" . $nrm_pasien . "'
                    LIMIT 0, 1
                ");
            if ($pasien_row != null) {
                $alamat_pasien = $pasien_row->alamat;
                $desa_kelurahan = $pasien_row->kelurahan;
            }

            $imunisasi_1 = array();
            $imunisasi_2 = array();
            $imunisasi_3 = array();
            $imunisasi_ke_arr = array('I', 'II', 'III');

            foreach ($imunisasi_ke_arr as $imunisasi_ke) {
                $rows = $db->get_result("
                        SELECT
                            tanggal, GROUP_CONCAT(
                                DISTINCT jenis_imunisasi
                                ORDER BY jenis_imunisasi ASC
                                SEPARATOR ' + '
                            ) jenis_imunisasi, origin
                        FROM 
                            smis_mr_imunisasi_bayi
                        WHERE
                            prop = '' AND 
                            tanggal >= '" . $tanggal_from . "' AND 
                            tanggal <= '" . $tanggal_to . "' AND 
                            imunisasi_ke = '" . $imunisasi_ke . "' AND 
                            nrm_pasien = '" . $nrm_pasien . "' AND
                            nama_pasien = '" . $nama_pasien . "' AND
                            tanggal_lahir = '" . $tanggal_lahir . "' AND
                            tempat_lahir = '" . $tempat_lahir . "' AND
                            nama_ibu = '" . $nama_ibu . "' AND
                            no_ktp_ibu = '" . $no_ktp_ibu . "' AND
                            jk = '" . $jk . "' AND
                            berat_badan = '" . $berat_badan . "' AND
                            origin LIKE '" . $klinik . "'
                        GROUP BY
                            tanggal, origin
                        ORDER BY
                            tanggal ASC
                    ");
                if ($rows != null) {
                    foreach ($rows as $r) {
                        $imunisasi = array(
                            'tanggal'           => $r->tanggal,
                            'jenis_imunisasi'   => $r->jenis_imunisasi,
                            'origin'            => $r->origin
                        );
                        if ($imunisasi_ke == "I")
                            $imunisasi_1[] = $imunisasi;
                        else if ($imunisasi_ke == "II")
                            $imunisasi_2[] = $imunisasi;
                        else if ($imunisasi_ke == "III")
                            $imunisasi_3[] = $imunisasi;
                    }
                }
            }
            if (count($imunisasi_1) > 0 || count($imunisasi_2) > 0 || count($imunisasi_3) > 0) {
                $is_first_row = true;
                $jk = $jk == 0 ? "L" : "P";
                $jumlah_baris = max(count($imunisasi_1), count($imunisasi_2), count($imunisasi_3));
                for ($i = 0; $i < $jumlah_baris; $i++) {
                    $jenis_imunisasi_1 = "";
                    $tanggal_imunisasi_1 = "";
                    $tempat_imunisasi_1 = "";
                    $jenis_imunisasi_2 = "";
                    $tanggal_imunisasi_2 = "";
                    $tempat_imunisasi_2 = "";
                    $jenis_imunisasi_3 = "";
                    $tanggal_imunisasi_3 = "";
                    $tempat_imunisasi_3 = "";

                    if (array_key_exists($i, $imunisasi_1)) {
                        $tanggal_imunisasi_1 = $imunisasi_1[$i]['tanggal'];
                        $jenis_imunisasi_1 = $imunisasi_1[$i]['jenis_imunisasi'];
                        $tempat_imunisasi_1 = $imunisasi_1[$i]['origin'];
                    }
                    if (array_key_exists($i, $imunisasi_2)) {
                        $tanggal_imunisasi_2 = $imunisasi_2[$i]['tanggal'];
                        $jenis_imunisasi_2 = $imunisasi_2[$i]['jenis_imunisasi'];
                        $tempat_imunisasi_2 = $imunisasi_2[$i]['origin'];
                    }
                    if (array_key_exists($i, $imunisasi_3)) {
                        $tanggal_imunisasi_3 = $imunisasi_3[$i]['tanggal'];
                        $jenis_imunisasi_3 = $imunisasi_3[$i]['jenis_imunisasi'];
                        $tempat_imunisasi_3 = $imunisasi_3[$i]['origin'];
                    }

                    if ($is_first_row) {
                        $html .=    "<tr>" .
                                        "<td>" . ($num + 1) . "</td>" .
                                        "<td>" . $nama_pasien . "</td>" .
                                        "<td>" . ArrayAdapter::format("date d/m/Y", $tanggal_lahir) . "</td>" .
                                        "<td>" . $tempat_lahir . "</td>" .
                                        "<td>" . $nama_ibu . "</td>" .
                                        "<td>" . $no_ktp_ibu . "</td>" .
                                        "<td>" . $jk . "</td>" .
                                        "<td>" . $berat_badan . "</td>" .
                                        "<td>" . $alamat_pasien . "</td>" .
                                        "<td>" . $desa_kelurahan . "</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>" . $jenis_imunisasi_1 . "</td>" .
                                        "<td>" . ArrayAdapter::format("date d/m/Y", $tanggal_imunisasi_1) . "</td>" .
                                        "<td>" . ArrayAdapter::format("unslug", $tempat_imunisasi_1) . "</td>" .
                                        "<td>" . $jenis_imunisasi_2 . "</td>" .
                                        "<td>" . ArrayAdapter::format("date d/m/Y", $tanggal_imunisasi_2) . "</td>" .
                                        "<td>" . ArrayAdapter::format("unslug", $tempat_imunisasi_2) . "</td>" .
                                        "<td>" . $jenis_imunisasi_3 . "</td>" .
                                        "<td>" . ArrayAdapter::format("date d/m/Y", $tanggal_imunisasi_3) . "</td>" .
                                        "<td>" . ArrayAdapter::format("unslug", $tempat_imunisasi_3) . "</td>" .
                                    "</tr>";
                        $is_first_row = false;
                    } else {
                        $html .=    "<tr>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>&nbsp;</td>" .
                                        "<td>" . $jenis_imunisasi_1 . "</td>" .
                                        "<td>" . ArrayAdapter::format("date d/m/Y", $tanggal_imunisasi_1) . "</td>" .
                                        "<td>" . ArrayAdapter::format("unslug", $tempat_imunisasi_1) . "</td>" .
                                        "<td>" . $jenis_imunisasi_2 . "</td>" .
                                        "<td>" . ArrayAdapter::format("date d/m/Y", $tanggal_imunisasi_2) . "</td>" .
                                        "<td>" . ArrayAdapter::format("unslug", $tempat_imunisasi_2) . "</td>" .
                                        "<td>" . $jenis_imunisasi_3 . "</td>" .
                                        "<td>" . ArrayAdapter::format("date d/m/Y", $tanggal_imunisasi_3) . "</td>" .
                                        "<td>" . ArrayAdapter::format("unslug", $tempat_imunisasi_3) . "</td>" .
                                    "</tr>";
                    }
                }
            }
        }

        $data = array(
            'html'          => $html,
            'nrm_pasien'    => $nrm_pasien,
            'nama_pasien'   => $nama_pasien
        );
        echo json_encode($data);
    } else if ($_POST['command'] == "export_xls") {
        $tanggal_from = ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']);
        $tanggal_to = ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']);
        $jenis_imunisasi_label = $_POST['jenis_imunisasi_label'];
        $klinik_label = $_POST['klinik_label'];
        $data = json_decode($_POST['d_data'], true);
        $num_rows = $_POST['num_rows'];
        $num_columns = $_POST['num_columns'] + 1;
        $last_column = $num_columns > 26 ? "A" . chr(64 + ($num_columns % 26) - 1) : chr(64 + $num_columns - 1);

        require_once("smis-libs-out/php-excel/PHPExcel.php");

        $file = new PHPExcel();
        $sheet = $file->getActiveSheet();
        $sheet->setTitle("Laporan Imunisasi Bayi");
        $i = 1;

        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Laporan Imunisasi Bayi");
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 1;
        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "CASA MEDICAL " . $klinik_label);
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 1;
        $sheet->mergeCells("A" . $i . ":" . $last_column . $i)->setCellValue("A" . $i, "Periode : " . $tanggal_from . " s.d. " . $tanggal_to . " | Jenis Imunisasi : " . $jenis_imunisasi_label);
        $sheet->getStyle("A" . $i . ":" . $last_column . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i)->getFont()->setBold(true);
        $i = $i + 2;

        $border_start = $i;
        $col = 65;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "No.");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("No.") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Nama");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nama") + 20);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Tanggal Lahir");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Tanggal Lahir") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Tempat Lahir");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Tempat Lahir") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Nama Ibu");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Nama Ibu") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "No. KTP Ibu");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("No. KTP Ibu") + 10);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Jenis Kelamin (L/P)");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Jenis Kelamin (L/P)") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Berat Lahir (kg)");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Berat Lahir (kg)") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Alamat");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Alamat") + 30);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "Desa/Kelurahan");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("Desa/Kelurahan") + 30);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col) . ($i + 1))->setCellValue(chr($col) . $i, "No. Telp. Ibu");
        $sheet->getColumnDimension(chr($col))->setWidth(mb_strwidth("No. Telp. Ibu") + 5);
        $col++;
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col + 2) . ($i))->setCellValue(chr($col) . $i, "Imunisasi I");
        $sub_col = $col;
        $col += 3;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Jenis Imunisasi");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Jenis Imunisasi") + 10);
        $sub_col++;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Tanggal");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Tanggal") + 5);
        $sub_col++;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Nama Tempat");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Nama Tempat") + 5);
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col + 2) . ($i))->setCellValue(chr($col) . $i, "Imunisasi II");
        $sub_col = $col;
        $col += 3;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Jenis Imunisasi");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Jenis Imunisasi") + 10);
        $sub_col++;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Tanggal");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Tanggal") + 5);
        $sub_col++;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Nama Tempat");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Nama Tempat") + 5);
        $sheet->mergeCells(chr($col) . $i . ":" . chr($col + 2) . ($i))->setCellValue(chr($col) . $i, "Imunisasi III");
        $sub_col = $col;
        $col += 3;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Jenis Imunisasi");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Jenis Imunisasi") + 10);
        $sub_col++;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Tanggal");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Tanggal") + 5);
        $sub_col++;
        $sheet->setCellValue(chr($sub_col) . ($i + 1), "Nama Tempat");
        $sheet->getColumnDimension(chr($sub_col))->setWidth(mb_strwidth("Nama Tempat") + 5);
        
        $sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
        $sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A" . $i . ":" . $last_column . ($i + 1))->getFont()->setBold(true);
        $i = $i + 2;

        if (count($data) > 0) {
            foreach ($data as $d) {
                if (count($d) > 0) {
                    $col = 65;
                    foreach ($d as $c) {
                        $sheet->setCellValue(chr($col) . $i, $c);
                        if ($col >= 69 && $col <= 72)
                            $sheet->getStyle(chr($col) . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                        $col++;
                    }
                    $i = $i + 1;
                }
            }
        }

        $thin = array();
        $thin['borders'] = array();
        $thin['borders']['allborders'] = array();
        $thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
        $sheet->getStyle("A" . $border_start . ":" . $last_column . ($i - 1))->applyFromArray($thin);

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Laporan Imunisasi Bayi - ' . $klinik_label . ' - ' . $tanggal_from . ' - ' . $tanggal_to . ' - ' . $jenis_imunisasi_label . '.xls"');
        header('Cache-Control: max-age=0');
        $writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
        $writer->save('php://output');
    }
    return;
}

$laporan_form = new Form("", "", "Laporan Imunisasi Bayi");
$tanggal_from_text = new Text("lib_tanggal_from", "lib_tanggal_from", date("Y-m-") . "01");
$tanggal_from_text->setClass("mydate");
$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
$laporan_form->addElement("Dari", $tanggal_from_text);
$tanggal_to_text = new Text("lib_tanggal_to", "lib_tanggal_to", date("Y-m-d"));
$tanggal_to_text->setClass("mydate");
$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
$laporan_form->addElement("Sampai", $tanggal_to_text);
$jenis_imunisasi_option = new OptionBuilder();
$jenis_imunisasi_option->add("Semua", "%%", "1");
$jenis_imunisasi_option->add("I", "I");
$jenis_imunisasi_option->add("II", "II");
$jenis_imunisasi_option->add("III", "III");
$jenis_imunisasi_select = new Select("lib_jenis_imunisasi", "lib_jenis_imunisasi", $jenis_imunisasi_option->getContent());
$laporan_form->addElement("Jenis Imunisasi", $jenis_imunisasi_select);
$klinik_rows = $db->get_result("
		SELECT DISTINCT origin
		FROM smis_mr_suntik_kb
		WHERE prop = '' AND origin IS NOT NULL AND origin NOT LIKE ''
		ORDER BY origin ASC
	");
$klinik_option = new OptionBuilder();
$klinik_option->add("SEMUA CABANG", "%%", "1");
if ($klinik_rows != null) {
    foreach ($klinik_rows as $klinik_row)
        $klinik_option->add(ArrayAdapter::format("unslug", $klinik_row->origin), $klinik_row->origin);
}
$klinik_select = new Select("lib_klinik", "lib_klinik", $klinik_option->getContent());
$laporan_form->addElement("Klinik", $klinik_select);
$show_button = new Button("", "", "Tampilkan");
$show_button->setClass("btn-primary");
$show_button->setIcon("icon-white icon-repeat");
$show_button->setIsButton(Button::$ICONIC);
$show_button->setAction("lib.view()");
$download_button = new Button("", "", "Unduh");
$download_button->setClass("btn-inverse");
$download_button->setIcon("fa fa-download");
$download_button->setIsButton(Button::$ICONIC);
$download_button->setAtribute("id='export_button'");
$btn_group = new ButtonGroup("noprint");
$btn_group->addButton($show_button);
$btn_group->addButton($download_button);
$laporan_form->addElement("", $btn_group);

$loading_bar = new LoadingBar("loading_bar", "");
$button = new Button("", "", "Batal");
$button->addClass("btn-primary");
$button->setIsButton(Button::$ICONIC_TEXT);
$button->setIcon("fa fa-close");
$button->setAction("lib.cancel()");
$loading_modal = new Modal("loading_modal", "", "Proses..");
$loading_modal->addHtml($loading_bar->getHtml(), "after");
$loading_modal->addFooter($button);

echo $loading_modal->getHtml();
echo $laporan_form->getHtml();
echo "<div id='table_content'>";
echo "</div>";
echo "<div id='info'>";
echo     "<div class='alert alert-block alert-inverse'>";
echo         "<center><strong>DATA BELUM DIPROSES</strong></center>";
echo     "</div>";
echo "</div>";
echo addJS("framework/smis/js/table_action.js");
echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
echo addJS("base-js/smis-base-loading.js");
echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
    var lib;
    var jumlah_kolom;
    var FINISHED;
    $(document).ready(function() {
        $(".mydate").datepicker();
        lib = new TableAction(
            "lib",
            "medical_record",
            "laporan_imunisasi_bayi",
            new Array()
        );
        lib.view = function() {
            $("#info").empty();
            $("#loading_bar").sload("true", "Harap ditunggu...", 0);
            $("#loading_modal").smodal("show");
            FINISHED = false;
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "initiate_table";
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) return;
                    $("#table_content").html(json.html);
                    jumlah_kolom = json.jumlah_kolom;
                    data = self.getRegulerData();
                    data['command'] = "get_jumlah";
                    data['tanggal_from'] = $("#lib_tanggal_from").val();
                    data['tanggal_to'] = $("#lib_tanggal_to").val();
                    data['jenis_imunisasi'] = $("#lib_jenis_imunisasi").val();
                    data['klinik'] = $("#lib_klinik").val();
                    $("#loading_bar").sload("true", "Proses Pemuatan Jumlah Data");
                    $.post(
                        "",
                        data,
                        function(response_jumlah) {
                            var json_jumlah = JSON.parse(response_jumlah);
                            if (json_jumlah == null) return;
                            self.fillHtml(0, json_jumlah.jumlah);
                        }
                    );
                }
            );
        };
        lib.fillHtml = function(num, limit) {
            if (FINISHED || num == limit) {
                if (FINISHED == false && num == limit) {
                    this.finalize();
                } else {
                    $("#loading_modal").smodal("hide");
                    $("#info").html(
                        "<div class='alert alert-block alert-inverse'>" +
                        "<center><strong>PROSES DIBATALKAN</strong></center>" +
                        "</div>"
                    );
                    $("#export_button").removeAttr("onclick");
                }
                return;
            }
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "get_info";
            data['num'] = num;
            data['tanggal_from'] = $("#lib_tanggal_from").val();
            data['tanggal_to'] = $("#lib_tanggal_to").val();
            data['jenis_imunisasi'] = $("#lib_jenis_imunisasi").val();
            data['klinik'] = $("#lib_klinik").val();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) return;
                    $("tbody#lib_list").append(
                        json.html
                    );
                    $("#loading_bar").sload("true", json.nrm_pasien + " - " + json.nama_pasien + " (" + num + " / " + limit + ")", num * 100 / limit - 1);
                    self.fillHtml(num + 1, limit);
                }
            );
        };
        lib.finalize = function() {
            $("#loading_modal").smodal("hide");
            $("#info").html(
                "<div class='alert alert-block alert-info'>" +
                "<center><strong>PROSES SELESAI</strong></center>" +
                "</div>"
            );
            $("#export_button").removeAttr("onclick");
            $("#export_button").attr("onclick", "lib.export_xls()");
        };
        lib.export_xls = function() {
            showLoading();
            var num_rows = $("#lib_list").children("tr").length;
            var num_columns = jumlah_kolom;
            var d_data = {};
            for (var i = 0; i < num_rows; i++) {
                d_data[i] = {};
                for (var j = 0; j < num_columns; j++)
                    d_data[i][j] = $("tbody#lib_list tr:eq(" + i + ") td:eq(" + j + ")").text();
            }
            var data = this.getRegulerData();
            data['command'] = "export_xls";
            data['tanggal_from'] = $("#lib_tanggal_from").val();
            data['tanggal_to'] = $("#lib_tanggal_to").val();
            data['jenis_imunisasi_label'] = $("#lib_jenis_imunisasi option:selected").text();
            data['klinik_label'] = $("#lib_klinik option:selected").text();
            data['d_data'] = JSON.stringify(d_data);
            data['num_rows'] = num_rows;
            data['num_columns'] = num_columns;
            postForm(data);
            dismissLoading();
        };
        lib.cancel = function() {
            FINISHED = true;
        };
        $("#loading_modal > div.modal-header > a").remove();
        $(document).keyup(function(e) {
            if (e.which == 27) {
                FINISHED = true;
            }
        });
    });
</script>