<?php
	global $db;
	global $user;
	require_once 'smis-libs-class/Policy.php';
	require_once 'smis-libs-inventory/policy.php';
	$inventory_policy = new InventoryPolicy("medical_record", $user,"modul/");
	
	$policy=new Policy("medical_record", $user);
	$policy->setDefaultPolicy(Policy::$DEFAULT_POLICY_RESTRICT);
    
	$policy->addPolicy("data_induk", "data_induk", Policy::$DEFAULT_COOKIE_CHANGE,"modul/data_induk");
	$policy->addPolicy("icdtindakan", "data_induk", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/data_induk/icdtindakan");
	$policy->addPolicy("icd", "data_induk", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/data_induk/icd");
	$policy->addPolicy("pasien", "data_induk", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/data_induk/pasien");
	$policy->addPolicy("label", "data_induk", Policy::$DEFAULT_COOKIE_KEEP,"snippet/label");
	$policy->addPolicy("keterangan_data_induk", "data_induk", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/data_induk/keterangan_data_induk");
	$policy->addPolicy("tujuan_rujukan", "data_induk", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/data_induk/tujuan_rujukan");
	
	$policy->addPolicy("input_data", "input_data", Policy::$DEFAULT_COOKIE_CHANGE,"modul/input_data");
	$policy->addPolicy("keterangan_input_data", "input_data", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/input_data/keterangan_input_data");
	$policy->addPolicy("input_operasi", "input_data", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/input_data/input_operasi");
	$policy->addPolicy("tindakan", "input_data", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/input_data/tindakan");
	$policy->addPolicy("diagnosa", "input_data", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/input_data/diagnosa");
	
	$policy->addPolicy("laporan_pasien_daftar", "laporan_pasien_daftar", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_pasien_daftar");
	$policy->addPolicy("laporan_kunjungan_pasien", "laporan_kunjungan_pasien", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_kunjungan_pasien");
	$policy->addPolicy("laporan_rekap_pendaftaran_bpjs", "laporan_rekap_pendaftaran_bpjs", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_rekap_pendaftaran_bpjs");
	$policy->addPolicy("laporan_vakum_dan_non_aktif", "laporan_vakum_dan_non_aktif", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_vakum_dan_non_aktif");
	$policy->addPolicy("laporan_vakum", "laporan_vakum_dan_non_aktif", Policy::$DEFAULT_COOKIE_CHANGE,"resource/php/laporan_vakum_dan_non_aktif/laporan_vakum");
	$policy->addPolicy("laporan_non_aktif", "laporan_vakum_dan_non_aktif", Policy::$DEFAULT_COOKIE_CHANGE,"resource/php/laporan_vakum_dan_non_aktif/laporan_non_aktif");
	$policy->addPolicy("laporan_rekap_diagnosa", "laporan_rekap_diagnosa", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_rekap_diagnosa");
	$policy->addPolicy("laporan_maternal_neonatal", "laporan_maternal_neonatal", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_maternal_neonatal");
	$policy->addPolicy("laporan_suntik_kb", "laporan_suntik_kb", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_suntik_kb");
	$policy->addPolicy("laporan_rujukan", "laporan_rujukan", Policy::$DEFAULT_COOKIE_CHANGE, "modul/laporan_rujukan");
	$policy->addPolicy("laporan_morbiditas_gigi", "laporan_morbiditas_gigi", Policy::$DEFAULT_COOKIE_CHANGE, "modul/laporan_morbiditas_gigi");
	$policy->addPolicy("laporan_imunisasi_bayi", "laporan_imunisasi_bayi", Policy::$DEFAULT_COOKIE_CHANGE, "modul/laporan_imunisasi_bayi");
    
    $policy->addPolicy("laporan_asesmen", "laporan_asesmen", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_asesmen");
    $policy->addPolicy("asesmen_anak", "laporan_asesmen", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_asesmen/asesmen_anak");
    $policy->addPolicy("asesmen_perawat", "laporan_asesmen", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_asesmen/asesmen_perawat");
    $policy->addPolicy("asesmen_jantung", "laporan_asesmen", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_asesmen/asesmen_jantung");
    $policy->addPolicy("asesmen_psikologi", "laporan_asesmen", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_asesmen/asesmen_psikologi");
    $policy->addPolicy("asesmen_psikiatri", "laporan_asesmen", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_asesmen/asesmen_psikiatri");
    $policy->addPolicy("asesmen_syaraf", "laporan_asesmen", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_asesmen/asesmen_syaraf");
	
	$policy->addPolicy("indikator_klinis", "indikator_klinis", Policy::$DEFAULT_COOKIE_CHANGE,"modul/indikator_klinis");
	$policy->addPolicy("sentinel", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/sentinel");
	$policy->addPolicy("nyaris", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/nyaris");
	$policy->addPolicy("cedera", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/cedera");
	$policy->addPolicy("decubitus", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/decubitus");
	$policy->addPolicy("infus", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/infus");
	$policy->addPolicy("transfusi", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/transfusi");
	$policy->addPolicy("lap_transfusi", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/lap_transfusi");
	
	$policy->addPolicy("operasi", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/operasi");
	$policy->addPolicy("isk", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/isk");
	$policy->addPolicy("bayi", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/bayi");
	$policy->addPolicy("elektif", "indikator_klinis", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/indikator_klinis/elektif");

	$policy->addPolicy("laporan_rl", "laporan_rl", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_rl");
	$policy->addPolicy("rl12", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl12");
	$policy->addPolicy("rl2", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl2");
	$policy->addPolicy("rl13", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl13");
	$policy->addPolicy("rl32", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl32");
	$policy->addPolicy("rl33", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl33");
	$policy->addPolicy("rl31", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl31");
	$policy->addPolicy("rl314", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl314");
	$policy->addPolicy("rl51", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl51");
	$policy->addPolicy("rl52", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl52");
	$policy->addPolicy("rl52b", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl52b");
	$policy->addPolicy("rl53", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl53");
	$policy->addPolicy("rl54", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl54");
	$policy->addPolicy("rl53_lama", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl53_lama");
	$policy->addPolicy("rl54_lama", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl54_lama");
	$policy->addPolicy("rl310", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl310");
	$policy->addPolicy("rl311", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl311");
	$policy->addPolicy("stp_uri", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/stp_uri");
	$policy->addPolicy("stp_urj", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/stp_urj");
	$policy->addPolicy("stp_uri_sebab", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/stp_uri_sebab");
	$policy->addPolicy("stp_urj_sebab", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/stp_urj_sebab");
	$policy->addPolicy("rl5_4", "laporan_rl", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_rl/rl5_4");
	
	$policy->addPolicy("lap_index", "lap_index", Policy::$DEFAULT_COOKIE_CHANGE,"modul/lap_index");
	$policy->addPolicy("lap_index_dokter", "lap_index", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_index/lap_index_dokter");
	$policy->addPolicy("lap_index_penyakit", "lap_index", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_index/lap_index_penyakit");
	$policy->addPolicy("lap_index_operasi", "lap_index", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_index/lap_index_operasi");
	$policy->addPolicy("lap_index_pasien", "lap_index", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_index/lap_index_pasien");
	$policy->addPolicy("lap_index_kematian", "lap_index", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_index/lap_index_kematian");
	$policy->addPolicy("lap_index_ranap", "lap_index", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_index/lap_index_ranap");
	$policy->addPolicy("lap_index_rajal", "lap_index", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_index/lap_index_rajal");
	
	$policy->addPolicy("lap_kb", "lap_kb", Policy::$DEFAULT_COOKIE_CHANGE,"modul/lap_kb");
	$policy->addPolicy("lap_kb_baru", "lap_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_kb_baru");
	$policy->addPolicy("lap_kb_kasus", "lap_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_kb_kasus");
	$policy->addPolicy("lap_kb_ulang", "lap_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_kb_ulang");
	$policy->addPolicy("lap_kb_pasca", "lap_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_kb_pasca");
	$policy->addPolicy("lap_persalinan", "lap_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_persalinan");
	$policy->addPolicy("lap_imunisasi", "lap_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_imunisasi");
	
    $policy->addPolicy("lap_persen", "lap_persen", Policy::$DEFAULT_COOKIE_CHANGE,"modul/lap_persen");
	$policy->addPolicy("lap_persen_diagnosa", "lap_persen", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_persen/lap_persen_diagnosa");
	
    
	$policy->addPolicy("lap_igd", "lap_igd", Policy::$DEFAULT_COOKIE_CHANGE,"modul/lap_igd");
	$policy->addPolicy("lap_igd_triage", "lap_igd", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_igd/lap_igd_triage");
	$policy->addPolicy("lap_igd_data", "lap_igd", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_igd/lap_igd_data");
	$policy->addPolicy("lap_igd_response", "lap_igd", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_igd/lap_igd_response");
	$policy->addPolicy("lap_igd_kunjungan", "lap_igd", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_igd/lap_igd_kunjungan");
	$policy->addPolicy("lap_igd_keterangan", "lap_igd", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_igd/lap_igd_keterangan");
	$policy->addPolicy("lap_igd_koreksi", "lap_igd", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_igd/lap_igd_koreksi");
	
	$policy->addPolicy("lap_operasi", "lap_operasi", Policy::$DEFAULT_COOKIE_CHANGE,"modul/lap_operasi");
	$policy->addPolicy("lap_operasi_kamar", "lap_operasi", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_operasi/lap_operasi_kamar");
	$policy->addPolicy("lap_operasi_anastesi", "lap_operasi", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_operasi/lap_operasi_anastesi");
	$policy->addPolicy("lap_operasi_bedah", "lap_operasi", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_operasi/lap_operasi_bedah");
	
	$policy->addPolicy("kuisioner", "kuisioner", Policy::$DEFAULT_COOKIE_CHANGE,"modul/kuisioner");
	$policy->addPolicy("kuisioner_ri", "kuisioner", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/kuisioner/kuisioner_ri");
	$policy->addPolicy("kuisioner_rj", "kuisioner", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/kuisioner/kuisioner_rj");
	$policy->addPolicy("analisa_kuisioner_rj", "kuisioner", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/kuisioner/analisa_kuisioner_rj");
	$policy->addPolicy("analisa_kuisioner_ri", "kuisioner", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/kuisioner/analisa_kuisioner_ri");
	
	$policy->addPolicy("laporan_pasien", "laporan_pasien", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_pasien");
	$policy->addPolicy("pasien_aktif", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/pasien_aktif");
	$policy->addPolicy("lap_ri", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_ri");
	$policy->addPolicy("lap_rj", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_rj");
	$policy->addPolicy("lap_pulang", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_pulang");
	$policy->addPolicy("lap_diagnosa", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_diagnosa");
	$policy->addPolicy("lap_diagnosa_per_bulan", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_diagnosa_per_bulan");
	$policy->addPolicy("lap_diagnosa_detail_pertanggal", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_diagnosa_detail_pertanggal");
    $policy->addPolicy("lap_sensus", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_sensus");
    $policy->addPolicy("lap_sensus_harian", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_sensus_harian");
	$policy->addPolicy("get_sensus_total", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"snippet/get_sensus_total");
	$policy->addPolicy("get_sensus_detail", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"snippet/get_sensus_detail");
	$policy->addPolicy("get_sensus_excel", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"snippet/get_sensus_excel");
	$policy->addPolicy("lap_kunjungan", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_kunjungan");
	$policy->addPolicy("lap_kun_pertanggal", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_kun_pertanggal");
	$policy->addPolicy("lap_rawat_inap", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_rawat_inap");
	$policy->addPolicy("lap_rawat_jalan", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_rawat_jalan");
	$policy->addPolicy("lap_resume_pasien_pulang_ri", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_resume_pasien_pulang_ri");
	$policy->addPolicy("lap_resume_ruangan", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_resume_ruangan");
	$policy->addPolicy("lap_lama_rawat", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_lama_rawat");
	$policy->addPolicy("lap_plebitis", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_plebitis");
	$policy->addPolicy("lap_cauti", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_cauti");
	$policy->addPolicy("lap_kasus", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_kasus");
	$policy->addPolicy("lap_kegiatan_gigi_mulut", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_kegiatan_gigi_mulut");
	$policy->addPolicy("lap_prolanis", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_prolanis");
	$policy->addPolicy("lap_kunjungan_rj", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_kunjungan_rj");
	$policy->addPolicy("lap_kunjungan_rawat", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_kunjungan_rawat");
	$policy->addPolicy("lap_kunjungan_rawat_jalan", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_kunjungan_rawat_jalan");
	$policy->addPolicy("lap_rujukan", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/lap_rujukan");

	$policy->addPolicy("laporan_rekap_rujukan_non_spesialistik", "laporan_rekap_rujukan_non_spesialistik", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_rekap_rujukan_non_spesialistik");
	
	$policy->addPolicy("morbiditas", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/morbiditas");
	$policy->addPolicy("odontogram", "laporan_pasien", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/laporan_pasien/odontogram");
	$policy->addPolicy("resume_medis", "resume_medis", Policy::$DEFAULT_COOKIE_CHANGE,"modul/resume_medis");
	$policy->addPolicy("settings","settings", Policy::$DEFAULT_COOKIE_CHANGE,"modul/settings");
    
    $policy->addPolicy("sepuluh_besar_penyakit","sepuluh_besar_penyakit", Policy::$DEFAULT_COOKIE_CHANGE,"modul/sepuluh_besar_penyakit");
    $policy->addPolicy("laporan_indeks_penyakit","laporan_indeks_penyakit", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_indeks_penyakit");
    $policy->addPolicy("laporan_indeks_dokter","laporan_indeks_dokter", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_indeks_dokter");
    $policy->addPolicy("laporan_imunisasi","laporan_imunisasi", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_imunisasi");
    $policy->addPolicy("laporan_kb","laporan_kb", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_kb");
    $policy->addPolicy("lap_kb_baru", "laporan_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_kb_baru");
	$policy->addPolicy("lap_kb_kasus", "laporan_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_kb_kasus");
	$policy->addPolicy("lap_kb_ulang", "laporan_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_kb_ulang");
	$policy->addPolicy("lap_kb_pasca", "laporan_kb", Policy::$DEFAULT_COOKIE_KEEP,"resource/php/lap_kb/lap_kb_pasca");
    $policy->addPolicy("laporan_persalinan", "laporan_persalinan", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_persalinan");
    $policy->addPolicy("laporan_prolanis", "laporan_prolanis", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_prolanis");
    $policy->addPolicy("laporan_gigi_mulut", "laporan_gigi_mulut", Policy::$DEFAULT_COOKIE_CHANGE,"modul/laporan_gigi_mulut");
    
	$policy->combinePolicy($inventory_policy);
	$policy->initialize();
?>
