<?php
require_once 'smis-framework/smis/template/ModulTemplate.php';
require_once ("smis-base/smis-include-service-consumer.php");
require_once 'medical_record/class/table/DiagnosaTable.php';
require_once 'medical_record/class/adapter/DiagnosaAdapter.php';
require_once 'smis-libs-hrd/EmployeeResponder.php';

class RekapitulasiMedicalRecordTemplate extends ModulTemplate {
	protected $db;
	protected $mode;
	protected $polislug;
	protected $page;
	protected $protoslug;
	protected $protoname;
	protected $protoimplement;
	protected $action;
	protected $dbtable;
	protected $uitable;
	protected $noreg_pasien;
	protected $nama_pasien;
	protected $nrm_pasien;
	protected $list_pesan;
	protected $list_hasil;
	protected $gol_umur;
	protected $jk;
	protected $kunjungan;
	protected $carabayar;
	public static $MODE_DAFTAR = "pendaftaran";
	public static $MODE_PERIKSA = "pemeriksaan";
	public function __construct($db, $mode, $polislug = "all", $noreg = "", $nrm = "", $nama = "", $page = "medical_record", $action = "diagnosa", $protoslug = "", $protoname = "", $protoimplement = "", $jenis_umur = "TGL LAHIR TDK VALID", $jk = "0", $kunjungan = "Baru", $carabayar = "Umum") {
		$this->db = $db;
		$this->mode = $mode;
		$this->noreg_pasien = $noreg;
		$this->nama_pasien = $nama;
		$this->gol_umur = $jenis_umur;
		$this->nrm_pasien = $nrm;
		$this->polislug = $polislug;
		$this->dbtable = new DBTable ( $this->db, "smis_mr_diagnosa" );
		$this->page = $page;
		$this->protoslug = $protoslug;
		$this->protoimplement = $protoimplement;
		$this->protoname = $protoname;
		$this->action = $action;
		$this->jk = $jk;
		$this->kunjungan = $kunjungan;
		$this->carabayar = $carabayar;
		//if ($polislug != "all")
			//$this->dbtable->addCustomKriteria ( "ruangan", "='" . $polislug . "'" );
		if ($nrm != "")
			$this->dbtable->addCustomKriteria ( "nrm_pasien", "='" . $nrm. "'" );
		
		$array=array ("No.",'Tanggal','NRM',"Pasien","Jenis Kelamin","Dokter",'Diagnosa',"ICD","Penyakit","Ruangan" );
		$this->uitable = new DiagnosaTable ($polislug,$noreg, $array ,"", NULL, true );
		$this->uitable->setName ( $action );
		if ($this->mode == self::$MODE_PERIKSA) {
			$this->uitable->setAddButtonEnable ( false );
			$this->uitable->setDelButtonEnable ( false );
		}
	}
	public function command($command) {
		

		$adapter = new DiagnosaAdapter ();
		$adapter->setUseNumber(true, "No.","back.");
		$adapter->add ( "Tanggal", "tanggal", "date d M Y" );
		$adapter->add ( "Pasien", "nama_pasien" );
		$adapter->add ( "NRM", "nrm_pasien", "digit8" );
		$adapter->add ( "Noreg", "noreg_pasien" );
		$adapter->add ( "Dokter", "nama_dokter" );
		$adapter->add ( "Diagnosa", "diagnosa" );
		$adapter->add ( "ICD", "kode_icd" );
		$adapter->add ( "Penyakit", "nama_icd" );
		$adapter->add ( "Kelas", "kelas", "unslug" );
		$adapter->add ( "Ruangan", "ruangan" );
		$adapter->add ( "Jenis Kelamin", "jk", "trivial_0_Laki-Laki_Perempuan" );
		$dbres = new DBResponder( $this->dbtable, $this->uitable, $adapter );
		if($dbres->isView()){
			$kondisi=$_POST['kondisi'];
			if($kondisi=="terisi") $this->dbtable->addCustomKriteria(" kode_icd", "!='' ");
			if($kondisi=="kosong") $this->dbtable->addCustomKriteria(" kode_icd", "='' ");
			
			if(isset($_POST['dari']) &&  $_POST['dari']!="" ){
				$this->dbtable->addCustomKriteria(" tanggal>= ", "'".$_POST['dari']."' ");
			}
			
			if(isset($_POST['sampai']) &&  $_POST['sampai']!="" ){
				$this->dbtable->addCustomKriteria(" tanggal< ", "'".$_POST['sampai']."' ");
			}
			
			$jenis_layanan=$_POST['jenis_layanan'];
			if($jenis_layanan=="non_poli") $this->dbtable->addCustomKriteria(" urji", " ='1' ");
			if($jenis_layanan=="poli") $this->dbtable->addCustomKriteria(" urji", " ='0' ");
		}
		if ($dbres->isSave()) {
			$tgl_masuk = "";
			$tgl_lahir = "";
			if (isset($_POST['ruangan']) && isset($_POST['noreg_pasien'])) {
				$ruangan = $_POST['ruangan'];
				$noreg_pasien = $_POST['noreg_pasien'];
				
				$row = $this->db->get_row("
					SELECT DATE(waktu) tgl_masuk
					FROM smis_rwt_antrian_" . $ruangan . "
					WHERE no_register = '" . $noreg_pasien . "'
				");
				if ($row != null)
					$tgl_masuk = $row->tgl_masuk;

				$row = $this->db->get_row("
					SELECT tgl_lahir
					FROM smis_rgv_layananpasien 
					WHERE id = '" . $noreg_pasien . "'
				");
				if ($row != null)
					$tgl_lahir = $row->tgl_lahir;

				// Update Data Antrian :
				$params = array();
				$params['noreg_pasien'] = $_POST['noreg_pasien'];
				$params['status_pulang'] = $_POST['status_pulang'];
				$params['tanggal_diagnosa'] = $_POST['tanggal'];
				$consumer_service = new ServiceConsumer(
					$this->db,
					"set_update_info_antrian",
					$params,
					$_POST['ruangan']
				);
				$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
				$consumer_service->execute();
				// Update Data Kunjungan :	
				$params = array();
				$params['noreg_pasien'] = $_POST['noreg_pasien'];
				$params['status_pulang'] = $_POST['status_pulang'];
				$params['tanggal_diagnosa'] = $_POST['tanggal'];
				$consumer_service = new ServiceConsumer(
					$this->db,
					"set_update_info_kunjungan",
					$params,
					"registration"
				);
				$consumer_service->setMode(ServiceConsumer::$CLEAN_BOTH);
				$consumer_service->execute();	
			}
			$_POST['tgl_masuk'] = $tgl_masuk;
			$_POST['tgl_lahir'] = $tgl_lahir;
		}
		$data = $dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
	public function phpPreLoad() {
		$this->uitable->addModal ( "id", "hidden", "", "" );
		$this->uitable->addModal ( "gol_umur", "hidden", "", $this->gol_umur );
		if ($this->noreg_pasien != "") {
			$this->uitable->addModal ( "nama_pasien", "hidden", "", $this->nama_pasien, "n", null, true );
			$this->uitable->addModal ( "nrm_pasien", "hidden", "", $this->nrm_pasien, "n", null, true );
			$this->uitable->addModal ( "noreg_pasien", "hidden", "", $this->noreg_pasien, "n", null, true );
		} else {
			$this->uitable->addModal ( "nama_pasien", "chooser-" . $this->action . "-mr_pasien", "Pasien", $this->nama_pasien, "n", null, true );
			$this->uitable->addModal ( "nrm_pasien", "text", "NRM", $this->nrm_pasien, "n", null, true );
			$this->uitable->addModal ( "noreg_pasien", "text", "No Reg", $this->noreg_pasien, "n", null, true );
		}
		$this->uitable->addModal ( "jk", "hidden", "", $this->jk );
		$this->uitable->addModal ( "kunjungan", "hidden", "", $this->kunjungan );
		$this->uitable->addModal ( "carabayar", "hidden", "", $this->carabayar );
		$this->uitable->addModal ( "urji", "hidden", "", $this->urji);
		$this->uitable->addModal ( "tanggal", "date", "Tanggal", date ( "Y-m-d" ) );
        loadClass ( "ServiceProviderList" );
        $service = new ServiceProviderList ( $this->db, "push_antrian" );
        $service->execute ();
        $ruangan = $service->getContent ();
		if ($this->polislug == "all")
			$this->uitable->addModal ( "ruangan", "select", "Ruangan", $ruangan );
        else {
        	$ruangan_option = new OptionBuilder();
        	foreach ($ruangan as $r) {
        		if ($r['value'] == $this->polislug)
        			$ruangan_option->add($r['name'], $r['value'], "1");
        		else
        			$ruangan_option->add($r['name'], $r['value']);
        	}
        	$this->uitable->addModal ( "ruangan", "select", "Ruangan", $ruangan_option->getContent(), "n", null, true );
        }
        $this->uitable->addModal ( "keluhan", "textarea", "Keluhan", "" );
        $this->uitable->addModal ( "anamnesa", "textarea", "Anamnesa", "" );
        $this->uitable->addModal("", "label", "&nbsp;", "&nbsp;");
		$this->uitable->addModal("", "label", "<strong>Riwayat Alergi</strong>", "");
		$makanan_option = new OptionBuilder();
		$makanan_option->add("", "", "1");
		$makanan_option->add("Seafood", "Seafood");
		$makanan_option->add("Gandum", "Gandum");
		$makanan_option->add("Susu Sapi", "Susu Sapi");
		$makanan_option->add("Kacang-Kacangan", "Kacang-Kacangan");
		$makanan_option->add("Makanan Lain", "Makanan Lain");
		$this->uitable->addModal ( "makanan", "select", "Makanan", $makanan_option->getContent() );
		$udara_option = new OptionBuilder();
		$udara_option->add("", "", "1");
		$udara_option->add("Udara Panas", "Udara Panas");
		$udara_option->add("Udara Dingin", "Udara Dingin");
		$udara_option->add("Udara Kotor", "Udara Kotor");
		$this->uitable->addModal ( "udara", "select", "Udara", $udara_option->getContent() );
		$obat_obatan_option = new OptionBuilder();
		$obat_obatan_option->add("", "", "1");
		$obat_obatan_option->add("Antibiotik", "Antibiotik");
		$obat_obatan_option->add("Antiinflamasi", "Antiinflamasi");
		$obat_obatan_option->add("Non Steroid", "Non Steroid");
		$obat_obatan_option->add("Aspirin", "Aspirin");
		$obat_obatan_option->add("Kortikosteroid", "Kortikosteroid");
		$obat_obatan_option->add("Insulin", "Insulin");
		$obat_obatan_option->add("Obat-Obat Lain", "Obat-Obatan Lain");
		$this->uitable->addModal ( "obat_obatan", "select", "Obat-Obatan", $obat_obatan_option->getContent() );
		$prognosa_option = new OptionBuilder();
		$prognosa_option->add("", "", "1");
		$prognosa_option->add("Sanam (Sembuh)", "Sanam (Sembuh)");
		$prognosa_option->add("Bonam (Baik)", "Bonam (Baik)");
		$prognosa_option->add("Malam (Buruk/Jelek)", "Malam (Buruk/Jelek)");
		$prognosa_option->add("Dubia Ad Sanam/Bolam (Tidak Tentu/Ragu-Ragu, Cenderung Baik)", "Dubia Ad Sanam/Bolam (Tidak Tentu/Ragu-Ragu, Cenderung Baik)");
		$prognosa_option->add("Dubia Ad Malam (Tidak tentu/Ragu-Ragu, Cenderung Buruk/Jelek", "Dubia Ad Malam (Tidak tentu/Ragu-Ragu, Cenderung Buruk/Jelek");
		$this->uitable->addModal ( "prognosa", "select", "Prognosa", $prognosa_option->getContent() );
		$this->uitable->addModal ( "terapi_obat", "textarea", "Terapi Obat", "" );
		$this->uitable->addModal ( "terapi_non_obat", "textarea", "Terapi Non-Obat", "" );
		$this->uitable->addModal ( "bmhp", "textarea", "BMHP", "" );
		$this->uitable->addModal ( "kode_icd", "chooser-" . $this->action . "-mr_icd-Diagnosa", "Diagnosa", "", "n", null, true );
		$this->uitable->addModal ( "nama_icd", "text", "&nbsp;", "", "y", null, true );
		$this->uitable->addModal ( "sebab_sakit", "text", "&nbsp;", "", "y", null, true );
		$this->uitable->addModal ( "kode_icd_sekunder", "chooser-" . $this->action . "-mr_icd_sekunder-Diagnosa Sekunder", "Diagnosa Sekunder", "", "y", null, true );
		$this->uitable->addModal ( "nama_icd_sekunder", "text", "&nbsp;", "", "y", null, true );
		$this->uitable->addModal ( "sebab_sakit_sekunder", "text", "&nbsp;", "", "y", null, true );
		$this->uitable->addModal ( "kesadaran", "text", "Kesadaran", "", "n" );
		$this->uitable->addModal ( "suhu", "text", "Suhu (<sup>o</sup>C)", "", "n" );
		$this->uitable->addModal("", "label", "&nbsp;", "&nbsp;");
		$this->uitable->addModal("", "label", "<strong>Pemeriksaan Fisik</strong>", "");
		$this->uitable->addModal ( "tinggi_badan", "text", "Tinggi Badan (cm)", "", "n" );
		$this->uitable->addModal ( "berat_badan", "text", "Berat Badan (kg)", "", "n" );
		$this->uitable->addModal ( "lingkar_perut", "text", "Lingkar Perut (cm)", "", "n" );
		$this->uitable->addModal ( "imt", "text", "IMT (kg/m<sup>2</sup>)", "", "n", null, true );
		$this->uitable->addModal("", "label", "&nbsp;", "&nbsp;");
		$this->uitable->addModal("", "label", "<strong>Tekanan Darah</strong>", "" );
		$this->uitable->addModal ( "sistole", "text", "Sistole (mmHg)", "", "n" );
		$this->uitable->addModal ( "diastole", "text", "Diastole (mmHg)", "", "n" );
		$this->uitable->addModal ( "rr", "text", "Respiratory Rate (x/menit)", "", "n" );
		$this->uitable->addModal ( "nadi", "text", "Heart Rate (bpm)", "", "n" );
		$this->uitable->addModal("", "label", "&nbsp;", "&nbsp;");
		$this->uitable->addModal ( "id_dokter", "hidden", "", "" );
		$this->uitable->addModal ( "nama_dokter", "chooser-" . $this->action . "-mr_dokter-Tenaga Medis", "Tenaga Medis", "", "n", null, true );
		$pelayanan_non_kapitasi_option = new OptionBuilder();
		$pelayanan_non_kapitasi_option->add("", "", "1");
		$pelayanan_non_kapitasi_option->add("Pelayanan KB", "Pelayanan KB");
		$pelayanan_non_kapitasi_option->add("Pelayanan PNC", "Pelayanan PNC");
		$pelayanan_non_kapitasi_option->add("Pelayanan Ambulance", "Pelayanan Ambulance");
		$this->uitable->addModal ( "pelayanan_non_kapitasi", "select", "Pelayanan Non-Kapitasi", $pelayanan_non_kapitasi_option->getContent() );
		$status_pulang_option = new OptionBuilder();
		$status_pulang_option->add("", "", "1");
		$status_pulang_option->add("Berobat Jalan", "Berobat Jalan");
		$status_pulang_option->add("Rujuk", "Rujuk");
		$status_pulang_option->add("Meninggal", "Meninggal");
		$this->uitable->addModal ( "status_pulang", "select", "Status Pulang", $status_pulang_option->getContent(), "n" );
		$this->uitable->addModal ( "ppk_rujukan", "text", "PPK Rujukan", "" );
		$this->uitable->addModal ( "spesialis_subspesialis", "text", "Spesialis/Subspesialis", "" );
		$this->uitable->addModal ( "catatan", "textarea", "Catatan", "" );
		$this->uitable->addModal ( "tanggal_rencana_berkunjung", "date", "Tgl. Rencana Berkunjung", "" );
		$this->uitable->addModal ( "no_surat_kematian", "text", "No. Surat Kematian", "" );
		
		$modal = $this->uitable->getModal ();
		$modal->setComponentSize(Modal::$MEDIUM);
		$modal->setTitle ( "Diagnosa" );
		
		$jenis_layanan=new OptionBuilder();
		$jenis_layanan->add("","%","1");
		$jenis_layanan->add("Rawat Inap","non_poli");
		$jenis_layanan->add("Rawat Jalan","poli");
		
		$ko=new OptionBuilder();
		$ko->add("","%","1");
		$ko->add("Kosong","kosong");
		$ko->add("Terisi","terisi");
		
		$this->uitable->clearContent();
		$this->uitable->addModal("dari", "date", "Dari", "");
		$this->uitable->addModal("sampai", "date", "Sampai", "");
		$this->uitable->addModal("jenis_layanan", "select", "Ruangan", $jenis_layanan->getContent());
		$this->uitable->addModal("kondisi", "select", "Kondisi", $ko->getContent());
		
		$form=$this->uitable->getModal()->getForm();
		
		$btn=new Button("", "", "");
		$btn->setClass("btn-primary");
		$btn->setIcon("fa fa-refresh");
		$btn->setIsButton(Button::$ICONIC);
		$btn->setAction($this->action.".view()");
		$form->addElement("", $btn);
		echo $form->getHtml();
		echo $this->uitable->getHtml ();
		echo $modal->getHtml ();
	}
	public function jsLoader() {
		echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
		echo addJS ( "framework/smis/js/table_action.js" );
		loadLibrary ( "smis-libs-function-javascript" );
	}
	public function cssLoader() {
		echo addCSS ( "framework/bootstrap/css/datepicker.css" );
	}
	
	
	/* when it's star build */
	public function jsPreLoad() {
		?>
<script type="text/javascript">

		var <?php echo $this->action; ?>;
		var mr_dokter;
		var mr_icd;
		var mr_icd_sekunder;
		var mr_pasien;
		var mr_noreg="<?php echo $this->noreg_pasien; ?>";
		var mr_nama_pasien="<?php echo $this->nama_pasien; ?>";
		var mr_nrm_pasien="<?php echo $this->nrm_pasien; ?>";
		var mr_polislug="<?php echo $this->polislug; ?>";
		var mr_the_page="<?php echo $this->page; ?>";
		var mr_the_protoslug="<?php echo $this->protoslug; ?>";
		var mr_the_protoname="<?php echo $this->protoname; ?>";
		var mr_the_protoimplement="<?php echo $this->protoimplement; ?>";
		$(document).ready(function() {
			$(".mydate").datepicker();


			$('#<?php echo $this->action; ?>_nama_dokter').typeahead({
				minLength:3,
		        source: function (query, process) {
			     var data_dokter=mr_dokter.getViewData();
			     data_dokter["kriteria"]=$('#<?php echo $this->action; ?>_nama_dokter').val();
		         var $items = new Array;
		           $items = [""];				                
		          $.ajax({
		            url: '',
		            type: 'POST',
		            data: data_dokter,
		            success: function(res) {
		              var json=getContent(res);
		              var the_data_proses=json.d.data;
		               $items = [""];	
		              $.map(the_data_proses, function(data){
		                  var group;
		                  group = {
		                      id: data.id,
		                      name: data.nama,                            
		                      toString: function () {
		                    	  return JSON.stringify(this);
		                      },
		                      toLowerCase: function () {
		                          return this.name.toLowerCase();
		                      },
		                      indexOf: function (string) {
		                          return String.prototype.indexOf.apply(this.name, arguments);
		                      },
		                      replace: function (string) {
		                          var value = '';
		                          value +=  this.name;
		                          if(typeof(this.level) != 'undefined') {
		                              value += ' <span class="pull-right muted">';
		                              value += this.level;
		                              value += '</span>';
		                          }
		                          return String.prototype.replace.apply('<div class="typeaheadiv">' + value + '</div>', arguments);
		                      }
		                  };
		                  $items.push(group);
		              });
		              
		              process($items);
		            }
		          });
		        },
		        updater: function (item) {
		            var item = JSON.parse(item);
					$("#<?php echo $this->action; ?>_id_dokter").val(item.id);
					$("#<?php echo $this->action; ?>_kasus").focus();
		            return item.name;
		        }
		      });


			$('#<?php echo $this->action; ?>_nama_icd').typeahead({
				minLength:3,
		        source: function (query, process) {
			     var data_dokter=mr_icd.getViewData();
			     data_dokter["kriteria"]=$('#<?php echo $this->action; ?>_nama_icd').val();
		         var $items = new Array;
		           $items = [""];				                
		          $.ajax({
		            url: '',
		            type: 'POST',
		            data: data_dokter,
		            success: function(res) {
		              var json=getContent(res);
		              var the_data_proses=json.dbtable.data;
		               $items = [""];	
		              $.map(the_data_proses, function(data){
		                  var group;
		                  group = {
		                      id: data.id,
		                      name: data.nama,
		                      kode: data.icd,    
		                      sebab: data.sebab,                                
		                      toString: function () {
		                    	  return JSON.stringify(this);
		                      },
		                      toLowerCase: function () {
		                          return this.name.toLowerCase();
		                      },
		                      indexOf: function (string) {
		                          return String.prototype.indexOf.apply(this.name, arguments);
		                      },
		                      replace: function (string) {
		                          var value = '';
		                          value +=  this.name;
		                          if(typeof(this.level) != 'undefined') {
		                              value += ' <span class="pull-right muted">';
		                              value += this.level;
		                              value += '</span>';
		                          }
		                          return String.prototype.replace.apply('<div class="typeaheadiv">' + value + '</div>', arguments);
		                      }
		                  };
		                  $items.push(group);
		              });
		              
		              process($items);
		            }
		          });
		        },
		        updater: function (item) {
		            var item = JSON.parse(item);
					$("#<?php echo $this->action; ?>_kode_icd").val(item.kode);
					$("#<?php echo $this->action; ?>_sebab_sakit").val(item.sebab);
					$("#<?php echo $this->action; ?>_save").focus();
		            return item.name;
		        }
		      });
			
			
			
			mr_pasien=new TableAction("mr_pasien",mr_the_page,"<?php echo $this->action; ?>",new Array());
			mr_pasien.setSuperCommand("mr_pasien");
			mr_pasien.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
			mr_pasien.selected=function(json){
				var nama=json.nama_pasien;
				var nrm=json.nrm;
				var noreg=json.id;		
				$("#<?php echo $this->action; ?>_nama_pasien").val(nama);
				$("#<?php echo $this->action; ?>_nrm_pasien").val(nrm);
				$("#<?php echo $this->action; ?>_noreg_pasien").val(noreg);
			};
			
			mr_dokter=new TableAction("mr_dokter",mr_the_page,"<?php echo $this->action; ?>",new Array());
			mr_dokter.setSuperCommand("mr_dokter");
			mr_dokter.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
			mr_dokter.selected=function(json){
				var nama=json.nama;
				var nip=json.id;		
				$("#<?php echo $this->action; ?>_nama_dokter").val(nama);
				$("#<?php echo $this->action; ?>_id_dokter").val(nip);
			};

			mr_icd=new TableAction("mr_icd",mr_the_page,"<?php echo $this->action; ?>",new Array());
			mr_icd.setSuperCommand("mr_icd");
			mr_icd.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
			mr_icd.selected=function(json){
				var nama=json.nama;
				var kode=json.icd;		
				var sebab=json.sebab;
				$("#<?php echo $this->action; ?>_nama_icd").val(nama);
				$("#<?php echo $this->action; ?>_kode_icd").val(kode);
				$("#<?php echo $this->action; ?>_sebab_sakit").val(sebab);
			};
			
			mr_icd_sekunder=new TableAction("mr_icd_sekunder",mr_the_page,"<?php echo $this->action; ?>",new Array());
			mr_icd_sekunder.setSuperCommand("mr_icd_sekunder");
			mr_icd_sekunder.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
			mr_icd_sekunder.selected=function(json){
				var nama=json.nama;
				var kode=json.icd;		
				var sebab=json.sebab;
				$("#<?php echo $this->action; ?>_nama_icd_sekunder").val(nama);
				$("#<?php echo $this->action; ?>_kode_icd_sekunder").val(kode);
				$("#<?php echo $this->action; ?>_sebab_sakit_sekunder").val(sebab);
			};

			var column=new Array(
				"id","tanggal","jk","kunjungan","carabayar","kasus","ruangan","nama_pasien","noreg_pasien","nrm_pasien","gol_umur","urji","diagnosa",'keterangan',"id_dokter","nama_dokter","kode_icd","nama_icd","sebab_sakit","tensi","nadi","suhu","rr","nyeri","keadaan_umum","keadaan_luka","gula_darah","berat_badan",
				"keluhan","anamnesa","makanan","udara","obat_obatan","prognosa","terapi_obat","terapi_non_obat","bmhp","kode_icd_sekunder","nama_icd_sekunder","sebab_sakit_sekunder","kesadaran","tinggi_badan","lingkar_perut","imt","sistole","diastole","pelayanan_non_kapitasi","status_pulang","ppk_rujukan","spesialis_subspesialis","catatan","tanggal_rencana_berkunjung","no_surat_kematian"
			);
			<?php echo $this->action; ?>=new TableAction("<?php echo $this->action; ?>",mr_the_page,"<?php echo $this->action; ?>",column);
			<?php echo $this->action; ?>.setPrototipe(mr_the_protoname,mr_the_protoslug,mr_the_protoimplement);
			<?php echo $this->action; ?>.setEnableAutofocus(true);
			<?php echo $this->action; ?>.setNextEnter();
			<?php echo $this->action; ?>.getRegulerData=function(){
				var reg_data={	
						page:this.page,
						action:this.action,
						super_command:this.super_command,
						prototype_name:this.prototype_name,
						prototype_slug:this.prototype_slug,
						prototype_implement:this.prototype_implement,
						polislug:mr_polislug,
						noreg_pasien:mr_noreg,
						nama_pasien:mr_nama_pasien,
						nrm_pasien:mr_nrm_pasien,
						dari:$("#<?php echo $this->action; ?>_dari").val(),
						sampai:$("#<?php echo $this->action; ?>_sampai").val(),
						ruangan:$("#<?php echo $this->action; ?>_ruangan").val(),
						jenis_layanan:$("#<?php echo $this->action; ?>_jenis_layanan").val(),
						kondisi:$("#<?php echo $this->action; ?>_kondisi").val()
					};
				return reg_data;
			};
			<?php echo $this->action; ?>.clear = function() {
				TableAction.prototype.clear.call(this);
				$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").hide();
				$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").hide();
				$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").hide();
				$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").hide();
				$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").hide();
			};
			<?php echo $this->action; ?>.edit = function(id) {
				var self		= this;
			    var json_obj	= new Array();
				showLoading();	
				var edit_data	= this.getEditData(id);
				$.post(
					'',
					edit_data,
					function(res) {		
						var json = getContent(res);
						if (json == null) return;
						for (var i = 0; i < self.column.length; i++) {
							if ($.inArray(self.column[i],self.noclear) != -1 && !self.edit_clear_for_no_clear)
								continue;
				            var name	= self.column[i];
							var the_id	= "#"+self.prefix+"_"+name;
				            if( name in self.json_column && self.json_column.length > 0) {
				                var json_grup_name=self.json_column[name];
				                if (json[json_grup_name] == "")
				                    continue;
				                if (!(json_grup_name in json_obj))
								    json_obj[json_grup_name] = $.parseJSON(json[json_grup_name]);
				                smis_edit(the_id,json_obj[json_grup_name][""+name]);    
				            } else
				                smis_edit(the_id,json[""+name]);
						}
						$("#<?php echo $this->action; ?>_status_pulang").trigger("change");
						dismissLoading();
						self.disabledOnEdit(self.column_disabled_on_edit);
						self.show_form();
					}
				);
				return this;
			};
			<?php echo $this->action; ?>.view();
			<?php echo $this->action; ?>.show=function(id){
				var data=$("#diagnosa_data_"+id).html();
				showWarning("Diagnosa ", data);
			};
			$("#<?php echo $this->action; ?>_status_pulang").on("change", function() {
            	var status_pulang = $(this).val();
            	if (status_pulang == "Rujuk") {
            		$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").show();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").show();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").show();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").show();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").hide();
            	} else if (status_pulang == "Meninggal") {
            		$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").hide();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").hide();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").hide();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").hide();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").show();
            	} else {
            		$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_ppk_rujukan").hide();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_spesialis_subspesialis").hide();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_catatan").hide();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_tanggal_rencana_berkunjung").hide();
					$("#<?php echo $this->action; ?>_add_form_form > div.fcontainer_<?php echo $this->action; ?>_no_surat_kematian").hide();
            	}
            });
            $("#<?php echo $this->action; ?>_berat_badan").on("keyup", function() {
            	var berat_badan = isNaN($("#<?php echo $this->action; ?>_berat_badan").val()) || $("#<?php echo $this->action; ?>_berat_badan").val() == "" ? 0 : $("#<?php echo $this->action; ?>_berat_badan").val();
            	var tinggi_badan = isNaN($("#<?php echo $this->action; ?>_tinggi_badan").val()) || $("#<?php echo $this->action; ?>_tinggi_badan").val() == "" ? 0 : $("#<?php echo $this->action; ?>_tinggi_badan").val();
            	var imt = 0;
            	if (tinggi_badan != 0)
            		imt = parseFloat(berat_badan / (2 * tinggi_badan / 100)).toFixed(2);
            	$("#<?php echo $this->action; ?>_imt").val(imt);
            });
            $("#<?php echo $this->action; ?>_tinggi_badan").on("keyup", function() {
            	var berat_badan = isNaN($("#<?php echo $this->action; ?>_berat_badan").val()) || $("#<?php echo $this->action; ?>_berat_badan").val() == "" ? 0 : $("#<?php echo $this->action; ?>_berat_badan").val();
            	var tinggi_badan = isNaN($("#<?php echo $this->action; ?>_tinggi_badan").val()) || $("#<?php echo $this->action; ?>_tinggi_badan").val() == "" ? 0 : $("#<?php echo $this->action; ?>_tinggi_badan").val();
            	var imt = 0;
            	if (tinggi_badan != 0)
            		imt = parseFloat(berat_badan / (2 * tinggi_badan / 100)).toFixed(2);
            	$("#<?php echo $this->action; ?>_imt").val(imt);
            });
		});
		</script>
<?php
	}
	
	public function superCommand($super_command) {
		$array=array ('Nama','Jabatan',"NIP" );
		$dktable = new Table ($array);
		$dktable->setName ( "mr_dokter" );
		$dktable->setModel ( Table::$SELECT );
		$dkadapter = new SimpleAdapter ();
		$dkadapter->add ( "Jabatan", "nama_jabatan" );
		$dkadapter->add ( "Nama", "nama" );
		$dkadapter->add ( "NIP", "nip" );
		$dkresponder = new EmployeeResponder($this->db, $dktable, $dkadapter, "dokter") ;
		
		/* PASIEN */
		$aname=array ('Nama','NRM',"No Reg" );
		$ptable = new Table ( $aname);
		$ptable->setName ( "mr_pasien" );
		$ptable->setModel ( Table::$SELECT );
		$padapter = new SimpleAdapter ();
		$padapter->add ( "Nama", "nama_pasien" );
		$padapter->add ( "NRM", "nrm", "digit8" );
		$padapter->add ( "No Reg", "id" );
		$presponder = new ServiceResponder ( $this->db, $ptable, $padapter, "get_registered" );
		
		$array=array ("Kode",'DTD','Nama',"Sebab" );
		$muitable = new Table ( $array);
		$muitable->setModel ( Table::$SELECT );
		$muitable->setName ( "mr_icd" );
		$madapter = new SimpleAdapter ();
		$madapter->add ( "Nama", "nama" );
		$madapter->add ( "Kode", "icd" );
		$madapter->add ( "DTD", "dtd" );
		$madapter->add ( "Sebab", "sebab" );
		$dbtable = new DBTable ( $this->db, "smis_mr_icd" );
		$mresponder = new DBResponder ( $dbtable, $muitable, $madapter );

		$array=array ("Kode",'DTD','Nama',"Sebab" );
		$msuitable = new Table ( $array);
		$msuitable->setModel ( Table::$SELECT );
		$msuitable->setName ( "mr_icd_sekunder" );
		$msadapter = new SimpleAdapter ();
		$msadapter->add ( "Nama", "nama" );
		$msadapter->add ( "Kode", "icd" );
		$msadapter->add ( "DTD", "dtd" );
		$msadapter->add ( "Sebab", "sebab" );
		$dbtable = new DBTable ( $this->db, "smis_mr_icd" );
		$msresponder = new DBResponder ( $dbtable, $msuitable, $msadapter );
		
		$super = new SuperCommand ();
		$super->addResponder ( "mr_dokter", $dkresponder );
		$super->addResponder ( "mr_pasien", $presponder );
		$super->addResponder ( "mr_icd", $mresponder );
		$init = $super->initialize ();
		if ($init != null) {
			echo $init;
			return;
		}
	}
}

?>