<?php
require_once ('smis-framework/smis/template/ModulTemplate.php');
require_once ("smis-base/smis-include-service-consumer.php");
require_once ('smis-libs-hrd/EmployeeResponder.php');

class ProlanisTemplate extends ModulTemplate {
	protected $db;
	protected $polislug;
	protected $page;
	protected $protoslug;
	protected $protoname;
	protected $protoimplement;
	protected $action;
	protected $dbtable;
	protected $uitable;
	protected $noreg_pasien;
	protected $nama_pasien;
	protected $nrm_pasien;
	protected $no_bpjs;
	protected $alamat;
	protected $umur;
	protected $jk;
	protected $no_telp;
	protected $carabayar;

	public function __construct(
		$db, 
		$noreg = "", 
		$nrm = "", 
		$nama = "",
		$no_bpjs = "",
		$alamat = "",
		$umur = "",
		$jk = "",
		$no_telp = "",
		$carabayar = "",
		$polislug = "",
		$page = "medical_record", 
		$action = "lap_prolanis", 
		$protoslug = "", 
		$protoname = "", 
		$protoimplement = ""
	) {
		$this->db = $db;
		$this->noreg_pasien = $noreg;
		$this->nrm_pasien = $nrm;
		$this->nama_pasien = $nama;
		$this->no_bpjs = $no_bpjs;
		$this->alamat = $alamat;
		$this->umur = $umur;
		$this->jk = $jk;
		$this->no_telp = $no_telp;
		$this->carabayar = $carabayar;
		$this->polislug = $polislug;
		$this->dbtable = new DBTable ( $this->db, "smis_mr_prolanis" );
		$this->page = $page;
		$this->protoslug = $protoslug;
		$this->protoimplement = $protoimplement;
		$this->protoname = $protoname;
		$this->action = $action;
		$this->dbtable->addCustomKriteria ( "noreg_pasien", "='" . $noreg . "'" );
		$this->dbtable->addCustomKriteria ( "ruangan", "='" . $polislug . "'" );
		$this->uitable = new Table( 
			array ("No. Reg.", "NRM", "No. BPJS", "Nama Pasien", "Alamat", "Diagnosa"), 
			"Prolanis " . ($this->polislug == "all" ? "" : ucfirst ( $this->protoname )), 
			null, 
			true 
		);
		$this->uitable->setName ( $action );
	}
    
	public function command($command) {
		if ($_POST['command'] == "save") {
			$noreg_pasien = $_POST['noreg_pasien'];
			$ruangan = $_POST['ruangan'];
			$row = $this->db->get_row("
				SELECT *
				FROM smis_mr_prolanis 
				WHERE prop = '' AND noreg_pasien = '" . $noreg_pasien . "' AND ruangan = '" . $ruangan . "'
			");
			if ($row != null)
				$_POST['id'] = $row->id;
		}

        require_once ("smis-base/smis-include-duplicate.php");
		$adapter = new SimpleAdapter ();
		$adapter->add ( "No. Reg.", "noreg_pasien" );
		$adapter->add ( "NRM", "nrm_pasien", "digit6" );
		$adapter->add ( "No. BPJS", "no_bpjs" );
		$adapter->add ( "Nama Pasien", "nama_pasien" );
		$adapter->add ( "Alamat", "alamat" );
		$adapter->add ( "Diagnosa", "diagnosa" );
		$dbres = new DuplicateResponder ( $this->dbtable, $this->uitable, $adapter );
		$dbres->setDuplicate(false,"");
        $dbres->setAutonomous(getSettings($this->db,"smis_autonomous_id",""));
        $data = $dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
    
	public function phpPreLoad() {
		$the_row = array ();
		$the_row ['tanggal'] = date ( "Y-m-d" );
        $the_row ['noreg_pasien'] = $this->noreg_pasien;
        $the_row ['nrm_pasien'] = $this->nrm_pasien;
        $the_row ['no_bpjs'] = $this->no_bpjs;
		$the_row ['alamat'] = $this->alamat_pasien;
		$the_row ['umur'] = $this->umur;
		$the_row ['jk'] = $this->jk;
		$the_row ['no_telp'] = $this->no_telp;
        $the_row ['carabayar'] = $this->carabayar;
        $the_row ['id_dokter'] = "";
		$the_row ['dokter'] = "";
		$the_row ['diagnosa'] = "";
		$the_row ['gds'] = "";
		$the_row ['gdp'] = "";
		$the_row ['gdpp'] = "";
		$the_row ['tensi'] = "";
		
		$row = $this->db->get_row("
			SELECT *
			FROM smis_mr_prolanis
			WHERE prop = '' AND noreg_pasien = '" . $this->noreg_pasien . "'
		");
		if ($row != null) {
			$the_row ['tanggal'] = $row->tanggal;
            $the_row ['id_dokter'] = $row->id_dokter;
			$the_row ['dokter'] = $row->dokter;
			$the_row ['diagnosa'] = $row->diagnosa;
			$the_row ['gds'] = $row->gds;
			$the_row ['gdp'] = $row->gdp;
			$the_row ['gdpp'] = $row->gdpp;
			$the_row ['tensi'] = $row->tensi;
			$the_row ["id"] = $row->id;
		} else {
			$diagnosa_row = $this->db->get_row("
				SELECT *
				FROM smis_mr_diagnosa
				WHERE noreg_pasien = '" . $this->noreg_pasien . "' AND prop = ''
				ORDER BY id DESC
				LIMIT 0, 1
			");
			if ($diagnosa_row != null) {
				$the_row ['diagnosa'] = $diagnosa_row->kode_icd . ". " . $diagnosa_row->nama_icd;
				if (
					$diagnosa_row->kode_icd_sekunder != null && 
					$diagnosa_row->nama_icd_sekunder != null && 
					$diagnosa_row->kode_icd_sekunder != "" &&
					$diagnosa_row->nama_icd_sekunder != ""
				)
					$the_row ['diagnosa'] .= " + " . $diagnosa_row->kode_icd_sekunder . ". " . $diagnosa_row->nama_icd_sekunder;
				$the_row ['tensi'] = $diagnosa_row->sistole . "/" . $diagnosa_row->diastole;
			}
		}
				
		$this->uitable->addModal ( "nama_pasien", "hidden", "", $this->nama_pasien, "n", null, true );
		$this->uitable->addModal ( "nrm_pasien", "hidden", "", $this->nrm_pasien, "n", null, true );
		$this->uitable->addModal ( "noreg_pasien", "hidden", "", $this->noreg_pasien, "n", null, true );
        $this->uitable->addModal ( "no_bpjs", "hidden", "", $this->no_bpjs, "n", null, true );
		$this->uitable->addModal ( "alamat", "hidden", "", $this->alamat, "n", null, true );
		$this->uitable->addModal ( "umur", "hidden", "", $this->umur, "n", null, true );
		$this->uitable->addModal ( "jk", "hidden", "", $this->jk, "n", null, true );
		$this->uitable->addModal ( "no_telp", "hidden", "", $this->no_telp, "n", null, true );
		$this->uitable->addModal ( "carabayar", "hidden", "", $this->carabayar, "n", null, true );
        $this->uitable->addModal ( "ruangan", "hidden", "", $this->polislug, "n", null, true );
		$this->uitable->addModal ( "id", "hidden", "", $the_row ['id'] );
		$this->uitable->addModal ( "tanggal", "date", "Tanggal", $the_row ['tanggal'] );
		$this->uitable->addModal ( "id_dokter", "hidden", "", $the_row ['id_dokter'], "n", null, true );
		$this->uitable->addModal ( "dokter", "chooser-".$this->action."-lp_dokter-Dokter", "Dokter", $the_row ['dokter'], "n", null, true );
		$this->uitable->addModal ( "diagnosa", "textarea", "Diagnosa", $the_row ['diagnosa'], "n", null, true );
		$this->uitable->addModal ( "gds", "text", "GDS", $the_row ['gds'], "n" );
		$this->uitable->addModal ( "gdp", "text", "GDP", $the_row ['gdp'], "n" );
		$this->uitable->addModal ( "gdpp", "text", "GDPP", $the_row ['gdpp'], "n" );
		$this->uitable->addModal ( "tensi", "text", "Tensi", $the_row ['tensi'], "n", null, true );		
			
		$modal = $this->uitable->getModal ();
		$modal->setTitle ( "Laporan Prolanis" );
		$modal->setAlwaysShow ( true );
		echo "<div class='hide'>" . $this->uitable->getHtml () . "</div>";
		echo $modal->joinFooterAndForm ()->getHtml ();
	}
    
	public function jsLoader() {
		echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
		echo addJS ( "framework/smis/js/table_action.js" );
		
		loadLibrary ( "smis-libs-function-javascript" );
	}
    
	public function cssLoader() {
		echo addCSS ( "framework/bootstrap/css/datepicker.css" );
	}
    
	public function cssPreLoad() {
		?>
		<style type="text/css">
		#<?php echo $this->action;?>_add_form_form>div { clear: both; width: 100%;}
		#<?php echo $this->action;?>_add_form_form>div label { width: 250px;}
		</style>
		<?php
	}
	
	/* when it's star build */
	public function jsPreLoad() {
		?>
		<script type="text/javascript">
		var <?php echo $this->action; ?>;
		var lp_pasien;
		var lp_noreg = "<?php echo $this->noreg_pasien; ?>";
		var lp_nama_pasien = "<?php echo $this->nama_pasien; ?>";
		var lp_nrm_pasien = "<?php echo $this->nrm_pasien; ?>";
		var lp_polislug = "<?php echo $this->polislug; ?>";
		var lp_the_page = "<?php echo $this->page; ?>";
		var lp_the_protoslug = "<?php echo $this->protoslug; ?>";
		var lp_the_protoname = "<?php echo $this->protoname; ?>";
		var lp_the_protoimplement = "<?php echo $this->protoimplement; ?>";
		var lp_prefix = "<?php echo $this->action; ?>";
		var lp_dokter;	
		
		$(document).ready(function() {			
			$(".mydate").datepicker();			
			var column=new Array(
				"id","tanggal", "ruangan",
				"nama_pasien","noreg_pasien","nrm_pasien","no_bpjs", "alamat", "no_telp", "carabayar", "jk", "umur",
				"id_dokter", "dokter", "diagnosa", "gds", "gdp", "gdpp", "tensi"
			);
			<?php echo $this->action; ?> = new TableAction("<?php echo $this->action; ?>", lp_the_page, "<?php echo $this->action; ?>", column);
			<?php echo $this->action; ?>.setPrototipe(lp_the_protoname, lp_the_protoslug, lp_the_protoimplement);
			<?php echo $this->action; ?>.getRegulerData = function() {
				var reg_data = {	
					page : this.page,
					action : this.action,
					super_command : this.super_command,
					prototype_name : this.prototype_name,
					prototype_slug : this.prototype_slug,
					prototype_implement : this.prototype_implement,
					polislug : lp_polislug,
					noreg_pasien : lp_noreg,
					nama_pasien : lp_nama_pasien,
					nrm_pasien : lp_nrm_pasien
				};
				return reg_data;
			};
			<?php echo $this->action . ".clear=function(){return;};"; ?>
			lp_dokter = new TableAction("lp_dokter", lp_the_page, lp_prefix, new Array());
			lp_dokter.setSuperCommand("lp_dokter");
			lp_dokter.setPrototipe(lp_the_protoname, lp_the_protoslug, lp_the_protoimplement);
			lp_dokter.selected = function(json) {
				$("#" + lp_prefix +"_id_dokter").val(json.id);
				$("#" + lp_prefix +"_dokter").val(json.nama);
			};
		});
		</script>
<?php
	}
    
	public function superCommand($super_command) {
		$super = new SuperCommand ();
		if ($super_command=="lp_dokter") {
            $eadapt = new SimpleAdapter ();
            $eadapt->add ( "Jabatan", "nama_jabatan" );
            $eadapt->add ( "Nama", "nama" );
            $eadapt->add ( "NIP", "nip" );
            $head_karyawan = array ('Nama','Jabatan',"NIP");
            $dktable = new Table ( $head_karyawan, "", NULL, true );
            $dktable->setName ( $super_command );
            $dktable->setModel ( Table::$SELECT );
            $employee = new EmployeeResponder ( $this->db, $dktable, $eadapt, "dokter" );
            $super->addResponder ( $super_command, $employee );
        }
        
		$init = $super->initialize ();
		if ($init != null) {
			echo $init;
			return;
		}
	}
}

?>