<?php
require_once("smis-base/smis-include-service-consumer.php");
require_once 'smis-framework/smis/template/ModulTemplate.php';

class ObatPCareTemplate extends ModulTemplate
{
	protected $db;
	protected $mode;
	protected $polislug;
	protected $page;
	protected $protoslug;
	protected $protoname;
	protected $protoimplement;
	protected $action;
	protected $dbtable;
	protected $uitable;
	protected $noreg_pasien;
	protected $nama_pasien;
	protected $nrm_pasien;
	protected $no_kunjungan;

	public function __construct($db, $polislug, $noreg, $nrm, $nama, $page, $action, $protoslug, $protoname, $protoimplement)
	{
		$this->db = $db;
		$this->noreg_pasien = $noreg;
		$this->nama_pasien = $nama;
		$this->nrm_pasien = $nrm;
		$this->no_kunjungan = "";
		$this->polislug = $polislug;
		$this->dbtable = new DBTable($this->db, "smis_mr_obat_pcare");
		$this->page = $page;
		$this->protoslug = $protoslug;
		$this->protoimplement = $protoimplement;
		$this->protoname = $protoname;
		$this->action = $action;
		if ($noreg != "") {
			$this->dbtable->addCustomKriteria("noreg_pasien", "='" . $noreg . "'");
			$kunjungan_row = $this->db->get_row("
				SELECT *
				FROM smis_mr_diagnosa 
				WHERE noreg_pasien = '" . $noreg . "'
				ORDER BY id DESC
				LIMIT 0, 1
			");
			if ($kunjungan_row != null)
				$this->no_kunjungan = $kunjungan_row->no_kunjungan_pcare;
		}

		$array = array("R/", "Nama Obat");
		$this->uitable = new Table($array, "Obat " . ($this->polislug == "all" ? "" : ucfirst($this->protoname)), NULL, true);
		$this->uitable->setName($action);
		$add_non_racikan_button = new Button("", "", "Non Racikan");
		$add_non_racikan_button->setClass("btn-primary");
		$add_non_racikan_button->setIcon("fa fa-plus");
		$add_non_racikan_button->setIsButton(Button::$ICONIC_TEXT);
		$add_non_racikan_button->setAction($this->action . ".show_add_non_racikan_form()");
		$this->uitable->addHeaderButton($add_non_racikan_button);
		$add_racikan_button = new Button("", "", "Racikan");
		$add_racikan_button->setClass("btn-primary");
		$add_racikan_button->setIcon("fa fa-plus");
		$add_racikan_button->setIsButton(Button::$ICONIC_TEXT);
		$add_racikan_button->setAction($this->action . ".show_add_racikan_form()");
		$this->uitable->addHeaderButton($add_racikan_button);
		$this->uitable->setAddButtonEnable(false);
		$this->uitable->setReloadButtonEnable(false);
		$this->uitable->setPrintButtonEnable(false);
	}
	public function command($command)
	{
		require_once "smis-base/smis-include-duplicate.php";
		$adapter = new SimpleAdapter();
		$adapter->add("R/", "kdracikan");
		$adapter->add("Nama Obat", "nmobat_nondpho");
		$dbres = new DuplicateResponder($this->dbtable, $this->uitable, $adapter);
		$dbres->setDuplicate(false, "");
		$dbres->setAutonomous(getSettings($this->db, "smis_autonomous_id", ""));
		$data = $dbres->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	public function phpPreLoad()
	{
		$non_racikan_table = new Table(null, "", null, true);
		$non_racikan_table->setName("obat_pcare_non_racikan");
		$non_racikan_table->addModal("id", "hidden", "", "");
		$non_racikan_table->addModal("kd_obat_sk", "hidden", "", "");
		$non_racikan_table->addModal("kdracikan", "hidden", "", "");
		$non_racikan_table->addModal("nrm_pasien", "hidden", "", $this->nrm_pasien, "n", null, true);
		$non_racikan_table->addModal("noreg_pasien", "hidden", "", $this->noreg_pasien, "n", null, true);
		$non_racikan_table->addModal("no_kunjungan_pcare", "hidden", "", $this->no_kunjungan, "n", null, true);
		$non_racikan_table->addModal("nama_pasien", "hidden", "", $this->nama_pasien, "n", null, true);
		$racikan_option = new OptionBuilder();
		$racikan_option->add("Non Racikan", "0", "1");
		$racikan_option->add("Racikan", "1");
		$non_racikan_table->addModal("racikan", "select", "Jenis", $racikan_option->getContent(), "n", null, true);
		$non_racikan_table->addModal("kd_obat", "hidden", "", "");
		$obat_dpho_option = new OptionBuilder();
		$obat_dpho_option->add("Ya", "1", "1");
		$obat_dpho_option->add("Tidak", "0");
		$non_racikan_table->addModal("obat_dpho", "select", "Obat DPHO", $obat_dpho_option->getContent(), "n");
		$non_racikan_table->addModal("nmobat_nondpho", "chooser-" . $this->action . "-op_obat_dpho-Obat DPHO", "Nama Obat", "", "n", null, true);
		$non_racikan_table->addModal("signa1", "text", "Signa", "", "n");
		$non_racikan_table->addModal("signa2", "text", "x", "", "n");
		$non_racikan_table->addModal("jml_obat", "text", "Jumlah Obat", "");
		$non_racikan_table->addModal("hari", "text", "Hari", "", "n", null, true);
		$non_racikan_modal = $non_racikan_table->getModal();
		$non_racikan_modal->setComponentSize(Modal::$MEDIUM);
		$non_racikan_modal->setTitle("Obat Non-Racikan");
		echo $this->uitable->getHtml();
		echo $non_racikan_modal->getHtml();
	}
	public function jsLoader()
	{
		echo addJS("framework/smis/js/table_action.js");
		loadLibrary("smis-libs-function-javascript");
	}
	public function cssLoader()
	{
	}

	public function cssPreLoad()
	{
?>
		<style type="text/css">
			#<?php echo $this->action; ?>_non_racikan_add_form_form>div.normal_model_medium_component.obat_pcare_non_racikan_signa2.fcontainer_obat_pcare_non_racikan_signa2>label {
				width: 37px !important;
			}

			#<?php echo $this->action; ?>_non_racikan_signa1,
			#<?php echo $this->action; ?>_non_racikan_signa2 {
				width: 75px !important;
			}
		</style>
	<?php
	}

	/* when it's star build */
	public function jsPreLoad()
	{
	?>
		<script type="text/javascript">
			var <?php echo $this->action; ?>;
			var <?php echo $this->action; ?>_non_racikan;
			var op_obat_dpho;
			var op_no_kunjungan = "<?php echo $this->no_kunjungan; ?>";
			var op_noreg = "<?php echo $this->noreg_pasien; ?>";
			var op_nama_pasien = "<?php echo $this->nama_pasien; ?>";
			var op_nrm_pasien = "<?php echo $this->nrm_pasien; ?>";
			var op_polislug = "<?php echo $this->polislug; ?>";
			var op_the_page = "<?php echo $this->page; ?>";
			var op_the_protoslug = "<?php echo $this->protoslug; ?>";
			var op_the_protoname = "<?php echo $this->protoname; ?>";
			var op_the_protoimplement = "<?php echo $this->protoimplement; ?>";
			$(document).ready(function() {
				<?php echo $this->action; ?> = new TableAction(
					"<?php echo $this->action; ?>",
					op_the_page,
					"<?php echo $this->action; ?>",
					new Array()
				);
				<?php echo $this->action; ?>.setPrototipe(op_the_protoname, op_the_protoslug, op_the_protoimplement);
				<?php echo $this->action; ?>.show_add_non_racikan_form = function() {
					$("#<?php echo $this->action; ?>_non_racikan_add_form").smodal("show");
				};
				<?php echo $this->action; ?>.view();
				<?php echo $this->action; ?>_non_racikan = new TableAction(
					"<?php echo $this->action; ?>_non_racikan",
					op_the_page,
					"<?php echo $this->action; ?>",
					new Array()
				);
				<?php echo $this->action; ?>_non_racikan.setPrototipe(op_the_protoname, op_the_protoslug, op_the_protoimplement);
				<?php echo $this->action; ?>_non_racikan.validate = function() {
					var valid = true;
					return valid;
				};
				<?php echo $this->action; ?>_non_racikan.save = function() {
					if (!this.validate())
						return;
					var data = this.getRegulerData();
					data['super_command'] = "po_obat_save";
					data['command'] = "save";
					data['id'] = $("#<?php echo $this->action; ?>_non_racikan_id").val();
					data['no_kunjungan_pcare'] = $("#<?php echo $this->action; ?>_non_racikan_no_kunjungan_pcare").val();
					data['noreg_pasien'] = $("#<?php echo $this->action; ?>_non_racikan_noreg_pasien").val();
					data['nrm_pasien'] = $("#<?php echo $this->action; ?>_non_racikan_nrm_pasien").val();
					data['nama_pasien'] = $("#<?php echo $this->action; ?>_non_racikan_nama_pasien").val();
					data['kd_obat_sk'] = $("#<?php echo $this->action; ?>_non_racikan_kd_obat_sk").val();
					data['racikan'] = $("#<?php echo $this->action; ?>_non_racikan_racikan").val();
					data['kdracikan'] = $("#<?php echo $this->action; ?>_non_racikan_kdracikan").val();
					data['obat_dpho'] = $("#<?php echo $this->action; ?>_non_racikan_obat_dpho").val();
					data['kd_obat'] = $("#<?php echo $this->action; ?>_non_racikan_kd_obat").val();
					data['signa1'] = $("#<?php echo $this->action; ?>_non_racikan_signa1").val();
					data['signa2'] = $("#<?php echo $this->action; ?>_non_racikan_signa2").val();
					data['jml_obat'] = $("#<?php echo $this->action; ?>_non_racikan_jml_obat").val();
					data['jml_permintaan'] = $("#<?php echo $this->action; ?>_non_racikan_jml_obat").val();
					data['nmobat_nondpho'] = $("#<?php echo $this->action; ?>_non_racikan_nmobat_nondpho").val();
					showLoading();
					$.post(
						"",
						data,
						function(response) {
							var json = JSON.parse(response);
							if (json == null) {
								dismissLoading();
								return;
							}
							if (json.content.message == "FAILED") {
								$("#<?php echo $this->action; ?>_non_racikan_add_form").smodal('hide');
								bootbox.dialog({
									closeButton: false,
									title: json.alert.title,
									message: json.alert.content == "" ? "Tidak ada pesan." : json.alert.content,
									buttons: {
										sucess: {
											label: "OK",
											callback: function() {
												$("#<?php echo $this->action; ?>_non_racikan_add_form").smodal('show');
											},
											onEscape: function() {
												$("#<?php echo $this->action; ?>_non_racikan_add_form").smodal('show');
											}
										}
									}
								});
								dismissLoading();
								return;
							}
							dismissLoading();
						}
					);
				};
				op_obat_dpho = new TableAction(
					"op_obat_dpho",
					op_the_page,
					"<?php echo $this->action; ?>",
					new Array()
				);
				op_obat_dpho.setPrototipe(op_the_protoname, op_the_protoslug, op_the_protoimplement);
				op_obat_dpho.setSuperCommand("op_obat_dpho");
				op_obat_dpho.select = function(row_num) {
					var kode_obat = $("#op_obat_dpho_list tr:eq(" + row_num + ") td:eq(1)").text();
					var nama_obat = $("#op_obat_dpho_list tr:eq(" + row_num + ") td:eq(2)").text();
					$("#<?php echo $this->action; ?>_non_racikan_kd_obat").val(kode_obat);
					$("#<?php echo $this->action; ?>_non_racikan_nmobat_nondpho").val(nama_obat);
					$($(this).data('target')).smodal('hide');
				};

				$("#<?php echo $this->action; ?>_non_racikan_obat_dpho").on("change", function() {
					$("#<?php echo $this->action; ?>_non_racikan_nmobat_nondpho").val("");
					$("#<?php echo $this->action; ?>_kd_obat").val("");
					var val = $(this).val();
					if (val == 1) {
						$("#<?php echo $this->action; ?>_non_racikan_nmobat_nondpho").removeAttr("disabled");
						$("#<?php echo $this->action; ?>_non_racikan_nmobat_nondpho").attr("disabled", "disabled");
					} else {
						$("#<?php echo $this->action; ?>_non_racikan_nmobat_nondpho").removeAttr("disabled");
					}
				});

				$("#<?php echo $this->action; ?>_non_racikan_signa1, #<?php echo $this->action; ?>_non_racikan_signa2, #<?php echo $this->action; ?>_non_racikan_jml_obat").on("keyup", function() {
					var signa1 = $("#<?php echo $this->action; ?>_non_racikan_signa1").val();
					var signa2 = $("#<?php echo $this->action; ?>_non_racikan_signa2").val();
					var jumlah_obat = $("#<?php echo $this->action; ?>_non_racikan_jml_obat").val();
					if ($.isNumeric(signa1) && $.isNumeric(signa2) && $.isNumeric(jumlah_obat)) {
						var hari = jumlah_obat / (signa1 * signa2);
						hari = hari.toFixed(2);
						$("#<?php echo $this->action; ?>_non_racikan_hari").val(hari);
					} else {
						$("#<?php echo $this->action; ?>_non_racikan_hari").val("");
					}
				});
			});
		</script>
<?php
	}

	public function superCommand($super_command)
	{
		if (isset($_POST['super_command']) && isset($_POST['command'])) {
			if ($_POST['super_command'] == "po_obat_save") {
				if ($_POST['command'] == "save") {
					$kd_obat_sk = $_POST['kd_obat_sk'] == "" ? 0 : $_POST['kd_obat_sk'];
					$no_kunjungan_pcare = $_POST['no_kunjungan_pcare'];
					$racikan = $_POST['racikan'] == 1 ? true : false;
					$kdracikan = $_POST['kdracikan'] == "" ? null : $_POST['kdracikan'];
					$obat_dpho = $_POST['obat_dpho'] == 1 ? true : false;
					$kd_obat = $_POST['kd_obat'];
					$signa1 = $_POST['signa1'];
					$signa2 = $_POST['signa2'];
					$jml_obat = $_POST['jml_obat'];
					$jml_permintaan = $_POST['jml_permintaan'];
					$nmobat_nondpho = $_POST['nmobat_nondpho'];

					require_once("medical_record/class/pcare/PCareObat.php");
					$pcare = new PCareObat();
					$pcare->setPCareAuthorization();
					$data_response = $pcare->addObat(
						$kd_obat_sk,
						$no_kunjungan_pcare,
						$racikan,
						$kdracikan,
						$obat_dpho,
						$kd_obat,
						$signa1,
						$signa2,
						$jml_obat,
						$jml_permintaan,
						$nmobat_nondpho
					);
					echo json_encode($data_response);
				}
				return;
			} else if ($_POST['super_command'] == "op_obat_dpho") {
				require_once("medical_record/class/pcare/PCareObat.php");
				if ($_POST['command'] == "list") {
					$response_package = new ResponsePackage();
					$number           = (isset($_POST['number']) && $_POST['number'] != "") ? $_POST['number'] : 0;
					$n_number         = $number;
					$max              = isset($_POST['max']) ? $_POST['max'] : "10";
					$kriteria         = $_POST['kriteria'];
					if ($kriteria == "")
						$kriteria = "A";
					$pcare            = new PCareObat();
					$pcare->setPCareAuthorization();
					$data_response    = $pcare->getListObatDPHO($kriteria, $number, $max);
					$total            = $data_response['response']['count'];
					$code             = $data_response['metaData']['code'];
					$message          = $data_response['metaData']['message'];
					$max_page         = ceil($total / $max);
					if ($n_number >= $max_page && $n_number != 0) {
						$n_number       = $max_page - 1;
					}
					$page             = $n_number;
					$data             = $data_response['response']['list'];
					$max_page         = $max_page;
					$list             = "";
					$nomor            = 1 + $max * $number;
					$index 			  = 0;
					foreach ($data as $d) {
						$list         .=    "<tr>" .
							"<td>" . $nomor++ . "</td>" .
							"<td>" . $d['kdObat'] . "</td>" .
							"<td>" . $d['nmObat'] . "</td>" .
							"<td class='noprint'>" .
							"<div class='btn-group noprint'>" .
							"<a href='#' onclick=' " . $_POST['super_command'] . ".select(" . $index++ . ") ' data-content='Pilih' data-toggle='popover' class='input btn btn-info '>" .
							"<i class='fa fa-check'></i>" .
							"</a>" .
							"</div>" .
							"</td>" .
							"</tr>";
					}
					$pagination = new Pagination('', '', $number, 3, $_POST['super_command'] . ".paginate(this)", $max_page);
					$content = array(
						'list'          => $list,
						'pagination'    => "",
						'number'        => $page,
						'number_p'      => $number,
						'total'         => $total,
						'max_page'      => $max_page,
						'max'           => $max
					);
					$response_package->setContent($content);
					if ($code == 200)
						$response_package->setStatus(ResponsePackage::$STATUS_OK);
					else {
						$response_package->setStatus(ResponsePackage::$STATUS_FAIL);
						$response_package->setAlertContent("Proses Pengambilan Data Gagal : " . $code, $message, ResponsePackage::$TIPE_DANGER);
						$response_package->setAlertVisible(true);
					}
					echo json_encode($response_package->getPackage());
				}
				return;
			}
		}

		$array = array('No.', 'Kode Obat', 'Nama Obat');
		require_once("medical_record/class/table/CustomChooserTable.php");
		$obat_dpho_table = new CustomChooserTable($array);
		$obat_dpho_table->setName("op_obat_dpho");
		$obat_dpho_table->setModel(Table::$SELECT);
		$obat_dpho_dbtable = new DBTable($this->db, "smis_mr_obat_pcare");
		$obat_dpho_adapter = new SimpleAdapter();
		$obat_dpho_adapter->add("Kode Obat", "kd_obat");
		$obat_dpho_adapter->add("Nama Obat", "nmobat_nondpho");
		$obat_dpho_dbresponder = new DBResponder(
			$obat_dpho_dbtable,
			$obat_dpho_table,
			$obat_dpho_adapter
		);
		$super = new SuperCommand();
		$super->addResponder("op_obat_dpho", $obat_dpho_dbresponder);
		$init = $super->initialize();
		if ($init != null) {
			echo $init;
			return;
		}
	}
}

?>